/*
 * Decompiled with CFR 0.152.
 */
package lumag.util;

import java.io.ByteArrayOutputStream;

public class Base64 {
    public static byte[] decode(String string) {
        int len = string.length();
        ByteArrayOutputStream output = new ByteArrayOutputStream(len * 3 / 4);
        long currentValue = 0L;
        int curChars = 0;
        int skipChars = 0;
        for (int i = 0; i < len; ++i) {
            int nextBits;
            char ch = string.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '=') {
                nextBits = 0;
                ++skipChars;
            } else {
                nextBits = Base64.parseCharacter(ch);
            }
            currentValue = (currentValue << 6) + (long)nextBits;
            if (++curChars != 4) continue;
            output.write((int)(currentValue >> 16 & 0xFFL));
            if (skipChars < 2) {
                output.write((int)(currentValue >> 8 & 0xFFL));
            }
            if (skipChars < 2) {
                output.write((int)(currentValue >> 0 & 0xFFL));
            }
            curChars = 0;
            skipChars = 0;
            currentValue = 0L;
        }
        return output.toByteArray();
    }

    private static int parseCharacter(char ch) {
        if ('A' <= ch && ch <= 'Z') {
            return ch - 65;
        }
        if ('a' <= ch && ch <= 'z') {
            return ch - 97 + 26;
        }
        if ('0' <= ch && ch <= '9') {
            return ch - 48 + 26 + 26;
        }
        if (ch == '+') {
            return ch - 43 + 26 + 26 + 10;
        }
        if (ch == '/') {
            return ch - 47 + 26 + 26 + 10 + 1;
        }
        throw new IllegalArgumentException("Bad character encountered: '" + ch + "' (0x" + Integer.toHexString(ch));
    }
}

