/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import jbookreader.rendering.swing.JGraphicDriver;
import jbookreader.ui.swing.AboutAction;

class MainWindow
extends JFrame {
    private static final int BORDER_WIDTH = 15;
    private JGraphicDriver display;

    public MainWindow() {
        this((GraphicsConfiguration)null);
    }

    public MainWindow(GraphicsConfiguration gc) {
        super(gc);
        this.setTitle("JBookReader");
        this.setJMenuBar(this.createMenuBar());
        this.display = new JGraphicDriver();
        this.display.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JScrollPane pane = new JScrollPane(this.display, 22, 30);
        this.add(pane);
        this.setDefaultCloseOperation(3);
        this.setPreferredSize(new Dimension(800, 600));
        this.pack();
        this.setVisible(true);
    }

    private JMenuBar createMenuBar() {
        JMenuBar mainmenu = new JMenuBar();
        mainmenu.add(this.createFileMenu());
        mainmenu.add(this.createHelpMenu());
        return mainmenu;
    }

    private Component createFileMenu() {
        JMenu menu = new JMenu();
        menu.setText("File");
        menu.setToolTipText("File operations");
        menu.setMnemonic(70);
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = new JMenu();
        menu.setText("Help");
        menu.setToolTipText("Help");
        menu.setMnemonic(72);
        JMenuItem menuItem = new JMenuItem(new AboutAction(this));
        menu.add(menuItem);
        return menu;
    }

    public JGraphicDriver getGraphicDriver() {
        return this.display;
    }
}

