/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import jbookreader.book.IBook;
import jbookreader.book.IStylesheet;
import jbookreader.formatengine.ICompositor;
import jbookreader.formatengine.IFormatEngine;
import jbookreader.formatengine.IStyleConfig;
import jbookreader.formatengine.IStyleStack;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IFont;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.Position;
import jbookreader.rendering.swing.AWTFontAdapter;
import jbookreader.rendering.swing.AWTImageAdapter;
import jbookreader.rendering.swing.Compositor;
import jbookreader.rendering.swing.JGraphicDriverConfig;
import jbookreader.rendering.swing.SimpleSwingString;
import jbookreader.style.FontDescriptor;
import lumag.util.ClassFactory;
import lumag.util.SimpleCache;

public class JGraphicDriver
extends JComponent
implements IGraphicDriver,
Scrollable {
    private SimpleCache<FontDescriptor, IFont> fontsCache = new SimpleCache<FontDescriptor, IFont>(new SimpleCache.Getter<FontDescriptor, IFont>(){

        @Override
        public IFont process(FontDescriptor fd) {
            return new AWTFontAdapter(fd, JGraphicDriver.this.getFontRC());
        }
    });
    float horizontalPosition;
    float verticalPosition;
    private IFormatEngine formatEngine;
    private Compositor compositor;
    private IBook book;
    private List<IDrawable> lines;
    private FontRenderContext fontRC;
    private Graphics2D paperGraphics;
    private IStylesheet defaultStylesheet;
    private IStylesheet formatStylesheet;
    private IStyleConfig config = new JGraphicDriverConfig(this);

    public void setCompositor(ICompositor compositor) {
        this.compositor = new Compositor(compositor);
    }

    public void setFormatEngine(IFormatEngine engine) {
        this.formatEngine = engine;
    }

    public void setBook(IBook book) {
        this.book = book;
        this.lines = null;
        this.clear();
    }

    public void setDefaultStylesheet(IStylesheet defaultStylesheet) {
        this.defaultStylesheet = defaultStylesheet;
    }

    public void setFormatStylesheet(IStylesheet formatStylesheet) {
        this.formatStylesheet = formatStylesheet;
    }

    Graphics2D getPaperGraphics() {
        return this.paperGraphics;
    }

    FontRenderContext getFontRC() {
        return this.fontRC;
    }

    public void addHorizontalSpace(float amount) {
        this.horizontalPosition += amount;
    }

    public void addVerticalSpace(float amount) {
        this.verticalPosition += amount;
    }

    public void clear() {
        this.verticalPosition = 0.0f;
        this.horizontalPosition = 0.0f;
    }

    public IFont getFont(FontDescriptor fd) {
        return this.fontsCache.get(fd);
    }

    public float getHorizontalPosition() {
        return this.horizontalPosition;
    }

    public float getVerticalPosition() {
        return this.verticalPosition;
    }

    public IDrawable renderBox(int width, int height, int depth) {
        throw new UnsupportedOperationException("boxes aren't supported");
    }

    public IDrawable renderString(String s, IFont font) {
        if (this.fontRC == null) {
            throw new IllegalStateException("renderString with null frc");
        }
        return new SimpleSwingString(this, s, (AWTFontAdapter)font);
    }

    public IDrawable renderImage(String contentType, InputStream dataStream) throws IOException {
        return new AWTImageAdapter(this, contentType, dataStream);
    }

    public int getPaperWidth() {
        Insets insets = this.getInsets();
        return this.getWidth() - insets.left - insets.right;
    }

    public int getPaperHeight() {
        Insets insets = this.getInsets();
        return this.getHeight() - insets.top - insets.bottom;
    }

    protected void paintBorder(Graphics g) {
        Rectangle rectangle = this.getVisibleRect();
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, g, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void paintComponent(Graphics g) {
        System.err.println("REPAINT " + this.getWidth() + "x" + this.getHeight());
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.book == null) {
            return;
        }
        Rectangle visible = this.getVisibleRect();
        Insets insets = this.getInsets();
        int w = visible.width - insets.left - insets.right;
        int h = visible.height - insets.top - insets.bottom;
        int offset = visible.y;
        System.out.println(w + "x" + h + "@" + offset);
        this.paperGraphics = (Graphics2D)g.create(visible.x + insets.left, visible.y + insets.top, w, h);
        this.paperGraphics.setBackground(this.getBackground());
        this.paperGraphics.setColor(Color.BLACK);
        this.paperGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paperGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.paperGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.fontRC = this.paperGraphics.getFontRenderContext();
        if (this.lines == null || this.lines.isEmpty() || (float)this.getPaperWidth() != this.lines.get(0).getWidth(Position.MIDDLE)) {
            this.reformatBook();
            float height = 0.0f;
            for (IDrawable dr : this.lines) {
                height += dr.getHeight() + dr.getDepth();
            }
            System.out.println(height + (float)insets.top + (float)insets.bottom);
            this.setPreferredSize(new Dimension(this.getWidth(), Math.round(height + (float)insets.top + (float)insets.bottom)));
            this.revalidate();
            this.repaint();
        } else {
            int hmin = 0;
            int hmax = this.getPaperHeight();
            Rectangle rectangle = this.paperGraphics.getClipBounds();
            if (rectangle != null) {
                hmin = rectangle.y;
                hmax = rectangle.y + rectangle.height;
            }
            System.out.print("rendering from " + hmin + " to " + hmax + "... ");
            this.horizontalPosition = 0.0f;
            this.verticalPosition = -offset;
            long before = System.nanoTime();
            for (IDrawable dr : this.lines) {
                if (this.verticalPosition + dr.getHeight() > (float)hmin) {
                    dr.draw(Position.MIDDLE);
                    this.horizontalPosition = 0.0f;
                }
                this.verticalPosition += dr.getHeight() + dr.getDepth();
                if (!(this.verticalPosition > (float)hmax)) continue;
                break;
            }
            long after = System.nanoTime();
            System.err.println("done " + (after - before) / 1000000L + "ms");
        }
        this.fontRC = null;
        this.paperGraphics.dispose();
        this.paperGraphics = null;
    }

    private void reformatBook() {
        IStylesheet bookStylesheet;
        System.err.println("formatting");
        IStyleStack styleStack = ClassFactory.createClass(IStyleStack.class, "jbookreader.stylestack");
        styleStack.setConfig(this.config);
        if (this.defaultStylesheet != null) {
            styleStack.addStylesheet(this.defaultStylesheet);
        }
        if (this.formatStylesheet != null) {
            styleStack.addStylesheet(this.formatStylesheet);
        }
        if ((bookStylesheet = this.book.getStylesheet()) != null) {
            styleStack.addStylesheet(bookStylesheet);
        }
        this.compositor.clearTotal();
        long before = System.nanoTime();
        this.lines = this.formatEngine.format(this, this.compositor, this.book.getFirstBody(), styleStack);
        long after = System.nanoTime();
        long format = (after - before) / 1000000L;
        long compose = this.compositor.getTotal();
        System.err.println("done " + format + "ms (" + compose + "ms for composition)");
    }

    private int findNextHeight(float height, int direction) {
        float h = height;
        if (direction > 0) {
            for (IDrawable dr : this.lines) {
                float move = -(h -= dr.getHeight() + dr.getDepth());
                if (!(move > 1.0f)) continue;
                return Math.round(move);
            }
        } else {
            for (IDrawable dr : this.lines) {
                if (h > dr.getHeight() + dr.getDepth() + 1.0f) {
                    h -= dr.getHeight() + dr.getDepth();
                    continue;
                }
                float move = h;
                return Math.round(move);
            }
        }
        return 0;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.lines == null || this.lines.isEmpty() || orientation == 0) {
            return 0;
        }
        float height = visibleRect.y;
        return this.findNextHeight(height, direction);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int pageSize = 100;
        if (this.lines == null || this.lines.isEmpty() || orientation == 0) {
            return 0;
        }
        float height = visibleRect.y;
        height = direction > 0 ? (height += 100.0f) : (height -= 100.0f);
        return 100 + this.findNextHeight(height, direction);
    }
}

