/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.impl;

import jbookreader.formatengine.IAdjustableDrawable;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.Position;

class Glue
implements IDrawable,
IAdjustableDrawable {
    private final float space;
    private final float stretch;
    private final float shrink;
    private final IGraphicDriver driver;
    private float adjustment;

    Glue(IGraphicDriver driver, float space, float stretch, float shrink) {
        this.driver = driver;
        this.space = space;
        this.stretch = stretch;
        this.shrink = shrink;
    }

    public float getShrink(Position position) {
        if (position != Position.MIDDLE) {
            return 0.0f;
        }
        return this.stretch;
    }

    public float getWidth(Position position) {
        if (position != Position.MIDDLE) {
            return 0.0f;
        }
        return this.space + this.adjustment;
    }

    public float getStretch(Position position) {
        if (position != Position.MIDDLE) {
            return 0.0f;
        }
        return this.stretch;
    }

    public float getDepth() {
        return 0.0f;
    }

    public float getHeight() {
        return 0.0f;
    }

    public void draw(Position position) {
        this.driver.addHorizontalSpace(this.getWidth(position));
    }

    public String toString() {
        return "Glue: " + this.space + "+" + this.adjustment + ":" + this.stretch + ":" + this.shrink;
    }

    public void adjust(float adjust) {
        this.adjustment = adjust;
    }
}

