/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jbookreader.book.IBinaryBlob;
import jbookreader.book.IContainerNode;
import jbookreader.book.IImageNode;
import jbookreader.book.INode;
import jbookreader.book.INodeVisitor;
import jbookreader.book.ITextNode;
import jbookreader.formatengine.ICompositor;
import jbookreader.formatengine.IFormatEngine;
import jbookreader.formatengine.IStyleStack;
import jbookreader.formatengine.impl.Glue;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IFont;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.style.Alignment;
import jbookreader.style.FontDescriptor;
import jbookreader.style.FontStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatEngine
implements IFormatEngine {
    @Override
    public List<IDrawable> format(IGraphicDriver driver, ICompositor compositor, INode node, IStyleStack styleStack) {
        ArrayList<IDrawable> result = new ArrayList<IDrawable>();
        node.accept(new BlockFormattingVisitor(driver, compositor, result, styleStack));
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InlineFormattingVisitor
    implements INodeVisitor {
        private final List<IDrawable> result;
        private final IGraphicDriver driver;
        private final IStyleStack styleStack;

        public InlineFormattingVisitor(IGraphicDriver driver, List<IDrawable> result, IStyleStack styleStack) {
            this.driver = driver;
            this.result = result;
            this.styleStack = styleStack;
        }

        @Override
        public void visitContainerNode(IContainerNode node) {
            this.styleStack.push(node);
            switch (this.styleStack.getDisplay()) {
                case NONE: {
                    this.styleStack.pop();
                    return;
                }
                case INLINE: {
                    node.visitChildren(this);
                    this.styleStack.pop();
                    break;
                }
                case BLOCK: {
                    System.err.println("BLOCK container in inline node isn't supported!");
                    this.styleStack.pop();
                    return;
                }
            }
        }

        @Override
        public void visitTextNode(ITextNode node) {
            int start;
            this.styleStack.push(node);
            String text = node.getText();
            if (text == null) {
                this.styleStack.pop();
                return;
            }
            IFont font = this.driver.getFont(new FontDescriptor(this.styleStack.getFontFamily()[0], this.styleStack.getFontSize(), this.styleStack.getFontWeight() > 500, this.styleStack.getFontStyle() != FontStyle.NORMAL));
            char[] str = text.toCharArray();
            int size = str.length;
            int end = start = 0;
            while (end < size) {
                while (start < size && str[start] <= ' ') {
                    ++start;
                }
                if (start > end) {
                    this.result.add(new Glue(this.driver, font.getSpaceWidth(), 1.0f, 1.0f));
                }
                for (end = start; end < size && str[end] > ' '; ++end) {
                }
                if (end == start) continue;
                String s = new String(str, start, end - start);
                this.result.add(this.driver.renderString(s, font));
                start = end;
            }
            this.styleStack.pop();
        }

        @Override
        public void visitImageNode(IImageNode node) {
            this.styleStack.push(node);
            switch (this.styleStack.getDisplay()) {
                case NONE: {
                    this.styleStack.pop();
                    return;
                }
                case INLINE: 
                case BLOCK: {
                    IDrawable image = this.formatImage(node.getHRef(), node);
                    if (image != null) {
                        this.result.add(image);
                    } else {
                        this.visitTextNode(node);
                    }
                    this.styleStack.pop();
                }
            }
        }

        private IDrawable formatImage(String href, IImageNode node) {
            if (href.length() >= 1 && href.charAt(0) == '#') {
                IBinaryBlob blob = node.getBook().getBinaryBlob(href.substring(1));
                if (blob != null) {
                    try {
                        return this.driver.renderImage(blob.getContentType(), blob.getDataStream());
                    }
                    catch (UnsupportedOperationException e) {
                        System.err.println("Error: " + e.getMessage());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                System.err.println("Bad image HRef: " + href);
            }
            return null;
        }

        @Override
        public void flush() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockFormattingVisitor
    implements INodeVisitor {
        private final IGraphicDriver driver;
        private final List<IDrawable> result;
        private final ICompositor compositor;
        private final IStyleStack styleStack;
        private List<IDrawable> inline = null;
        private Alignment textAlign = null;

        public BlockFormattingVisitor(IGraphicDriver driver, ICompositor compositor, List<IDrawable> result, IStyleStack styleStack) {
            this.driver = driver;
            this.compositor = compositor;
            this.result = result;
            this.styleStack = styleStack;
        }

        @Override
        public void visitContainerNode(IContainerNode node) {
            this.styleStack.push(node);
            switch (this.styleStack.getDisplay()) {
                case NONE: {
                    this.styleStack.pop();
                    return;
                }
                case INLINE: {
                    this.styleStack.pop();
                    this.formatInline(node);
                    break;
                }
                case BLOCK: {
                    this.flushInline();
                    node.visitChildren(this);
                    this.styleStack.pop();
                }
            }
        }

        @Override
        public void visitTextNode(ITextNode node) {
            this.formatInline(node);
        }

        @Override
        public void visitImageNode(IImageNode node) {
            this.styleStack.push(node);
            boolean flush = false;
            switch (this.styleStack.getDisplay()) {
                case NONE: {
                    this.styleStack.pop();
                    return;
                }
                case INLINE: {
                    break;
                }
                case BLOCK: {
                    this.styleStack.pop();
                    flush = true;
                }
            }
            this.formatInline(node);
            if (flush) {
                this.flushInline();
            }
        }

        private void formatInline(INode node) {
            if (this.inline == null) {
                this.inline = new ArrayList<IDrawable>();
                this.textAlign = this.styleStack.getTextAlign();
            }
            InlineFormattingVisitor visitor = new InlineFormattingVisitor(this.driver, this.inline, this.styleStack);
            node.accept(visitor);
        }

        private void flushInline() {
            if (this.inline == null) {
                return;
            }
            List<IDrawable> lines = this.compositor.compose(this.inline, this.driver.getPaperWidth(), this.textAlign, this.driver);
            this.result.addAll(lines);
            this.inline = null;
            this.textAlign = null;
        }

        @Override
        public void flush() {
            this.flushInline();
        }
    }
}

