/*
 * Decompiled with CFR 0.152.
 */
package lumag.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCache<K, V> {
    private final Getter<K, V> getter;
    private final ReferenceQueue<V> queue = new ReferenceQueue();
    private final Map<K, Reference<V>> forwardMap = new HashMap<K, Reference<V>>();
    private final Map<Reference<V>, K> backwardMap = new HashMap<Reference<V>, K>();

    public SimpleCache(Getter<K, V> getter) {
        this.getter = getter;
    }

    public V get(K key) {
        this.clearQueue();
        V value = null;
        Reference<V> ref = this.forwardMap.get(key);
        if (ref != null && (value = (V)ref.get()) == null) {
            this.backwardMap.remove(ref);
            this.forwardMap.remove(key);
        }
        if (value == null) {
            value = this.addValue(key);
        }
        return value;
    }

    public void remove(K key) {
        Reference<V> ref = this.forwardMap.remove(key);
        this.backwardMap.remove(ref);
        ref.clear();
        this.clearQueue();
    }

    public void clear() {
        Iterator<Reference<V>> it = this.backwardMap.keySet().iterator();
        while (it.hasNext()) {
            it.next().clear();
            it.remove();
        }
        this.forwardMap.clear();
        while (this.queue.poll() != null) {
        }
    }

    private void clearQueue() {
        Reference<V> ref;
        while ((ref = this.queue.poll()) != null) {
            K key = this.backwardMap.remove(ref);
            this.forwardMap.remove(key);
        }
    }

    private V addValue(K key) {
        V value = this.getter.process(key);
        SoftReference<V> ref = new SoftReference<V>(value, this.queue);
        this.forwardMap.put(key, ref);
        this.backwardMap.put((Reference<K>)ref, (SoftReference<V>)key);
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Getter<K, V> {
        public V process(K var1);
    }
}

