/*
 * Decompiled with CFR 0.152.
 */
package lumag.util;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import lumag.util.IOrderedContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedSet<E>
extends AbstractSet<E>
implements Set<E>,
IOrderedContainer<E> {
    private Map<E, E> forwardMap = new HashMap<E, E>();
    private Map<E, E> backwardMap = new HashMap<E, E>();

    public OrderedSet() {
        this.forwardMap.put(null, null);
        this.backwardMap.put(null, null);
    }

    @Override
    public Iterator<E> iterator() {
        return new SetIterator();
    }

    @Override
    public int size() {
        return this.forwardMap.size() - 1;
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.contains((Object)e)) {
            return false;
        }
        E last = this.backwardMap.get(null);
        this.forwardMap.put(e, null);
        this.backwardMap.put(e, last);
        this.backwardMap.put(null, e);
        this.forwardMap.put(last, e);
        return true;
    }

    @Override
    public void clear() {
        this.forwardMap.clear();
        this.forwardMap.put(null, null);
        this.backwardMap.clear();
        this.backwardMap.put(null, null);
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return this.forwardMap.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!this.contains(o)) {
            return false;
        }
        E previous = this.backwardMap.remove(o);
        E next = this.forwardMap.remove(o);
        this.forwardMap.put(previous, next);
        this.backwardMap.put(next, previous);
        return true;
    }

    @Override
    public E getNext(E element) throws NoSuchElementException {
        if (!this.contains((Object)element)) {
            throw new NoSuchElementException();
        }
        E result = this.forwardMap.get(element);
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public E getPrevious(E element) throws NoSuchElementException {
        if (!this.contains((Object)element)) {
            throw new NoSuchElementException();
        }
        E result = this.backwardMap.get(element);
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public boolean hasNext(E element) {
        if (!this.contains((Object)element)) {
            throw new NoSuchElementException();
        }
        return this.forwardMap.get(element) != null;
    }

    @Override
    public boolean hasPrevious(E element) {
        if (!this.contains((Object)element)) {
            throw new NoSuchElementException();
        }
        return this.backwardMap.get(element) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetIterator
    implements Iterator<E> {
        private E lastReturnedElement = null;

        private SetIterator() {
        }

        @Override
        public boolean hasNext() {
            return OrderedSet.this.forwardMap.get(this.lastReturnedElement) != null;
        }

        @Override
        public E next() {
            Object next = OrderedSet.this.forwardMap.get(this.lastReturnedElement);
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.lastReturnedElement = next;
            return this.lastReturnedElement;
        }

        @Override
        public void remove() {
            if (this.lastReturnedElement == null) {
                throw new IllegalStateException();
            }
            Object previous = OrderedSet.this.backwardMap.get(this.lastReturnedElement);
            OrderedSet.this.remove(this.lastReturnedElement);
            this.lastReturnedElement = previous;
        }
    }
}

