/*
 * Decompiled with CFR 0.152.
 */
package lumag.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassFactory {
    private static Properties defaults = new Properties();

    private ClassFactory() {
    }

    private static String findClassName(String property) {
        String className = null;
        try {
            className = System.getProperty(property);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (className == null) {
            className = defaults.getProperty(property);
        }
        if (className == null) {
            throw new IllegalArgumentException("Can't find a class for '" + property + "' property");
        }
        return className;
    }

    public static InputStream getResourceStream(String resourceName) throws IOException {
        ClassLoader loader = ClassFactory.getClassLoader();
        InputStream stream = loader == null ? new FileInputStream(resourceName) : loader.getResourceAsStream(resourceName);
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperies(String pkg) {
        InputStream stream = null;
        String resourceName = "";
        if (pkg != null && !"".equals(pkg)) {
            resourceName = pkg + ".";
        }
        resourceName = resourceName.replace('.', '/');
        resourceName = resourceName + "classes.properties";
        try {
            stream = ClassFactory.getResourceStream(resourceName);
            defaults.load(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.class.getClassLoader();
        }
        return loader;
    }

    public static <T> T createClass(Class<T> intf, String property) {
        String className = ClassFactory.findClassName(property);
        ClassLoader loader = ClassFactory.getClassLoader();
        try {
            Class<T> klass = loader == null ? Class.forName(className).asSubclass(intf) : loader.loadClass(className).asSubclass(intf);
            return klass.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new UnknownError(e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new UnknownError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new UnknownError(e.getMessage());
        }
    }
}

