/*
 * Decompiled with CFR 0.152.
 */
package lumag.rtf;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import lumag.rtf.CodePageTables;
import lumag.rtf.DefaultRTFHandler;
import lumag.rtf.IRTFContentHandler;

public class RTFParser {
    private IRTFContentHandler handler;
    private int level;
    private State state = State.TEXT;
    private char[] codePageTable = CodePageTables.getCodePageTable(437);
    private StringBuilder builder = new StringBuilder();
    private String currentControl;
    private int tickedChar;
    private boolean shouldSkipGroupIfUnknown;
    private int skipLevel = Integer.MAX_VALUE;
    private long blobBytesLeft;
    private ByteArrayOutputStream blobBuffer;

    public void setCharacterSet(int cpNumber) {
        char[] table = CodePageTables.getCodePageTable(cpNumber);
        if (table != null) {
            this.codePageTable = table;
        } else {
            System.err.println("Unsupported codepage" + cpNumber);
        }
    }

    private void processControlWord(String control, boolean hasParameter, int parameter) {
        if (this.level >= this.skipLevel) {
            this.builder.setLength(0);
            return;
        }
        boolean handled = false;
        if (!(handled |= this.handler.control(control, hasParameter, hasParameter ? parameter : 1))) {
            String ctrl = control;
            if (hasParameter) {
                ctrl = ctrl + " " + parameter;
            }
            if (this.shouldSkipGroupIfUnknown) {
                System.err.println("Ignoring: " + ctrl);
                this.skipLevel = this.level;
                this.shouldSkipGroupIfUnknown = false;
            } else {
                System.err.println("Ignored unsupported control: " + ctrl);
            }
        }
        this.state = State.TEXT;
    }

    public void process(byte[] bytes, int offset, int length) {
        block9: for (int i = 0; i < length; ++i) {
            byte b = bytes[offset + i];
            switch (this.state) {
                case TEXT: {
                    this.processStateText(b);
                    continue block9;
                }
                case BACKSLASH: {
                    this.processStateBackslash(b);
                    continue block9;
                }
                case CONTROL: {
                    this.processStateControl(b);
                    continue block9;
                }
                case PARAMETER: {
                    this.processStateParameter(b);
                    continue block9;
                }
                case BACKTICK: {
                    this.processStateBacktick(b);
                    continue block9;
                }
                case BACKTICK_X: {
                    this.processStateBacktickX(b);
                    continue block9;
                }
                case BLOB: {
                    this.processStateBlob(b);
                    continue block9;
                }
                default: {
                    throw new InternalError("unsupported rtf state?");
                }
            }
        }
    }

    private void processStateText(byte b) {
        if (this.level < this.skipLevel) {
            this.processStateTextNormal(b);
        } else {
            this.processStateTextIgnoredGroup(b);
        }
    }

    private void processStateTextIgnoredGroup(byte b) {
        this.builder.setLength(0);
        if (b == 123) {
            ++this.level;
        } else if (b == 125) {
            if (this.level == this.skipLevel) {
                this.handler.endGroup();
                this.skipLevel = Integer.MAX_VALUE;
            }
            --this.level;
        } else if (b == 92) {
            this.builder.setLength(0);
            this.state = State.BACKSLASH;
        }
    }

    private void processStateTextNormal(byte b) {
        if (b == 123) {
            this.handler.string(this.builder.toString());
            this.builder.setLength(0);
            ++this.level;
            this.handler.startGroup();
        } else if (b == 125) {
            this.handler.string(this.builder.toString());
            this.builder.setLength(0);
            this.handler.endGroup();
            --this.level;
        } else if (b == 92) {
            this.handler.string(this.builder.toString());
            this.builder.setLength(0);
            this.state = State.BACKSLASH;
        } else if (b != 10 && b != 13) {
            this.putChar(b);
        }
    }

    private void processStateBackslash(byte b) {
        if (Character.isLetter(b)) {
            this.state = State.CONTROL;
            this.putChar(b);
        } else if (b == 39) {
            this.state = State.BACKTICK;
            this.tickedChar = 0;
        } else if (b == 42) {
            this.shouldSkipGroupIfUnknown = true;
            this.state = State.TEXT;
        } else {
            this.processControlWord(String.valueOf((char)b), false, 1);
        }
    }

    private void processStateControl(byte b) {
        if (Character.isLetter(b)) {
            this.putChar(b);
        } else if (Character.isDigit(b) || b == 45) {
            this.currentControl = this.builder.toString();
            this.builder.setLength(0);
            this.putChar(b);
            this.state = State.PARAMETER;
        } else {
            this.currentControl = this.builder.toString();
            this.builder.setLength(0);
            this.processControlWord(this.currentControl, false, 1);
            this.currentControl = null;
            if (!Character.isWhitespace(b)) {
                this.processStateText(b);
            }
        }
    }

    private void processStateParameter(byte b) {
        if (Character.isDigit(b)) {
            this.putChar(b);
        } else if (this.currentControl.equals("bin")) {
            this.blobBytesLeft = Long.valueOf(this.builder.toString());
            this.builder.setLength(0);
            this.blobBuffer = this.blobBytesLeft > Integer.MAX_VALUE ? new ByteArrayOutputStream(Integer.MAX_VALUE) : new ByteArrayOutputStream((int)this.blobBytesLeft);
            this.state = State.BLOB;
        } else {
            int parameterValue = Integer.valueOf(this.builder.toString());
            this.builder.setLength(0);
            this.processControlWord(this.currentControl, true, parameterValue);
            this.currentControl = null;
            if (!Character.isWhitespace(b)) {
                this.processStateText(b);
            }
        }
    }

    private void processStateBacktick(byte b) {
        if (Character.digit(b, 16) == -1) {
            this.state = State.TEXT;
        } else {
            this.tickedChar = Character.digit(b, 16);
            this.state = State.BACKTICK_X;
        }
    }

    private void processStateBacktickX(byte b) {
        if (Character.digit(b, 16) != -1) {
            this.tickedChar = (this.tickedChar << 4) + Character.digit(b, 16);
            this.putChar(this.tickedChar);
        }
        this.state = State.TEXT;
    }

    private void processStateBlob(byte b) {
        this.blobBuffer.write(b);
        --this.blobBytesLeft;
        if (this.blobBytesLeft == 0L) {
            if (this.level < this.skipLevel) {
                this.handler.binaryBlob(this.blobBuffer.toByteArray());
            }
            this.blobBuffer = null;
            this.state = State.TEXT;
        }
    }

    private void putChar(int ch) {
        this.builder.append(this.codePageTable[ch & 0xFF]);
    }

    public void setHandler(IRTFContentHandler handler) {
        this.handler = handler;
    }

    public static void main(String[] args) throws Exception {
        int len;
        RTFParser parser = new RTFParser();
        parser.setHandler(new DefaultRTFHandler());
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(args.length > 0 ? args[0] : "tests/test.rtf"));
        byte[] buffer = new byte[1024];
        while ((len = ((InputStream)stream).read(buffer)) >= 0) {
            parser.process(buffer, 0, len);
        }
        ((InputStream)stream).close();
    }

    public int getLevel() {
        return this.level;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        TEXT,
        BACKSLASH,
        CONTROL,
        PARAMETER,
        BACKTICK,
        BACKTICK_X,
        BLOB;

    }
}

