/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.swing;

import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.Position;
import jbookreader.rendering.swing.AWTFontAdapter;
import jbookreader.rendering.swing.JGraphicDriver;

final class SimpleSwingString
implements IDrawable {
    private final JGraphicDriver driver;
    private final String string;
    private final AWTFontAdapter font;
    private float height;
    private float depth;
    private float width;

    SimpleSwingString(JGraphicDriver driver, String string, AWTFontAdapter font) {
        this.driver = driver;
        this.string = string;
        this.font = font;
        LineMetrics metrics = font.getFont().getLineMetrics(string, driver.getFontRC());
        Rectangle2D bounds = font.getFont().getStringBounds(string, driver.getFontRC());
        this.height = metrics.getAscent();
        this.depth = metrics.getDescent();
        this.width = (float)bounds.getWidth();
    }

    public void draw(Position position) {
        Graphics2D graphics = this.driver.getPaperGraphics();
        if (!graphics.getFont().equals(this.font.getFont())) {
            graphics.setFont(this.font.getFont());
        }
        graphics.drawString(this.string, this.driver.horizontalPosition, this.driver.verticalPosition + this.height);
        this.driver.horizontalPosition += this.width;
    }

    public float getDepth() {
        return this.depth;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth(Position position) {
        return this.width;
    }
}

