/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.style.impl;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import jbookreader.book.INode;
import jbookreader.book.IStylesheet;
import jbookreader.formatengine.IStyleConfig;
import jbookreader.formatengine.IStyleStack;
import jbookreader.formatengine.style.impl.StyleStackState;
import jbookreader.style.Alignment;
import jbookreader.style.Display;
import jbookreader.style.FontStyle;
import jbookreader.style.IStyleRule;
import jbookreader.style.StyleAttribute;

public class StyleStackImpl
implements IStyleStack {
    private List<IStylesheet> stylesheets = new ArrayList<IStylesheet>();
    private List<StyleStackState> stateStack = new ArrayList<StyleStackState>();
    private StyleStackState currentState;
    private IStyleConfig config;

    public void setConfig(IStyleConfig config) {
        if (this.currentState != null) {
            throw new IllegalStateException("Can't change config in the middle of operation");
        }
        this.config = config;
        this.currentState = new StyleStackState(config);
        this.stateStack.add(this.currentState);
    }

    IStyleConfig getConfig() {
        return this.config;
    }

    public void addStylesheet(IStylesheet stylesheet) {
        this.stylesheets.add(stylesheet);
    }

    public void push(INode node) {
        EnumMap<StyleAttribute, IStyleRule> rules = new EnumMap<StyleAttribute, IStyleRule>(StyleAttribute.class);
        for (IStylesheet stylesheet : this.stylesheets) {
            for (IStyleRule rule : stylesheet.getApplicableRules(node)) {
                StyleAttribute attrib = rule.getAttribute();
                long weight = rule.getWeight();
                if (rules.containsKey(attrib) && ((IStyleRule)rules.get(attrib)).getWeight() > weight) continue;
                rules.put(attrib, rule);
            }
        }
        this.currentState = new StyleStackState(this.currentState, rules, this.config);
        this.stateStack.add(this.currentState);
    }

    public void pop() {
        this.stateStack.remove(this.currentState);
        if (this.stateStack.isEmpty()) {
            this.currentState = new StyleStackState(this.config);
            this.stateStack.add(this.currentState);
            System.err.println("style stack became empty!");
        } else {
            this.currentState = this.stateStack.get(this.stateStack.size() - 1);
        }
    }

    public Display getDisplay() {
        return (Display)((Object)this.currentState.getAttributeValue(StyleAttribute.DISPLAY));
    }

    public Alignment getTextAlign() {
        return (Alignment)((Object)this.currentState.getAttributeValue(StyleAttribute.TEXT_ALIGN));
    }

    public String[] getFontFamily() {
        return (String[])this.currentState.getAttributeValue(StyleAttribute.FONT_FAMILY);
    }

    public int getFontSize() {
        return (Integer)this.currentState.getAttributeValue(StyleAttribute.FONT_SIZE);
    }

    public int getFontWeight() {
        return (Integer)this.currentState.getAttributeValue(StyleAttribute.FONT_WEIGHT);
    }

    public FontStyle getFontStyle() {
        return (FontStyle)((Object)this.currentState.getAttributeValue(StyleAttribute.FONT_STYLE));
    }
}

