/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jbookreader.formatengine.IAdjustableDrawable;
import jbookreader.formatengine.ICompositor;
import jbookreader.formatengine.impl.HBox;
import jbookreader.formatengine.impl.SimpleWhitespace;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.Position;
import jbookreader.style.Alignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCompositor
implements ICompositor {
    @Override
    public List<IDrawable> compose(List<IDrawable> particles, int width, Alignment alignment, IGraphicDriver driver) {
        ArrayList<IDrawable> result = new ArrayList<IDrawable>();
        ArrayList<IDrawable> line = new ArrayList<IDrawable>();
        float currentWidth = 0.0f;
        for (IDrawable d : particles) {
            if (line.isEmpty()) {
                line.add(d);
                currentWidth = d.getWidth(Position.START);
                continue;
            }
            if (currentWidth + d.getWidth(Position.END) > (float)width) {
                IDrawable last = (IDrawable)line.get(line.size() - 1);
                currentWidth = currentWidth - last.getWidth(Position.MIDDLE) + last.getWidth(Position.END);
                result.add(this.makeHBox(driver, line, width, alignment, false));
                line.clear();
                line.add(d);
                currentWidth = d.getWidth(Position.START);
                continue;
            }
            if (currentWidth + d.getWidth(Position.MIDDLE) > (float)width) {
                line.add(d);
                currentWidth += d.getWidth(Position.END);
                result.add(this.makeHBox(driver, line, width, alignment, false));
                line.clear();
                currentWidth = 0.0f;
                continue;
            }
            line.add(d);
            currentWidth += d.getWidth(Position.MIDDLE);
        }
        if (!line.isEmpty()) {
            IDrawable last = (IDrawable)line.get(line.size() - 1);
            currentWidth = currentWidth - last.getWidth(Position.MIDDLE) + last.getWidth(Position.END);
            result.add(this.makeHBox(driver, line, width, alignment, true));
            line.clear();
        }
        return result;
    }

    private IDrawable makeHBox(IGraphicDriver driver, List<IDrawable> line, float width, Alignment alignment, boolean last) {
        HBox hbox;
        switch (alignment) {
            case JUSTIFY: {
                hbox = this.makeJustifiedHBox(line, width, last);
                float boxWidth = hbox.getWidth(Position.MIDDLE);
                float defect = width - boxWidth;
                if (defect == 0.0f) break;
                HBox wrapperBox = new HBox();
                wrapperBox.add(hbox);
                wrapperBox.add(new SimpleWhitespace(driver, defect));
                hbox = wrapperBox;
                break;
            }
            case LEFT: {
                hbox = new HBox();
                hbox.addAll(line);
                float boxWidth = hbox.getWidth(Position.MIDDLE);
                float defect = width - boxWidth;
                if (defect == 0.0f) break;
                HBox wrapperBox = new HBox();
                wrapperBox.add(hbox);
                wrapperBox.add(new SimpleWhitespace(driver, defect));
                hbox = wrapperBox;
                break;
            }
            case RIGHT: {
                hbox = new HBox();
                hbox.addAll(line);
                float boxWidth = hbox.getWidth(Position.MIDDLE);
                float defect = width - boxWidth;
                if (defect == 0.0f) break;
                HBox wrapperBox = new HBox();
                wrapperBox.add(new SimpleWhitespace(driver, defect));
                wrapperBox.add(hbox);
                hbox = wrapperBox;
                break;
            }
            case CENTER: {
                hbox = new HBox();
                hbox.addAll(line);
                float boxWidth = hbox.getWidth(Position.MIDDLE);
                float defect = width - boxWidth;
                if (defect == 0.0f) break;
                HBox wrapperBox = new HBox();
                wrapperBox.add(new SimpleWhitespace(driver, defect / 2.0f));
                wrapperBox.add(hbox);
                wrapperBox.add(new SimpleWhitespace(driver, defect - defect / 2.0f));
                hbox = wrapperBox;
                break;
            }
            default: {
                throw new InternalError("Unhandled alignment type: " + (Object)((Object)alignment));
            }
        }
        return hbox;
    }

    private HBox makeJustifiedHBox(List<IDrawable> line, float width, boolean last) {
        if (last) {
            HBox hbox = new HBox();
            hbox.addAll(line);
            return hbox;
        }
        float currentWidth = 0.0f;
        float currentStretch = 0.0f;
        ListIterator<IDrawable> iter = line.listIterator();
        while (iter.hasNext()) {
            IDrawable d = iter.next();
            currentWidth = iter.previousIndex() == 0 ? (currentWidth += d.getWidth(Position.START)) : (iter.hasNext() ? (currentWidth += d.getWidth(Position.MIDDLE)) : (currentWidth += d.getWidth(Position.END)));
            if (!(d instanceof IAdjustableDrawable)) continue;
            IAdjustableDrawable ad = (IAdjustableDrawable)d;
            if (iter.previousIndex() == 0) {
                currentStretch += ad.getStretch(Position.START);
                continue;
            }
            if (iter.hasNext()) {
                currentStretch += ad.getStretch(Position.MIDDLE);
                continue;
            }
            currentStretch += ad.getStretch(Position.END);
        }
        if (currentStretch == 0.0f) {
            HBox hbox = new HBox();
            hbox.addAll(line);
            return hbox;
        }
        float adjust = width - currentWidth;
        if (adjust < 0.0f) {
            throw new UnsupportedOperationException("Shrinking isn't supported yet");
        }
        HBox hbox = new HBox();
        ListIterator<IDrawable> iter2 = line.listIterator();
        while (iter2.hasNext()) {
            IDrawable drawable = iter2.next();
            if (drawable instanceof IAdjustableDrawable) {
                IAdjustableDrawable d = (IAdjustableDrawable)drawable;
                float adj_i = iter2.previousIndex() == 0 ? d.getStretch(Position.START) : (iter2.hasNext() ? d.getStretch(Position.MIDDLE) : d.getStretch(Position.END));
                if (adj_i != 0.0f) {
                    float amount = adjust * adj_i / currentStretch;
                    adjust -= amount;
                    currentStretch -= adj_i;
                    d.adjust(amount);
                }
            }
            hbox.add(drawable);
        }
        return hbox;
    }
}

