/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HBox
implements IDrawable {
    private final List<IDrawable> elements = new ArrayList<IDrawable>();
    private float width;
    private float height;
    private float depth;

    HBox() {
    }

    @Override
    public void draw(Position position) {
        ListIterator<IDrawable> it = this.elements.listIterator();
        while (it.hasNext()) {
            IDrawable drawable = it.next();
            if (it.previousIndex() == 0) {
                drawable.draw(Position.START);
                continue;
            }
            if (it.hasNext()) {
                drawable.draw(Position.MIDDLE);
                continue;
            }
            drawable.draw(Position.END);
        }
    }

    @Override
    public float getDepth() {
        return this.depth;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getWidth(Position position) {
        return this.width;
    }

    public void add(IDrawable drawable) {
        if (this.elements.isEmpty()) {
            this.width = drawable.getWidth(Position.START);
        } else {
            IDrawable last = this.elements.get(this.elements.size() - 1);
            this.width += drawable.getWidth(Position.END) + last.getWidth(Position.MIDDLE) - last.getWidth(Position.END);
        }
        if (this.height < drawable.getHeight()) {
            this.height = drawable.getHeight();
        }
        if (this.depth < drawable.getDepth()) {
            this.depth = drawable.getDepth();
        }
        this.elements.add(drawable);
    }

    public void addAll(List<IDrawable> drawables) {
        ListIterator<IDrawable> it = drawables.listIterator();
        while (it.hasNext()) {
            IDrawable drawable = it.next();
            this.width = it.previousIndex() == 0 && this.elements.size() == 0 ? (this.width += drawable.getWidth(Position.START)) : (it.hasNext() ? (this.width += drawable.getWidth(Position.MIDDLE)) : (this.width += drawable.getWidth(Position.END)));
            if (this.height < drawable.getHeight()) {
                this.height = drawable.getHeight();
            }
            if (this.depth < drawable.getDepth()) {
                this.depth = drawable.getDepth();
            }
            this.elements.add(drawable);
        }
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public String toString() {
        return this.width + " x " + this.height + " + " + this.depth;
    }
}

