/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.css;

import java.util.ArrayList;
import jbookreader.css.CSSHandler;
import jbookreader.css.IRuleHandler;
import jbookreader.style.ERuleValueType;
import jbookreader.style.StyleAttribute;
import org.w3c.css.sac.LexicalUnit;

class StringArrayHandler
implements IRuleHandler {
    private final StyleAttribute attribute;

    public StringArrayHandler(StyleAttribute attribute) {
        this.attribute = attribute;
    }

    public void handle(CSSHandler handler, LexicalUnit value) {
        if (value.getLexicalUnitType() == 12) {
            handler.addRule(this.attribute, ERuleValueType.INHERIT, null);
        }
        ArrayList<String> strings = new ArrayList<String>();
        block4: for (LexicalUnit lex = value; lex != null; lex = lex.getNextLexicalUnit()) {
            switch (lex.getLexicalUnitType()) {
                case 0: {
                    continue block4;
                }
                case 35: 
                case 36: {
                    strings.add(lex.getStringValue());
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Bad value type: " + value.getLexicalUnitType() + " (" + value + ")");
                }
            }
        }
        handler.addRule(this.attribute, ERuleValueType.STRING_ARRAY, strings.toArray(new String[strings.size()]));
    }
}

