#include "include/dha2.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main( void )
{
  pciinfo_t lst[MAX_PCI_DEVICES];
  unsigned i,num_pci;
  unsigned long dev_class_long;
  int err;
  err = pci_scan(lst,&num_pci);
  if(err)
  {
    printf("Error occurred during pci scan: %s\n",strerror(err));
    return EXIT_FAILURE;
  }
  else
  {
    printf(" Bus:card:func vend:dev  command base0   :base1   :base2   :baserom\n");
    for(i=0;i<num_pci;i++)
    {
	dev_class_long = pci_config_read_long(lst[i].bus, lst[i].card, lst[i].func, 0x08);
	printf("%04X:%04X:%04X %04X:%04X %04X    %08X:%08X:%08X:%08X    :%08lX\n"
    	    ,lst[i].bus,lst[i].card,lst[i].func
	    ,lst[i].vendor,lst[i].device,lst[i].command
	    ,lst[i].base0,lst[i].base1,lst[i].base2,lst[i].baserom,dev_class_long);
    }
  }
  return EXIT_SUCCESS;
}
