#ifndef DHA2_INTERNAL_H
#define DHA2_INTERNAL_H
/*
    Direct Hardware Access library --- header for internal use.
    Copyright (C) 2004  Dmitry Baryshkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


typedef struct dha2_ports_driver_s
{
	char * name;

	int status; /* 0 - not initialized. try calling ->init()
		       -1 - not available.
		       1 - working.*/

	int (*init)(void); /* init all internal structures, etc. */
	void (*shutdown)(void); /* shutdown all io, free all mem, etc. */

	/* In/out ports */
	unsigned char (*dha2_inb)(unsigned port);
	unsigned short (*dha2_inw)(unsigned port);
	unsigned int (*dha2_inl)(unsigned port);
	void (*dha2_outb)(unsigned port, unsigned char value);
	void (*dha2_outw)(unsigned port, unsigned short value);
	void (*dha2_outl)(unsigned port, unsigned int value);
} dha2_ports_driver_t;

typedef struct dha2_mtrr_driver_s
{
	char * name;

	int status; /* 0 - not initialized. try calling ->init()
		       -1 - not available.
		       1 - working.*/

	int (*init)(void); /* init all internal structures, etc. */
	void (*shutdown)(void); /* shutdown all io, free all mem, etc. */

	/* Set up MTRR */
	int (*mtrr_set_type)(unsigned base, unsigned size, int type);
} dha2_mtrr_driver_t;

typedef struct dha2_pci_driver_s
{
	char * name;

	int status; /* 0 - not initialized. try calling ->init()
		       -1 - not available.
		       1 - working.*/

	int (*init)(void); /* init all internal structures, etc. */
	void (*shutdown)(void); /* shutdown all io, free all mem, etc. */

	/* PCI functions */
	int (*pci_config_type)(void);
	int (*pci_config_read_long)(unsigned char bus, unsigned char dev, int func, unsigned cmd);
	int (*pci_get_vendor)(unsigned char bus, unsigned char dev, int func);
} dha2_pci_driver_t;


typedef struct dha2_mmap_driver_s
{
	char * name;

	int status; /* 0 - not initialized. try calling ->init()
		       -1 - not available.
		       1 - working.*/

	int (*init)(void); /* init all internal structures, etc. */
	void (*shutdown)(void); /* shutdown all io, free all mem, etc. */

	/* Memory mapping/unmapping */
	void* (*map_phys_mem)(unsigned long base, unsigned long size);
	void (*unmap_phys_mem)(void * base, unsigned long size);
} dha2_mmap_driver_t;

/* For pci_scan */

#define enable_os_io enable_app_io
#define disable_os_io disable_app_io

int pci_config_type(void);
int pci_get_vendor(unsigned char bus, unsigned char dev, int func);

#define	PCI_MODE1_ADDRESS_REG		0xCF8
#define	PCI_MODE1_DATA_REG		0xCFC
 
#define	PCI_MODE2_ENABLE_REG		0xCF8
#ifdef PC98
#define	PCI_MODE2_FORWARD_REG		0xCF9
#else
#define	PCI_MODE2_FORWARD_REG		0xCFA
#endif

#if defined(__alpha__)
#define PCI_EN 0x00000000
#else
#define PCI_EN 0x80000000
#endif

int IsWinNT();

#ifndef DONT_POISON_PORTS
#if defined __GNUC__ && ((__GNUC__ * 100 + __GNUC_MINOR__) >= 303)
#pragma GCC poison inb inw inl outb outw outl
#endif
#endif

#endif /* DHA2_INTERNAL_H */
