#ifdef WIN32
/*
  MAPDEV.h - include file for VxD MAPDEV
  Copyright (c) 1996 Vireo Software, Inc.
  Modified for libdha by Nick Kurshev.
*/

#include <windows.h>
#include <ddk/ntddk.h>
#include "dhahelperwin/dhahelper.h"
#include <stdio.h>

#include "dha2.h"
#include "dha2_internal.h"

static HANDLE hDriver = INVALID_HANDLE_VALUE;  
    
extern dha2_ports_driver_t dha2_windha_ports;
extern dha2_mmap_driver_t dha2_windha_mmap;

static int dha2_windha_init(void)
{
	if(!IsWinNT())
	{
		dha2_windha_ports.status = -1;
		dha2_windha_mmap.status = -1;
		return -1;
	}

	if (hDriver == INVALID_HANDLE_VALUE)
		hDriver = CreateFile("\\\\.\\DHAHELPER",GENERIC_READ | GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (hDriver == INVALID_HANDLE_VALUE)
	{
		fprintf(stderr, "Cannot open driver, error=%08lx\n", GetLastError()) ;
		dha2_windha_ports.status = -1;
		dha2_windha_mmap.status = -1;
		return -1;
	}

	dha2_windha_mmap.status = 1;
	return 0;
}

static void dha2_windha_shutdown(void)
{
	if (hDriver != INVALID_HANDLE_VALUE)
	{
		dha2_windha_ports.status = 0;
		dha2_windha_mmap.status = 0;

		/* FIXME I'm not sure if the right call is CloseHandle. */
		CloseHandle(hDriver);

		hDriver = INVALID_HANDLE_VALUE;
	}
}

#include "portio/portio_x86.h"

dha2_ports_driver_t dha2_windha_ports =
{
	.name = "DHA windows helper driver (IO)",
	.status = 0,
	.init = dha2_windha_init,
	.shutdown = dha2_windha_shutdown,

	.dha2_inb = dha2_ports_direct_inb,
	.dha2_inw = dha2_ports_direct_inw,
	.dha2_inl = dha2_ports_direct_inl,

	.dha2_outb = dha2_ports_direct_outb,
	.dha2_outw = dha2_ports_direct_outw,
	.dha2_outl = dha2_ports_direct_outl,
};

/* Memory Map a piece of Real Memory */
static void *dha2_windha_map_phys_mem(unsigned long base, unsigned long size)
{
	dhahelper_t dhahelper_priv;
	DWORD dwBytesReturned;
	dhahelper_priv.size = size;
	dhahelper_priv.base = (void*)base;

	if (!DeviceIoControl(hDriver, IOCTL_DHAHELPER_MAPPHYSTOLIN, &dhahelper_priv,sizeof(dhahelper_t), &dhahelper_priv, sizeof(dhahelper_t),&dwBytesReturned, NULL))
	{
		printf("unable to map thre requested memory region\n");
		return MAP_FAILED;
	}
	else
		return dhahelper_priv.ptr;
}

static void dha2_windha_unmap_phys_mem(void *ptr, unsigned long size)
{
	dhahelper_t dhahelper_priv;
	DWORD dwBytesReturned;
	dhahelper_priv.ptr = ptr;
	DeviceIoControl(hDriver, IOCTL_DHAHELPER_UNMAPPHYSADDR, &dhahelper_priv,sizeof(dhahelper_t), NULL, 0, &dwBytesReturned, NULL);
}

dha2_mmap_driver_t dha2_windha_mmap =
{
	.name = "DHA windows helper driver (mmap)",
	.status = 0,
	.init = dha2_windha_init,
	.shutdown = dha2_windha_shutdown,

	.map_phys_mem = dha2_windha_map_phys_mem,
	.unmap_phys_mem = dha2_windha_unmap_phys_mem,
};

#endif
