/*
    Direct Hardware Access library.
    Copyright (C) 2004  Dmitry Baryshkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "direct_io.h"

#include "dha2.h"
#include "dha2_internal.h"

#include <errno.h>

extern dha2_ports_driver_t dha2_ports_direct_ports;

static int dha2_ports_direct_init(void)
{
	if (dha2_ports_direct_ports.status == 0)
	{
		if (!(errno = start_port_access()))
		{
			dha2_ports_direct_ports.status = 1;
			return 0;
		}
		else
		{
			dha2_ports_direct_ports.status = -1;
			return -1;
		}
	}
	else if (dha2_ports_direct_ports.status == 1)
		return 0;
	else
		return -1;
}

static void dha2_ports_direct_shutdown(void)
{
	dha2_ports_direct_ports.status = 0;
	stop_port_access();
}


#if defined(__GNUC__)
#if defined(__alpha__)
#include "portio/portio_alpha.h"
#elif defined(__ia64__)
#include "portio/portio_ia64.h"
#elif defined(__sparc__)
#include "portio/portio_sparc.h"
#elif defined( __arm32__ )
#include "portio/portio_arm32.h"
#elif defined(__powerpc__)
#include "portio/portio_powerpc.h"
#else
#include "portio/portio_x86.h"
#endif
#endif

dha2_ports_driver_t dha2_ports_direct_ports =
{
	.name = "Direct access driver (ports)",
	.status = 0,

	.init = dha2_ports_direct_init,
	.shutdown = dha2_ports_direct_shutdown,

	.dha2_inb = dha2_ports_direct_inb,
	.dha2_inw = dha2_ports_direct_inw,
	.dha2_inl = dha2_ports_direct_inl,

	.dha2_outb = dha2_ports_direct_outb,
	.dha2_outw = dha2_ports_direct_outw,
	.dha2_outl = dha2_ports_direct_outl,
};

