#if defined(__alpha__)  || (defined(__powerpc__) && (defined(Lynx) || defined(__OpenBSD__)))

/*
   This file is based on:
   $XFree86: xc/programs/Xserver/hw/xfree86/etc/scanpci.c,v 3.34.2.17 1998/11/10 11:55:40 dawes Exp $
   Modified for readability by Nick Kurshev
   Reworked by Dmitry Baryshkov
*/

/* Warning: It won't work if port access is done through svgalib kernel helper. */

#include "dha2.h"
#include "dha2_internal.h"

#ifdef Lynx
#include "io/io_lynx.c"
#endif


extern dha2_pci_driver_t dha2_pciconfig_pci;

static int dha2_pciconfig_init(void)
{
#ifdef Lynx
	start_port_access();
#endif
	dha2_pciconfig_pci.status = 1;
	return 0;
}

static void dha2_pciconfig_shutdown(void)
{
	dha2_pciconfig_pci.status = 0;
#ifdef Lynx
	stop_port_access();
#endif
}

static int dha2_pciconfig_pci_config_type( void )
{
  return 1;
}

static int dha2_pciconfig_pci_get_vendor
          (unsigned char bus,
          unsigned char dev,
          int func)
{
    unsigned long retval;
    pciconfig_read(bus, dev<<3, PCI_ID_REG, 4, &retval);
    return retval;
}

static int dha2_pciconfig_pci_config_read_long
          (unsigned char bus,
          unsigned char dev,
          int func, 
          unsigned cmd)
{
    unsigned long retval;
    pciconfig_read(bus, dev<<3, cmd, 4, &retval);
    return retval;
}

dha2_pci_driver_t dha2_pciconfig_pci =
{
	.name = "pciconfig_read/write driver (PCI)",
	.status = 0,
	.init = dha2_pciconfig_init,
	.shutdown = dha2_pciconfig_shutdown,

	.pci_config_type = dha2_pciconfig_pci_config_type,
	.pci_config_read_long = dha2_pciconfig_pci_config_read_long,
	.pci_get_vendor = dha2_pciconfig_pci_get_vendor,
};

#endif
