#ifdef __linux__
/*
    Direct Hardware Access library --- pci operations for (powerpc) Linux
       questions, suggestions etc: mplayer-dev-eng@mplayerhq.hu, colin@colino.net

    Copyright (C) 2002	Nick Kurshev. library implementation
    Copyright (C) 2002	Alex Beregszaszi. dhahelper and some changes
    Copyright (C) 2004  Dmitry Baryshkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* for pread */
#define _XOPEN_SOURCE 500

#include "dha2.h"
#include "dha2_internal.h"

#include "../bswap.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <unistd.h>

#define PCI_VENDOR_ID           0x00    /* 16 bits */
#define PCI_DEVICE_ID           0x02    /* 16 bits */

extern dha2_pci_driver_t dha2_pci_proc_linux_pci;

static int dha2_pci_proc_linux_init(void)
{
	dha2_pci_proc_linux_pci.status = 1;
	return 0;
}

static void dha2_pci_proc_linux_shutdown(void)
{
	dha2_pci_proc_linux_pci.status = 0;
}

static int dha2_pci_proc_linux_pci_config_type(void)
{
	return 1;
}

static int dha2_pci_proc_linux_pci_config_read_long(unsigned char bus, unsigned char dev, int func, unsigned cmd)
{
	long retval;
	char path[100];
	int fd;

	snprintf(path, 100, "/proc/bus/pci/%02d/%02x.%x", bus, dev, func);

	fd = open(path,O_RDONLY|O_SYNC);

	if (fd == -1)
	{
		retval=0;
	}
	else if (pread(fd, &retval, 4, cmd) == 4)
	{
		retval = le2me_32(retval);
	}
	else
	{
		retval = 0;
	}

	if (fd > 0) {
		close(fd);
	}

	return retval;
}

static int dha2_pci_proc_linux_pci_get_vendor(unsigned char bus, unsigned char dev, int func)
{
	int retval;
	char path[100];
	int fd;
	short vendor, device;

	snprintf(path, 100, "/proc/bus/pci/%02d/%02x.%x", bus, dev, func);

	fd = open(path,O_RDONLY|O_SYNC);

	if (fd == -1) {
		retval=0xFFFF;
	}
	else if (pread(fd, &vendor, 2, PCI_VENDOR_ID) == 2 &&
			pread(fd, &device, 2, PCI_DEVICE_ID) == 2)
	{
		vendor = le2me_16(vendor);
		device = le2me_16(device);
		retval = vendor + (device<<16);
	}
	else
	{
		retval = 0xFFFF;
	}

	if (fd > 0)
	{
		close(fd);
	}

	return retval;
}

dha2_pci_driver_t dha2_pci_proc_linux_pci =
{
	.name = "Linux driver for proc filesystem (PCI)",
	.status = 0,
	.init = dha2_pci_proc_linux_init,
	.shutdown = dha2_pci_proc_linux_shutdown,

	.pci_config_type = dha2_pci_proc_linux_pci_config_type,
	.pci_config_read_long = dha2_pci_proc_linux_pci_config_read_long,
	.pci_get_vendor = dha2_pci_proc_linux_pci_get_vendor,
};

#endif /* __linux__ */
