/*
   This file is based on:
   $XFree86: xc/programs/Xserver/hw/xfree86/drivers/chips/util/AsmMacros.h,v 1.1 2001/11/16 21:13:34 tsi Exp $
   Modified for readability by Nick Kurshev
*/

unsigned int IOPortBase;  /* Memory mapped I/O port area */

static void dha2_ports_direct_outb(unsigned port,char val)
{
	 if ((unsigned short)port >= 0x400) return;
	*(volatile unsigned char*)(((unsigned short)(port))+IOPortBase) = val;
}

static void dha2_ports_direct_outw(unsigned port,short val)
{
	 if ((unsigned short)port >= 0x400) return;
	*(volatile unsigned short*)(((unsigned short)(port))+IOPortBase) = val;
}

static void dha2_ports_direct_outl(unsigned port,int val)
{
	 if ((unsigned short)port >= 0x400) return;
	*(volatile unsigned long*)(((unsigned short)(port))+IOPortBase) = val;
}

static unsigned char dha2_ports_direct_inb(unsigned port)
{
	 if ((unsigned short)port >= 0x400) return((unsigned int)-1);
	return(*(volatile unsigned char*)(((unsigned short)(port))+IOPortBase));
}

static unsigned short dha2_ports_direct_inw(unsigned port)
{
	 if ((unsigned short)port >= 0x400) return((unsigned int)-1);
	return(*(volatile unsigned short*)(((unsigned short)(port))+IOPortBase));
}

static unsigned int dha2_ports_direct_inl(unsigned port)
{
	 if ((unsigned short)port >= 0x400) return((unsigned int)-1);
	return(*(volatile unsigned int*)(((unsigned short)(port))+IOPortBase));
}

