/*
   This file is based on:
   $XFree86: xc/programs/Xserver/hw/xfree86/etc/scanpci.c,v 3.34.2.17 1998/11/10 11:55:40 dawes Exp $
   Modified for readability by Nick Kurshev
*/
#include <errno.h>
#include <sys/file.h>

#if defined (__FreeBSD__)
/* machine/console.h seems to be outdated by recent FreeBSD *
 * however pcvt_ioctl.h seems to exist for very long time   */
/* #include <machine/console.h>*/
#include <machine/pcvt_ioctl.h>
#elif defined (__386BSD__)
#include <machine/console.h>
#elif defined (__bsdi__)
#include <sys/ioctl.h>
#include <i386/isa/pcconsioctl.h>
#define KDENABIO PCCONENABIOPL
#define KDDISABIO PCCONDISABIOPL
#endif

#ifndef GCCUSESGAS
#define GCCUSESGAS
#endif

static int io_fd;

static int start_port_access(void)
{
    io_fd = -1 ;
    if ((io_fd = open("/dev/console", O_RDWR, 0)) < 0) {
        perror("/dev/console");
	return(errno);
    }
    if (ioctl(io_fd, KDENABIO, 0) < 0) {
        perror("ioctl(KDENABIO)");
        return(errno);
    }
    return(0);
}

static int stop_port_access(void)
{
    if (ioctl(io_fd, KDDISABIO, 0) < 0) {
        perror("ioctl(KDDISABIO)");
	close(io_fd);
        return(errno);
    }
    close(io_fd);
    return(0);
}

