#ifdef WIN32
/*
  MAPDEV.h - include file for VxD MAPDEV
  Copyright (c) 1996 Vireo Software, Inc.
  Modified for libdha by Nick Kurshev.
*/

#include <windows.h>
#include <ddk/ntddk.h>

#include <stdio.h>

#include "dha2.h"
#include "dha2_internal.h"


/*
  This is the request structure that applications use
  to request services from the MAPDEV VxD.
*/

typedef struct _MapDevRequest
{
	DWORD	mdr_ServiceID;		/* supplied by caller */
	LPVOID	mdr_PhysicalAddress;	/* supplied by caller */
	DWORD	mdr_SizeInBytes;	/* supplied by caller */
	LPVOID	mdr_LinearAddress;	/* returned by VxD */
	WORD	mdr_Selector;		/* returned if 16-bit caller */
	WORD	mdr_Status;		/* MDR_xxxx code below */
} MAPDEVREQUEST, *PMAPDEVREQUEST;

#define MDR_SERVICE_MAP		CTL_CODE(FILE_DEVICE_UNKNOWN, 1, METHOD_NEITHER, FILE_ANY_ACCESS)
#define MDR_SERVICE_UNMAP	CTL_CODE(FILE_DEVICE_UNKNOWN, 2, METHOD_NEITHER, FILE_ANY_ACCESS)

#define MDR_STATUS_SUCCESS	1
#define MDR_STATUS_ERROR	0
/*#include "winioctl.h"*/
#define FILE_DEVICE_UNKNOWN             0x00000022
#define METHOD_NEITHER                  3
#ifndef FILE_ANY_ACCESS
#define FILE_ANY_ACCESS			0
#endif
#ifndef CTL_CODE
#define CTL_CODE( DeviceType, Function, Method, Access ) ( \
    ((DeviceType)<<16) | ((Access)<<14) | ((Function)<<2) | (Method) )
#endif

    
static int IsWinNT(){
  OSVERSIONINFO OSVersionInfo;
  OSVersionInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
  GetVersionEx(&OSVersionInfo);
  return OSVersionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT;
}  

static HANDLE hDriver = INVALID_HANDLE_VALUE;  
    
extern dha2_mmap_driver_t dha2_win9x_mmap;

static int dha2_win9x_init(void)
{
	const PCHAR VxDName = "\\\\.\\MAPDEV.VXD" ;
	const PCHAR VxDNameAlreadyLoaded = "\\\\.\\MAPDEV" ;

	if(IsWinNT())
	{
		dha2_win9x_mmap.status = -1;
		return -1;
	}

	if (hDriver == INVALID_HANDLE_VALUE)
		hDriver = CreateFile(VxDName, 0,0,0,
				CREATE_NEW, FILE_FLAG_DELETE_ON_CLOSE, 0) ;
	if (hDriver == INVALID_HANDLE_VALUE)
		hDriver = CreateFile(VxDNameAlreadyLoaded, 0,0,0,
				CREATE_NEW, FILE_FLAG_DELETE_ON_CLOSE, 0) ;
	if (hDriver == INVALID_HANDLE_VALUE)
	{
		fprintf(stderr, "Cannot open driver, error=%08lx\n", GetLastError()) ;
		dha2_win9x_mmap.status = -1;
		return -1;
	}

	dha2_win9x_mmap.status = 1;
	return 0;
}

static void dha2_win9x_shutdown(void)
{
	if (hDriver != INVALID_HANDLE_VALUE)
	{
		dha2_win9x_mmap.status = 0;

		/* FIXME I'm not sure if the right call is CloseHandle. */
		CloseHandle(hDriver);

		hDriver = INVALID_HANDLE_VALUE;
	}
}

    
/* Memory Map a piece of Real Memory */
static void *dha2_win9x_map_phys_mem(unsigned long base, unsigned long size) {
	HANDLE hDriver ;
	PVOID inBuf[1] ;		/* buffer for struct pointer to VxD */
	DWORD cbBytesReturned ;	/* count of bytes returned from VxD */
	MAPDEVREQUEST req ;		/* map device request structure */
	req.mdr_ServiceID = MDR_SERVICE_MAP ;
	req.mdr_PhysicalAddress = (PVOID)base ;
	req.mdr_SizeInBytes = size ;
	inBuf[0] = &req ;

	if ( ! DeviceIoControl(hDriver, MDR_SERVICE_MAP, inBuf, sizeof(PVOID),
				NULL, 0, &cbBytesReturned, NULL) )
	{
		fprintf(stderr, "Failed to map device\n");
		return MAP_FAILED;
	}

	return (void*)req.mdr_LinearAddress ;
}

static void dha2_win9x_unmap_phys_mem(void *ptr, unsigned long size) {
	/* FIXME */
}

dha2_mmap_driver_t dha2_win9x_mmap =
{
	.name = "MAPDEV.VXD driver (mmap)",
	.status = 0,
	.init = dha2_win9x_init,
	.shutdown = dha2_win9x_shutdown,

	.map_phys_mem = dha2_win9x_map_phys_mem,
	.unmap_phys_mem = dha2_win9x_unmap_phys_mem,
};

#endif
