#if !defined (WIN32) && !defined (__EMX__)
/*
    Direct Hardware Access library
    Copyright (C) 1996  Robin Cutshaw (robin@xfree86.org)  XFree86 3.3.3 implementation
    Copyright (C) 1999	yvind Aabling. Modified for GATOS/win/gfxdump.
		  
    Copyright (C) 2002	Nick Kurshev. library implementation
    Copyright (C) 2002	Alex Beregszaszi. dhahelper and some changes
    Copyright (C) 2002  Matan Ziv-Av. Svgalib kernelhelper support
    Copyright (C) 2004  Dmitry Baryshkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "dha2.h"
#include "dha2_internal.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <sys/mman.h>

#if defined(SVR4) || defined(SCO325)
#  if !(defined(sun) && defined (i386) && defined (SVR4))
#    define DEV_MEM "/dev/pmem"
#  elif defined(PowerMAX_OS)
#    define DEV_MEM "/dev/iomem"
#  endif
#  ifdef SCO325
#   undef DEV_MEM
#   define DEV_MEM "/dev/mem"
#  endif
# endif /* SVR4 */

#ifndef DEV_MEM
#define DEV_MEM "/dev/mem"
#endif

static int devmem_fd = -1;

extern dha2_mmap_driver_t dha2_devmem_mmap;

static int dha2_devmem_init(void)
{
	errno = 0;

	if (devmem_fd != -1)
		return 0;

	devmem_fd = open (DEV_MEM, O_RDWR);
	if (devmem_fd == -1)
	{
		dha2_devmem_mmap.status = -1;
		return -1;
	}

	dha2_devmem_mmap.status = 1;
	return 0;
}

static void dha2_devmem_shutdown(void)
{
	if (devmem_fd != -1)
	{
		dha2_devmem_mmap.status = 0;

		close(devmem_fd);
		devmem_fd = -1;
	}
}

static void *dha2_devmem_map_phys_mem(unsigned long base, unsigned long size)
{
	return mmap(0,size,PROT_READ|PROT_WRITE,MAP_SHARED,devmem_fd,base);
}

static void dha2_devmem_unmap_phys_mem(void *ptr, unsigned long size)
{
	munmap(ptr, size);
}

dha2_mmap_driver_t dha2_devmem_mmap =
{
	.name = DEV_MEM "driver (mmap)",
	.status = 0,
	.init = dha2_devmem_init,
	.shutdown = dha2_devmem_shutdown,

	.map_phys_mem = dha2_devmem_map_phys_mem,
	.unmap_phys_mem = dha2_devmem_unmap_phys_mem,
};

#endif
