<?php
require_once("config.php");

require_once(LIBS_DIR . "http.php");
require_once(LIBS_DIR . "db.php");
require_once(LIBS_DIR . "tse_menu.php");
require_once(LIBS_DIR . "tse_smarty.php");

fill_request_info($id, $URIlang, $URIformat);

if (empty($id))
	$id = 1;

$lang = get_document_lang($URIlang);
$format = get_document_format($URIformat, $conttype);

$cid =  '_404'.'|'.$lang.'|'.$format;

$smarty = new TSE_Smarty($TSE_DEVEL);

$smarty->assign('node', 0);
if (!empty($URIlang))
	$smarty->assign('URIlang', $URIlang);
$smarty->assign('lang', $lang);
$smarty->assign('langs', $document_langs);
if (!empty($URIformat))
	$smarty->assign('URIformat', $URIformat);
$smarty->assign('format', $format);
$smarty->assign('conttype', $conttype);
$smarty->assign('stylesheets', $stylesheets);
$smarty->assign('tseimgpath', preg_replace('![^/]*\.php$!', 'images', $_SERVER['SCRIPT_NAME']));

$template = "404.tpl";
if (!$smarty->is_cached($template, $cid))
{
	$db = db_connect($DB_URI);
	if (is_string($db))
	{
		$smarty->assign('error', $db);
		$template = "500.tpl";
		$smarty->caching = 0;
		header("HTTP/1.1 500 Internal Server Error");
	}
	else
	{
		$menu = db_get_menu_items($db, $lang);
		if (is_string($menu))
		{
			$smarty->assign('error', $menu);
			$template = "500.tpl";
			$smarty->caching = 0;
			header("HTTP/1.1 500 Internal Server Error");
		}
		else
		{
			process_menu($menu);
			$smarty->assign('menu', $menu);
			if (true)
			{
				$smarty->assign('errorcode', 404);
				$smarty->assign($_404_strings[$lang]);
				$smarty->assign('menupath', array(-1));
				header("HTTP/1.1 404 Not Found");
			}
		}
	}
}
else
	$db = null;

$_SERVER['SCRIPT_NAME'] = preg_replace("!/" . basename($_SERVER['SCRIPT_FILENAME']) . "$!", "/index.php", $_SERVER['SCRIPT_NAME']);

header("Content-Type: {$conttype}; charset=utf-8");

$smarty->display($template, $cid);

if ($db && is_object($db))
	db_disconnect($db);
?>
