<?php
require_once("config.php");
$_admin = false;
if (file_exists("admin-config.php"))
{
	require("admin-config.php");
	$_admin = true;
}

require_once(LIBS_DIR . "http.php");
require_once(LIBS_DIR . "db.php");
require_once(LIBS_DIR . "tse_menu.php");
require_once(LIBS_DIR . "tse_smarty.php");

fill_request_info($id, $URIlang, $URIformat);

if (($id !== "0") && empty($id))
	$id = 1;

$lang = get_document_lang($URIlang);
$format = get_document_format($URIformat, $conttype);

$smarty = new TSE_Smarty($TSE_DEVEL);

$cache_id =  ''.$id.'|'.$lang.'|'.$format;

if ($_admin)
{
	$smarty->assign('adminmode', true);
	$smarty->assign('adminpath', $adminpath);
	$cache_id = 'admin|'.$cache_id;
	$smarty->caching = 0;
}

$smarty->assign('node', $id);
if (!empty($URIlang))
	$smarty->assign('URIlang', $URIlang);
$smarty->assign('lang', $lang);
$smarty->assign('langs', $document_langs);
if (!empty($URIformat))
	$smarty->assign('URIformat', $URIformat);
$smarty->assign('format', $format);
$smarty->assign('conttype', $conttype);
$smarty->assign('stylesheets', $stylesheets);
$smarty->assign('tseimgpath', preg_replace('![^/]*\.php$!', 'images', $_SERVER['SCRIPT_NAME']));

$template = "index.tpl";
if (!$smarty->is_cached($template, $cache_id))
{
	$db = db_connect($DB_URI);
	if (is_string($db))
	{
		$smarty->assign('error', $db);
		$template = "500.tpl";
		$smarty->caching = 0;
		header("HTTP/1.1 500 Internal Server Error");
	}
	else
	{
		$menu = db_get_menu_items($db, $lang);
		if (is_string($menu))
		{
			$smarty->assign('error', $menu);
			$template = "500.tpl";
			$smarty->caching = 0;
			header("HTTP/1.1 500 Internal Server Error");
		}
		else
		{
			process_menu($menu);
			$smarty->assign('menu', $menu);
			if (empty($menu[$id]))
			{
				$cache_id =  '_404'.'|'.$lang.'|'.$format;
				if ($_admin)
					$cache_id = 'admin|'.$cache_id;
				$template = "404.tpl";
				$smarty->assign($_404_strings[$lang]);
				$smarty->assign('menupath', array(-1));
				$smarty->assign('node', 0);
				header("HTTP/1.1 404 Not Found");
			}
			else
			{
				$menu_path = get_menu_path($menu, $id);

				$page = db_get_page($db, $id, $lang);
				if (is_string($page))
				{
					$smarty->assign('error', $page);
					$template = "500.tpl";
					$smarty->caching = 0;
				}
				else
				{
					$smarty->assign('menupath', $menu_path);
					$smarty->assign($page);
					$smarty->assign_by_ref('db', $db);
				}
			}
		}
	}
}
else
	$db = null;

header("Content-Type: {$conttype}; charset=utf-8");

$smarty->display($template, $cache_id);

if ($db && is_object($db))
	db_disconnect($db);
?>
