<?php
/*
* Smarty plugin
* -------------------------------------------------------------
* File:     resource.db.php
* Type:     resource
* Name:     db
* Purpose:  Fetches templates from a database
* -------------------------------------------------------------
*/
require_once(LIBS_DIR . 'db.php');
require_once(LIBS_DIR . 'http.php');
function smarty_resource_db_source($tpl_name, &$tpl_source, &$smarty)
{
	$db = $smarty->get_template_vars('db');

	
	list($id, $lang) = explode('_', $tpl_name);

	$tpl_source = db_get_page($db, $id, $lang);
	// FIXME: handle 404
	if ($tpl_source)
	{
		return true;
	} else {
		return false;
	}
	return db_get_page($db, $id, $lang);
}

function smarty_resource_db_timestamp($tpl_name, &$tpl_timestamp, &$smarty)
{
	$db = $smarty->get_template_vars('db');
	list($id, $lang) = explode('_', $tpl_name);
	$tpl_timestamp = db_get_page_timestamp($db, $id, $lang);
	if ($tpl_timestamp)
	{
		return true;
	} else {
		return false;
	}
}

function smarty_resource_db_secure($tpl_name, &$smarty)
{
	// assume all templates are secure
	return true;
}

function smarty_resource_db_trusted($tpl_name, &$smarty)
{
	// not used for templates
	return false;
}
												 ?>
