<?php
/*
* Smarty plugin
* -------------------------------------------------------------
* File:     function.image.php
* Type:     function
* Name:     image
* Purpose:  Insert image into page
* -------------------------------------------------------------
*/
function smarty_function_image($params, &$smarty)
{
        $_class = isset($params['class']) ? $smarty->_dequote($params['class']) : null;
        $_id = isset($params['id']) ? $smarty->_dequote($params['id']) : null;
        $_src = isset($params['src']) ? $smarty->_dequote($params['src']) : null;
        $_alt = isset($params['alt']) ? $smarty->_dequote($params['alt']) : null;

	if (!isset($_src))
	{
		$smarty->trigger_error("missing 'src' attribute in image tag", E_USER_ERROR, __FILE__, __LINE__);
	}

	if (!isset($_alt))
	{
		$smarty->trigger_error("missing 'alt' attribute in image tag", E_USER_ERROR, __FILE__, __LINE__);
	}

	$_output = '<img src="' . $_src . '" alt="' . $_alt . '"';

	if (isset($_id))
	{
		$_output .= 'id="' . $_id . '"';
		if ($smarty->get_template_vars('format') === "html")
			$_output .= ' name="' . $_id . '"';
	}

	if (isset($_class))
		$_output .= ' class="' . $_class . '"';

	if ($smarty->get_template_vars('format') === "html")
		$_output .= '>';
	else
		$_output .= ' />';
	
	return $_output;
}
