<?php
/*
* Smarty plugin
* -------------------------------------------------------------
* File:     block.get_node_url.php
* Type:     block
* Name:     para
* Purpose:  Defines a paragraph
* -------------------------------------------------------------
*/
function smarty_block_para($params, $content, &$smarty, &$repeat)
{
        $_class = isset($params['class']) ? $smarty->_dequote($params['class']) : null;
        $_id = isset($params['id']) ? $smarty->_dequote($params['id']) : null;
	if ($content === null)
		return;

	$_output = "<p";

	if (isset($_id))
	{
		$_output .= ' id="' . $_id . '"';
		if ($smarty->get_template_vars('format') === "html")
			$_output .= ' name="' . $_id . '"';
	}

	if (isset($_class))
		$_output .= ' class="' . $_class . '"';
	
	$_output .= '>' . $content . '</p>';

	return $_output;
}
?>
