<?php
/*
* Smarty plugin
* -------------------------------------------------------------
* File:     block.link.php
* Type:     block
* Name:     link
* Purpose:  Returns link to internal node
* -------------------------------------------------------------
*/

function smarty_block_link($params, $content, &$smarty, &$repeat)
{
        $_node = isset($params['node']) ? $smarty->_dequote($params['node']) : null;
        $_title = isset($params['title']) ? $smarty->_dequote($params['title']) : null;

	if ($content === null)
		return;

	if (!isset($_node))
	{
		$smarty->trigger_error("missing 'node' attribute in link tag", E_USER_ERROR, __FILE__, __LINE__);
	}
	if (!is_numeric($_node) || $_node != ''.(int)$_node)
	{
		$smarty->trigger_error("'node' attribute must be integer in link tag: $_node", E_USER_ERROR, __FILE__, __LINE__);
	}

	require_once $smarty->_get_plugin_filepath('function', 'get_node_url');

	$_url = smarty_function_get_node_url($params, $smarty);

	$_output = '<a href="' . $_url . '"';
	if (isset($_title))
		$_output .= ' title="' . $_title . '"';
	$_output .= '>';
	if (!empty($content))
		$_output .= $content;
	else
		$_output .= 'http://' . $_SERVER["SERVER_NAME"] . $_url;
	$_output .= '</a>';
	
	return $_output;
}
