<?php
/*
* Smarty plugin
* -------------------------------------------------------------
* File:     block.link.php
* Type:     block
* Name:     extlink
* Purpose:  Returns link to external url
* -------------------------------------------------------------
*/

function smarty_block_extlink($params, $content, &$smarty, &$repeat)
{
        $_url = isset($params['url']) ? $smarty->_dequote($params['url']) : null;
        $_title = isset($params['title']) ? $smarty->_dequote($params['title']) : null;

	if ($content === null)
		return;

	if (!isset($_url))
	{
		$smarty->trigger_error("missing 'url' attribute in extlink tag", E_USER_ERROR, __FILE__, __LINE__);
	}
	if (empty($_url))
	{
		$smarty->trigger_error("'url' attribute might not be empty in extlink tag", E_USER_ERROR, __FILE__, __LINE__);
	}

	$_output = '<a href="' . $_url . '"';
	if (isset($_title))
		$_output .= ' title="' . $_title . '"';
	$_output .= '>';
	if (!empty($content))
		$_output .= $content;
	else
		$_output .= $_url;
	$_output .= '</a>';
	
	return $_output;
}
