<?php

function fill_request_info(&$id, &$lang, &$format)
{
	if (!empty($_SERVER["PATH_INFO"]))
		$path = $_SERVER["PATH_INFO"];
	else
		$path = "";

	if (preg_match("!\.([^.]*)$!", $path, $matches) )
	{
		$format = $matches[1];
		$path = preg_replace("!\.[^.]*$!", "", $path);
	}

	$path = preg_replace("!/$!", "", $path);
	$path = preg_replace("!^/!", "", $path);

	if (preg_match("!^(\d+)/?!", $path, $matches))
	{
		$id = $matches[1];
		$path = preg_replace("!^" . $id . "/?!", "", $path);
	}

	if (!empty($path))
		$lang = $path;
}

function get_document_lang($URIlang)
{
	global $document_langs;
	if (!empty($URIlang))
	{
		foreach ($document_langs as $dlang)
		{
			if ($URIlang === $dlang)
			{
				return $dlang;
			}
		}
	}

	if (!empty($_SERVER["HTTP_ACCEPT_LANGUAGE"]))
	{
		// FIXME: honor q, order, etc.!
		foreach ($document_langs as $dlang)
		{
			if (
				preg_match("!^" . $dlang . "[,;]!", $_SERVER["HTTP_ACCEPT_LANGUAGE"])
				||
				preg_match("!, *" . $dlang . "[,;]!", $_SERVER["HTTP_ACCEPT_LANGUAGE"])
			)
			{
				return $dlang;
			}
		}
	}

	return document_lang_fallback;
}

function get_document_format($URIformat, &$mime)
{
	global $document_types;
	if (!empty($URIformat))
	{
		foreach($document_types as $mtype => $ext)
		{
			if ($ext === $URIformat)
			{
				$mime = $mtype;
				return $ext;
			}
		}
	}

	if (
		(!empty($_SERVER["HTTP_USER_AGENT"]) && (
			  (preg_match("!Konqueror!",	$_SERVER["HTTP_USER_AGENT"]))
//			||(preg_match("!Validator!",	$_SERVER["HTTP_USER_AGENT"]))
			))
	   )
	{
		$mime = "application/xhtml+xml";
		return "xhtml";
	}

	if (!empty($_SERVER["HTTP_ACCEPT"]))
	{
		// FIXME: honor q, order, etc.!
		foreach ($document_types as $mtype => $ext)
		{
			$mimefixed = preg_replace("!\+!", "\+", $mtype);
			if (
				preg_match("!^" . $mimefixed . "[,;]!", $_SERVER["HTTP_ACCEPT"])
				||
				preg_match("!, *" . $mimefixed . "[,;]!", $_SERVER["HTTP_ACCEPT"])
				||
				preg_match("!, *" . $mimefixed . "$!", $_SERVER["HTTP_ACCEPT"])
				)
			{
				$mime = $mtype;
				return $ext;
			}
		}
	}

	$format = end($document_types);
	$mime = key($document_types);
	return $format;
}

?>
