<?php

require_once 'DB.php';

function db_connect($db_uri)
{
	$db =& DB::connect($db_uri);

	if (PEAR::isError($db))
	{
		return $db->getMessage();
	}

	$db->setFetchMode(DB_FETCHMODE_ASSOC);

	$res =& $db->query('/*!40101 SET NAMES utf8 */');
	if (PEAR::isError($res))
	{
		return $res->getMessage();
	}

	$res =& $db->query('/*!40101 SET CHARACTER SET utf8 */');
	if (PEAR::isError($res))
	{
		return $res->getMessage();
	}

	return $db;
}

function db_get_menu_items(&$db, $lang)
{
	$db_fields = "lsr_main.id, parent_id, entry, title, created";
	// Proceed with a query...
	if ($lang === document_lang_fallback)
		$res =& $db->query("SELECT {$db_fields} FROM ".DB_PREFIX."_main NATURAL JOIN ".DB_PREFIX."_{$lang} ORDER BY id ASC");
	else
		$res =& $db->query("(SELECT {$db_fields} FROM ".DB_PREFIX."_main NATURAL JOIN ".DB_PREFIX."_{$lang}) UNION (SELECT {$db_fields} FROM ".DB_PREFIX."_main NATURAL JOIN ".DB_PREFIX."_".document_lang_fallback." WHERE ".DB_PREFIX."_main.id <> ALL (SELECT id FROM ".DB_PREFIX."_{$lang})) ORDER BY id ASC");
	
	// Always check that result is not an error
	if (PEAR::isError($res))
	{
		return ($res->getMessage());
	}

	$menu_data = array();

	while ($_row = $res->fetchRow())
	{
		$menu_data[$_row['id']] = $_row;
	}

	$res->free();

	return $menu_data;
}

function db_get_page(&$db, $id, $lang)
{
	$res =& $db->query("SELECT handler,title,text,parent_id,next_id,prev_id,UNIX_TIMESTAMP(updated) AS updated FROM ".DB_PREFIX."_main NATURAL JOIN ".DB_PREFIX."_{$lang} WHERE ".DB_PREFIX."_main.id = {$id}");

	if (PEAR::isError($res))
	{
		return ($res->getMessage());
	}

	$_row = $res->fetchRow();

	$res->free();

	if (!empty($_row))
		return $_row;
	else if ($lang !== document_lang_fallback)
		return db_get_page($db, $id, document_lang_fallback);
	else // FIXME: should somehow return 404
		return "Error: no such page";
}

function db_disconnect(&$db)
{
	$db->disconnect();
	$db = null;
}

?>
