 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"


NvU64
devMulU64 (NvU64 u1, NvU64 u2)
{
	NvU64               result;
	unsigned long       ip,
	                    np;
	unsigned short      mp[4];
	unsigned short      mc[4];
	unsigned short      product[8];
	int                 p,
	                    c;

	mp[0] = (unsigned short) (u1.low & 0xffff);
	mp[1] = (unsigned short) ((u1.low >> 16) & 0xffff);
	mc[0] = (unsigned short) (u2.low & 0xffff);
	mc[1] = (unsigned short) ((u2.low >> 16) & 0xffff);
	mp[2] = (unsigned short) (u1.high & 0xffff);
	mp[3] = (unsigned short) ((u1.high >> 16) & 0xffff);
	mc[2] = (unsigned short) (u2.high & 0xffff);
	mc[3] = (unsigned short) ((u2.high >> 16) & 0xffff);
	for (p = 0; p < 8; p++)
		product[p] = 0;
	for (c = 0; c < 4; c++)
	{
		np = 0;
		for (p = 0; p < 4; p++)
		{
			ip = mp[p] * mc[c] + np;
			np = product[p + c] + ip;
			product[p + c] = (unsigned short) (np & 0xffff);
			np >>= 16;
		}
	}
	result.low = product[1] << 16 | product[0];
	result.high = product[3] << 16 | product[2];
	return result;
}

NvU64
devMulU64ULong (NvU64 u1, unsigned long u2)
{
	NvU64               result;

	result.high = 0;
	result.low = u2;
	return devMulU64 (u1, result);
}

NvU64
devAddU64 (NvU64 u1, NvU64 u2)
{
	NvU64               result;
	unsigned short      s1,
	                    s2;
	unsigned long       overflow = 0;

	s1 = (unsigned short) u1.low & 0xffff;
	s2 = (unsigned short) u2.low & 0xffff;
	overflow += s1 + s2;
	result.low = (unsigned short) overflow & 0xffff;
	overflow >>= 16;
	s1 = (unsigned short) u1.low >> 16;
	s2 = (unsigned short) u2.low >> 16;
	overflow += s1 + s2;
	result.low |= ((unsigned short) overflow & 0xffff) << 16;
	overflow >>= 16;
	s1 = (unsigned short) u1.high & 0xffff;
	s2 = (unsigned short) u2.high & 0xffff;
	overflow += s1 + s2;
	result.high = (unsigned short) overflow & 0xffff;
	overflow >>= 16;
	s1 = (unsigned short) u1.high >> 16;
	s2 = (unsigned short) u2.high >> 16;
	overflow += s1 + s2;
	result.high |= ((unsigned short) overflow & 0xffff) << 16;
	overflow >>= 16;
	return result;
}

NvU64
devSubU64 (NvU64 u1, NvU64 u2)
{
	NvU64               result;
	long                term;
	int                 borrow;
	unsigned short      s1,
	                    s2;

	borrow = 0;
	s1 = (unsigned short) u1.low & 0xffff;
	s2 = (unsigned short) u2.low & 0xffff;
	term = s1 - s2 - borrow;
	result.low = term < 0 ? 0x10000 + term : term;
	borrow = term < 0 ? 1 : 0;
	s1 = (unsigned short) u1.low >> 16;
	s2 = (unsigned short) u2.low >> 16;
	term = s1 - s2 - borrow;
	result.low |= (term < 0 ? 0x10000 + term : term) << 16;
	borrow = term < 0 ? 1 : 0;
	s1 = (unsigned short) u1.high & 0xffff;
	s2 = (unsigned short) u2.high & 0xffff;
	term = s1 - s2 - borrow;
	result.high = term < 0 ? 0x10000 + term : term;
	borrow = term < 0 ? 1 : 0;
	s1 = (unsigned short) u1.high >> 16;
	s2 = (unsigned short) u2.high >> 16;
	term = s1 - s2 - borrow;
	result.high |= (term < 0 ? 0x10000 + term : term) << 16;
	return result;
}

NvU64
devAddU64ULong (NvU64 u1, unsigned long u2)
{
	NvU64               result;

	result.high = 0;
	result.low = u2;
	return devAddU64 (u1, result);
}

NvU64
devSubU64ULong (NvU64 u1, unsigned long u2)
{
	NvU64               result;

	result.high = 0;
	result.low = u2;
	return devSubU64 (u1, result);
}

NvU64
devShiftU64right (NvU64 u64, unsigned long shift)
{
	NvU64               result;
	unsigned long       mask = (2 << shift) - 1;

	if (shift > 63)
	{
		result.high = 0;
		result.low = 0;
		return result;
	}
	if (shift >= 32)
	{
		result.low = u64.high >> (shift - 32);
		result.high = 0;
		return result;
	}
	result.high = u64.high >> shift;
	result.low = u64.low >> shift | ((u64.high & mask) << (32 - shift));
	return result;
}

NvU64
devShiftU64left (NvU64 u64, unsigned long shift)
{
	NvU64               result;
	unsigned long       mask = (2 << shift) - 1;

	if (shift > 63)
	{
		result.high = 0;
		result.low = 0;
		return result;
	}
	if (shift >= 32)
	{
		result.high = u64.low << (shift - 32);
		result.low = 0;
		return result;
	}
	result.high = u64.high << shift | (u64.low & (mask << (32 - shift))) >> (32 - shift);
	result.low = u64.low << shift;
	return result;
}

NvU64
devAndU64ULong (NvU64 u64, unsigned long mask)
{
	NvU64               result;

	result.high = u64.high & ((mask) & 0x80000000) ? 0xffffffff : 0;
	result.low = u64.low & mask;
	return result;
}

int
devCmpU64 (NvU64 u1, NvU64 u2)
{
	NvU64               result;

	result = devSubU64 (u1, u2);
	if (result.low == 0 && result.high == 0)
		return 0;
	return (((result.high) & 0x80000000)) ? -1 : 1;
}

int
devCmpU64ULong (NvU64 u1, unsigned long ul)
{
	NvU64               result;

	result.high = 0;
	result.low = ul;
	return devCmpU64 (u1, result);
}
