 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
tmrInit (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvS32               num,
	                    den;
	NvP64               base;
	NvU64               limit;
	NvV32               status,
	                    id;
	int                 i;

	;
	hwdev->info.Timer.tmrSave[0] = ((hwreg)->Reg32[(NV_PTIMER_NUMERATOR) / 4]);
	hwdev->info.Timer.tmrSave[1] = ((hwreg)->Reg32[(NV_PTIMER_DENOMINATOR) / 4]);
	hwdev->info.Timer.CallbackList = (void *) 0;
	(&limit)->high = 0, (&limit)->low = (NvU32) (sizeof (TimerCallback) * 32 - 1);
	status = nvArchMemoryAllocKernel (&base, limit, &id);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return 2;
	}
	hwdev->info.Timer.CallbackTable = (TimerCallback *) (&base)->low;
	hwdev->info.Timer.CallbackTableId = id;
	hwdev->info.Timer.CallbackFreeList = hwdev->info.Timer.CallbackTable;
	for (i = 0; i < 32 - 1; i++)
	{
		hwdev->info.Timer.CallbackFreeList[i].next =
			&(hwdev->info.Timer.CallbackFreeList[i + 1]);
	}
	hwdev->info.Timer.CallbackFreeList[i].next = (void *) 0;
	num = hwdev->info.Dac.MClk;
	den = 31250000;
	while ((num % 2 == 0) && (den % 2 == 0))
	{
		num /= 2;
		den /= 2;
	}
	while ((num % 5 == 0) && (den % 5 == 0))
	{
		num /= 5;
		den /= 5;
	}
	while ((num > 2 * (0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) + ((0 ? 15 : 0) % 32))))
		|| (den > 2 * (0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) + ((0 ? 15 : 0) % 32)))))
	{
		num /= 2;
		den /= 2;
	}
	num = (num + 1) / 2;
	den = (den + 1) / 2;
	;
	hwdev->info.Timer.Numerator = num;
	hwdev->info.Timer.Denominator = den;
	(hwreg)->Reg32[(NV_PTIMER_NUMERATOR) / 4] = (NvV32) (hwdev->info.Timer.Numerator);
	(hwreg)->Reg32[(NV_PTIMER_DENOMINATOR) / 4] = (NvV32) (hwdev->info.Timer.Denominator);
	(hwreg)->Reg32[(NV_PTIMER_ALARM_0) / 4] = (NvV32) (0xFFFFFFFF);
	hwdev->info.Statistics.UpdateLo = 1000000000;
	hwdev->info.Statistics.UpdateHi = 0;
	hwdev->info.Statistics.FifoExceptionCount = 0;
	hwdev->info.Statistics.FramebufferExceptionCount = 0;
	hwdev->info.Statistics.GraphicsExceptionCount = 0;
	hwdev->info.Statistics.TotalExceptionCount = 0;
	hwdev->info.Fifo.ServiceCount = 0;
	hwdev->info.Graphics.ServiceCount = 0;
	hwdev->info.Chip.ServiceCount = 0;
	return 0;
}
