 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


extern NvV32        mthdUnimplemented (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSwSetContextDmaNotifies (EngineObj *, MethodInfo *, NvV32, NvV32, int);
NvV32               tmrService (NvDeviceInfo *);
NvV32               tmrScheduleCallback (TimerObj *);
NvV32               tmrCancelCallback (TimerObj *);
NvV32               tmrAdjustCallback (TimerObj *);
NvV32               tmrAlarmNotify (TimerObj *);
static void
timerNotify (TimerObj *timerObj, int style, int ndx, NvV32 status)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) ((((EngineObj *) timerObj))->base.parent->
					parent))->device->deviceInfo));
	NvContextDmaObj    *ctxDmaObj = ((EngineObj *) timerObj)->notifyCtxDma;
	NvU32               timeHi,
	                    timeLo;
	NvU64               timeStamp;
	Nv0004Notification *notify;
	int                 awaken;
	int                 i;

	;
	;
	if (ndx == 0)
		awaken = (style == (0x00000003));
	else
		awaken = (style == (0x00000001));
	notify = (Nv0004Notification *) ((&ctxDmaObj->memoryObj->kernAddr)->low +
		(unsigned long) (&ctxDmaObj->offset)->low);
	tmrGetCurrentTime (device, &timeHi, &timeLo);
	timeStamp.high = timeHi;
	timeStamp.low = timeLo;
	if (timerObj->flags == (NV_PMC_BOOT_0))
	{
		notify[ndx].timeStamp = timeStamp;
	}
	else
	{
		for (i = 0; i < 8; i++)
			((NvU8 *) (&notify[ndx].timeStamp))[i] = ((NvU8 *) &timeStamp)[(~i) & 0x7];
	}
	for (i = 0; i < 7; i++)
		notify[ndx].zero[i] = (NvV8) 0;
	notify[ndx].status = (NvV8) status;
}

NvV32
tmrService (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               timeCheck,
	                    currTimeLo,
	                    currTimeHi;
	TimerCallback      *callbackList,
	                   *deleteCallback;

	;
	(hwreg)->Reg32[(NV_PTIMER_INTR_0) / 4] = (NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
	callbackList = hwdev->info.Timer.CallbackList;
	if (callbackList)
	{
		do
		{
			timeCheck = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
			currTimeLo = ((hwreg)->Reg32[(NV_PTIMER_TIME_0) / 4]);
			currTimeHi = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
		}
		while (timeCheck != currTimeHi);
		while ((callbackList->timeHi < currTimeHi) || ((callbackList->timeHi == currTimeHi)
				&& (callbackList->timeLo <= currTimeLo)))
		{
			deleteCallback = callbackList;
			hwdev->info.Timer.CallbackList = deleteCallback->next;
			deleteCallback->next = hwdev->info.Timer.CallbackFreeList;
			hwdev->info.Timer.CallbackFreeList = deleteCallback;
			callbackList = hwdev->info.Timer.CallbackList;
			deleteCallback->callback (deleteCallback->timerObj);
			if (!callbackList)
			{
				break;
			}
			(hwreg)->Reg32[(NV_PTIMER_ALARM_0) / 4] = (NvV32) (callbackList->timeLo);
			do
			{
				timeCheck = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
				currTimeLo = ((hwreg)->Reg32[(NV_PTIMER_TIME_0) / 4]);
				currTimeHi = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
			}
			while (timeCheck != currTimeHi);
		}
	}
	return ((hwreg)->Reg32[(NV_PTIMER_INTR_0) / 4]);
}

void
tmrDelay (NvDeviceInfo *device, unsigned int nsec)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               timeCheck,
	                    timeLo,
	                    timeHi;

	do
	{
		timeCheck = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
		timeLo = ((hwreg)->Reg32[(NV_PTIMER_TIME_0) / 4]);
		timeHi = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
	}
	while (timeCheck != timeHi);
	timeLo += nsec;
	if (timeLo < nsec)
	{
		timeHi++;
	}
	while (timeHi > ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4])) ;
	while ((timeLo > ((hwreg)->Reg32[(NV_PTIMER_TIME_0) / 4]))
		&& (timeHi == ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]))) ;
}

void
tmrGetCurrentTime (NvDeviceInfo *device, NvU32 *timeHi, NvU32 *timeLo)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               timeCheck;

	do
	{
		timeCheck = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
		*timeLo = ((hwreg)->Reg32[(NV_PTIMER_TIME_0) / 4]);
		*timeHi = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
	}
	while (timeCheck != *timeHi);
}
static NvV32
mthdSynchronize (EngineObj *object, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvV32               status = 0;

	;
	if (!object->notifyCtxDma)
		status |= (0x01000000);
	switch (data)
	{
		case (NV_PMC_BOOT_0):
		case (0x00000001):
			return status;
		case (0x00000002):
		case (0x00000003):
			break;
		default:;
			status |= (0x02000000);
			break;
	}
	if (status)
		return status;
	timerNotify ((TimerObj *) object, data, 0, status);
	return 0;
}

NvV32
mthdStopAlarm (EngineObj *object, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	TimerObj           *timer = (TimerObj *) object;
	NvU32               status;

	;
	;
	if (data != (NV_PMC_BOOT_0))
	{
		return (0x02000000);
	}
	else if (timer->state & 0x01)
	{
		timer->state |= 0x10;
		status = tmrCancelCallback (timer);
		timerNotify (timer, timer->notifyType, 1, status);
		timer->state &= ~0x10;
	}
	return 0;
}

NvV32
mthdSetAlarmTime (EngineObj *object, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	TimerObj           *timer = (TimerObj *) object;

	;
	;
	if (timer->state & (0x01 | 0x10))
	{
		;
		return (0x00800000);
	}
	else
	{
		if (offset == 0x300)
			timer->userLo = data;
		else
			timer->userHi = data;
	}
	return 0;
}

NvV32
mthdSetAlarmNotify (EngineObj *object, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	TimerObj           *timer = (TimerObj *) object;
	NvV32               errors = 0;

	;
	if (object->notifyCtxDma == (void *) 0)
		errors |= (0x01000000);
	if (data != (NV_PMC_BOOT_0) && data != (0x00000001))
	{
		;
		errors |= (0x02000000);
	}
	if (timer->state & (0x01 | 0x10))
	{
		;
		errors |= (0x00800000);
	}
	if (errors)
		return errors;
	timer->state = 0x01;
	timer->notifyType = data;
	return (tmrAdjustCallback (timer));
}

NvV32
mthdTimerSetContextDmaNotifies (EngineObj *object, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	TimerObj           *timer = (TimerObj *) object;
	NvV32               errors = 0;

	if (timer->state & (0x01 | 0x10))
	{
		;
		errors |= (0x00800000);
	}
	errors |= mthdSwSetContextDmaNotifies (object, method, offset, data, cause);
	return errors;
}

MethodInfo          nv01TimerMethods[] = {
	{mthdSynchronize, "Synchronize", 0x100, 0x103}, {mthdStopAlarm, "StopAlarm", 0x104, 0x107},
		{mthdTimerSetContextDmaNotifies, "SetCntxtDmaNotifies", 0x180, 0x183},
		{mthdSetAlarmTime, "SetTime0", 0x300, 0x303}, {mthdSetAlarmTime, "SetTime1", 0x304,
			0x307}, {mthdSetAlarmNotify, "SetAlarmNotify", 0x308, 0x30b},
};
NvV32
Nv01AllocTimer (GenericObj *genericObj, NvClassAllocParameters *alloc)
{
	Nv0004AllocParameters *allocTimer = (Nv0004AllocParameters *) alloc;
	TimerObj           *timerObj = (TimerObj *) genericObj;
	NvV32               flags;

	;
	flags = ((allocTimer->flags >> ((0 ? 31 : 0) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 31 : 0) % 32) + ((0 ? 31 : 0) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)))
	{
		;
		return (0x00000005);
	}
	timerObj->flags = flags;
	timerObj->userLo = 0;
	timerObj->userHi = 0;
	timerObj->alarmLo = 0;
	timerObj->alarmHi = 0;
	timerObj->state = 0x00;
	timerObj->callback = tmrAdjustCallback;
	timerObj->notifyType = (NvV32) -1;
	return 0;
}

NvV32
Nv01FreeTimer (GenericObj *genericObj)
{
	TimerObj           *timer = (TimerObj *) genericObj;

	;
	(void) tmrCancelCallback (timer);
	return 0;
}

NvV32
Nv01AttachTimer (GenericObj *genericObj, NvClassAllocParameters *alloc)
{
	NvDeviceInfo       *deviceInfo =
		((NvDeviceInfo *) (((NvDeviceObj *) ((((EngineObj *) genericObj))->base.parent->
					parent))->device->deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) deviceInfo;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	;
	(hwreg)->Reg32[(NV_PTIMER_INTR_EN_0) / 4] = (NvV32) (0xFFFFFFFF);
	return swAttachEngineObject (genericObj, alloc);
}

NvV32
Nv01DetachTimer (GenericObj *genericObj)
{
	NvDeviceInfo       *deviceInfo =
		((NvDeviceInfo *) (((NvDeviceObj *) ((((EngineObj *) genericObj))->base.parent->
					parent))->device->deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) deviceInfo;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	;
	(hwreg)->Reg32[(NV_PTIMER_INTR_EN_0) / 4] = (NvV32) (0x0);
	return swDetachEngineObject (genericObj);
}

EngineObjInfo       timerObjInfo = {
	((NV_PMC_BOOT_0) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0, {(0x00000004), 0x0,
			0x0}, (void *) 0
};
ClassInfo           Nv01TimerClassInfo = {
	(0x00000004), "timer", sizeof (TimerObj), 0x1, 2, &timerObjInfo, (void *) 0, Nv01AllocTimer,
		Nv01AttachTimer, (void *) 0, Nv01FreeTimer, Nv01DetachTimer, (void *) 0, 0,
		(void *) 0, (sizeof (nv01TimerMethods) / sizeof (nv01TimerMethods[0])),
		nv01TimerMethods
};
NvV32
tmrScheduleCallback (TimerObj *timer)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((&timer->base))->base.parent->parent))->
			device->deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               timeCheck,
	                    currTimeLo,
	                    currTimeHi;
	TimerCallback      *callbackList,
	                   *callbackFreeList;
	TimerCallback      *tmrInsert,
	                   *tmrScan;

	;
	callbackList = hwdev->info.Timer.CallbackList;
	callbackFreeList = hwdev->info.Timer.CallbackFreeList;
	do
	{
		timeCheck = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
		currTimeLo = ((hwreg)->Reg32[(NV_PTIMER_TIME_0) / 4]);
		currTimeHi = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
	}
	while (timeCheck != currTimeHi);
	;
	if ((timer->alarmHi < currTimeHi) || ((timer->alarmHi == currTimeHi)
			&& (timer->alarmLo <= currTimeLo)))
	{
		timer->callback (timer);
	}
	else
	{
		if (callbackFreeList == (void *) 0)
		{
			return 2;
		}
		tmrInsert = callbackFreeList;
		hwdev->info.Timer.CallbackFreeList = callbackFreeList->next;
		tmrInsert->callback = timer->callback;
		tmrInsert->timerObj = timer;
		tmrInsert->timeLo = timer->alarmLo;
		tmrInsert->timeHi = timer->alarmHi;
		tmrInsert->next = (void *) 0;
		if (callbackList == (void *) 0 || ((tmrInsert->timeHi < callbackList->timeHi)
				|| ((tmrInsert->timeHi == callbackList->timeHi)
					&& (tmrInsert->timeLo <= callbackList->timeLo))))
		{
			tmrInsert->next = callbackList;
			hwdev->info.Timer.CallbackList = tmrInsert;
			(hwreg)->Reg32[(NV_PTIMER_ALARM_0) / 4] = (NvV32) (timer->alarmLo);
		}
		else
		{
			tmrScan = callbackList;
			while (tmrScan->next)
			{
				if ((tmrInsert->timeHi < tmrScan->next->timeHi)
					|| ((tmrInsert->timeHi == tmrScan->next->timeHi)
						&& (tmrInsert->timeLo <= tmrScan->next->timeLo)))
				{
					tmrInsert->next = tmrScan->next;
					tmrScan->next = tmrInsert;
					return 0;
				}
				tmrScan = tmrScan->next;
			}
			tmrScan->next = tmrInsert;
		}
	}
	return 0;
}

NvV32
tmrCancelCallback (TimerObj *timer)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((&timer->base))->base.parent->parent))->
			device->deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	TimerCallback      *tmrDelete,
	                   *tmrScan;
	TimerCallback      *callbackList,
	                   *callbackFreeList;

	;
	callbackList = hwdev->info.Timer.CallbackList;
	callbackFreeList = hwdev->info.Timer.CallbackFreeList;
	if (callbackList)
	{
		if (callbackList->timerObj == timer)
		{
			;
			if (timer->state & 0x01)
				tmrAlarmNotify (timer);
			tmrDelete = callbackList;
			hwdev->info.Timer.CallbackList = tmrDelete->next;
			tmrDelete->next = callbackFreeList;
			hwdev->info.Timer.CallbackFreeList = tmrDelete;
			callbackList = hwdev->info.Timer.CallbackList;
			if (callbackList)
				(hwreg)->Reg32[(NV_PTIMER_ALARM_0) / 4] =
					(NvV32) (callbackList->timeLo);
		}
		else
		{
			tmrScan = callbackList;
			while (tmrScan->next)
			{
				if (tmrScan->next->timerObj == timer)
				{
					;
					if (timer->state & 0x01)
						tmrAlarmNotify (timer);
					tmrDelete = tmrScan->next;
					tmrScan->next = tmrScan->next->next;
					tmrDelete->next = callbackFreeList;
					callbackFreeList = tmrDelete;
				}
				else
				{
					tmrScan = tmrScan->next;
				}
			}
		}
	}
	timer->state &= ~0x01;
	return 0;
}

NvV32
tmrAdjustCallback (TimerObj *timer)
{
	EngineObj          *engObj = &timer->base;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               timeCheck,
	                    currTimeLo,
	                    currTimeHi;

	;
	do
	{
		timeCheck = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
		currTimeLo = ((hwreg)->Reg32[(NV_PTIMER_TIME_0) / 4]);
		currTimeHi = ((hwreg)->Reg32[(NV_PTIMER_TIME_1) / 4]);
	}
	while (timeCheck != currTimeHi);
	;
	if ((timer->userHi < currTimeHi) || ((timer->userHi == currTimeHi)
			&& (timer->userLo <= currTimeLo)))
	{
		return tmrAlarmNotify (timer);
	}
	if ((timer->userHi == currTimeHi) || (((timer->userHi - currTimeHi) == 1)
			&& (timer->userLo < currTimeLo)))
	{
		timer->alarmLo = timer->userLo;
		timer->alarmHi = timer->userHi;
	}
	else
	{
		timer->alarmLo = currTimeLo;
		timer->alarmHi = currTimeHi + 1;
	}
	return tmrScheduleCallback (timer);
}

NvV32
tmrAlarmNotify (TimerObj *timer)
{
	EngineObj          *engObj = &timer->base;

	if (engObj->notifyCtxDma)
	{
		;
		;
		timerNotify (timer, timer->notifyType, 1, (0x00));
		timer->state &= ~0x01;
	}
	return 0;
}
