 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


extern NvV32        mthdUnimplemented (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSwSetContextDmaNotifies (EngineObj *, MethodInfo *, NvV32, NvV32, int);
NvV32
swAttachEngineObject (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	EngineObjInfo      *engObjInfo = ((engObj)->base.classInfo->objectInfo);
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	int                 chid = objectToChID (engObj);
	NvU32               instMemLoc;
	NvV32               instMemSize;
	NvV32               status;

	;
	;
	instMemSize = 1;
	status = fbAllocInstMem (device, &instMemLoc, &instMemSize, 0);
	if (status != 0)
	{
		;
		return 2;
	}
	(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((instMemLoc) << 4) + ((((0 ? (0 * 32 +
									31) : (0 * 32 +
									0)) / 32) << 2)))) / 4] =
		(NvV32) ((engObjInfo->instanceMem[0]));
	(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((instMemLoc) << 4) + ((((0 ? (1 * 32 +
									31) : (1 * 32 +
									0)) / 32) << 2)))) / 4] =
		(NvV32) ((engObjInfo->instanceMem[1]));
	(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((instMemLoc) << 4) + ((((0 ? (2 * 32 +
									31) : (2 * 32 +
									0)) / 32) << 2)))) / 4] =
		(NvV32) ((engObjInfo->instanceMem[2]));
	engObj->instMemLoc = instMemLoc;
	;
	engObj->context =
		engObjInfo->hashContextMask | (((instMemLoc) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
							15) : (1 * 32 + 0)) + (0 ? (1 * 32 +
							15) : (1 * 32 + 0))))) << ((0 ? (1 * 32 +
					15) : (1 * 32 + 0)) & 31)) | (((chid) & (0xFFFFFFFF >> (31 -
					(1 ? (1 * 32 + 27) : (1 * 32 + 24)) + (0 ? (1 * 32 +
							27) : (1 * 32 + 24))))) << ((0 ? (1 * 32 +
					27) : (1 * 32 + 24)) & 31));
	engObj->hashEntry = (~0);
	engObj->notifyCtxDma = (void *) 0;
	fifoAddHashEntry (device, engObj);
	return 0;
}

NvV32
swDetachEngineObject (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	;
	;
	;
	;
	fifoRemoveHashEntry (device, engObj);
	fbFreeInstMem (device, engObj->instMemLoc, 1);
	fifoRemoveObjectFromSubChannelCache (engObj);
	if (engObj->notifyCtxDma)
	{
		engObj->notifyCtxDma->base.refcnt--;
		;
		engObj->notifyCtxDma = (void *) 0;
	}
	return 0;
}
