 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
mthdSwSetContextDmaNotifies (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	EngineObjInfo      *engObjInfo;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0 || dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		engObjInfo = (EngineObjInfo *) ((engObj)->base.classInfo->objectInfo);
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003E))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(0x00000001))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000001)))))
		{
			;
			;
			return (0x01000000);
		}
		if (engObj->notifyCtxDma != (void *) 0)
		{
			engObj->notifyCtxDma->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		engObj->notifyCtxDma = ctxDmaObj;
	}
	else
	{
		ctxDmaObj = engObj->notifyCtxDma;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			engObj->notifyCtxDma = (void *) 0;
		}
	}
	return 0;
}
