#ifndef __STATEMENTS_H__
#define __STATEMENTS_H__

#if defined(NV_COMPILE_NV03)
#include <nv3ref.h>
#elif defined(NV_COMPILE_NV04)
#include <nv4ref.h>
#endif

#define	NULL	(void *)0

#define nvU64ToULong(u64)		(unsigned long)(u64)->low
#define nvULongToU64(u64,l)		(u64)->high = 0, (u64)->low = (NvU32)(l)

#ifdef _WIN32
#define nvP64ToAddr(p64)		(p64)->offset
#define nvAddrToP64(p64,addr)		(p64)->offset = (NvU32)(addr)
#endif
#ifdef __linux__
#define nvP64ToAddr(p64)		(p64)->low
#define nvAddrToP64(p64,addr)		(p64)->low = (NvU32)(addr)
#endif

#define NV_RD32(addr)			((hwreg)->Reg32[( addr )/4])
#define NV_RD16(addr)			((hwreg)->Reg16[( addr )/2])
#define NV_RD8(addr)			((hwreg)->Reg8 [ addr ])

#define NV_WR32(addr, value)		(hwreg)->Reg32[( addr) /4] = (NvV32) ( value )
#define NV_WR16(addr, value)		(hwreg)->Reg16[( addr )/4] = (NvV16) ( value )
#define NV_WR8(addr, value)		(hwreg)->Reg8[ addr ] = (NvV8) ( value )

#define NV_MEM_RD32(addr)		((hwram)->Reg32[( addr )/4])
#define NV_MEM_WR32(addr, value)	(hwram)->Reg32[( addr) /4] = (NvV32) ( value )

#define NV_BF_LOW(bf)			((0? bf ) % 32)
#define NV_BF_HIGH(bf)			((1? bf ) % 32)

#define NV_SHIFTED_MASK(bf)		(0xFFFFFFFF>>(31-NV_BF_HIGH(bf)+NV_BF_LOW(bf)))
#define NV_MAKE_VALUE(value, bf)	((( value )& NV_SHIFTED_MASK(bf) )<< NV_BF_LOW(bf) )
#define NV_EXTRACT_VALUE(value, bf)	(( value >> NV_BF_LOW(bf) ) & NV_SHIFTED_MASK(bf) )

#define NV_GET_VALUE(addr, bf)		NV_EXTRACT_VALUE(NV_RD32(addr), bf)
#define NV_SET_VALUE(addr, bf, value)	NV_WR32(addr, ((value )<< NV_BF_LOW(bf) ))

#endif /* __STATEMENTS_H__ */
