 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



 /***************************************************************************\
|*                                                                           *|
|*                         NV Architecture Interface                         *|
|*                                                                           *|
|*     <nvsw32.h> defines  a 32-bit wide software interface  to NVIDIA's     *|
|*     Unified Media Architecture (TM).                                      *|
|*                                                                           *|
 \***************************************************************************/


#ifndef NVSW32_INCLUDED
#define NVSW32_INCLUDED
#ifdef __cplusplus
extern              "C"
{
#endif

#include <nvtypes.h>


 /***************************************************************************\
|*                               NV User Calls                               *|
 \***************************************************************************/


/* Win32 */
#ifdef _WIN32
#include <windows.h>
#include <winbase.h>
#include <winioctl.h>
#include <malloc.h>
	struct
	{
		int                 opened;
		int                 status;
		HANDLE              hFile;
	} _NvUser;
#define nvSwCall(function, parameters)                                    \
{                                                                         \
  DWORD bytesReturned;                                                    \
  if (_NvUser.opened == FALSE) {                                          \
    _NvUser.hFile =                                                       \
	CreateFileA((LPCSTR)"\\\\.\\nvidia",                                \
        (DWORD)(GENERIC_READ | GENERIC_WRITE),                            \
        (DWORD)0,                                                         \
        (LPSECURITY_ATTRIBUTES)NULL,                                      \
        (DWORD)OPEN_EXISTING,                                             \
        (DWORD)FILE_ATTRIBUTE_NORMAL,                                     \
        (HANDLE)NULL);                                                    \
    _NvUser.opened = _NvUser.hFile == INVALID_HANDLE_VALUE ? FALSE : TRUE;\
    _NvUser.status = _NvUser.hFile != INVALID_HANDLE_VALUE;               \
  }                                                                       \
  if (_NvUser.opened && _NvUser.hFile != INVALID_HANDLE_VALUE) {          \
    _NvUser.status =                                                      \
	DeviceIoControl(                                                    \
        _NvUser.hFile,                                                    \
        CTL_CODE(                                                         \
          0x8000,                                                         \
          0x800 + function,                                               \
          METHOD_BUFFERED,                                                \
          FILE_ANY_ACCESS),                                               \
        (LPVOID)parameters,                                               \
        (DWORD)64,                                                        \
        (LPVOID)parameters,                                               \
        (DWORD)64,                                                        \
        (LPDWORD)&bytesReturned,                                          \
        NULL);                                                            \
  }                                                                       \
}
#define nvSwIsOsError()  (_NvUser.status == 0)
#define nvSwGetOsError() (GetLastError())
#endif				/* _WIN32 */

/* SystemV and Linux */
#if defined(SYSV) || defined(__linux__)
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>
#define NV_IOCTL_PREFIX 'F'
	struct
	{
		int                 opened;
		int                 status;
		int                 fd;
	} _NvUser;
#define nvSwCall(function, parameters)              \
{                                                   \
  if (_NvUser.opened == 0) {                        \
    _NvUser.fd = open("/dev/nv", O_RDWR);           \
    _NvUser.opened = _NvUser.fd < 0 ? 0 : 1;        \
    _NvUser.status = _NvUser.fd < 0 ? errno : 0;    \
  }                                                 \
  if (_NvUser.opened && _NvUser.fd != -1) {         \
    _NvUser.status = 0;                             \
    if (ioctl(                                      \
        _NvUser.fd,                                 \
        _IOWR(NV_IOCTL_PREFIX, function, caddr_t),  \
        (caddr_t)parameters) < 0)                   \
	_NvUser.status = errno;                       \
  }                                                 \
}
#define nvSwIsOsError()  (_NvUser.status != 0)
#define nvSwGetOsError() (_NvUser.status)
#endif				/* defined(SYSV) || defined(__linux__) */




#define NVSW001_ALLOC                                              (0x00000001)




#define NVSW002_FREE                                               (0x00000002)




#define NVSW003_CONTROL                                            (0x00000003)



 /***************************************************************************\
|*                               NV User Events                              *|
 \***************************************************************************/

/* function EVENT */


#ifdef __cplusplus
};
#endif
#endif /* NVSW32_INCLUDED */
