 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



 /***************************************************************************\
|*                                                                           *|
|*                         NV Architecture Interface                         *|
|*                                                                           *|
|*     <nvos32.h>   defines  the  internal  Operating  System  dependent     *|
|*     interfaces to NVIDIA's Unified Media Architecture (TM).               *|
|*                                                                           *|
 \***************************************************************************/


#ifndef NVOS32_INCLUDED
#define NVOS32_INCLUDED
#ifdef __cplusplus
extern              "C"
{
#endif

#include <nvtypes.h>


 /***************************************************************************\
|*                         NV Operating System Calls                         *|
 \***************************************************************************/


/* nvOsCall */
	extern void         nvOsCall (void *parameters);
#define NVOS000_STATUS_ERROR_BAD_FUNCTION                          (0x00000001)


/* function NVOS020_ARCHITECTURE_ALLOC */
#define  NVOS020_ARCHITECTURE_ALLOC                                (0x00000020)
/* NvOsCall() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS020_ARCHITECTURE_ALLOC       0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               flags;	/* NVOS020_FLAGS_*                  0008-000b */
	} NvOs020Parameters;
#define NVOS020_STATUS_SUCCESS                                     (0x00000000)
#define NVOS020_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS020_STATUS_ERROR_BAD_FLAGS_CPU_NUMBER                  (0x00000003)
#define NVOS020_STATUS_ERROR_BAD_FLAGS_CPU_CACHES                  (0x00000004)
#define NVOS020_STATUS_ERROR_ALREADY_ALLOCATED                     (0x00000005)
#define NVOS020_FLAGS_CPU_NUMBER                                            3:0
#define NVOS020_FLAGS_CPU_NUMBER_UNKNOWN                           (0x00000000)
#define NVOS020_FLAGS_CPU_NUMBER_SINGLE_PROCESSOR                  (0x00000001)
#define NVOS020_FLAGS_CPU_NUMBER_MULTIPLE_PROCESSORS               (0x00000002)
#define NVOS020_FLAGS_CPU_CACHES                                            7:4
#define NVOS020_FLAGS_CPU_CACHES_UNKNOWN                           (0x00000000)
#define NVOS020_FLAGS_CPU_CACHES_ALL_UNCACHED                      (0x00000001)
#define NVOS020_FLAGS_CPU_CACHES_ALL_PHYSICAL                      (0x00000002)
#define NVOS020_FLAGS_CPU_CACHES_ALL_VIRTUAL                       (0x00000003)
#define NVOS020_FLAGS_CPU_CACHES_MIXED                             (0x00000004)
#define NVOS020_FLAGS_DEBUG                                                31:8
#define NVOS020_FLAGS_DEBUG_DISABLED                               (0x00000000)
#define NVOS020_FLAGS_DEBUG_ENABLED                                (0x00000001)


/* function NVOS021_ARCHITECTURE_FREE */
#define  NVOS021_ARCHITECTURE_FREE                                 (0x00000021)
/* NvOsCall() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS021_ARCHITECTURE_FREE        0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
	} NvOs021Parameters;
#define NVOS021_STATUS_SUCCESS                                     (0x00000000)
#define NVOS021_STATUS_ERROR_NOTHING_ALLOCATED                     (0x00000002)


/* function NVOS040_DEVICE_PROBED */
#define  NVOS040_DEVICE_PROBED                                     (0x00000040)
/* NvOsCall() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS040_DEVICE_PROBED            0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvP64               deviceBase[6];	/* physical address of device regs  0008-0037 */
		NvP64               romBase;	/* virtual address of rom           0038-003f */
		NvU64               romLimit;	/* size-1 of rom                    0040-0047 */
		NvV32               deviceId;	/* device id number                 0048-004b */
	} NvOs040Parameters;
#define NVOS040_STATUS_SUCCESS                                     (0x00000000)
#define NVOS040_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS040_STATUS_ERROR_BAD_DEVICE_ID                         (0x00000003)


/* function NVOS060_SESSION_ALLOC */
#define  NVOS060_SESSION_ALLOC                                     (0x00000060)
/* NvOsCall() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS060_SESSION_ALLOC            0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               sessionId;	/* session id number                0008-000b */
	} NvOs060Parameters;
#define NVOS060_STATUS_SUCCESS                                     (0x00000000)
#define NVOS060_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS060_STATUS_ERROR_BAD_SESSION_ID                        (0x00000003)


/* function NVOS061_SESSION_FREE */
#define  NVOS061_SESSION_FREE                                      (0x00000061)
/* NvOsCall() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS061_SESSION_FREE             0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               sessionId;	/* session id number                0008-000b */
	} NvOs061Parameters;
#define NVOS061_STATUS_SUCCESS                                     (0x00000000)
#define NVOS061_STATUS_ERROR_BAD_SESSION_ID                        (0x00000002)


/* function NVOS080_USER_ALLOC */
#define  NVOS080_USER_ALLOC                                        (0x00000080)
/* NvOsCall() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS080_USER_ALLOC               0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvP64               userParameters;	/* pointer to user parameters       0008-000f */
		NvV32               sessionId;	/* session id number                0010-0013 */
	} NvOs080Parameters;
#define NVOS080_STATUS_SUCCESS                                     (0x00000000)
#define NVOS080_STATUS_ERROR_BAD_SESSION_ID                        (0x00000002)


/* function NVOS081_USER_FREE */
#define  NVOS081_USER_FREE                                         (0x00000081)
/* NvOsCall() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS081_USER_FREE                0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvP64               userParameters;	/* pointer to user parameters       0008-000f */
		NvV32               sessionId;	/* session id number                0010-0013 */
	} NvOs081Parameters;
#define NVOS081_STATUS_SUCCESS                                     (0x00000000)
#define NVOS081_STATUS_ERROR_BAD_SESSION_ID                        (0x00000002)


/* function NVOS082_USER_CONTROL */
#define  NVOS082_USER_CONTROL                                      (0x00000082)
/* NvOsCall() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS082_USER_CONTROL             0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvP64               userParameters;	/* pointer to user parameters       0008-000f */
		NvV32               sessionId;	/* session id number                0010-0013 */
	} NvOs082Parameters;
#define NVOS082_STATUS_SUCCESS                                     (0x00000000)
#define NVOS082_STATUS_ERROR_BAD_SESSION_ID                        (0x00000002)


/* function NVOS0A0_INTERRUPT_SCHEDULE */
#define  NVOS0A0_INTERRUPT_SCHEDULE                                (0x000000A0)
/* NvOsCall() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS0A0_INTERRUPT_SCHEDULE       0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               interruptId;	/* returns interrupt id number      0008-000b */
		NvV32               latency;	/* returns latency in nanoseconds   000c-000f */
	} NvOs0a0Parameters;
#define NVOS0A0_STATUS_SUCCESS                                     (0x00000000)
#define NVOS0A0_STATUS_ERROR_NO_MORE_INTERRUPTS                    (0x00000002)


/* function NVOS0A1_INTERRUPT_SERVICE */
#define  NVOS0A1_INTERRUPT_SERVICE                                 (0x000000A1)
/* NvOsCall() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS0A1_INTERRUPT_SERVICE        0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               interruptId;	/* returns interrupt id number      0008-000b */
	} NvOs0a1Parameters;
#define NVOS0A1_STATUS_SUCCESS                                     (0x00000000)
#define NVOS0A1_STATUS_ERROR_BAD_INTERRUPT_ID                      (0x00000002)


 /***************************************************************************\
|*                       NV Operating System Callbacks                       *|
 \***************************************************************************/


/* nvOsCallback */
	extern void         nvOsCallback (void *parameters);
#define NVOS800_STATUS_ERROR_BAD_FUNCTION                          (0x00000001)


/* function NVOS820_LOCK_ALLOC_SPIN */
#define  NVOS820_LOCK_ALLOC_SPIN                                   (0x00000820)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS820_LOCK_ALLOC_SPIN          0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               lockId;	/* lock id number                   0008-000b */
	} NvOs820Parameters;
#define NVOS820_STATUS_SUCCESS                                     (0x00000000)
#define NVOS820_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS820_STATUS_ERROR_BAD_LOCK_ID                           (0x00000003)


/* function NVOS821_LOCK_ALLOC_SLEEP */
#define  NVOS821_LOCK_ALLOC_SLEEP                                  (0x00000821)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS821_LOCK_ALLOC_SLEEP         0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               lockId;	/* lock id number                   0008-000b */
	} NvOs821Parameters;
#define NVOS821_STATUS_SUCCESS                                     (0x00000000)
#define NVOS821_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS821_STATUS_ERROR_BAD_LOCK_ID                           (0x00000003)


/* function NVOS822_LOCK_FREE */
#define  NVOS822_LOCK_FREE                                         (0x00000822)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS822_LOCK_FREE                0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               lockId;	/* lock id number                   0008-000b */
	} NvOs822Parameters;
#define NVOS822_STATUS_SUCCESS                                     (0x00000000)
#define NVOS822_STATUS_ERROR_BAD_LOCK_ID                           (0x00000002)


/* function NVOS823_LOCK_ACQUIRE */
#define  NVOS823_LOCK_ACQUIRE                                      (0x00000823)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS823_LOCK_ACQUIRE             0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               lockId;	/* lock id number                   0008-000b */
	} NvOs823Parameters;
#define NVOS823_STATUS_SUCCESS                                     (0x00000000)
#define NVOS823_STATUS_ERROR_BAD_LOCK_ID                           (0x00000002)


/* function NVOS824_LOCK_RELEASE */
#define  NVOS824_LOCK_RELEASE                                      (0x00000824)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS824_LOCK_RELESE              0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               lockId;	/* lock id number                   0008-000b */
	} NvOs824Parameters;
#define NVOS824_STATUS_SUCCESS                                     (0x00000000)
#define NVOS824_STATUS_ERROR_BAD_LOCK_ID                           (0x00000002)


/* function NVOS840_MEMORY_ALLOC */
#define  NVOS840_MEMORY_ALLOC                                      (0x00000840)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS840_MEMORY_ALLOC             0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               memoryId;	/* memory id number                 0008-000b */
		NvV32               flags;	/* NVOS840_FLAGS_*                  000c-000f */
		NvP64               base;	/* returns a memory pointer         0010-0017 */
		NvU64               limit;	/* size-1 of memory                 0018-001f */
	} NvOs840Parameters;
#define NVOS840_STATUS_SUCCESS                                     (0x00000000)
#define NVOS840_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS840_STATUS_ERROR_BAD_MEMORY_ID                         (0x00000003)
#define NVOS840_STATUS_ERROR_BAD_FLAGS_MEMORY_PAGES                (0x00000004)
#define NVOS840_STATUS_ERROR_BAD_FLAGS_MAPPING_ACCESS              (0x00000005)
#define NVOS840_STATUS_ERROR_BAD_FLAGS_MAPPING_COHERENCY           (0x00000006)
#define NVOS840_STATUS_ERROR_UNSUPPORTED_FLAGS_MEMORY_PAGES        (0x00000007)
#define NVOS840_STATUS_ERROR_UNSUPPORTED_FLAGS_MAPPING_ACCESS      (0x00000008)
#define NVOS840_STATUS_ERROR_UNSUPPORTED_FLAGS_MAPPING_COHERENCY   (0x00000009)
#define NVOS840_FLAGS_MEMORY_PAGES                                          3:0
#define NVOS840_FLAGS_MEMORY_PAGES_FIXED_NONCONTIGUOUS             (0x00000000)
#define NVOS840_FLAGS_MEMORY_PAGES_FIXED_CONTIGUOUS                (0x00000001)
#define NVOS840_FLAGS_MAPPING_ACCESS                                        7:4
#define NVOS840_FLAGS_MAPPING_ACCESS_READ_WRITE_NONCOMBINED        (0x00000000)
#define NVOS840_FLAGS_MAPPING_COHERENCY                                    31:8
#define NVOS840_FLAGS_MAPPING_COHERENCY_UNCACHED                   (0x00000000)
#define NVOS840_FLAGS_MAPPING_COHERENCY_CACHED                     (0x00000001)
/* deprecated stuff */
#ifdef NVDEPRECATED
#define NVOS840_MEMORY_ALLOC_KERNEL                                (0x00000840)
#define NVOS840_FLAGS_MAPPING_ACCESS_READ_WRITE                    (0x00000000)
#endif


/* function NVOS84F_MEMORY_FREE */
#define  NVOS84F_MEMORY_FREE                                       (0x0000084F)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS84F_MEMORY_FREE              0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               memoryId;	/* memory id number                 0008-000b */
	} NvOs84fParameters;
#define NVOS84F_STATUS_SUCCESS                                     (0x00000000)
#define NVOS84F_STATUS_ERROR_BAD_MEMORY_ID                         (0x00000002)
/* deprecated stuff */
#ifdef NVDEPRECATED
#define NVOS842_MEMORY_FREE                                        (0x0000084F)
#define NvOs842Parameters                                     NvOs84fParameters
#define NVOS842_STATUS_SUCCESS                                     (0x00000000)
#define NVOS842_STATUS_ERROR_BAD_MEMORY_ID                         (0x00000002)
#endif


/* function NVOS860_MAPPING_ALLOC_DEVICE_PHYSICAL_TO_KERNEL */
#define  NVOS860_MAPPING_ALLOC_DEVICE_PHYSICAL_TO_KERNEL           (0x00000860)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS860_MAPPING_ALLOC_DEVICE_PHY 0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               mappingId;	/* mapping id number                0008-000b */
		NvV32               flags;	/* NVOS860_FLAGS_*                  000c-000f */
		NvP64               base;	/* mapping pointer                  0010-0017 */
		NvU64               limit;	/* size-1 of mapping                0018-001f */
	} NvOs860Parameters;
#define NVOS860_STATUS_SUCCESS                                     (0x00000000)
#define NVOS860_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS860_STATUS_ERROR_BAD_MAPPING_ID                        (0x00000003)
#define NVOS860_STATUS_ERROR_BAD_FLAGS_MEMORY_PAGES                (0x00000004)
#define NVOS860_STATUS_ERROR_BAD_FLAGS_MAPPING_ACCESS              (0x00000005)
#define NVOS860_STATUS_ERROR_BAD_FLAGS_MAPPING_COHERENCY           (0x00000006)
#define NVOS860_STATUS_ERROR_BAD_BASE                              (0x00000007)
#define NVOS860_STATUS_ERROR_BAD_LIMIT                             (0x00000008)
#define NVOS860_STATUS_ERROR_UNSUPPORTED_FLAGS_MEMORY_PAGES        (0x00000009)
#define NVOS860_STATUS_ERROR_UNSUPPORTED_FLAGS_MAPPING_ACCESS      (0x0000000A)
#define NVOS860_STATUS_ERROR_UNSUPPORTED_FLAGS_MAPPING_COHERENCY   (0x0000000B)
#define NVOS860_STATUS_ERROR_PROTECTION_FAULT                      (0x0000000C)
#define NVOS860_FLAGS_MEMORY_PAGES                                          3:0
#define NVOS860_FLAGS_MEMORY_PAGES_FIXED_CONTIGUOUS                (0x00000000)
#define NVOS860_FLAGS_MAPPING_ACCESS                                        7:4
#define NVOS860_FLAGS_MAPPING_ACCESS_READ_WRITE_NONCOMBINED        (0x00000000)
#define NVOS860_FLAGS_MAPPING_COHERENCY                                    31:8
#define NVOS860_FLAGS_MAPPING_COHERENCY_UNCACHED                   (0x00000000)
/* deprecated stuff */
#ifdef NVDEPRECATED
#define NVOS860_MAPPING_ALLOC_PHYSICAL_TO_KERNEL                   (0x00000860)
#define NVOS860_FLAGS_MAPPING_ACCESS_READ_WRITE                    (0x00000000)
#endif


/* function NVOS861_MAPPING_ALLOC_DEVICE_PHYSICAL_TO_USER */
#define  NVOS861_MAPPING_ALLOC_DEVICE_PHYSICAL_TO_USER             (0x00000861)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS861_MAPPING_ALLOC_DEVICE_PHY 0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               mappingId;	/* mapping id number                0008-000b */
		NvV32               flags;	/* NVOS861_FLAGS_*                  000c-000f */
		NvP64               base;	/* mapping pointer                  0010-0017 */
		NvU64               limit;	/* size-1 of mapping                0018-001f */
	} NvOs861Parameters;
#define NVOS861_STATUS_SUCCESS                                     (0x00000000)
#define NVOS861_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS861_STATUS_ERROR_BAD_MAPPING_ID                        (0x00000003)
#define NVOS861_STATUS_ERROR_BAD_FLAGS_MEMORY_PAGES                (0x00000004)
#define NVOS861_STATUS_ERROR_BAD_FLAGS_MAPPING_ACCESS              (0x00000005)
#define NVOS861_STATUS_ERROR_BAD_FLAGS_MAPPING_COHERENCY           (0x00000006)
#define NVOS861_STATUS_ERROR_BAD_BAD_BASE                          (0x00000007)
#define NVOS861_STATUS_ERROR_BAD_BAD_LIMIT                         (0x00000008)
#define NVOS861_STATUS_ERROR_UNSUPPORTED_FLAGS_MEMORY_PAGES        (0x00000009)
#define NVOS861_STATUS_ERROR_UNSUPPORTED_FLAGS_MAPPING_ACCESS      (0x0000000A)
#define NVOS861_STATUS_ERROR_UNSUPPORTED_FLAGS_MAPPING_COHERENCY   (0x0000000B)
#define NVOS861_STATUS_ERROR_PROTECTION_FAULT                      (0x0000000C)
#define NVOS861_FLAGS_MEMORY_PAGES                                          3:0
#define NVOS861_FLAGS_MEMORY_PAGES_FIXED_CONTIGUOUS                (0x00000000)
#define NVOS861_FLAGS_MEMORY_PAGES_FIXED_NONCONTIGUOUS             (0x00000001)
#define NVOS861_FLAGS_MEMORY_PAGES_NONPAGABLE_NONCONTIGUOUS        (0x00000002)
#define NVOS861_FLAGS_MEMORY_PAGES_PAGABLE_NONCONTIGUOUS           (0x00000003)
#define NVOS861_FLAGS_MAPPING_ACCESS                                        7:4
#define NVOS861_FLAGS_MAPPING_ACCESS_READ_WRITE_NONCOMBINED        (0x00000000)
#define NVOS861_FLAGS_MAPPING_ACCESS_READ_WRITE_COMBINED           (0x00000001)
#define NVOS861_FLAGS_MAPPING_ACCESS_READ_ONLY                     (0x00000002)
#define NVOS861_FLAGS_MAPPING_ACCESS_WRITE_NONCOMBINED             (0x00000003)
#define NVOS861_FLAGS_MAPPING_ACCESS_WRITE_COMBINED                (0x00000004)
#define NVOS861_FLAGS_MAPPING_COHERENCY                                    31:8
#define NVOS861_FLAGS_MAPPING_COHERENCY_UNCACHED                   (0x00000000)
#define NVOS861_FLAGS_MAPPING_COHERENCY_CACHED                     (0x00000001)
/* deprecated stuff */
#ifdef NVDEPRECATED
#define NVOS862_MAPPING_ALLOC_PHYSICAL_TO_USER                     (0x00000862)
#define NVOS862_FLAGS_MEMORY_PAGES_FIXED_CONTIGUOUS                (0x00000000)
#define NVOS862_FLAGS_MEMORY_PAGES_FIXED_NONCONTIGUOUS             (0x00000001)
#define NVOS862_FLAGS_MEMORY_PAGES_NONPAGABLE_NONCONTIGUOUS        (0x00000002)
#define NVOS862_FLAGS_MEMORY_PAGES_PAGABLE_NONCONTIGUOUS           (0x00000003)
#define NVOS862_FLAGS_MAPPING_ACCESS_READ_WRITE                    (0x00000000)
#define NVOS862_FLAGS_MAPPING_ACCESS_READ_ONLY                     (0x00000002)
#define NVOS862_FLAGS_MAPPING_ACCESS_WRITE_ONLY                    (0x00000003)
#define NVOS862_FLAGS_MAPPING_COHERENCY_UNCACHED                   (0x00000000)
#define NVOS862_FLAGS_MAPPING_COHERENCY_CACHED                     (0x00000001)
#endif


/* function NVOS862_MAPPING_ALLOC_MEMORY_USER_TO_KERNEL */
#define  NVOS862_MAPPING_ALLOC_MEMORY_USER_TO_KERNEL               (0x00000862)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS862_MAPPING_ALLOC_MEMORY_USE 0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               mappingId;	/* mapping id number                0008-000b */
		NvV32               flags;	/* NVOS862_FLAGS_*                  000c-000f */
		NvP64               base;	/* mapping pointer                  0010-0017 */
		NvU64               limit;	/* size-1 of mapping                0018-001f */
	} NvOs862Parameters;
#define NVOS862_STATUS_SUCCESS                                     (0x00000000)
#define NVOS862_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS862_STATUS_ERROR_BAD_MAPPING_ID                        (0x00000003)
#define NVOS862_STATUS_ERROR_BAD_FLAGS_MEMORY_PAGES                (0x00000004)
#define NVOS862_STATUS_ERROR_BAD_FLAGS_MAPPING_ACCESS              (0x00000005)
#define NVOS862_STATUS_ERROR_BAD_FLAGS_MAPPING_COHERENCY           (0x00000006)
#define NVOS862_STATUS_ERROR_BAD_BASE                              (0x00000007)
#define NVOS862_STATUS_ERROR_BAD_LIMIT                             (0x00000008)
#define NVOS862_STATUS_ERROR_UNSUPPORTED_FLAGS_MEMORY_PAGES        (0x00000009)
#define NVOS862_STATUS_ERROR_UNSUPPORTED_FLAGS_MAPPING_ACCESS      (0x0000000A)
#define NVOS862_STATUS_ERROR_UNSUPPORTED_FLAGS_MAPPING_COHERENCY   (0x0000000B)
#define NVOS862_STATUS_ERROR_PROTECTION_FAULT                      (0x0000000C)
#define NVOS862_FLAGS_MEMORY_PAGES                                          3:0
#define NVOS862_FLAGS_MEMORY_PAGES_ANY                             (0x00000003)
#define NVOS862_FLAGS_MAPPING_ACCESS                                        7:4
#define NVOS862_FLAGS_MAPPING_ACCESS_READ_WRITE_NONCOMBINED        (0x00000000)
#define NVOS862_FLAGS_MAPPING_COHERENCY                                    31:8
#define NVOS862_FLAGS_MAPPING_COHERENCY_ANY                        (0x00000003)
/* deprecated stuff */
#ifdef NVDEPRECATED
#define NVOS861_MAPPING_ALLOC_USER_TO_KERNEL                       (0x00000862)
#define NVOS861_FLAGS_MEMORY_PAGES_ANY                             (0x00000003)
#define NVOS861_FLAGS_MAPPING_ACCESS_READ_WRITE                    (0x00000000)
#define NVOS861_FLAGS_MAPPING_COHERENCY_ANY                        (0x00000003)
#endif


/* function NVOS86F_MAPPING_FREE */
#define  NVOS86F_MAPPING_FREE                                      (0x0000086F)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS86F_MAPPING_FREE             0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               mappingId;	/* mapping id number                0008-000b */
	} NvOs86fParameters;
#define NVOS86F_STATUS_SUCCESS                                     (0x00000000)
#define NVOS86F_STATUS_ERROR_BAD_MAPPING_ID                        (0x00000002)
/* deprecated stuff */
#ifdef NVDEPRECATED
#define NVOS863_MAPPING_FREE                                       (0x0000086F)
#define NvOs863Parameters                                     NvOs86fParameters
#define NVOS863_STATUS_SUCCESS                                     (0x00000000)
#define NVOS863_STATUS_ERROR_BAD_MAPPING_ID                        (0x00000002)
#endif


/* function NVOS880_TIME */
#define  NVOS880_TIME                                              (0x00000880)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS880_TIME                     0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvU64               time;	/* nanoseconds since Jan 1,1970 GMT 0008-000f */
	} NvOs880Parameters;
#define NVOS880_STATUS_SUCCESS                                     (0x00000000)


/* function NVOS8A0_INTERRUPT_ALLOC */
#define  NVOS8A0_INTERRUPT_ALLOC                                   (0x000008A0)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS8A0_INTERRUPT_ALLOC          0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               interruptId;	/* interrupt id number              0008-000b */
	} NvOs8a0Parameters;
#define NVOS8A0_STATUS_SUCCESS                                     (0x00000000)
#define NVOS8A0_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS8A0_STATUS_ERROR_BAD_INTERRUPT_ID                      (0x00000003)


/* function NVOS8A1_INTERRUPT_FREE */
#define  NVOS8A1_INTERRUPT_FREE                                    (0x000008A1)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS8A1_INTERRUPT_FREE           0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               interruptId;	/* interrupt id number              0008-000b */
	} NvOs8a1Parameters;
#define NVOS8A1_STATUS_SUCCESS                                     (0x00000000)
#define NVOS8A1_STATUS_ERROR_BAD_INTERRUPT_ID                      (0x00000002)


/* function NVOS8C0_FLUSH_CACHES */
#define  NVOS8C0_FLUSH_CACHES                                      (0x000008C0)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS8C0_FLUSH_CACHES             0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvP64               base;	/* mapping pointer                  0008-000f */
		NvU64               limit;	/* size-1 of mapping                0010-0017 */
	} NvOs8c0Parameters;
#define NVOS8C0_STATUS_SUCCESS                                     (0x00000000)
#define NVOS8C0_STATUS_ERROR_PROTECTION_FAULT                      (0x00000002)


/* function NVOS8E0_CONTEXT_DMA_SYSTEM_ALLOC */
#define  NVOS8E0_CONTEXT_DMA_SYSTEM_ALLOC                          (0x000008E0)
/* memory data structures */
	typedef struct
	{			/* start of data structure          0000-    */
		NvP64               base;	/* returns physical address            0-   7 */
		NvV32               flags;	/* NVOS8E0_INFO_FLAGS_*                8-   b */
		NvV32               ignore;	/* ignored                             c-   f */
	} NvOs8e0Info;		/* end of data structure                -000f */
#define NVOS8E0_INFO_FLAGS_MEMORY_ACCESS_READ                               3:0
#define NVOS8E0_INFO_FLAGS_MEMORY_ACCESS_READ_UNKNOWN              (0x00000000)
#define NVOS8E0_INFO_FLAGS_MEMORY_ACCESS_READ_ALLOWED              (0x00000001)
#define NVOS8E0_INFO_FLAGS_MEMORY_ACCESS_READ_NOT_ALLOWED          (0x00000002)
#define NVOS8E0_INFO_FLAGS_MEMORY_ACCESS_WRITE                              7:4
#define NVOS8E0_INFO_FLAGS_MEMORY_ACCESS_WRITE_UNKNOWN             (0x00000000)
#define NVOS8E0_INFO_FLAGS_MEMORY_ACCESS_WRITE_ALLOWED             (0x00000001)
#define NVOS8E0_INFO_FLAGS_MEMORY_ACCESS_WRITE_NOT_ALLOWED         (0x00000002)
#define NVOS8E0_INFO_FLAGS_BUS_ACCESS_READ                                 11:8
#define NVOS8E0_INFO_FLAGS_BUS_ACCESS_READ_UNKNOWN                 (0x00000000)
#define NVOS8E0_INFO_FLAGS_BUS_ACCESS_READ_ALLOWED                 (0x00000001)
#define NVOS8E0_INFO_FLAGS_BUS_ACCESS_READ_NOT_ALLOWED             (0x00000002)
#define NVOS8E0_INFO_FLAGS_BUS_ACCESS_WRITE                               31:12
#define NVOS8E0_INFO_FLAGS_BUS_ACCESS_WRITE_UNKNOWN                (0x00000000)
#define NVOS8E0_INFO_FLAGS_BUS_ACCESS_WRITE_ALLOWED                (0x00000001)
#define NVOS8E0_INFO_FLAGS_BUS_ACCESS_WRITE_NOT_ALLOWED            (0x00000002)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS8E0_CONTEXT_DMA_SYSTEM_ALLOC 0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               contextDmaId;	/* context dma id number            0008-000b */
		NvV32               flags;	/* NVOS8E0_FLAGS_*                  000c-000f */
		NvP64               base;	/* mapping pointer                  0010-0017 */
		NvU64               limit;	/* size-1 of mapping                0018-001f */
		NvP64               info;	/* pointer to array of NvOs8e0Info  0020-0027 */
		NvV32               deviceId;	/* device id number                 0028-002b */
	} NvOs8e0Parameters;
#define NVOS8E0_STATUS_SUCCESS                                     (0x00000000)
#define NVOS8E0_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS8E0_STATUS_ERROR_BAD_CONTEXT_DMA_ID                    (0x00000003)
#define NVOS8E0_STATUS_ERROR_BAD_FLAGS_MEMORY_PAGES                (0x00000004)
#define NVOS8E0_STATUS_ERROR_UNSUPPORTED_FLAGS_MEMORY_PAGES        (0x00000005)
#define NVOS8E0_STATUS_ERROR_BAD_BASE                              (0x00000006)
#define NVOS8E0_STATUS_ERROR_BAD_LIMIT                             (0x00000007)
#define NVOS8E0_STATUS_ERROR_PROTECTION_FAULT                      (0x00000008)
#define NVOS8E0_STATUS_ERROR_BAD_INFO                              (0x00000009)
#define NVOS8E0_STATUS_ERROR_BAD_DEVICE_ID                         (0x0000000A)
#define NVOS8E0_FLAGS_MEMORY_PAGES                                          3:0
#define NVOS8E0_FLAGS_MEMORY_PAGES_FIXED_CONTIGUOUS                (0x00000000)
#define NVOS8E0_FLAGS_MEMORY_PAGES_FIXED_NONCONTIGUOUS             (0x00000001)
#define NVOS8E0_FLAGS_MEMORY_PAGES_NONPAGABLE_NONCONTIGUOUS        (0x00000002)
#define NVOS8E0_FLAGS_MEMORY_PAGES_PAGABLE_NONCONTIGUOUS           (0x00000003)
#define NVOS8E0_FLAGS_MAPPING_ACCESS_READ                                   7:4
#define NVOS8E0_FLAGS_MAPPING_ACCESS_READ_UNKNOWN                  (0x00000000)
#define NVOS8E0_FLAGS_MAPPING_ACCESS_READ_ALL_PAGES                (0x00000001)
#define NVOS8E0_FLAGS_MAPPING_ACCESS_READ_SOME_PAGES               (0x00000002)
#define NVOS8E0_FLAGS_MAPPING_ACCESS_READ_NO_PAGES                 (0x00000003)
#define NVOS8E0_FLAGS_MAPPING_ACCESS_WRITE                                 11:8
#define NVOS8E0_FLAGS_MAPPING_ACCESS_WRITE_UNKNOWN                 (0x00000000)
#define NVOS8E0_FLAGS_MAPPING_ACCESS_WRITE_ALL_PAGES               (0x00000001)
#define NVOS8E0_FLAGS_MAPPING_ACCESS_WRITE_SOME_PAGES              (0x00000002)
#define NVOS8E0_FLAGS_MAPPING_ACCESS_WRITE_NO_PAGES                (0x00000003)
#define NVOS8E0_FLAGS_MAPPING_COHERENCY_UNCACHED                          31:12
#define NVOS8E0_FLAGS_MAPPING_COHERENCY_UNCACHED_UNKNOWN           (0x00000000)
#define NVOS8E0_FLAGS_MAPPING_COHERENCY_UNCACHED_ALL_PAGES         (0x00000001)
#define NVOS8E0_FLAGS_MAPPING_COHERENCY_UNCACHED_SOME_PAGES        (0x00000002)
#define NVOS8E0_FLAGS_MAPPING_COHERENCY_UNCACHED_NO_PAGES          (0x00000003)



/* function NVOS8E1_CONTEXT_DMA_SYSTEM_FREE */
#define  NVOS8E1_CONTEXT_DMA_SYSTEM_FREE                           (0x000008E1)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS8E1_CONTEXT_DMA_SYSTEM_FREE  0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               contextDmaId;	/* context dma id number            0008-000b */
	} NvOs8e1Parameters;
#define NVOS8E1_STATUS_SUCCESS                                     (0x00000000)
#define NVOS8E1_STATUS_ERROR_BAD_CONTEXT_DMA_ID                    (0x00000002)


/* function NVOS900_EVENT_ALLOC */
#define  NVOS900_EVENT_ALLOC                                       (0x00000900)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS900_EVENT_ALLOC              0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               eventId;	/* event id number                  0008-000b */
		NvV32               info32;	/* operating system dependent value 000c-000f */
		NvV64               info64;	/* operating system dependent value 0010-0017 */
	} NVOS900Parameters;
#define NVOS900_STATUS_SUCCESS                                     (0x00000000)
#define NVOS900_STATUS_ERROR_INSUFFICIENT_RESOURCES                (0x00000002)
#define NVOS900_STATUS_ERROR_BAD_EVENT_ID                          (0x00000003)
#define NVOS900_STATUS_ERROR_BAD_INFO32                            (0x00000004)
#define NVOS900_STATUS_ERROR_BAD_INFO64                            (0x00000005)


/* function NVOS901_EVENT_FREE */
#define  NVOS901_EVENT_FREE                                        (0x00000901)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS901_EVENT_FREE               0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               eventId;	/* event id number                  0008-000b */
	} NvOs901Parameters;
#define NVOS901_STATUS_SUCCESS                                     (0x00000000)
#define NVOS901_STATUS_ERROR_BAD_EVENT_ID                          (0x00000002)


/* function NVOS902_EVENT_AWAKEN */
#define  NVOS902_EVENT_AWAKEN                                      (0x00000902)
/* NvOsCallback() parameters */
	typedef struct
	{
		NvV32               function;	/* NVOS902_EVENT_AWAKEN             0000-0003 */
		NvV32               status;	/* returned status                  0004-0007 */
		NvV32               eventId;	/* event id number                  0008-000b */
	} NvOs902Parameters;
#define NVOS902_STATUS_SUCCESS                                     (0x00000000)
#define NVOS902_STATUS_ERROR_BAD_EVENT_ID                          (0x00000002)


#ifdef __cplusplus
};
#endif
#endif /* NVOS32_INCLUDED */
