 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



 /***************************************************************************\
|*                                                                           *|
|*                         NV Architecture Interface                         *|
|*                                                                           *|
|*     <nvhw32.h> defines  a 32-bit wide hardware interface  to NVIDIA's     *|
|*     Unified Media Architecture (TM).                                      *|
|*                                                                           *|
 \***************************************************************************/


#ifndef NVHW32_INCLUDED
#define NVHW32_INCLUDED
#ifdef __cplusplus
extern              "C"
{
#endif

#include <nvtypes.h>


 /***************************************************************************\
|*                            NV Hardware Classes                            *|
 \***************************************************************************/

/*
 * These structures indicate the offsets of hardware registers corresponding to
 * the methods of each class.  Since the first 256 bytes of each subchannel is 
 * the NvControlPio registers, the hexadecimal offsets in comments start at 
 * 0x100.
 */


/* class NV01_CLASS */
#define  NV01_CLASS                                                (0x00000000)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_CLASS                       0000-0003 */
		NvV32               status;	/* returns NV0000_ALLOC_STATUS_*    0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0000AllocParameters;
#define NV0000_ALLOC_STATUS_ERROR_BAD_CLASS_NUMBER                 (0x00000001)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CLASS instance              0000-0003 */
		NvV32               status;	/* returns NV0000_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0000FreeParameters;
#define NV0000_FREE_STATUS_ERROR_BAD_OBJECT                        (0x00000001)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CLASS instance              0000-0003 */
		NvV32               status;	/* returns NV0000_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0000ControlParameters;
#define NV0000_CONTROL_STATUS_ERROR_BAD_OBJECT                     (0x00000001)


/* class NV01_ROOT */
#define  NV01_ROOT                                                 (0x00000001)
/* Nv0001Error[] fields and values */
	typedef struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV32               object;	/* returns object handle            0008-000b */
		NvV32               data;	/* returns data                     000c-000f */
		NvV32               address;	/* returns method or offset         0010-0013 */
		NvV32               info[2];	/* info returned depends on error   0014-001b */
		NvV32               status;	/* returns NV0001_ERROR_STATUS_*    001c-001f */
	} Nv0001Error;
/* status values */
#define NV0001_ERROR_STATUS_REFERENCE_OVERFLOW                     (0x00200000)
#define NV0001_ERROR_STATUS_INSUFFICIENT_BANDWIDTH                 (0x00400000)
#define NV0001_ERROR_STATUS_STATE_IN_USE                           (0x00800000)
#define NV0001_ERROR_STATUS_INVALID_STATE                          (0x01000000)
#define NV0001_ERROR_STATUS_BAD_ARGUMENT                           (0x02000000)
#define NV0001_ERROR_STATUS_PROTECTION_FAULT                       (0x04000000)
#define NV0001_ERROR_STATUS_RESERVED_METHOD                        (0x08000000)
#define NV0001_ERROR_STATUS_INFO_1_NOT_VALID                       (0x10000000)
#define NV0001_ERROR_STATUS_INFO_0_NOT_VALID                       (0x20000000)
#define NV0001_ERROR_STATUS_ADDRESS_NOT_VALID                      (0x40000000)
#define NV0001_ERROR_STATUS_DATA_NOT_VALID                         (0x80000000)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_ROOT                        0000-0003 */
		NvV32               status;	/* returns NV0001_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               flags;	/* NV0001_ALLOC_FLAGS_*             000c-000f */
		NvP64               errorBase;	/* pointer to Nv0001Error[0]        0010-0017 */
		NvU64               errorLimit;	/* size-1 of Nv0001Error[0]         0018-001f */
		NvV32               ignored01[0x008];
	} Nv0001AllocParameters;
#define NV0001_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0001_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0001_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0001_ALLOC_STATUS_ERROR_BAD_FLAGS_ENDIAN                 (0x00000004)
#define NV0001_ALLOC_STATUS_ERROR_BAD_ERROR_BASE                   (0x00000005)
#define NV0001_ALLOC_STATUS_ERROR_BAD_ERROR_LIMIT                  (0x00000006)
#define NV0001_ALLOC_STATUS_ERROR_PROTECTION_FAULT                 (0x00000007)
#define NV0001_ALLOC_FLAGS_ENDIAN                                          31:0
#define NV0001_ALLOC_FLAGS_ENDIAN_LITTLE                           (0x00000000)
#define NV0001_ALLOC_FLAGS_ENDIAN_BIG                              (0x00000001)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_ROOT instance               0000-0003 */
		NvV32               status;	/* returns NV0001_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0001FreeParameters;
#define NV0001_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0001_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_ROOT instance               0000-0003 */
		NvV32               status;	/* returns NV0001_CONTROL_STATUS_*  0004-0007 */
		NvV32               flags;	/* NV01_CONTROL_FLAGS_*             0008-000b */
		NvU32               errorsReturned;	/* returns the number of errors     000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0001ControlParameters;
#define NV0001_CONTROL_STATUS_SUCCESS                              (0x00000000)
#define NV0001_CONTROL_STATUS_ERROR_BAD_FLAGS_INTERRUPT            (0x00000002)
#define NV0001_CONTROL_STATUS_ERROR_BAD_FLAGS_ERRORS               (0x00000003)
#define NV0001_CONTROL_FLAGS_INTERRUPT                                      3:0
#define NV0001_CONTROL_FLAGS_INTERRUPT_IGNORE                      (0x00000000)
#define NV0001_CONTROL_FLAGS_INTERRUPT_PROCESS                     (0x00000001)
#define NV0001_CONTROL_FLAGS_ERRORS                                        31:4
#define NV0001_CONTROL_FLAGS_ERRORS_IGNORE                         (0x00000000)
#define NV0001_CONTROL_FLAGS_ERRORS_PE_REPORT                      (0x00000001)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Reserved00[0x7c0];
	} Nv0001Typedef    , Nv01Root;
#define NV0001_TYPEDEF                                                 nv01Root


/* class NV01_CONTEXT_DMA */
#define  NV01_CONTEXT_DMA                                          (0x00000002)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_CONTEXT_DMA                 0000-0003 */
		NvV32               status;	/* returns NV0002_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               objectMemory;	/* see text                         0010-0013 */
		NvV32               flags;	/* NV0002_ALLOC_FLAGS_*             0014-0017 */
		NvU64               offset;	/* offset to the context dma        0018-001f */
		NvU64               limit;	/* size-1 of context dma            0020-0027 */
		NvV32               ignored00[0x008];
	} Nv0002AllocParameters;
#define NV0002_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0002_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0002_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0002_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
#define NV0002_ALLOC_STATUS_ERROR_BAD_OBJECT_MEMORY                (0x00000005)
#define NV0002_ALLOC_STATUS_ERROR_BAD_FLAGS_MEMORY_PAGES           (0x00000006)
#define NV0002_ALLOC_STATUS_ERROR_BAD_FLAGS_MAPPING_ACCESS         (0x00000007)
#define NV0002_ALLOC_STATUS_ERROR_BAD_FLAGS_MAPPING_COHERENCY      (0x00000008)
#define NV0002_ALLOC_STATUS_ERROR_BAD_OFFSET                       (0x00000009)
#define NV0002_ALLOC_STATUS_ERROR_BAD_LIMIT                        (0x0000000A)
#define NV0002_ALLOC_FLAGS_MEMORY_PAGES                                     3:0
#define NV0002_ALLOC_FLAGS_MEMORY_PAGES_FIXED_CONTIGUOUS           (0x00000000)
#define NV0002_ALLOC_FLAGS_MEMORY_PAGES_FIXED_NONCONTIGUOUS        (0x00000001)
#define NV0002_ALLOC_FLAGS_MEMORY_PAGES_NONPAGABLE_NONCONTIGUOUS   (0x00000002)
#define NV0002_ALLOC_FLAGS_MEMORY_PAGES_PAGABLE_NONCONTIGUOUS      (0x00000003)
#define NV0002_ALLOC_FLAGS_MAPPING_ACCESS                                   7:4
#define NV0002_ALLOC_FLAGS_MAPPING_ACCESS_READ_WRITE               (0x00000000)
#define NV0002_ALLOC_FLAGS_MAPPING_ACCESS_READ_ONLY                (0x00000001)
#define NV0002_ALLOC_FLAGS_MAPPING_ACCESS_WRITE_ONLY               (0x00000002)
#define NV0002_ALLOC_FLAGS_MAPPING_COHERENCY                               31:8
#define NV0002_ALLOC_FLAGS_MAPPING_COHERENCY_UNCACHED              (0x00000000)
#define NV0002_ALLOC_FLAGS_MAPPING_COHERENCY_CACHED                (0x00000001)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CONTEXT_DMA instance        0000-0003 */
		NvV32               status;	/* returns NV0002_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0002FreeParameters;
#define NV0002_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0002_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CONTEXT_DMA instance        0000-0003 */
		NvV32               status;	/* returns NV0002_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0002ControlParameters;
#define NV0002_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Reserved00[0x7c0];
	} Nv0002Typedef    , Nv01ContextDma;
#define NV0002_TYPEDEF                                           nv01ContextDma


/* class NV01_DEVICE */
#define  NV01_DEVICE                                               (0x00000003)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_DEVICE                      0000-0003 */
		NvV32               status;	/* returns NV0003_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvU32               portId;	/* port id number                   0010-0013 */
		NvV32               ignored00[0x00b];
	} Nv0003AllocParameters;
#define NV0003_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0003_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0003_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0003_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_DEVICE instance             0000-0003 */
		NvV32               status;	/* returns NV0003_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0003FreeParameters;
#define NV0003_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0003_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_DEVICE instance             0000-0003 */
		NvV32               status;	/* returns NV0003_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0003ControlParameters;
#define NV0003_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Reserved00[0x7c0];
	} Nv0003Typedef    , Nv01Device;
#define NV0003_TYPEDEF                                               nv01Device


/* class NV01_TIMER */
#define  NV01_TIMER                                                (0x00000004)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0004_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0004Notification;
#define NV0004_NOTIFIERS_SYNCHRONIZE                                        (0)
#define NV0004_NOTIFIERS_SET_ALARM_NOTIFY                                   (1)
#define NV0004_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0004_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_TIMER                       0000-0003 */
		NvV32               status;	/* returns NV0004_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               flags;	/* NV0004_ALLOC_FLAGS_*             0010-0013 */
		NvV32               ignored00[0x00b];
	} Nv0004AllocParameters;
#define NV0004_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0004_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0004_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0004_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
#define NV0004_ALLOC_STATUS_ERROR_BAD_FLAGS_ENDIAN                 (0x00000005)
#define NV0004_ALLOC_FLAGS_ENDIAN                                          31:0
#define NV0004_ALLOC_FLAGS_ENDIAN_LITTLE                           (0x00000000)
#define NV0004_ALLOC_FLAGS_ENDIAN_BIG                              (0x00000001)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_TIMER instance              0000-0003 */
		NvV32               status;	/* returns NV0004_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0004FreeParameters;
#define NV0004_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0004_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_TIMER instance              0000-0003 */
		NvV32               status;	/* returns NV0004_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0004ControlParameters;
#define NV0004_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Synchronize;	/* NV0004_SYNCHRONIZE_*             0100-0103 */
		NvV32               StopAlarm;	/* NV0004_STOP_ALARM_*              0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               Reserved01[0x05f];
		NvU32               SetTime0;	/* nanoseconds  since 1970-01-01    0300-0303 */
		NvU32               SetTime1;	/* 4.29 seconds since 1970-01-01    0304-0307 */
		NvV32               SetAlarmNotify;	/* NV0004_SET_ALARM_NTOIFY_*        0308-030b */
		NvV32               Reserved02[0x73d];
	} Nv0004Typedef    , Nv01Timer;
#define NV0004_TYPEDEF                                                nv01Timer
/* method offsets, fields, and values */
#define NV0004_SYNCHRONIZE                                         (0x00000100)
#define NV0004_SYNCHRONIZE_NO_OPERATION                            (0x00000000)
#define NV0004_SYNCHRONIZE_WAIT_FOR_IDLE                           (0x00000001)
#define NV0004_SYNCHRONIZE_WAIT_FOR_IDLE_WRITE_PE_NOTIFY           (0x00000002)
#define NV0004_SYNCHRONIZE_WAIT_FOR_IDLE_WRITE_PE_NOTIFY_AWAKEN    (0x00000003)
#define NV0004_STOP_ALARM                                          (0x00000104)
#define NV0004_STOP_ALARM_IMMEDIATELY                              (0x00000000)
#define NV0004_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0004_SET_TIME                                            (0x00000300)
#define NV0004_SET_TIME_0                                          (0x00000300)
#define NV0004_SET_TIME_1                                          (0x00000304)
#define NV0004_SET_ALARM_NOTIFY                                    (0x00000308)
#define NV0004_SET_ALARM_NOTIFY_WRITE_PE_NOTIFY                    (0x00000000)
#define NV0004_SET_ALARM_NOTIFY_WRITE_PE_NOTIFY_AWAKEN             (0x00000001)

	typedef NvV32       Nv0005Typedef;

	typedef NvV32       Nv0006Typedef;

	typedef NvV32       Nv0007Typedef;

	typedef NvV32       Nv0008Typedef;

	typedef NvV32       Nv0009Typedef;

	typedef NvV32       Nv000aTypedef;

	typedef NvV32       Nv000bTypedef;

	typedef NvV32       Nv000cTypedef;

	typedef NvV32       Nv000dTypedef;

	typedef NvV32       Nv000eTypedef;

	typedef NvV32       Nv000fTypedef;

	typedef NvV32       Nv0010Typedef;

	typedef NvV32       Nv0011Typedef;


/* class NV01_CONTEXT_BETA1 */
#define  NV01_CONTEXT_BETA1                                        (0x00000012)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0012_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0012Notification;
#define NV0012_NOTIFIERS_NOTIFY                                             (0)
#define NV0012_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0012_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_CONTEXT_BETA1               0000-0003 */
		NvV32               status;	/* returns NV0012_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0012AllocParameters;
#define NV0012_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0012_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0012_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0012_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CONTEXT_BETA1 instance      0000-0003 */
		NvV32               status;	/* returns NV0012_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0012FreeParameters;
#define NV0012_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0012_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CONTEXT_BETA1 instance      0000-0003 */
		NvV32               status;	/* returns NV0012_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0012ControlParameters;
#define NV0012_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV0012_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               Reserved01[0x05f];
		NvV32               SetBeta1d31;	/* S1d31 beta value                 0300-0303 */
		NvV32               Reserved02[0x73f];
	} Nv0012Typedef    , Nv01ContextBeta1;
#define NV0012_TYPEDEF                                         nv01ContextBeta1
/* method offsets, fields, and values */
#define NV0012_NO_OPERATION                                        (0x00000100)
#define NV0012_NOTIFY                                              (0x00000104)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV0012_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV0012_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0012_SET_BETA_1D31                                       (0x00000300)

	typedef NvV32       Nv0013Typedef;

	typedef NvV32       Nv0014Typedef;

	typedef NvV32       Nv0015Typedef;

	typedef NvV32       Nv0016Typedef;


/* class NV01_CONTEXT_COLOR_KEY */
#define  NV01_CONTEXT_COLOR_KEY                                    (0x00000017)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0017_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0017Notification;
#define NV0017_NOTIFIERS_NOTIFY                                             (0)
#define NV0017_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0017_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_CONTEXT_COLOR_KEY           0000-0003 */
		NvV32               status;	/* returns NV0017_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0017AllocParameters;
#define NV0017_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0017_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0017_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0017_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CONTEXT_COLOR_KEY instance  0000-0003 */
		NvV32               status;	/* returns NV0017_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0017FreeParameters;
#define NV0017_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0017_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CONTEXT_COLOR_KEY instance  0000-0003 */
		NvV32               status;	/* returns NV0017_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0017ControlParameters;
#define NV0017_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV0017_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               Reserved01[0x05f];
		NvV32               SetColorFormat;	/* NV0017_SET_COLOR_FORMAT_*        0300-0303 */
		NvV32               SetColor;	/* color key value                  0304-0307 */
		NvV32               Reserved02[0x73e];
	} Nv0017Typedef    , Nv01ContextColorKey;
#define NV0017_TYPEDEF                                      nv01ContextColorKey
/* method offsets, fields, and values */
#define NV0017_NO_OPERATION                                        (0x00000100)
#define NV0017_NOTIFY                                              (0x00000104)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV0017_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV0017_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0017_SET_COLOR_FORMAT                                    (0x00000300)
#define NV0017_SET_COLOR_FORMAT_NE32_X16A8Y8                       (0x00000001)
#define NV0017_SET_COLOR_FORMAT_NE32_X16A1R5G5B5                   (0x00000002)
#define NV0017_SET_COLOR_FORMAT_NE32_A8R8G8B8                      (0x00000003)
#define NV0017_SET_COLOR                                           (0x00000304)


/* class NV01_CONTEXT_PATTERN */
#define  NV01_CONTEXT_PATTERN                                      (0x00000018)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0018_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0018Notification;
#define NV0018_NOTIFIERS_NOTIFY                                             (0)
#define NV0018_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0018_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_CONTEXT_PATTERN             0000-0003 */
		NvV32               status;	/* returns NV0018_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0018AllocParameters;
#define NV0018_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0018_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0018_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0018_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CONTEXT_PATTERN instance    0000-0003 */
		NvV32               status;	/* returns NV0018_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0018FreeParameters;
#define NV0018_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0018_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CONTEXT_PATTERN instance    0000-0003 */
		NvV32               status;	/* returns NV0018_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0018ControlParameters;
#define NV0018_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV0018_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               Reserved01[0x05f];
		NvV32               SetColorFormat;	/* NV0018_SET_COLOR_FORMAT_*        0300-0303 */
		NvV32               SetMonochromeFormat;	/* NV0018_SET_MONOCHROME_FORMAT_*   0304-0307 */
		NvV32               SetMonochromeShape;	/* NV0018_SET_MONOCHROME_SHAPE_*    0308-030b */
		NvV32               Reserved02[0x001];
		NvV32               SetMonochromeColor0;	/* color of 0 pixels                0310-0313 */
		NvV32               SetMonochromeColor1;	/* color of 1 pixels                0314-0317 */
		NvV32               SetMonochromePattern0;	/* first  32 bits of pattern data   0318-031b */
		NvV32               SetMonochromePattern1;	/* second 32 bits of pattern data   031c-031f */
		NvV32               Reserved03[0x738];
	} Nv0018Typedef    , Nv01ContextPattern;
#define NV0018_TYPEDEF                                       nv01ContextPattern
/* method offsets, fields, and values */
#define NV0018_NO_OPERATION                                        (0x00000100)
#define NV0018_NOTIFY                                              (0x00000104)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV0018_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV0018_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0018_SET_COLOR_FORMAT                                    (0x00000300)
#define NV0018_SET_COLOR_FORMAT_NE32_X16A8Y8                       (0x00000001)
#define NV0018_SET_COLOR_FORMAT_NE32_X16A1R5G5B5                   (0x00000002)
#define NV0018_SET_COLOR_FORMAT_NE32_A8R8G8B8                      (0x00000003)
#define NV0018_SET_MONOCHROME_FORMAT                               (0x00000304)
#define NV0018_SET_MONOCHROME_FORMAT_LE32_BEI1                     (0x00000001)
#define NV0018_SET_MONOCHROME_FORMAT_LE32_LEI1                     (0x00000002)
#define NV0018_SET_MONOCHROME_SHAPE                                (0x00000308)
#define NV0018_SET_MONOCHROME_SHAPE_8X_8Y                          (0x00000000)
#define NV0018_SET_MONOCHROME_SHAPE_64X_1Y                         (0x00000001)
#define NV0018_SET_MONOCHROME_SHAPE_1X_64Y                         (0x00000002)
#define NV0018_SET_MONOCHORME_COLOR0                               (0x00000310)
#define NV0018_SET_MONOCHORME_COLOR1                               (0x00000314)
#define NV0018_SET_MONOCHORME_PATTERN0                             (0x00000318)
#define NV0018_SET_MONOCHORME_PATTERN1                             (0x0000031C)


/* class NV01_CONTEXT_CLIP_RECTANGLE */
#define  NV01_CONTEXT_CLIP_RECTANGLE                               (0x00000019)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0019_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0019Notification;
#define NV0019_NOTIFIERS_NOTIFY                                             (0)
#define NV0019_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0019_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_CONTEXT_CLIP_RECTANGLE      0000-0003 */
		NvV32               status;	/* returns NV0019_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0019AllocParameters;
#define NV0019_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0019_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0019_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0019_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CONTEXT_CLIP_RECTANGLE inst 0000-0003 */
		NvV32               status;	/* returns NV0019_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0019FreeParameters;
#define NV0019_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0019_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_CONTEXT_CLIP_RECTANGLE inst 0000-0003 */
		NvV32               status;	/* returns NV0019_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0019ControlParameters;
#define NV0019_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV0019_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               Reserved01[0x05f];
		NvV32               SetPoint;	/* y_x S16_S16                      0300-0303 */
		NvV32               SetSize;	/* height_width U16_U16             0304-0307 */
		NvV32               Reserved02[0x73e];
	} Nv0019Typedef    , Nv01ContextClipRectangle;
#define NV0019_TYPEDEF                                 nv01ContextClipRectangle
/* method offsets, fields, and values */
#define NV0019_NO_OPERATION                                        (0x00000100)
#define NV0019_NOTIFY                                              (0x00000104)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV0019_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV0019_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0019_SET_POINT                                           (0x00000300)
#define NV0019_SET_POINT_X                                                 15:0
#define NV0019_SET_POINT_Y                                                31:16
#define NV0019_SET_SIZE                                            (0x00000304)
#define NV0019_SET_SIZE_WIDTH                                              15:0
#define NV0019_SET_SIZE_HEIGHT                                            31:16

	typedef NvV32       Nv001aTypedef;

	typedef NvV32       Nv001bTypedef;


/* class NV01_RENDER_SOLID_LIN */
#define  NV01_RENDER_SOLID_LIN                                     (0x0000001C)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV001C_NOTIFICATION_STATUS_*     000f-000f */
	} Nv001cNotification;
#define NV001C_NOTIFIERS_NOTIFY                                             (0)
#define NV001C_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV001C_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_RENDER_SOLID_LIN            0000-0003 */
		NvV32               status;	/* returns NV001C_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv001cAllocParameters;
#define NV001C_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV001C_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV001C_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV001C_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_RENDER_SOLID_LIN instance   0000-0003 */
		NvV32               status;	/* returns NV001C_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv001cFreeParameters;
#define NV001C_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV001C_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_RENDER_SOLID_LIN instance   0000-0003 */
		NvV32               status;	/* returns NV001C_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv001cControlParameters;
#define NV001C_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV001C_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextClipRectangle;	/* NV01_CONTEXT_CLIP_RECTANGLE      0184-0187 */
		NvV32               SetContextPattern;	/* NV01_CONTEXT_PATTERN             0188-018b */
		NvV32               SetContextRop;	/* NV03_CONTEXT_ROP                 018c-018f */
		NvV32               SetContextBeta1;	/* NV01_CONTEXT_BETA1               0190-0193 */
		NvV32               SetContextSurface;	/* NV03_CONTEXT_SURFACES_2D         0194-0197 */
		NvV32               Reserved01[0x059];
		NvV32               SetOperation;	/* NV001C_SET_OPERATION_*           02fc-02ff */
		NvV32               SetColorFormat;	/* NV001C_SET_COLOR_FORMAT_*        0300-0303 */
		NvV32               Color;	/* source color                     0304-0307 */
		NvV32               Reserved02[0x03e];
		struct
		{		/* start aliased methods in array   0400-    */
			NvV32               point0;	/* y_x S16_S16 in pixels               0-   3 */
			NvV32               point1;	/* y_x S16_S16 in pixels               4-   7 */
		} Lin[16];	/* end of aliased methods in array      -047f */
		struct
		{		/* start aliased methods in array   0480-    */
			NvS32               point0X;	/* in pixels, 0 at left                0-   3 */
			NvS32               point0Y;	/* in pixels, 0 at top                 4-   7 */
			NvS32               point1X;	/* in pixels, 0 at left                8-   b */
			NvS32               point1Y;	/* in pixels, 0 at top                 c-   f */
		} Lin32[8];	/* end of aliased methods in array      -04ff */
		NvV32               PolyLin[32];	/* y_x S16_S16 in pixels            0500-057f */
		struct
		{		/* start aliased methods in array   0580-    */
			NvS32               x;	/* in pixels, 0 at left                0-   3 */
			NvS32               y;	/* in pixels, 0 at top                 4-   7 */
		} PolyLin32[16];	/* end of aliased methods in array      -05ff */
		struct
		{		/* start aliased methods in array   0600-    */
			NvV32               color;	/* source color                        0-   3 */
			NvV32               point;	/* y_x S16_S16 in pixels               4-   7 */
		} ColorPolyLin[16];	/* end of aliased methods in array      -067f */
		NvV32               Reserved03[0x660];
	} Nv001cTypedef    , Nv01RenderSolidLin;
#define NV001C_TYPEDEF                                       nv01RenderSolidLin
/* method offsets, fields, and values */
#define NV001C_NO_OPERATION                                        (0x00000100)
#define NV001C_NOTIFY                                              (0x00000104)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV001C_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV001C_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV001C_SET_CONTEXT_CLIP_RECTANGLE                          (0x00000184)
#define NV001C_SET_CONTEXT_PATTERN                                 (0x00000188)
#define NV001C_SET_CONTEXT_ROP                                     (0x0000018C)
#define NV001C_SET_CONTEXT_BETA1                                   (0x00000190)
#define NV001C_SET_CONTEXT_SURFACE                                 (0x00000194)
#define NV001C_SET_OPERATION                                       (0x000002FC)
#define NV001C_SET_OPERATION_SRCCOPY_AND                           (0x00000000)
#define NV001C_SET_OPERATION_ROP_AND                               (0x00000001)
#define NV001C_SET_OPERATION_BLEND_AND                             (0x00000002)
#define NV001C_SET_COLOR_FORMAT                                    (0x00000300)
#define NV001C_SET_COLOR_FORMAT_NE32_X24Y8                         (0x00000001)
#define NV001C_SET_COLOR_FORMAT_NE32_X17R5G5B5                     (0x00000002)
#define NV001C_SET_COLOR_FORMAT_NE32_X8R8G8B8                      (0x00000003)
#define NV001C_SET_COLOR_FORMAT_NE32_X16Y16                        (0x00000004)
#define NV001C_COLOR                                               (0x00000304)
#define NV001C_LIN(a)                                              (0x00000400\
                                                                   +(a)*0x0008)
#define NV001C_LIN_POINT0(a)                                       (0x00000400\
                                                                   +(a)*0x0008)
#define NV001C_LIN_POINT0_X                                                15:0
#define NV001C_LIN_POINT0_Y                                               31:16
#define NV001C_LIN_POINT1(a)                                       (0x00000404\
                                                                   +(a)*0x0008)
#define NV001C_LIN_POINT1_X                                                15:0
#define NV001C_LIN_POINT1_Y                                               31:16
#define NV001C_LIN32(a)                                            (0x00000480\
                                                                   +(a)*0x0010)
#define NV001C_LIN32_POINT0_X(a)                                   (0x00000480\
                                                                   +(a)*0x0010)
#define NV001C_LIN32_POINT0_Y(a)                                   (0x00000484\
                                                                   +(a)*0x0010)
#define NV001C_LIN32_POINT1_X(a)                                   (0x00000488\
                                                                   +(a)*0x0010)
#define NV001C_LIN32_POINT1_Y(a)                                   (0x0000048C\
                                                                   +(a)*0x0010)
#define NV001C_POLY_LIN(a)                                         (0x00000500\
                                                                   +(a)*0x0004)
#define NV001C_POLY_LIN_X                                                  15:0
#define NV001C_POLY_LIN_Y                                                 31:16
#define NV001C_POLY_LIN32(a)                                       (0x00000580\
                                                                   +(a)*0x0008)
#define NV001C_POLY_LIN32_X(a)                                     (0x00000580\
                                                                   +(a)*0x0008)
#define NV001C_POLY_LIN32_Y(a)                                     (0x00000584\
                                                                   +(a)*0x0008)
#define NV001C_COLOR_POLY_LIN(a)                                   (0x00000600\
                                                                   +(a)*0x0008)
#define NV001C_COLOR_POLY_LIN_COLOR(a)                             (0x00000600\
                                                                   +(a)*0x0008)
#define NV001C_COLOR_POLY_LIN_POINT(a)                             (0x00000604\
                                                                   +(a)*0x0008)
#define NV001C_COLOR_POLY_LIN_POINT_X                                      15:0
#define NV001C_COLOR_POLY_LIN_POINT_Y                                     31:16


/* class NV01_RENDER_SOLID_TRIANGLE */
#define  NV01_RENDER_SOLID_TRIANGLE                                (0x0000001D)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV001D_NOTIFICATION_STATUS_*     000f-000f */
	} Nv001dNotification;
#define NV001D_NOTIFIERS_NOTIFY                                             (0)
#define NV001D_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV001D_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_RENDER_SOLID_TRIANGLE       0000-0003 */
		NvV32               status;	/* returns NV001D_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv001dAllocParameters;
#define NV001D_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV001D_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV001D_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV001D_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_RENDER_SOLID_TRIANGLE insta 0000-0003 */
		NvV32               status;	/* returns NV001D_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv001dFreeParameters;
#define NV001D_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV001D_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_RENDER_SOLID_TRIANGLE insta 0000-0003 */
		NvV32               status;	/* returns NV001D_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv001dControlParameters;
#define NV001D_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV001D_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextClipRectangle;	/* NV01_CONTEXT_CLIP_RECTANGLE      0184-0187 */
		NvV32               SetContextPattern;	/* NV01_CONTEXT_PATTERN             0188-018b */
		NvV32               SetContextRop;	/* NV03_CONTEXT_ROP                 018c-018f */
		NvV32               SetContextBeta1;	/* NV01_CONTEXT_BETA1               0190-0193 */
		NvV32               SetContextSurface;	/* NV03_CONTEXT_SURFACES_2D         0194-0197 */
		NvV32               Reserved01[0x059];
		NvV32               SetOperation;	/* NV001D_SET_OPERATION_*           02fc-02ff */
		NvV32               SetColorFormat;	/* NV001D_SET_COLOR_FORMAT_*        0300-0303 */
		NvV32               Color;	/* source color                     0304-0307 */
		NvV32               Reserved02[0x002];
		NvV32               TrianglePoint0;	/* y_x S16_S16 in pixels            0310-0313 */
		NvV32               TrianglePoint1;	/* y_x S16_S16 in pixels            0314-0317 */
		NvV32               TrianglePoint2;	/* y_x S16_S16 in pixels            0318-031b */
		NvV32               Reserved03[0x001];
		NvS32               Triangle32Point0X;	/* in pixels, 0 at left             0320-0323 */
		NvS32               Triangle32Point0Y;	/* in pixels, 0 at top              0324-0327 */
		NvS32               Triangle32Point1X;	/* in pixels, 0 at left             0328-032b */
		NvS32               Triangle32Point1Y;	/* in pixels, 0 at top              032c-032f */
		NvS32               Triangle32Point2X;	/* in pixels, 0 at left             0330-0333 */
		NvS32               Triangle32Point2Y;	/* in pixels, 0 at top              0334-0337 */
		NvV32               Reserved04[0x032];
		NvV32               Trimesh[32];	/* y_x S16_S16 in pixels            0400-047f */
		struct
		{		/* start aliased methods in array   0480-    */
			NvS32               x;	/* in pixels, 0 at left                0-   3 */
			NvS32               y;	/* in pixels, 0 at top                 4-   7 */
		} Trimesh32[16];	/* end of aliased methods in array      -04ff */
		struct
		{		/* start aliased methods in array   0500-    */
			NvV32               color;	/* source color                        0-   3 */
			NvV32               point0;	/* y_x S16_S16 in pixels               4-   7 */
			NvV32               point1;	/* y_x S16_S16 in pixels               8-   b */
			NvV32               point2;	/* y_x S16_S16 in pixels               c-   f */
		} ColorTriangle[8];	/* end of aliased methods in array      -057f */
		struct
		{		/* start aliased methods in array   0580-    */
			NvV32               color;	/* source color                        0-   3 */
			NvV32               point;	/* y_x S16_S16 in pixels               4-   7 */
		} ColorTrimesh[16];	/* end of aliased methods in array      -05ff */
		NvV32               Reserved05[0x680];
	} Nv001dTypedef    , Nv01RenderSolidTriangle;
#define NV001D_TYPEDEF                                  nv01RenderSolidTriangle
/* method offsets, fields, and values */
#define NV001D_NO_OPERATION                                        (0x00000100)
#define NV001D_NOTIFY                                              (0x00000104)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV001D_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV001D_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV001D_SET_CONTEXT_CLIP_RECTANGLE                          (0x00000184)
#define NV001D_SET_CONTEXT_PATTERN                                 (0x00000188)
#define NV001D_SET_CONTEXT_ROP                                     (0x0000018C)
#define NV001D_SET_CONTEXT_BETA1                                   (0x00000190)
#define NV001D_SET_CONTEXT_SURFACE                                 (0x00000194)
#define NV001D_SET_OPERATION                                       (0x000002FC)
#define NV001D_SET_OPERATION_SRCCOPY_AND                           (0x00000000)
#define NV001D_SET_OPERATION_ROP_AND                               (0x00000001)
#define NV001D_SET_OPERATION_BLEND_AND                             (0x00000002)
#define NV001D_SET_COLOR_FORMAT                                    (0x00000300)
#define NV001D_SET_COLOR_FORMAT_NE32_X24Y8                         (0x00000001)
#define NV001D_SET_COLOR_FORMAT_NE32_X17R5G5B5                     (0x00000002)
#define NV001D_SET_COLOR_FORMAT_NE32_X8R8G8B8                      (0x00000003)
#define NV001D_SET_COLOR_FORMAT_NE32_X16Y16                        (0x00000004)
#define NV001D_COLOR                                               (0x00000304)
#define NV001D_TRIANGLE_POINT0                                     (0x00000310)
#define NV001D_TRIANGLE_POINT0_X                                           15:0
#define NV001D_TRIANGLE_POINT0_Y                                          31:16
#define NV001D_TRIANGLE_POINT1                                     (0x00000314)
#define NV001D_TRIANGLE_POINT1_X                                           15:0
#define NV001D_TRIANGLE_POINT1_Y                                          31:16
#define NV001D_TRIANGLE_POINT2                                     (0x00000318)
#define NV001D_TRIANGLE_POINT2_X                                           15:0
#define NV001D_TRIANGLE_POINT2_Y                                          31:16
#define NV001D_TRIANGLE32_POINT0_X                                 (0x00000320)
#define NV001D_TRIANGLE32_POINT0_Y                                 (0x00000324)
#define NV001D_TRIANGLE32_POINT1_X                                 (0x00000328)
#define NV001D_TRIANGLE32_POINT1_Y                                 (0x0000032C)
#define NV001D_TRIANGLE32_POINT2_X                                 (0x00000330)
#define NV001D_TRIANGLE32_POINT2_Y                                 (0x00000334)
#define NV001D_TRIMESH(a)                                          (0x00000400\
                                                                   +(a)*0x0004)
#define NV001D_TRIMESH_X                                                   15:0
#define NV001D_TRIMESH_Y                                                  31:16
#define NV001D_TRIMESH32(a)                                        (0x00000480\
                                                                   +(a)*0x0008)
#define NV001D_TRIMESH32_X(a)                                      (0x00000480\
                                                                   +(a)*0x0008)
#define NV001D_TRIMESH32_Y(a)                                      (0x00000484\
                                                                   +(a)*0x0008)
#define NV001D_COLOR_TRIANGLE(a)                                   (0x00000500\
                                                                   +(a)*0x0010)
#define NV001D_COLOR_TRIANGLE_COLOR(a)                             (0x00000500\
                                                                   +(a)*0x0010)
#define NV001D_COLOR_TRIANGLE_POINT0(a)                            (0x00000504\
                                                                   +(a)*0x0010)
#define NV001D_COLOR_TRIANGLE_POINT0_X                                     15:0
#define NV001D_COLOR_TRIANGLE_POINT0_Y                                    31:16
#define NV001D_COLOR_TRIANGLE_POINT1(a)                            (0x00000508\
                                                                   +(a)*0x0010)
#define NV001D_COLOR_TRIANGLE_POINT1_X                                     15:0
#define NV001D_COLOR_TRIANGLE_POINT1_Y                                    31:16
#define NV001D_COLOR_TRIANGLE_POINT2(a)                            (0x0000050C\
                                                                   +(a)*0x0010)
#define NV001D_COLOR_TRIANGLE_POINT2_X                                     15:0
#define NV001D_COLOR_TRIANGLE_POINT2_Y                                    31:16
#define NV001D_COLOR_TRIMESH(a)                                    (0x00000580\
                                                                   +(a)*0x0008)
#define NV001D_COLOR_TRIMESH_COLOR(a)                              (0x00000580\
                                                                   +(a)*0x0008)
#define NV001D_COLOR_TRIMESH_POINT(a)                              (0x00000584\
                                                                   +(a)*0x0008)
#define NV001D_COLOR_TRIMESH_POINT_X                                       15:0
#define NV001D_COLOR_TRIMESH_POINT_Y                                      31:16


/* class NV01_RENDER_SOLID_RECTANGLE */
#define  NV01_RENDER_SOLID_RECTANGLE                               (0x0000001E)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV001E_NOTIFICATION_STATUS_*     000f-000f */
	} Nv001eNotification;
#define NV001E_NOTIFIERS_NOTIFY                                             (0)
#define NV001E_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV001E_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_RENDER_SOLID_RECTANGLE      0000-0003 */
		NvV32               status;	/* returns NV001E_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv001eAllocParameters;
#define NV001E_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV001E_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV001E_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV001E_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_RENDER_SOLID_RECTANGLE inst 0000-0003 */
		NvV32               status;	/* returns NV001E_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv001eFreeParameters;
#define NV001E_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV001E_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_RENDER_SOLID_RECTANGLE inst 0000-0003 */
		NvV32               status;	/* returns NV001E_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv001eControlParameters;
#define NV001E_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV001E_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextClipRectangle;	/* NV01_CONTEXT_CLIP_RECTANGLE      0184-0187 */
		NvV32               SetContextPattern;	/* NV01_CONTEXT_PATTERN             0188-018b */
		NvV32               SetContextRop;	/* NV03_CONTEXT_ROP                 018c-018f */
		NvV32               SetContextBeta1;	/* NV01_CONTEXT_BETA1               0190-0193 */
		NvV32               SetContextSurface;	/* NV03_CONTEXT_SURFACES_2D         0194-0197 */
		NvV32               Reserved01[0x059];
		NvV32               SetOperation;	/* NV001E_SET_OPERATION_*           02fc-02ff */
		NvV32               SetColorFormat;	/* NV001E_SET_COLOR_FORMAT_*        0300-0303 */
		NvV32               Color;	/* source color                     0304-0307 */
		NvV32               Reserved02[0x03e];
		struct
		{		/* start aliased methods in array   0400-    */
			NvV32               point;	/* y_x S16_S16                         0-   3 */
			NvV32               size;	/* height_width U16_U16                4-   7 */
		} Rectangle[16];	/* end of method in array in array      -047f */
		NvV32               Reserved03[0x6e0];
	} Nv001eTypedef    , Nv01RenderSolidRectangle;
#define NV001E_TYPEDEF                                 nv01RenderSolidRectangle
/* method offsets, fields, and values */
#define NV001E_NO_OPERATION                                        (0x00000100)
#define NV001E_NOTIFY                                              (0x00000104)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV001E_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV001E_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV001E_SET_CONTEXT_CLIP_RECTANGLE                          (0x00000184)
#define NV001E_SET_CONTEXT_PATTERN                                 (0x00000188)
#define NV001E_SET_CONTEXT_ROP                                     (0x0000018C)
#define NV001E_SET_CONTEXT_BETA1                                   (0x00000190)
#define NV001E_SET_CONTEXT_SURFACE                                 (0x00000194)
#define NV001E_SET_OPERATION                                       (0x000002FC)
#define NV001E_SET_OPERATION_SRCCOPY_AND                           (0x00000000)
#define NV001E_SET_OPERATION_ROP_AND                               (0x00000001)
#define NV001E_SET_OPERATION_BLEND_AND                             (0x00000002)
#define NV001E_SET_COLOR_FORMAT                                    (0x00000300)
#define NV001E_SET_COLOR_FORMAT_NE32_X24Y8                         (0x00000001)
#define NV001E_SET_COLOR_FORMAT_NE32_X17R5G5B5                     (0x00000002)
#define NV001E_SET_COLOR_FORMAT_NE32_X8R8G8B8                      (0x00000003)
#define NV001E_SET_COLOR_FORMAT_NE32_X16Y16                        (0x00000004)
#define NV001E_COLOR                                               (0x00000304)
#define NV001E_RECTANGLE(a)                                        (0x00000400\
                                                                   +(a)*0x0008)
#define NV001E_RECTANGLE_POINT(a)                                  (0x00000400\
                                                                   +(a)*0x0008)
#define NV001E_RECTANGLE_POINT_X                                           15:0
#define NV001E_RECTANGLE_POINT_Y                                          31:16
#define NV001E_RECTANGLE_SIZE(a)                                   (0x00000404\
                                                                   +(a)*0x0008)
#define NV001E_RECTANGLE_SIZE_WIDTH                                        15:0
#define NV001E_RECTANGLE_SIZE_HEIGHT                                      31:16


/* class NV01_IMAGE_BLIT */
#define  NV01_IMAGE_BLIT                                           (0x0000001F)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV001F_NOTIFICATION_STATUS_*     000f-000f */
	} Nv001fNotification;
#define NV001F_NOTIFIERS_NOTIFY                                             (0)
#define NV001F_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV001F_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_IMAGE_BLIT                  0000-0003 */
		NvV32               status;	/* returns NV001F_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv001fAllocParameters;
#define NV001F_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV001F_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV001F_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV001F_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_IMAGE_BLIT instance         0000-0003 */
		NvV32               status;	/* returns NV001F_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv001fFreeParameters;
#define NV001F_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV001F_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_IMAGE_BLIT instance         0000-0003 */
		NvV32               status;	/* returns NV001F_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv001fControlParameters;
#define NV001F_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV001F_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextColorKey;	/* NV01_CONTEXT_COLOR_KEY           0184-0187 */
		NvV32               SetContextClipRectangle;	/* NV01_CONTEXT_CLIP_RECTANGLE      0188-018b */
		NvV32               SetContextPattern;	/* NV01_CONTEXT_PATTERN             018c-018f */
		NvV32               SetContextRop;	/* NV03_CONTEXT_ROP                 0190-0193 */
		NvV32               SetContextBeta1;	/* NV01_CONTEXT_BETA1               0194-0197 */
		NvV32               Reserved01[0x001];
		NvV32               SetContextSurfaces;	/* NV03_CONTEXT_SURFACES_2D         019c-019f */
		NvV32               Reserved02[0x057];
		NvV32               SetOperation;	/* NV001F_SET_OPERATION_*           02fc-02ff */
		NvV32               ControlPointIn;	/* y_x U16_U16, pixels              0300-0303 */
		NvV32               ControlPointOut;	/* y_x S16_S16, pixels              0304-0307 */
		NvV32               Size;	/* height_width U16_U16 in pixels   0308-030b */
		NvV32               Reserved03[0x73d];
	} Nv001fTypedef    , Nv01ImageBlit;
#define NV001F_TYPEDEF                                            nv01ImageBlit
/* method offsets, fields, and values */
#define NV001F_NO_OPERATION                                        (0x00000100)
#define NV001F_NOTIFY                                              (0x00000104)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV001F_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV001F_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV001F_SET_CONTEXT_COLOR_KEY                               (0x00000184)
#define NV001F_SET_CONTEXT_CLIP_RECTANGLE                          (0x00000188)
#define NV001F_SET_CONTEXT_PATTERN                                 (0x0000018C)
#define NV001F_SET_CONTEXT_ROP                                     (0x00000190)
#define NV001F_SET_CONTEXT_BETA1                                   (0x00000194)
#define NV001F_SET_CONTEXT_SURFACES                                (0x0000019C)
#define NV001F_SET_OPERATION                                       (0x000002FC)
#define NV001F_SET_OPERATION_SRCCOPY_AND                           (0x00000000)
#define NV001F_SET_OPERATION_ROP_AND                               (0x00000001)
#define NV001F_SET_OPERATION_BLEND_AND                             (0x00000002)
#define NV001F_CONTROL_POINT_IN                                    (0x00000300)
#define NV001F_CONTROL_POINT_IN_X                                          15:0
#define NV001F_CONTROL_POINT_IN_Y                                         31:16
#define NV001F_CONTROL_POINT_OUT                                   (0x00000304)
#define NV001F_CONTROL_POINT_OUT_X                                         15:0
#define NV001F_CONTROL_POINT_OUT_Y                                        31:16
#define NV001F_SIZE                                                (0x00000308)
#define NV001F_SIZE_WIDTH                                                  15:0
#define NV001F_SIZE_HEIGHT                                                31:16

	typedef NvV32       Nv0020Typedef;


/* class NV01_IMAGE_FROM_CPU */
#define  NV01_IMAGE_FROM_CPU                                       (0x00000021)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0021_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0021Notification;
#define NV0021_NOTIFIERS_NOTIFY                                             (0)
#define NV0021_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0021_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_IMAGE_FROM_CPU              0000-0003 */
		NvV32               status;	/* returns NV0021_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0021AllocParameters;
#define NV0021_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0021_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0021_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0021_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_IMAGE_FROM_CPU instance     0000-0003 */
		NvV32               status;	/* returns NV0021_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0021FreeParameters;
#define NV0021_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0021_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_IMAGE_FROM_CPU instance     0000-0003 */
		NvV32               status;	/* returns NV0021_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0021ControlParameters;
#define NV0021_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV0021_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextColorKey;	/* NV01_CONTEXT_COLOR_KEY           0184-0187 */
		NvV32               SetContextClipRectangle;	/* NV01_CONTEXT_CLIP_RECTANGLE      0188-018b */
		NvV32               SetContextPattern;	/* NV01_CONTEXT_PATTERN             018c-018f */
		NvV32               SetContextRop;	/* NV03_CONTEXT_ROP                 0190-0193 */
		NvV32               SetContextBeta1;	/* NV01_CONTEXT_BETA1               0194-0197 */
		NvV32               SetContextSurface;	/* NV03_CONTEXT_SURFACES_2D         0198-019b */
		NvV32               Reserved01[0x058];
		NvV32               SetOperation;	/* NV0021_SET_OPERATION_*           02fc-02ff */
		NvV32               SetColorFormat;	/* NV0021_SET_COLOR_FORMAT_*        0300-0303 */
		NvV32               Point;	/* y_x S16_S16 in pixels            0304-0307 */
		NvV32               SizeOut;	/* height_width U16_U16, in pixels  0308-030b */
		NvV32               SizeIn;	/* height_width U16_U16, in pixels  030c-030f */
		NvV32               Reserved02[0x03c];
		NvV32               Color[32];	/* packed pixel(s) to add to image  0400-047f */
		NvV32               Reserved03[0x6e0];
	} Nv0021Typedef    , Nv01ImageFromCpu;
#define NV0021_TYPEDEF                                         nv01ImageFromCpu
/* method offsets, fields, and values */
#define NV0021_NO_OPERATION                                        (0x00000100)
#define NV0021_NOTIFY                                              (0x00000104)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV0021_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV0021_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0021_SET_CONTEXT_COLOR_KEY                               (0x00000184)
#define NV0021_SET_CONTEXT_CLIP_RECTANGLE                          (0x00000188)
#define NV0021_SET_CONTEXT_PATTERN                                 (0x0000018C)
#define NV0021_SET_CONTEXT_ROP                                     (0x00000190)
#define NV0021_SET_CONTEXT_BETA1                                   (0x00000194)
#define NV0021_SET_CONTEXT_SURFACE                                 (0x00000198)
#define NV0021_SET_OPERATION                                       (0x000002FC)
#define NV0021_SET_OPERATION_SRCCOPY_AND                           (0x00000000)
#define NV0021_SET_OPERATION_ROP_AND                               (0x00000001)
#define NV0021_SET_OPERATION_BLEND_AND                             (0x00000002)
#define NV0021_SET_COLOR_FORMAT                                    (0x00000300)
#define NV0021_SET_COLOR_FORMAT_LE32_Y8                            (0x00000001)
#define NV0021_SET_COLOR_FORMAT_LE32_A1R5G5B5                      (0x00000002)
#define NV0021_SET_COLOR_FORMAT_LE32_X1R5G5B5                      (0x00000003)
#define NV0021_SET_COLOR_FORMAT_NE32_A8R8G8B8                      (0x00000004)
#define NV0021_SET_COLOR_FORMAT_NE32_X8R8G8B8                      (0x00000005)
#define NV0021_POINT                                               (0x00000304)
#define NV0021_POINT_X                                                     15:0
#define NV0021_POINT_Y                                                    31:16
#define NV0021_SIZE_OUT                                            (0x00000308)
#define NV0021_SIZE_OUT_WIDTH                                              15:0
#define NV0021_SIZE_OUT_HEIGHT                                            31:16
#define NV0021_SIZE_IN                                             (0x0000030C)
#define NV0021_SIZE_IN_WIDTH                                               15:0
#define NV0021_SIZE_IN_HEIGHT                                             31:16
#define NV0021_COLOR(a)                                            (0x00000400\
                                                                   +(a)*0x0004)

	typedef NvV32       Nv0022Typedef;

	typedef NvV32       Nv0023Typedef;

	typedef NvV32       Nv0024Typedef;

	typedef NvV32       Nv0025Typedef;

	typedef NvV32       Nv0026Typedef;

	typedef NvV32       Nv0027Typedef;

	typedef NvV32       Nv0028Typedef;

	typedef NvV32       Nv0029Typedef;

	typedef NvV32       Nv002aTypedef;

	typedef NvV32       Nv002bTypedef;

	typedef NvV32       Nv002cTypedef;

	typedef NvV32       Nv002dTypedef;

	typedef NvV32       Nv002eTypedef;

	typedef NvV32       Nv002fTypedef;


/* class NV01_NULL */
#define  NV01_NULL                                                 (0x00000030)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_NULL                        0000-0003 */
		NvV32               status;	/* returns NV0030_ALLOC_STATUS_*    0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0030AllocParameters;
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_NULL instance               0000-0003 */
		NvV32               status;	/* returns NV0030_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0030FreeParameters;
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_NULL instance               0000-0003 */
		NvV32               status;	/* returns NV0030_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0030ControlParameters;
#define NV0030_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Reserved00[0x7c0];
	} Nv0030Typedef    , Nv01Null;
#define NV0030_TYPEDEF                                                 nv01Null

	typedef NvV32       Nv0031Typedef;

	typedef NvV32       Nv0032Typedef;

	typedef NvV32       Nv0033Typedef;

	typedef NvV32       Nv0034Typedef;

	typedef NvV32       Nv0035Typedef;


/* class NV03_STRETCHED_IMAGE_FROM_CPU */
#define  NV03_STRETCHED_IMAGE_FROM_CPU                             (0x00000036)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0036_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0036Notification;
#define NV0036_NOTIFIERS_NOTIFY                                             (0)
#define NV0036_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0036_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV03_STRETCHED_IMAGE_FROM_CPU    0000-0003 */
		NvV32               status;	/* returns NV0036_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0036AllocParameters;
#define NV0036_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0036_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0036_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0036_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_STRETCHED_IMAGE_FROM_CPU in 0000-0003 */
		NvV32               status;	/* returns NV0036_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0036FreeParameters;
#define NV0036_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0036_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_STRETCHED_IMAGE_FROM_CPU in 0000-0003 */
		NvV32               status;	/* returns NV0036_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0036ControlParameters;
#define NV0036_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV0036_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextColorKey;	/* NV01_CONTEXT_COLOR_KEY           0184-0187 */
		NvV32               SetContextPattern;	/* NV01_CONTEXT_PATTERN             0188-018b */
		NvV32               SetContextRop;	/* NV03_CONTEXT_ROP                 018c-018f */
		NvV32               SetContextBeta1;	/* NV01_CONTEXT_BETA1               0190-0193 */
		NvV32               SetContextSurface;	/* NV03_CONTEXT_SURFACES_2D         0194-0197 */
		NvV32               Reserved01[0x059];
		NvV32               SetOperation;	/* NV0036_SET_OPERATION_*           02fc-02ff */
		NvV32               SetColorFormat;	/* NV0036_SET_COLOR_FORMAT_*        0300-0303 */
		NvV32               SizeIn;	/* height_width U16_U16 in texels   0304-0307 */
		NvV32               DxDu;	/* S12d20 dx/du                     0308-030b */
		NvV32               DyDv;	/* S12d20 dy/dv                     030c-030f */
		NvV32               ClipPoint;	/* y_x S16_S16                      0310-0313 */
		NvV32               ClipSize;	/* height_width U16_U16             0314-0317 */
		NvV32               Point12d4;	/* y_x S12d4_S12d4 in pixels        0318-031b */
		NvV32               Reserved02[0x039];
		NvV32               Color[1792];	/* source colors (packed texels)    0400-1fff */
	} Nv0036Typedef    , Nv03StretchedImageFromCpu;
#define NV0036_TYPEDEF                                nv03StretchedImageFromCpu
/* method offsets, fields, and values */
#define NV0036_NO_OPERATION                                        (0x00000100)
#define NV0036_NOTIFY                                              (0x00000104)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV0036_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV0036_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0036_SET_CONTEXT_COLOR_KEY                               (0x00000184)
#define NV0036_SET_CONTEXT_PATTERN                                 (0x00000188)
#define NV0036_SET_CONTEXT_ROP                                     (0x0000018C)
#define NV0036_SET_CONTEXT_BETA1                                   (0x00000190)
#define NV0036_SET_CONTEXT_SURFACE                                 (0x00000194)
#define NV0036_SET_OPERATION                                       (0x000002FC)
#define NV0036_SET_OPERATION_SRCCOPY_AND                           (0x00000000)
#define NV0036_SET_OPERATION_ROP_AND                               (0x00000001)
#define NV0036_SET_OPERATION_BLEND_AND                             (0x00000002)
#define NV0036_SET_COLOR_FORMAT                                    (0x00000300)
#define NV0036_SET_COLOR_FORMAT_LE32_Y8                            (0x00000001)
#define NV0036_SET_COLOR_FORMAT_LE32_A1R5G5B5                      (0x00000002)
#define NV0036_SET_COLOR_FORMAT_LE32_X1R5G5B5                      (0x00000003)
#define NV0036_SET_COLOR_FORMAT_NE32_A8R8G8B8                      (0x00000004)
#define NV0036_SET_COLOR_FORMAT_NE32_X8R8G8B8                      (0x00000005)
#define NV0036_SIZE_IN                                             (0x00000304)
#define NV0036_SIZE_IN_WIDTH                                               15:0
#define NV0036_SIZE_IN_HEIGHT                                             31:16
#define NV0036_DX_DU                                               (0x00000308)
#define NV0036_DY_DV                                               (0x0000030C)
#define NV0036_CLIP_POINT                                          (0x00000310)
#define NV0036_CLIP_POINT_X                                                15:0
#define NV0036_CLIP_POINT_Y                                               31:16
#define NV0036_CLIP_SIZE                                           (0x00000314)
#define NV0036_CLIP_SIZE_WIDTH                                             15:0
#define NV0036_CLIP_SIZE_HEIGHT                                           31:16
#define NV0036_POINT_12D4                                          (0x00000318)
#define NV0036_POINT_12D4_X                                                15:0
#define NV0036_POINT_12D4_Y                                               31:16
#define NV0036_COLOR(a)                                            (0x00000400\
                                                                   +(a)*0x0004)


/* class NV03_SCALED_IMAGE_FROM_MEMORY */
#define  NV03_SCALED_IMAGE_FROM_MEMORY                             (0x00000037)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0037_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0037Notification;
#define NV0037_NOTIFIERS_NOTIFY                                             (0)
#define NV0037_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0037_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV03_SCALED_IMAGE_FROM_MEMORY    0000-0003 */
		NvV32               status;	/* returns NV0037_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0037AllocParameters;
#define NV0037_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0037_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0037_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0037_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_SCALED_IMAGE_FROM_MEMORY in 0000-0003 */
		NvV32               status;	/* returns NV0037_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0037FreeParameters;
#define NV0037_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0037_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_SCALED_IMAGE_FROM_MEMORY in 0000-0003 */
		NvV32               status;	/* returns NV0037_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0037ControlParameters;
#define NV0037_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV0037_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextDmaImage;	/* NV01_CONTEXT_DMA                 0184-0187 */
		NvV32               SetContextPattern;	/* NV01_CONTEXT_PATTERN             0188-018b */
		NvV32               SetContextRop;	/* NV03_CONTEXT_ROP                 018c-018f */
		NvV32               SetContextBeta1;	/* NV01_CONTEXT_BETA1               0190-0193 */
		NvV32               SetContextSurface;	/* NV03_CONTEXT_SURFACES_2D         0194-0197 */
		NvV32               Reserved01[0x05a];
		NvV32               SetColorFormat;	/* NV0037_SET_COLOR_FORMAT_*        0300-0303 */
		NvV32               SetOperation;	/* NV0037_SET_OPERATION_*           0304-0307 */
		NvV32               ClipPoint;	/* y_x S16_S16                      0308-030b */
		NvV32               ClipSize;	/* height_width U16_U16             030c-030f */
		NvV32               ImageOutPoint;	/* y_x S16_S16                      0310-0313 */
		NvV32               ImageOutSize;	/* height_width U16_U16             0314-0317 */
		NvV32               DuDx;	/* S12d20 du/dx                     0318-031b */
		NvV32               DvDy;	/* S12d20 dv/dy                     031c-031f */
		NvV32               Reserved02[0x038];
		NvV32               ImageInSize;	/* height_width U16_U16             0400-0403 */
		NvV32               ImageInFormat;	/* pitch U32                        0404-0407 */
		NvU32               ImageInOffset;	/* byte offset of top-left texel    0408-040b */
		NvV32               ImageInPoint;	/* v_u U12d4_U12d4                  040c-040f */
		NvV32               Reserved03[0x6fc];
	} Nv0037Typedef    , Nv03ScaledImageFromMemory;
#define NV0037_TYPEDEF                                nv03ScaledImageFromMemory
/* method offsets, fields, and values */
#define NV0037_NO_OPERATION                                        (0x00000100)
#define NV0037_NOTIFY                                              (0x00000104)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV0037_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV0037_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0037_SET_CONTEXT_DMA_IMAGE                               (0x00000184)
#define NV0037_SET_CONTEXT_PATTERN                                 (0x00000188)
#define NV0037_SET_CONTEXT_ROP                                     (0x0000018C)
#define NV0037_SET_CONTEXT_BETA1                                   (0x00000190)
#define NV0037_SET_CONTEXT_SURFACE                                 (0x00000194)
#define NV0037_SET_COLOR_FORMAT                                    (0x00000300)
#define NV0037_SET_COLOR_FORMAT_LE_A1R5G5B5                        (0x00000001)
#define NV0037_SET_COLOR_FORMAT_LE_X1R5G5B5                        (0x00000002)
#define NV0037_SET_COLOR_FORMAT_LE_A8R8G8B8                        (0x00000003)
#define NV0037_SET_COLOR_FORMAT_LE_X8R8G8B8                        (0x00000004)
#define NV0037_SET_COLOR_FORMAT_LE_CR8YB8CB8YA8                    (0x00000005)
#define NV0037_SET_COLOR_FORMAT_LE_YB8CR8YA8CB8                    (0x00000006)
#define NV0037_SET_OPERATION                                       (0x00000304)
#define NV0037_SET_OPERATION_SRCCOPY_AND                           (0x00000000)
#define NV0037_SET_OPERATION_ROP_AND                               (0x00000001)
#define NV0037_SET_OPERATION_BLEND_AND                             (0x00000002)
#define NV0037_CLIP_POINT                                          (0x00000308)
#define NV0037_CLIP_POINT_X                                                15:0
#define NV0037_CLIP_POINT_Y                                               31:16
#define NV0037_CLIP_SIZE                                           (0x0000030C)
#define NV0037_CLIP_SIZE_WIDTH                                             15:0
#define NV0037_CLIP_SIZE_HEIGHT                                           31:16
#define NV0037_IMAGE_OUT_POINT                                     (0x00000310)
#define NV0037_IMAGE_OUT_POINT_X                                           15:0
#define NV0037_IMAGE_OUT_POINT_Y                                          31:16
#define NV0037_IMAGE_OUT_SIZE                                      (0x00000314)
#define NV0037_IMAGE_OUT_SIZE_WIDTH                                        15:0
#define NV0037_IMAGE_OUT_SIZE_HEIGHT                                      31:16
#define NV0037_DU_DX                                               (0x00000318)
#define NV0037_DV_DY                                               (0x0000031C)
#define NV0037_IMAGE_IN_SIZE                                       (0x00000400)
#define NV0037_IMAGE_IN_SIZE_WIDTH                                         15:0
#define NV0037_IMAGE_IN_SIZE_HEIGHT                                       31:16
#define NV0037_IMAGE_IN_FORMAT                                     (0x00000404)
#define NV0037_IMAGE_IN_FORMAT_PITCH                                       31:0
#define NV0037_IMAGE_IN_OFFSET                                     (0x00000408)
#define NV0037_IMAGE_IN_POINT                                      (0x0000040C)
#define NV0037_IMAGE_IN_POINT_U                                            15:0
#define NV0037_IMAGE_IN_POINT_V                                           31:16
/* deprecated stuff */
#ifdef NVDEPRECATED
#define ImageInPitch                                              ImageInFormat
#define NV0037_IMAGE_IN_PITCH                                      (0x00000404)
#endif

	typedef NvV32       Nv0038Typedef;

	typedef NvV32       Nv0039Typedef;

	typedef NvV32       Nv003aTypedef;

	typedef NvV32       Nv003bTypedef;

	typedef NvV32       Nv003cTypedef;


/* class NV01_MEMORY_LOCAL_BANKED */
#define  NV01_MEMORY_LOCAL_BANKED                                  (0x0000003D)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_MEMORY_LOCAL_BANKED         0000-0003 */
		NvV32               status;	/* returns NV003D_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvP64               base;	/* returns a memory pointer         0010-0017 */
		NvU64               limit;	/* size-1 of memory                 0018-001f */
		NvV32               flags;	/* NV003D_ALLOC_FLAGS_*             0020-0023 */
		NvU32               portId;	/* port id number                   0024-0027 */
		NvV32               ignored00[0x006];
	} Nv003dAllocParameters;
#define NV003D_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV003D_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV003D_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV003D_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
#define NV003D_ALLOC_STATUS_ERROR_BAD_FLAGS_MEMORY_PAGES           (0x00000005)
#define NV003D_ALLOC_STATUS_ERROR_BAD_FLAGS_MAPPING_ACCESS         (0x00000006)
#define NV003D_ALLOC_STATUS_ERROR_BAD_FLAGS_MAPPING_COHERENCY      (0x00000007)
#define NV003D_ALLOC_FLAGS_MEMORY_PAGES                                     3:0
#define NV003D_ALLOC_FLAGS_MEMORY_PAGES_FIXED_CONTIGUOUS           (0x00000000)
#define NV003D_ALLOC_FLAGS_MEMORY_PAGES_FIXED_NONCONTIGUOUS        (0x00000001)
#define NV003D_ALLOC_FLAGS_MEMORY_PAGES_NONPAGABLE_NONCONTIGUOUS   (0x00000002)
#define NV003D_ALLOC_FLAGS_MEMORY_PAGES_PAGABLE_NONCONTIGUOUS      (0x00000003)
#define NV003D_ALLOC_FLAGS_MAPPING_ACCESS                                   7:4
#define NV003D_ALLOC_FLAGS_MAPPING_ACCESS_READ_WRITE_NONCOMBINED   (0x00000000)
#define NV003D_ALLOC_FLAGS_MAPPING_ACCESS_READ_WRITE_COMBINED      (0x00000001)
#define NV003D_ALLOC_FLAGS_MAPPING_ACCESS_READ_ONLY                (0x00000002)
#define NV003D_ALLOC_FLAGS_MAPPING_ACCESS_WRITE_NONCOMBINED        (0x00000003)
#define NV003D_ALLOC_FLAGS_MAPPING_ACCESS_WRITE_COMBINED           (0x00000004)
#define NV003D_ALLOC_FLAGS_MAPPING_COHERENCY                               31:8
#define NV003D_ALLOC_FLAGS_MAPPING_COHERENCY_UNCACHED              (0x00000000)
#define NV003D_ALLOC_FLAGS_MAPPING_COHERENCY_CACHED                (0x00000001)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_MEMORY_LOCAL_BANKED instanc 0000-0003 */
		NvV32               status;	/* returns NV003D_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv003dFreeParameters;
#define NV003D_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV003D_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_MEMORY_LOCAL_BANKED instanc 0000-0003 */
		NvV32               status;	/* returns NV003D_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv003dControlParameters;
#define NV003D_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Reserved00[0x7c0];
	} Nv003dTypedef    , Nv01MemoryLocalBanked;
#define NV003D_TYPEDEF                                    nv01MemoryLocalBanked
/* deprecated stuff */
#ifdef NVDEPRECATED
#define NV003D_ALLOC_FLAGS_MAPPING_ACCESS_READ_WRITE               (0x00000000)
#define NV003D_ALLOC_FLAGS_MAPPING_ACCESS_WRITE_ONLY               (0x00000003)
#endif


/* class NV01_MAPPING_SYSTEM */
#define  NV01_MAPPING_SYSTEM                                       (0x0000003E)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_MAPPING_SYSTEM              0000-0003 */
		NvV32               status;	/* returns NV003E_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvP64               base;	/* memory pointer                   0010-0017 */
		NvU64               limit;	/* size-1 of memory                 0018-001f */
		NvV32               ignored00[0x008];
	} Nv003eAllocParameters;
#define NV003E_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV003E_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV003E_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV003E_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
#define NV003E_ALLOC_STATUS_ERROR_BAD_BASE                         (0x00000005)
#define NV003E_ALLOC_STATUS_ERROR_BAD_LIMIT                        (0x00000006)
#define NV003E_ALLOC_STATUS_ERROR_PROTECTION_FAULT                 (0x00000007)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_MAPPING_SYSTEM instance     0000-0003 */
		NvV32               status;	/* returns NV003E_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv003eFreeParameters;
#define NV003E_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV003E_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_MAPPING_SYSTEM instance     0000-0003 */
		NvV32               status;	/* returns NV003E_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv003eControlParameters;
#define NV003E_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Reserved00[0x7c0];
	} Nv003eTypedef    , Nv01MemorySystem;
#define  NV003E_TYPEDEF                                        nv01MemorySystem
/* deprecated stuff */
#ifdef NVDEPRECATED
#define NV01_MEMORY_SYSTEM                                         (0x0000003E)
#endif


/* class NV03_MEMORY_LOCAL_CURSOR */
#define  NV03_MEMORY_LOCAL_CURSOR                                  (0x0000003F)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV03_MEMORY_LOCAL_CURSOR         0000-0003 */
		NvV32               status;	/* returns NV003F_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvP64               base;	/* returns a memory pointer         0010-0017 */
		NvU64               limit;	/* size-1 of memory                 0018-001f */
		NvV32               flags;	/* NV003F_ALLOC_FLAGS_*             0020-0023 */
		NvV32               ignored00[0x007];
	} Nv003fAllocParameters;
#define NV003F_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV003F_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV003F_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV003F_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
#define NV003F_ALLOC_STATUS_ERROR_BAD_FLAGS_MEMORY_PAGES           (0x00000005)
#define NV003F_ALLOC_STATUS_ERROR_BAD_FLAGS_MAPPING_ACCESS         (0x00000006)
#define NV003F_ALLOC_STATUS_ERROR_BAD_FLAGS_MAPPING_COHERENCY      (0x00000007)
#define NV003F_ALLOC_FLAGS_MEMORY_PAGES                                     3:0
#define NV003F_ALLOC_FLAGS_MEMORY_PAGES_FIXED_CONTIGUOUS           (0x00000000)
#define NV003F_ALLOC_FLAGS_MEMORY_PAGES_FIXED_NONCONTIGUOUS        (0x00000001)
#define NV003F_ALLOC_FLAGS_MEMORY_PAGES_NONPAGABLE_NONCONTIGUOUS   (0x00000002)
#define NV003F_ALLOC_FLAGS_MEMORY_PAGES_PAGABLE_NONCONTIGUOUS      (0x00000003)
#define NV003F_ALLOC_FLAGS_MAPPING_ACCESS                                   7:4
#define NV003F_ALLOC_FLAGS_MAPPING_ACCESS_READ_WRITE_NONCOMBINED   (0x00000000)
#define NV003F_ALLOC_FLAGS_MAPPING_ACCESS_READ_WRITE_COMBINED      (0x00000001)
#define NV003F_ALLOC_FLAGS_MAPPING_ACCESS_READ_ONLY                (0x00000002)
#define NV003F_ALLOC_FLAGS_MAPPING_ACCESS_WRITE_NONCOMBINED        (0x00000003)
#define NV003F_ALLOC_FLAGS_MAPPING_ACCESS_WRITE_COMBINED           (0x00000004)
#define NV003F_ALLOC_FLAGS_MAPPING_COHERENCY                               31:8
#define NV003F_ALLOC_FLAGS_MAPPING_COHERENCY_UNCACHED              (0x00000000)
#define NV003F_ALLOC_FLAGS_MAPPING_COHERENCY_CACHED                (0x00000001)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_MEMORY_LOCAL_CURSOR instanc 0000-0003 */
		NvV32               status;	/* returns NV003F_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv003fFreeParameters;
#define NV003F_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV003F_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_MEMORY_LOCAL_CURSOR instanc 0000-0003 */
		NvV32               status;	/* returns NV003F_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv003fControlParameters;
#define NV003F_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Reserved00[0x7c0];
	} Nv003fTypedef    , Nv03MemoryLocalCursor;
#define NV003F_TYPEDEF                                    nv03MemoryLocalCursor
/* deprecated stuff */
#ifdef NVDEPRECATED
#define NV003F_ALLOC_FLAGS_MAPPING_ACCESS_READ_WRITE               (0x00000000)
#define NV003F_ALLOC_FLAGS_MAPPING_ACCESS_WRITE_ONLY               (0x00000003)
#endif


/* class NV01_MEMORY_LOCAL_LINEAR */
#define  NV01_MEMORY_LOCAL_LINEAR                                  (0x00000040)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_MEMORY_LOCAL_LINEAR         0000-0003 */
		NvV32               status;	/* returns NV0040_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvP64               base;	/* returns a memory pointer         0010-0017 */
		NvU64               limit;	/* size-1 of memory                 0018-001f */
		NvV32               flags;	/* NV0040_ALLOC_FLAGS_*             0020-0023 */
		NvV32               ignored00[0x007];
	} Nv0040AllocParameters;
#define NV0040_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0040_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0040_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0040_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
#define NV0040_ALLOC_STATUS_ERROR_BAD_FLAGS_MEMORY_PAGES           (0x00000005)
#define NV0040_ALLOC_STATUS_ERROR_BAD_FLAGS_MAPPING_ACCESS         (0x00000006)
#define NV0040_ALLOC_STATUS_ERROR_BAD_FLAGS_MAPPING_COHERENCY      (0x00000007)
#define NV0040_ALLOC_FLAGS_MEMORY_PAGES                                     3:0
#define NV0040_ALLOC_FLAGS_MEMORY_PAGES_FIXED_CONTIGUOUS           (0x00000000)
#define NV0040_ALLOC_FLAGS_MEMORY_PAGES_FIXED_NONCONTIGUOUS        (0x00000001)
#define NV0040_ALLOC_FLAGS_MEMORY_PAGES_NONPAGABLE_NONCONTIGUOUS   (0x00000001)
#define NV0040_ALLOC_FLAGS_MEMORY_PAGES_PAGABLE_NONCONTIGUOUS      (0x00000002)
#define NV0040_ALLOC_FLAGS_MAPPING_ACCESS                                   7:4
#define NV0040_ALLOC_FLAGS_MAPPING_ACCESS_READ_WRITE_NONCOMBINED   (0x00000000)
#define NV0040_ALLOC_FLAGS_MAPPING_ACCESS_READ_WRITE_COMBINED      (0x00000001)
#define NV0040_ALLOC_FLAGS_MAPPING_ACCESS_READ_ONLY                (0x00000002)
#define NV0040_ALLOC_FLAGS_MAPPING_ACCESS_WRITE_NONCOMBINED        (0x00000003)
#define NV0040_ALLOC_FLAGS_MAPPING_ACCESS_WRITE_COMBINED           (0x00000004)
#define NV0040_ALLOC_FLAGS_MAPPING_COHERENCY                               31:8
#define NV0040_ALLOC_FLAGS_MAPPING_COHERENCY_UNCACHED              (0x00000000)
#define NV0040_ALLOC_FLAGS_MAPPING_COHERENCY_CACHED                (0x00000001)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_MEMORY_LOCAL_LINEAR instanc 0000-0003 */
		NvV32               status;	/* returns NV0040_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0040FreeParameters;
#define NV0040_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0040_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_MEMORY_LOCAL_LINEAR instanc 0000-0003 */
		NvV32               status;	/* returns NV0040_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0040ControlParameters;
#define NV0040_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Reserved00[0x7c0];
	} Nv0040Typedef    , Nv01MemoryLocalLinear;
#define NV0040_TYPEDEF                                    nv01MemoryLocalLinear
/* deprecated stuff */
#ifdef NVDEPRECATED
#define NV0040_ALLOC_FLAGS_MAPPING_ACCESS_READ_WRITE               (0x00000000)
#define NV0040_ALLOC_FLAGS_MAPPING_ACCESS_WRITE_ONLY               (0x00000003)
#endif


/* class NV01_MAPPING_LOCAL */
#define  NV01_MAPPING_LOCAL                                        (0x00000041)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV01_MAPPING_LOCAL               0000-0003 */
		NvV32               status;	/* returns NV0041_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvP64               base;	/* memory pointer                   0010-0017 */
		NvU64               limit;	/* size-1 of memory                 0018-001f */
		NvV32               classMemory;	/* returns NV??_MEMORY_LOCAL_*      0020-0023 */
		NvV32               ignored00[0x007];
	} Nv0041AllocParameters;
#define NV0041_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0041_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0041_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0041_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
#define NV0041_ALLOC_STATUS_ERROR_BAD_BASE                         (0x00000005)
#define NV0041_ALLOC_STATUS_ERROR_BAD_LIMIT                        (0x00000006)
#define NV0041_ALLOC_STATUS_ERROR_PROTECTION_FAULT                 (0x00000007)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_MAPPING_LOCAL instance      0000-0003 */
		NvV32               status;	/* returns NV0041_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0041FreeParameters;
#define NV0041_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0041_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV01_MAPPING_LOCAL instance      0000-0003 */
		NvV32               status;	/* returns NV0041_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0041ControlParameters;
#define NV0041_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Reserved00[0x7c0];
	} Nv0041Typedef    , Nv01MappingLocal;
#define  NV0041_TYPEDEF                                        nv01MappingLocal

	typedef NvV32       Nv0042Typedef;


/* class NV03_CONTEXT_ROP */
#define  NV03_CONTEXT_ROP                                          (0x00000043)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0043_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0043Notification;
#define NV0043_NOTIFIERS_NOTIFY                                             (0)
#define NV0043_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0043_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV03_CONTEXT_ROP                 0000-0003 */
		NvV32               status;	/* returns NV0043_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0043AllocParameters;
#define NV0043_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0043_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0043_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0043_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_CONTEXT_ROP instance        0000-0003 */
		NvV32               status;	/* returns NV0043_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0043FreeParameters;
#define NV0043_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0043_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_CONTEXT_ROP instance        0000-0003 */
		NvV32               status;	/* returns NV0043_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0043ControlParameters;
#define NV0043_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV0043_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               Reserved01[0x05f];
		NvV32               SetRop;	/* 32-bit ROP                       0300-0303 */
		NvV32               Reserved02[0x73f];
	} Nv0043Typedef    , Nv03ContextRop;
#define NV0043_TYPEDEF                                           nv03ContextRop
/* method offsets, fields, and values */
#define NV0043_NO_OPERATION                                        (0x00000100)
#define NV0043_NOTIFY                                              (0x00000104)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV0043_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV0043_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0043_SET_ROP                                             (0x00000300)

	typedef NvV32       Nv0044Typedef;

	typedef NvV32       Nv0045Typedef;


/* class NV03_VIDEO_LUT_CURSOR_DAC */
#define  NV03_VIDEO_LUT_CURSOR_DAC                                 (0x00000046)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvU32               offset;	/* see text                         0008-000b */
		NvV8                zero[0x003];	/* zero                             000c-000e */
		NvV8                status;	/* NV0046_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0046Notification;
#define NV0046_NOTIFIERS_SYNCHRONIZE                                        (0)
#define NV0046_NOTIFIERS_GET                                                (0)
#define NV0046_NOTIFIERS_SET_IMAGE(b)                                   (1+(b))
#define NV0046_NOTIFIERS_SET_CURSOR(b)                                  (3+(b))
#define NV0046_NOTIFIERS_SET_DAC(b)                                     (5+(b))
#define NV0046_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0046_NOTIFICATION_STATUS_INVALID_OFFSET                        (0x01)
#define NV0046_NOTIFICATION_STATUS_VALID_OFFSET                          (0x02)
#define NV0046_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV03_VIDEO_LUT_CURSOR_DAC        0000-0003 */
		NvV32               status;	/* returns NV0046_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvU32               portId;	/* port id number                   0010-0013 */
		NvU32               limitBandwidth;	/* Kilobytes/Second                 0014-0017 */
		NvU32               limitPixelClock;	/* Hertz                            0018-001b */
		NvV32               overheadImage;	/* U16d16 unitless                  001c-001f */
		NvV32               overheadCursor;	/* U16d16 unitless                  0020-0023 */
		NvV32               ignored00[0x007];
	} Nv0046AllocParameters;
#define NV0046_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0046_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0046_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0046_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_VIDEO_LUT_CURSOR_DAC instan 0000-0003 */
		NvV32               status;	/* returns NV0046_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0046FreeParameters;
#define NV0046_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0046_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_VIDEO_LUT_CURSOR_DAC instan 0000-0003 */
		NvV32               status;	/* returns NV0046_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0046ControlParameters;
#define NV0046_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Synchronize;	/* NV0046_SYNCHRONIZE_*             0100-0103 */
		NvV32               StopImage;	/* NV0046_STOP_IMAGE_*              0104-0107 */
		NvV32               StopCursor;	/* NV0046_STOP_CURSOR_*             0108-010b */
		NvV32               StopDac;	/* NV0046_STOP_DAC_*                010c-010f */
		NvV32               Reserved00[0x01c];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextDmaImage[2];	/* NV01_CONTEXT_DMA                 0184-018b */
		NvV32               SetContextDmaLut[2];	/* NV01_CONTEXT_DMA                 018c-0193 */
		NvV32               SetContextDmaCursor[2];	/* NV01_CONTEXT_DMA                 0194-019b */
		NvV32               Reserved01[0x058];
		NvV32               Get;	/* NV0046_GET_*                     02fc-02ff */
		struct
		{		/* start of methods in array        0300-    */
			NvU32               offset;	/* byte offset of top-left pixel       0-   3 */
			NvV32               format;	/* notify_color_pitch V1_V15_U16       4-   7 */
		} SetImage[2];	/* end of methods in array              -030f */
		NvV32               Reserved02[0x00c];
		struct
		{		/* start of methods in array        0340-    */
			NvU32               offset;	/* byte offset of top-left pixel       0-   3 */
			NvV32               pointOut;	/* y_x S16_S16                         4-   7 */
			NvV32               format;	/* notify                              8-   b */
		} SetCursor[2];	/* end of methods in array              -0357 */
		NvV32               SetCursorPointOutA;	/* y_x S16_S16                      0358-035b */
		NvV32               Reserved03[0x009];
		struct
		{		/* start of methods in array        0380-    */
			NvV32               imageSize;	/* height_width U16_U16 in pixels      0-   3 */
			NvV32               horizontalSync;	/* width_start U16_U16 in pixels       4-   7 */
			NvV32               verticalSync;	/* width_start U16_U16 in pixels       8-   b */
			NvV32               totalSize;	/* notify_height_width V1_U15_U16      c-   f */
		} SetDac[2];	/* end of methods in array              -039f */
		NvU32               SetPixelClock;	/* in Hertz                         03a0-03a3 */
		NvV32               Reserved04[0x717];
	} Nv0046Typedef    , nv03VideoLutCursorDac;
#define NV0046_TYPEDEF                                    nv03VideoLutCursorDac
/* method offsets, fields, and values */
#define NV0046_SYNCHRONIZE                                         (0x00000100)
#define NV0046_SYNCHRONIZE_NO_OPERATION                            (0x00000000)
#define NV0046_SYNCHRONIZE_WAIT_FOR_IDLE                           (0x00000001)
#define NV0046_SYNCHRONIZE_WAIT_FOR_IDLE_WRITE_LE_NOTIFY           (0x00000002)
#define NV0046_SYNCHRONIZE_WAIT_FOR_IDLE_WRITE_LE_NOTIFY_AWAKEN    (0x00000003)
#define NV0046_STOP_IMAGE                                          (0x00000104)
#define NV0046_STOP_IMAGE_IMMEDIATELY                              (0x00000000)
#define NV0046_STOP_IMAGE_AT_END_OF_SAMPLE                         (0x00000001)
#define NV0046_STOP_IMAGE_AT_END_OF_BUFFER                         (0x00000001)
#define NV0046_STOP_CURSOR                                         (0x00000108)
#define NV0046_STOP_CURSOR_IMMEDIATELY                             (0x00000000)
#define NV0046_STOP_CURSOR_AT_END_OF_SAMPLE                        (0x00000001)
#define NV0046_STOP_CURSOR_AT_END_OF_BUFFER                        (0x00000001)
#define NV0046_STOP_DAC                                            (0x0000010C)
#define NV0046_STOP_DAC_IMMEDIATELY                                (0x00000000)
#define NV0046_STOP_DAC_AT_END_OF_SAMPLE                           (0x00000001)
#define NV0046_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0046_SET_CONTEXT_DMA_IMAGE(b)                            (0x00000184\
                                                                   +(b)*0x0004)
#define NV0046_SET_CONTEXT_DMA_LUT(b)                              (0x0000018C\
                                                                   +(b)*0x0004)
#define NV0046_SET_CONTEXT_DMA_CURSOR(b)                           (0x00000194\
                                                                   +(b)*0x0004)
#define NV0046_GET                                                 (0x000002FC)
#define NV0046_GET_LE_NOTIFY_IMAGE_0                               (0x00000000)
#define NV0046_GET_LE_NOTIFY_IMAGE_1                               (0x00000001)
#define NV0046_SET_IMAGE(b)                                        (0x00000300\
                                                                   +(b)*0x0008)
#define NV0046_SET_IMAGE_OFFSET(b)                                 (0x00000300\
                                                                   +(b)*0x0008)
#define NV0046_SET_IMAGE_FORMAT(b)                                 (0x00000304\
                                                                   +(b)*0x0008)
#define NV0046_SET_IMAGE_FORMAT_PITCH                                      15:0
#define NV0046_SET_IMAGE_FORMAT_COLOR                                     27:16
#define NV0046_SET_IMAGE_FORMAT_COLOR_LUT_NE_Y8                    (0x00000000)
#define NV0046_SET_IMAGE_FORMAT_COLOR_BYPASS_LE_R5G6B5             (0x00000001)
#define NV0046_SET_IMAGE_FORMAT_COLOR_LE_BYPASS16                  (0x00000002)
#define NV0046_SET_IMAGE_FORMAT_COLOR_LE_BYPASS32                  (0x00000003)
#define NV0046_SET_IMAGE_FORMAT_NOTIFY                                    31:28
#define NV0046_SET_IMAGE_FORMAT_NOTIFY_WRITE_LE_NOTIFY             (0x00000000)
#define NV0046_SET_IMAGE_FORMAT_NOTIFY_WRITE_LE_NOTIFY_AWAKEN      (0x00000001)
#define NV0046_SET_CURSOR(b)                                       (0x00000340\
                                                                   +(b)*0x000C)
#define NV0046_SET_CURSOR_OFFSET(b)                                (0x00000340\
                                                                   +(b)*0x000C)
#define NV0046_SET_CURSOR_POINT_OUT(b)                             (0x00000344\
                                                                   +(b)*0x000C)
#define NV0046_SET_CURSOR_POINT_OUT_X                                      15:0
#define NV0046_SET_CURSOR_POINT_OUT_Y                                     31:16
#define NV0046_SET_CURSOR_FORMAT(b)                                (0x00000348\
                                                                   +(b)*0x000C)
#define NV0046_SET_CURSOR_FORMAT_NOTIFY_WRITE_LE_NOTIFY            (0x00000000)
#define NV0046_SET_CURSOR_FORMAT_NOTIFY_WRITE_LE_NOTIFY_AWAKEN     (0x00000001)
#define NV0046_SET_CURSOR_POINT_OUT_A                              (0x00000358)
#define NV0046_SET_CURSOR_POINT_OUT_A_X                                    15:0
#define NV0046_SET_CURSOR_POINT_OUT_A_Y                                   31:16
#define NV0046_SET_DAC(b)                                          (0x00000380\
                                                                   +(b)*0x0010)
#define NV0046_SET_DAC_IMAGE_SIZE(b)                               (0x00000380\
                                                                   +(b)*0x0010)
#define NV0046_SET_DAC_IMAGE_SIZE_WIDTH                                    15:0
#define NV0046_SET_DAC_IMAGE_SIZE_HEIGHT                                  31:16
#define NV0046_SET_DAC_HORIZONTAL_SYNC(b)                          (0x00000384\
                                                                   +(b)*0x0010)
#define NV0046_SET_DAC_HORIZONTAL_SYNC_START                               15:0
#define NV0046_SET_DAC_HORIZONTAL_SYNC_WIDTH                              27:16
#define NV0046_SET_DAC_HORIZONTAL_SYNC_POLARITY                           31:28
#define NV0046_SET_DAC_HORIZONTAL_SYNC_POLARITY_POSITIVE           (0x00000000)
#define NV0046_SET_DAC_HORIZONTAL_SYNC_POLARITY_NEGATIVE           (0x00000001)
#define NV0046_SET_DAC_VERTICAL_SYNC(b)                            (0x00000388\
                                                                   +(b)*0x0010)
#define NV0046_SET_DAC_VERTICAL_SYNC_START                                 15:0
#define NV0046_SET_DAC_VERTICAL_SYNC_WIDTH                                27:16
#define NV0046_SET_DAC_VERTICAL_SYNC_POLARITY                             31:28
#define NV0046_SET_DAC_VERTICAL_SYNC_POLARITY_POSITIVE             (0x00000000)
#define NV0046_SET_DAC_VERTICAL_SYNC_POLARITY_NEGATIVE             (0x00000001)
#define NV0046_SET_DAC_TOTAL_SIZE(b)                               (0x0000038C\
                                                                   +(b)*0x0010)
#define NV0046_SET_DAC_TOTAL_SIZE_WIDTH                                    15:0
#define NV0046_SET_DAC_TOTAL_SIZE_HEIGHT                                  27:16
#define NV0046_SET_DAC_TOTAL_SIZE_NOTIFY                                  31:28
#define NV0046_SET_DAC_TOTAL_SIZE_NOTIFY_WRITE_LE_NOTIFY           (0x00000000)
#define NV0046_SET_DAC_TOTAL_SIZE_NOTIFY_WRITE_LE_NOTIFY_AWAKEN    (0x00000001)
#define NV0046_SET_PIXEL_CLOCK                                     (0x000003A0)
/* obsolete stuff */
#if NVDEPRECATED
#define NV0046_STOP_IMAGE_NORMALLY                                 (0x00000001)
#define NV0046_STOP_CURSOR_NORMALLY                                (0x00000001)
#define NV0046_STOP_DAC_NORMALLY                                   (0x00000001)
#endif

	typedef NvV32       Nv0047Typedef;


/* class NV03_DX3_TEXTURED_TRIANGLE */
#define  NV03_DX3_TEXTURED_TRIANGLE                                (0x00000048)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0048_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0048Notification;
#define NV0048_NOTIFIERS_NOTIFY                                             (0)
#define NV0048_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0048_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV03_DX3_TEXTURED_TRIANGLE       0000-0003 */
		NvV32               status;	/* returns NV0048_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0048AllocParameters;
#define NV0048_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0048_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0048_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0048_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_DX3_TEXTURED_TRIANGLE insta 0000-0003 */
		NvV32               status;	/* returns NV0048_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0048FreeParameters;
#define NV0048_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0048_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_DX3_TEXTURED_TRIANGLE insta 0000-0003 */
		NvV32               status;	/* returns NV0048_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0048ControlParameters;
#define NV0048_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV0048_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextDmaTexture;	/* NV01_CONTEXT_DMA                 0184-0187 */
		NvV32               SetContextClipRectangle;	/* NV01_CONTEXT_CLIP_RECTANGLE      0188-018b */
		NvV32               SetContextSurfaces;	/* NV03_CONTEXT_SURFACES_3D         018c-018f */
		NvV32               Reserved01[0x05d];
		NvU32               TextureOffset;	/* offset in bytes                  0304-0307 */
		NvV32               TextureFormat;	/* see text                         0308-030b */
		NvV32               TextureFilter;	/* ignre_sizeAdjust_spreadY_spreadX 030c-030f */
		NvV32               FogColor;	/* X8R8G8B8 fog color               0310-0313 */
		NvV32               Control0;	/* see text                         0314-0317 */
		NvV32               Control1;	/* alphafunc_alpharef V24_U8        0318-031b */
		NvV32               Reserved02[0x339];
		struct
		{		/* start of method in array         1000-    */
			NvV32               specular;	/* fog_i5-i0 U0d8_U4_U4_U4_U4_U4_U4   00-  03 */
			NvV32               color;	/* X8R8G8B8 or A8R8G8B8               04-  07 */
			NvF32               sx;	/* screen x coordinate                08-  0b */
			NvF32               sy;	/* screen y coordinate                0c-  0f */
			NvF32               sz;	/* screen z coordinate                10-  13 */
			NvF32               rhw;	/* reciprocal homogeneous W (1/W)     14-  17 */
			NvF32               tu;	/* texture u coordinate               18-  1b */
			NvF32               tv;	/* texture v coordinate               1c-  1f */
		} Tlvertex[128];	/* end of method in array               -1fff */
	} Nv0048Typedef    , Nv03Dx3TexturedTriangle;
#define NV0048_TYPEDEF                                  nv03Dx3TexturedTriangle
/* method offsets, fields, and values */
#define NV0048_NO_OPERATION                                        (0x00000100)
#define NV0048_NOTIFY                                              (0x00000104)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV0048_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV0048_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0048_SET_CONTEXT_DMA_TEXTURE                             (0x00000184)
#define NV0048_SET_CONTEXT_CLIP_RECTANGLE                          (0x00000188)
#define NV0048_SET_CONTEXT_SURFACES                                (0x0000018C)
#define NV0048_TEXTURE_OFFSET                                      (0x00000304)
#define NV0048_TEXTURE_FORMAT                                      (0x00000308)
#define NV0048_TEXTURE_FORMAT_COLOR_KEY_VALUE                              15:0
#define NV0048_TEXTURE_FORMAT_COLOR_KEY_MATCH                             19:16
#define NV0048_TEXTURE_FORMAT_COLOR_KEY_MATCH_SRCCOPY              (0x00000000)
#define NV0048_TEXTURE_FORMAT_COLOR_KEY_MATCH_ZERO_ALPHA           (0x00000001)
#define NV0048_TEXTURE_FORMAT_COLOR                                       23:20
#define NV0048_TEXTURE_FORMAT_COLOR_LE_A1R5G5B5                    (0x00000000)
#define NV0048_TEXTURE_FORMAT_COLOR_LE_X1R5G5B5                    (0x00000001)
#define NV0048_TEXTURE_FORMAT_COLOR_LE_A4R4G4B4                    (0x00000002)
#define NV0048_TEXTURE_FORMAT_COLOR_LE_R5G6B5                      (0x00000003)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN                                    27:24
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_1X1                         (0x00000000)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_2X2                         (0x00000001)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_4X4                         (0x00000002)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_8X8                         (0x00000003)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_16X16                       (0x00000004)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_32X32                       (0x00000005)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_64X64                       (0x00000006)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_128X128                     (0x00000007)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_256X256                     (0x00000008)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_512X512                     (0x00000009)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_1024X1024                   (0x0000000A)
#define NV0048_TEXTURE_FORMAT_SIZE_MIN_2048X2048                   (0x0000000B)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX                                    31:28
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_1X1                         (0x00000000)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_2X2                         (0x00000001)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_4X4                         (0x00000002)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_8X8                         (0x00000003)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_16X16                       (0x00000004)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_32X32                       (0x00000005)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_64X64                       (0x00000006)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_128X128                     (0x00000007)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_256X256                     (0x00000008)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_512X512                     (0x00000009)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_1024X1024                   (0x0000000A)
#define NV0048_TEXTURE_FORMAT_SIZE_MAX_2048X2048                   (0x0000000B)
#define NV0048_TEXTURE_FILTER                                      (0x0000030C)
#define NV0048_TEXTURE_FILTER_SPREAD_X                                      4:0
#define NV0048_TEXTURE_FILTER_IGNORE0                                       7:5
#define NV0048_TEXTURE_FILTER_SPREAD_Y                                     12:8
#define NV0048_TEXTURE_FILTER_IGNORE1                                     15:13
#define NV0048_TEXTURE_FILTER_SIZE_ADJUST                                 23:16
#define NV0048_TEXTURE_FILTER_IGNORE2                                     31:24
#define NV0048_FOG_COLOR                                           (0x00000310)
#define NV0048_CONTROL0                                            (0x00000314)
#define NV0048_CONTROL0_INTERPOLATOR                                        3:0
#define NV0048_CONTROL0_INTERPOLATOR_ZOH_CORNER                    (0x00000000)
#define NV0048_CONTROL0_INTERPOLATOR_ZOH_CENTER                    (0x00000001)
#define NV0048_CONTROL0_INTERPOLATOR_FOH_CENTER                    (0x00000002)
#define NV0048_CONTROL0_WRAP_U                                              5:4
#define NV0048_CONTROL0_WRAP_U_CYLINDRICAL                         (0x00000000)
#define NV0048_CONTROL0_WRAP_U_WRAP                                (0x00000001)
#define NV0048_CONTROL0_WRAP_U_MIRROR                              (0x00000002)
#define NV0048_CONTROL0_WRAP_U_CLAMP                               (0x00000003)
#define NV0048_CONTROL0_WRAP_V                                              7:6
#define NV0048_CONTROL0_WRAP_V_CYLINDRICAL                         (0x00000000)
#define NV0048_CONTROL0_WRAP_V_WRAP                                (0x00000001)
#define NV0048_CONTROL0_WRAP_V_MIRROR                              (0x00000002)
#define NV0048_CONTROL0_WRAP_V_CLAMP                               (0x00000003)
#define NV0048_CONTROL0_SOURCE_COLOR                                       11:8
#define NV0048_CONTROL0_SOURCE_COLOR_NORMAL                        (0x00000001)
#define NV0048_CONTROL0_SOURCE_COLOR_COLOR_INVERSE                 (0x00000002)
#define NV0048_CONTROL0_SOURCE_COLOR_ALPHA_INVERSE                 (0x00000003)
#define NV0048_CONTROL0_SOURCE_COLOR_ALPHA_ONE                     (0x00000006)
#define NV0048_CONTROL0_CULLING                                           14:12
#define NV0048_CONTROL0_CULLING_NONE                               (0x00000001)
#define NV0048_CONTROL0_CULLING_COUNTERCLOCKWISE                   (0x00000002)
#define NV0048_CONTROL0_CULLING_CLOCKWISE                          (0x00000003)
#define NV0048_CONTROL0_Z_PERSPECTIVE_ENABLE                              15:15
#define NV0048_CONTROL0_Z_PERSPECTIVE_ENABLE_FALSE                 (0x00000000)
#define NV0048_CONTROL0_Z_PERSPECTIVE_ENABLE_TRUE                  (0x00000001)
#define NV0048_CONTROL0_ZFUNC                                             19:16
#define NV0048_CONTROL0_ZFUNC_NEVER                                (0x00000001)
#define NV0048_CONTROL0_ZFUNC_LESS                                 (0x00000002)
#define NV0048_CONTROL0_ZFUNC_EQUAL                                (0x00000003)
#define NV0048_CONTROL0_ZFUNC_LESSEQUAL                            (0x00000004)
#define NV0048_CONTROL0_ZFUNC_GREATER                              (0x00000005)
#define NV0048_CONTROL0_ZFUNC_NOTEQUAL                             (0x00000006)
#define NV0048_CONTROL0_ZFUNC_GREATEREQUAL                         (0x00000007)
#define NV0048_CONTROL0_ZFUNC_ALWAYS                               (0x00000008)
#define NV0048_CONTROL0_Z_WRITE_ENABLE                                    23:20
#define NV0048_CONTROL0_Z_WRITE_ENABLE_TRUE                        (0x00000003)
#define NV0048_CONTROL0_Z_WRITE_ENABLE_FALSE                       (0x00000005)
#define NV0048_CONTROL0_COLOR_WRITE_ENABLE                                26:24
#define NV0048_CONTROL0_COLOR_WRITE_ENABLE_FALSE                   (0x00000000)
#define NV0048_CONTROL0_COLOR_WRITE_ENABLE_TRUE                    (0x00000003)
#define NV0048_CONTROL0_ROP                                               28:27
#define NV0048_CONTROL0_ROP_BLEND                                  (0x00000000)
#define NV0048_CONTROL0_ROP_ADD                                    (0x00000001)
#define NV0048_CONTROL0_BETA                                              29:29
#define NV0048_CONTROL0_BETA_SRCALPHA                              (0x00000000)
#define NV0048_CONTROL0_BETA_DESTCOLOR                             (0x00000001)
#define NV0048_CONTROL0_DEST_BLEND                                        30:30
#define NV0048_CONTROL0_DEST_BLEND_INVBETA                         (0x00000000)
#define NV0048_CONTROL0_DEST_BLEND_ZERO                            (0x00000001)
#define NV0048_CONTROL0_SRC_BLEND                                         31:31
#define NV0048_CONTROL0_SRC_BLEND_BETA                             (0x00000000)
#define NV0048_CONTROL0_SRC_BLEND_ZERO                             (0x00000001)
#define NV0048_CONTROL1                                            (0x00000318)
#define NV0048_CONTROL1_ALPHAREF                                            7:0
#define NV0048_CONTROL1_ALPHAFUNC                                          31:8
#define NV0048_CONTROL1_ALPHAFUNC_NEVER                            (0x00000001)
#define NV0048_CONTROL1_ALPHAFUNC_LESS                             (0x00000002)
#define NV0048_CONTROL1_ALPHAFUNC_EQUAL                            (0x00000003)
#define NV0048_CONTROL1_ALPHAFUNC_LESSEQUAL                        (0x00000004)
#define NV0048_CONTROL1_ALPHAFUNC_GREATER                          (0x00000005)
#define NV0048_CONTROL1_ALPHAFUNC_NOTEQUAL                         (0x00000006)
#define NV0048_CONTROL1_ALPHAFUNC_GREATEREQUAL                     (0x00000007)
#define NV0048_CONTROL1_ALPHAFUNC_ALWAYS                           (0x00000008)
#define NV0048_TLVERTEX(a)                                         (0x00001000\
                                                                   +(a)*0x0020)
#define NV0048_TLVERTEX_SPECULAR(a)                                (0x00001000\
                                                                   +(a)*0x0020)
#define NV0048_TLVERTEX_SPECULAR_I0                                         3:0
#define NV0048_TLVERTEX_SPECULAR_I1                                         7:4
#define NV0048_TLVERTEX_SPECULAR_I2                                        11:8
#define NV0048_TLVERTEX_SPECULAR_I3                                       15:12
#define NV0048_TLVERTEX_SPECULAR_I4                                       19:16
#define NV0048_TLVERTEX_SPECULAR_I5                                       23:20
#define NV0048_TLVERTEX_SPECULAR_FOG                                      31:24
#define NV0048_TLVERTEX_COLOR(a)                                   (0x00001004\
                                                                   +(a)*0x0020)
#define NV0048_TLVERTEX_SX(a)                                      (0x00001008\
                                                                   +(a)*0x0020)
#define NV0048_TLVERTEX_SY(a)                                      (0x0000100C\
                                                                   +(a)*0x0020)
#define NV0048_TLVERTEX_SZ(a)                                      (0x00001010\
                                                                   +(a)*0x0020)
#define NV0048_TLVERTEX_RHW(a)                                     (0x00001014\
                                                                   +(a)*0x0020)
#define NV0048_TLVERTEX_TU(a)                                      (0x00001018\
                                                                   +(a)*0x0020)
#define NV0048_TLVERTEX_TV(a)                                      (0x0000101C\
                                                                   +(a)*0x0020)

	typedef NvV32       Nv0049Typedef;

	typedef NvV32       Nv004aTypedef;


/* class NV03_GDI_RECTANGLE_TEXT */
#define  NV03_GDI_RECTANGLE_TEXT                                   (0x0000004B)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV004B_NOTIFICATION_STATUS_*     000f-000f */
	} Nv004bNotification;
#define NV004B_NOTIFIERS_NOTIFY                                             (0)
#define NV004B_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV004B_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV03_GDI_RECTANGLE_TEXT          0000-0003 */
		NvV32               status;	/* returns NV004B_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv004bAllocParameters;
#define NV004B_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV004B_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV004B_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV004B_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_GDI_RECTANGLE_TEXT instance 0000-0003 */
		NvV32               status;	/* returns NV004B_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv004bFreeParameters;
#define NV004B_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV004B_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_GDI_RECTANGLE_TEXT instance 0000-0003 */
		NvV32               status;	/* returns NV004B_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv004bControlParameters;
#define NV004B_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV004B_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextPattern;	/* NV01_CONTEXT_PATTERN             0184-0187 */
		NvV32               SetContextRop;	/* NV03_CONTEXT_ROP                 0188-018b */
		NvV32               SetContextBeta1;	/* NV01_CONTEXT_BETA1               018c-018f */
		NvV32               SetContextSurface;	/* NV03_CONTEXT_SURFACES_2D         0190-0193 */
		NvV32               Reserved01[0x05a];
		NvV32               SetOperation;	/* NV004B_SET_OPERATION_*           02fc-02ff */
		NvV32               SetColorFormat;	/* NV004B_SET_COLOR_FORMAT_*        0300-0303 */
		NvV32               SetMonochromeFormat;	/* NV004B_SET_MONOCHROME_FORMAT_*   0304-0307 */
		NvV32               Reserved02[0x03d];
		NvV32               Color1A;	/* rectangle color                  03fc-03ff */
		struct
		{		/* start aliased methods in array   0400-    */
			NvV32               point;	/* x_y S16_S16 in pixels               0-   3 */
			NvV32               size;	/* width_height U16_U16 in pixels      4-   7 */
		} UnclippedRectangle[64];	/* end of aliased methods in array      -05ff */
		NvV32               Reserved03[0x07D];
		NvV32               ClipPoint0B;	/* top_left S16_S16 in pixels       07f4-07f7 */
		NvV32               ClipPoint1B;	/* bottom_right S16_S16 in pixels   07f8-07fb */
		NvV32               Color1B;	/* rectangle color                  07fc-07ff */
		struct
		{		/* start aliased methods in array   0800-    */
			NvV32               point0;	/* top_left S16_S16 in pixels          0-   3 */
			NvV32               point1;	/* bottom_right S16_S16 in pixels      4-   7 */
		} ClippedRectangle[64];	/* end of aliased methods in array      -09ff */
		NvV32               Reserved04[0x07B];
		NvV32               ClipPoint0C;	/* top_left S16_S16 in pixels       0bec-0bef */
		NvV32               ClipPoint1C;	/* bottom_right S16_S16 in pixels   0bf0-0bf3 */
		NvV32               Color1C;	/* color of 1 pixels                0bf4-0bf7 */
		NvV32               SizeC;	/* height_width U16_U16 in pixels   0bf8-0bfb */
		NvV32               PointC;	/* y_x S16_S16 in pixels            0bfc-0bff */
		NvV32               MonochromeColor1C[128];	/* 32 monochrome pixels per write   0c00-0dff */
		NvV32               Reserved05[0x07A];
		NvV32               ClipPoint0D;	/* top_left S16_S16 in pixels       0fe8-0feb */
		NvV32               ClipPoint1D;	/* bottom_right S16_S16 in pixels   0fec-0fef */
		NvV32               Color1D;	/* color of 1 pixels                0ff0-0ff3 */
		NvV32               SizeInD;	/* height_width U16_U16 in pixels   0ff4-0ff7 */
		NvV32               SizeOutD;	/* height_width U16_U16 in pixels   0ff8-0ffb */
		NvV32               PointD;	/* y_x S16_S16 in pixels            0ffc-0fff */
		NvV32               MonochromeColor1D[128];	/* 32 monochrome pixels per write   1000-11ff */
		NvV32               Reserved06[0x079];
		NvV32               ClipPoint0E;	/* top_left S16_S16 in pixels       13e4-13e7 */
		NvV32               ClipPoint1E;	/* bottom_right S16_S16 in pixels   13e8-13eb */
		NvV32               Color0E;	/* color of 0 pixels                13ec-13ef */
		NvV32               Color1E;	/* color of 1 pixels                13f0-13f3 */
		NvV32               SizeInE;	/* height_width U16_U16 in pixels   13f4-13f7 */
		NvV32               SizeOutE;	/* height_width U16_U16 in pixels   13f8-13fb */
		NvV32               PointE;	/* y_x S16_S16 in pixels            13fc-13ff */
		NvV32               MonochromeColor01E[128];	/* 32 monochrome pixels per write   1400-15ff */
		NvV32               Reserved07[0x280];
	} Nv004bTypedef    , Nv03GdiRectangleText;
#define NV004B_TYPEDEF                                     nv03GdiRectangleText
/* method offsets, fields, and values */
#define NV004B_NO_OPERATION                                        (0x00000100)
#define NV004B_NOTIFY                                              (0x00000104)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_2                     (0x00000002)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_3                     (0x00000003)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_4                     (0x00000004)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_5                     (0x00000005)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_6                     (0x00000006)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_7                     (0x00000007)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_8                     (0x00000008)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_9                     (0x00000009)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_A                     (0x0000000A)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_B                     (0x0000000B)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_C                     (0x0000000C)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_D                     (0x0000000D)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_E                     (0x0000000E)
#define NV004B_NOTIFY_WRITE_LE_NOTIFY_AWAKEN_F                     (0x0000000F)
#define NV004B_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV004B_SET_CONTEXT_PATTERN                                 (0x00000184)
#define NV004B_SET_CONTEXT_ROP                                     (0x00000188)
#define NV004B_SET_CONTEXT_BETA1                                   (0x0000018C)
#define NV004B_SET_CONTEXT_SURFACE                                 (0x00000190)
#define NV004B_SET_OPERATION                                       (0x000002FC)
#define NV004B_SET_OPERATION_SRCCOPY_AND                           (0x00000000)
#define NV004B_SET_OPERATION_ROP_AND                               (0x00000001)
#define NV004B_SET_OPERATION_BLEND_AND                             (0x00000002)
#define NV004B_SET_COLOR_FORMAT                                    (0x00000300)
#define NV004B_SET_COLOR_FORMAT_NE32_X24Y8                         (0x00000001)
#define NV004B_SET_COLOR_FORMAT_NE32_X17R5G5B5                     (0x00000002)
#define NV004B_SET_COLOR_FORMAT_NE32_X8R8G8B8                      (0x00000003)
#define NV004B_SET_MONOCHROME_FORMAT                               (0x00000304)
#define NV004B_SET_MONOCHROME_FORMAT_BEI1                          (0x00000001)
#define NV004B_SET_MONOCHROME_FORMAT_LEI1                          (0x00000002)
#define NV004B_COLOR1_A                                            (0x000003FC)
#define NV004B_UNCLIPPED_RECTANGLE(a)                              (0x00000400\
                                                                   +(a)*0x0008)
#define NV004B_UNCLIPPED_RECTANGLE_POINT(a)                        (0x00000400\
                                                                   +(a)*0x0008)
#define NV004B_UNCLIPPED_RECTANGLE_POINT_Y                                 15:0
#define NV004B_UNCLIPPED_RECTANGLE_POINT_X                                31:16
#define NV004B_UNCLIPPED_RECTANGLE_SIZE(a)                         (0x00000404\
                                                                   +(a)*0x0008)
#define NV004B_UNCLIPPED_RECTANGLE_SIZE_HEIGHT                             15:0
#define NV004B_UNCLIPPED_RECTANGLE_SIZE_WIDTH                             31:16
#define NV004B_CLIP_POINT0_B                                       (0x000007F4)
#define NV004B_CLIP_POINT0_B_LEFT                                          15:0
#define NV004B_CLIP_POINT0_B_TOP                                          31:16
#define NV004B_CLIP_POINT1_B                                       (0x000007F8)
#define NV004B_CLIP_POINT1_B_RIGHT                                         15:0
#define NV004B_CLIP_POINT1_B_BOTTOM                                       31:16
#define NV004B_COLOR1_B                                            (0x000007FC)
#define NV004B_CLIPPED_RECTANGLE(a)                                (0x00000800\
                                                                   +(a)*0x0008)
#define NV004B_CLIPPED_RECTANGLE_POINT0(a)                         (0x00000800\
                                                                   +(a)*0x0008)
#define NV004B_CLIPPED_RECTANGLE_POINT0_LEFT                               15:0
#define NV004B_CLIPPED_RECTANGLE_POINT0_TOP                               31:16
#define NV004B_CLIPPED_RECTANGLE_POINT1(a)                         (0x00000804\
                                                                   +(a)*0x0008)
#define NV004B_CLIPPED_RECTANGLE_POINT1_RIGHT                              15:0
#define NV004B_CLIPPED_RECTANGLE_POINT1_BOTTOM                            31:16
#define NV004B_CLIP_POINT0_C                                       (0x00000BEC)
#define NV004B_CLIP_POINT0_C_LEFT                                          15:0
#define NV004B_CLIP_POINT0_C_TOP                                          31:16
#define NV004B_CLIP_POINT1_C                                       (0x00000BF0)
#define NV004B_CLIP_POINT1_C_RIGHT                                         15:0
#define NV004B_CLIP_POINT1_C_BOTTOM                                       31:16
#define NV004B_COLOR1_C                                            (0x00000BF4)
#define NV004B_SIZE_C                                              (0x00000BF8)
#define NV004B_SIZE_C_WIDTH                                                15:0
#define NV004B_SIZE_C_HEIGHT                                              31:16
#define NV004B_POINT_C                                             (0x00000BFC)
#define NV004B_POINT_C_X                                                   15:0
#define NV004B_POINT_C_Y                                                  31:16
#define NV004B_MONOCHROME_COLOR1_C(a)                              (0x00000C00\
                                                                   +(a)*0x0004)
#define NV004B_CLIP_POINT0_D                                       (0x00000FE8)
#define NV004B_CLIP_POINT0_D_LEFT                                          15:0
#define NV004B_CLIP_POINT0_D_TOP                                          31:16
#define NV004B_CLIP_POINT1_D                                       (0x00000FEC)
#define NV004B_CLIP_POINT1_D_RIGHT                                         15:0
#define NV004B_CLIP_POINT1_D_BOTTOM                                       31:16
#define NV004B_COLOR1_D                                            (0x00000FF0)
#define NV004B_SIZE_IN_D                                           (0x00000FF4)
#define NV004B_SIZE_IN_D_WIDTH                                             15:0
#define NV004B_SIZE_IN_D_HEIGHT                                           31:16
#define NV004B_SIZE_OUT_D                                          (0x00000FF8)
#define NV004B_SIZE_OUT_D_WIDTH                                            15:0
#define NV004B_SIZE_OUT_D_HEIGHT                                          31:16
#define NV004B_POINT_D                                             (0x00000FFC)
#define NV004B_POINT_D_X                                                   15:0
#define NV004B_POINT_D_Y                                                  31:16
#define NV004B_MONOCHROME_COLOR1_D(a)                              (0x00001000\
                                                                   +(a)*0x0004)
#define NV004B_CLIP_POINT0_E                                       (0x000013E4)
#define NV004B_CLIP_POINT0_E_LEFT                                          15:0
#define NV004B_CLIP_POINT0_E_TOP                                          31:16
#define NV004B_CLIP_POINT1_E                                       (0x000013E8)
#define NV004B_CLIP_POINT1_E_RIGHT                                         15:0
#define NV004B_CLIP_POINT1_E_BOTTOM                                       31:16
#define NV004B_COLOR0_E                                            (0x000013EC)
#define NV004B_COLOR1_E                                            (0x000013F0)
#define NV004B_SIZE_IN_E                                           (0x000013F4)
#define NV004B_SIZE_IN_E_WIDTH                                             15:0
#define NV004B_SIZE_IN_E_HEIGHT                                           31:16
#define NV004B_SIZE_OUT_E                                          (0x000013F8)
#define NV004B_SIZE_OUT_E_WIDTH                                            15:0
#define NV004B_SIZE_OUT_E_HEIGHT                                          31:16
#define NV004B_POINT_E                                             (0x000013FC)
#define NV004B_POINT_E_X                                                   15:0
#define NV004B_POINT_E_Y                                                  31:16
#define NV004B_MONOCHROME_COLOR01_E(a)                             (0x00001400\
                                                                   +(a)*0x0004)

	typedef NvV32       Nv004cTypedef;

	typedef NvV32       Nv004dTypedef;

	typedef NvV32       Nv004eTypedef;

	typedef NvV32       Nv004fTypedef;

	typedef NvV32       Nv0050Typedef;

	typedef NvV32       Nv0051Typedef;

	typedef NvV32       Nv0052Typedef;


/* class NV04_CONTEXT_SURFACES_3D */
#define  NV04_CONTEXT_SURFACES_3D                                  (0x00000053)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0053_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0053Notification;
#define NV0053_NOTIFIERS_NOTIFY                                             (0)
#define NV0053_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0053_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV04_CONTEXT_SURFACES_3D         0000-0003 */
		NvV32               status;	/* returns NV0053_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0053AllocParameters;
#define NV0053_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0053_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0053_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0053_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV04_CONTEXT_SURFACES_3D instanc 0000-0003 */
		NvV32               status;	/* returns NV0053_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0053FreeParameters;
#define NV0053_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0053_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV04_CONTEXT_SURFACES_3D instanc 0000-0003 */
		NvV32               status;	/* returns NV0053_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0053ControlParameters;
#define NV0053_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV0053_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextDmaColor;	/* NV01_CONTEXT_DMA                 0184-0187 */
		NvV32               SetContextDmaZeta;	/* NV01_CONTEXT_DMA                 0188-018b */
		NvV32               Reserved01[0x05b];
		NvV32               SetClipHorizontal;	/* width_x U16_U16                  02f8-02fb */
		NvV32               SetClipVertical;	/* height_y U16_U16                 02fc-02ff */
		NvV32               SetFormat;	/* height_width_type_color all V8   0300-0303 */
		NvV32               SetClipSize;	/* height_width U16_U16             0304-0307 */
		NvV32               SetPitch;	/* zeta_color U16_U16               0308-030b */
		NvU32               SetOffsetColor;	/* byte offset of top-left pixel    030c-030f */
		NvU32               SetOffsetZeta;	/* byte offset of top-left pixel    0310-0313 */
		NvV32               Reserved02[0x73b];
	} Nv0053Typedef    , Nv04ContextSurfaces3d;
#define NV0053_TYPEDEF                                    nv04ContextSurfaces3d
/* method offsets, fields, and values */
#define NV0053_NO_OPERATION                                        (0x00000100)
#define NV0053_NOTIFY                                              (0x00000104)
#define NV0053_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV0053_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV0053_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0053_SET_CONTEXT_DMA_COLOR                               (0x00000184)
#define NV0053_SET_CONTEXT_DMA_ZETA                                (0x00000188)
#define NV0053_SET_CLIP_HORIZONTAL                                 (0x000002F8)
#define NV0053_SET_CLIP_HORIZONTAL_X                                       15:0
#define NV0053_SET_CLIP_HORIZONTAL_WIDTH                                  31:16
#define NV0053_SET_CLIP_VERTICAL                                   (0x000002FC)
#define NV0053_SET_CLIP_VERTICAL_Y                                         15:0
#define NV0053_SET_CLIP_VERTICAL_HEIGHT                                   31:16
#define NV0053_SET_FORMAT                                          (0x00000300)
#define NV0053_SET_FORMAT_COLOR                                             7:0
#define NV0053_SET_FORMAT_COLOR_X1R5G5B5_Z1R5G5B5                  (0x00000001)
#define NV0053_SET_FORMAT_COLOR_X1R5G5B5_O1R5G5B5                  (0x00000002)
#define NV0053_SET_FORMAT_COLOR_R5G6B5                             (0x00000003)
#define NV0053_SET_FORMAT_COLOR_X8R8G8B8_Z8R8G8B8                  (0x00000004)
#define NV0053_SET_FORMAT_COLOR_X8R8G8B8_O8R8G8B8                  (0x00000005)
#define NV0053_SET_FORMAT_COLOR_X1A7R8G8B8_Z1A7R8G8B8              (0x00000006)
#define NV0053_SET_FORMAT_COLOR_X1A7R8G8B8_O1A7R8G8B8              (0x00000007)
#define NV0053_SET_FORMAT_COLOR_A8R8G8B8                           (0x00000008)
#define NV0053_SET_FORMAT_TYPE                                             15:8
#define NV0053_SET_FORMAT_TYPE_PITCH                               (0x00000001)
#define NV0053_SET_FORMAT_TYPE_SWIZZLE                             (0x00000002)
#define NV0053_SET_FORMAT_WIDTH                                           23:16
#define NV0053_SET_FORMAT_HEIGHT                                          31:24
#define NV0053_SET_CLIP_SIZE                                       (0x00000304)
#define NV0053_SET_CLIP_SIZE_WIDTH                                         15:0
#define NV0053_SET_CLIP_SIZE_HEIGHT                                       31:16
#define NV0053_SET_PITCH                                           (0x00000308)
#define NV0053_SET_PITCH_COLOR                                             15:0
#define NV0053_SET_PITCH_ZETA                                             31:16
#define NV0053_SET_OFFSET_COLOR                                    (0x0000030C)
#define NV0053_SET_OFFSET_ZETA                                     (0x00000310)


/* class NV04_DX5_TEXTURED_TRIANGLE */
#define  NV04_DX5_TEXTURED_TRIANGLE                                (0x00000054)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0054_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0054Notification;
#define NV0054_NOTIFIERS_NOTIFY                                             (0)
#define NV0054_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0054_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV04_DX5_TEXTURED_TRIANGLE       0000-0003 */
		NvV32               status;	/* returns NV0054_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0054AllocParameters;
#define NV0054_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0054_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0054_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0054_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV04_DX5_TEXTURED_TRIANGLE insta 0000-0003 */
		NvV32               status;	/* returns NV0054_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0054FreeParameters;
#define NV0054_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0054_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV04_DX5_TEXTURED_TRIANGLE insta 0000-0003 */
		NvV32               status;	/* returns NV0054_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0054ControlParameters;
#define NV0054_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               NoOperation;	/* ignored                          0100-0103 */
		NvV32               Notify;	/* NV0054_NOTIFY_*                  0104-0107 */
		NvV32               Reserved00[0x01e];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextDmaA;	/* NV01_CONTEXT_DMA                 0184-0187 */
		NvV32               SetContextDmaB;	/* NV01_CONTEXT_DMA                 0188-018b */
		NvV32               SetContextSurfaces;	/* NV04_CONTEXT_SURFACES_3D         018c-018f */
		NvV32               Reserved01[0x05c];
		NvV32               ColorKeyValue;	/* see text                         0300-0303 */
		NvU32               TextureOffset;	/* texture offset in bytes          0304-0307 */
		NvV32               TextureFormat;	/* see text                         0308-030b */
		NvV32               TextureFilter;	/* see text                         030c-030f */
		NvV32               Blend;	/* see text                         0310-0313 */
		NvV32               Control;	/* see text                         0314-0317 */
		NvV32               FogColor;	/* X8R8G8B8 fog color               0318-031b */
		NvV32               Reserved02[0x039];
		struct
		{		/* start of methods in array        0400-    */
			NvF32               sx;	/* screen x coordinate                00-  03 */
			NvF32               sy;	/* screen y coordinate                04-  07 */
			NvF32               sz;	/* screen z coordinate                08-  0b */
			NvF32               rhw;	/* reciprocal homogeneous W (1/W)     0c-  0f */
			NvV32               color;	/* A8R8G8B8                           10-  13 */
			NvV32               specular;	/* F8R8G8B8                           14-  17 */
			NvF32               tu;	/* texture u coordinate               18-  1b */
			NvF32               tv;	/* texture v coordinate               1c-  1f */
		} Tlvertex[16];	/* end of methods in array              -05ff */
		NvV32               DrawPrimitive[64];	/* see text                         0600-06ff */
		NvV32               Reserved03[0x640];
	} Nv0054Typedef    , Nv04Dx5TexturedTriangle;
#define NV0054_TYPEDEF                                  nv04Dx5TexturedTriangle
/* method offsets, fields, and values */
#define NV0054_NO_OPERATION                                        (0x00000100)
#define NV0054_NOTIFY                                              (0x00000104)
#define NV0054_NOTIFY_WRITE_LE_NOTIFY                              (0x00000000)
#define NV0054_NOTIFY_WRITE_LE_NOTIFY_AWAKEN                       (0x00000001)
#define NV0054_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0054_SET_CONTEXT_DMA_A                                   (0x00000184)
#define NV0054_SET_CONTEXT_DMA_B                                   (0x00000188)
#define NV0054_SET_CONTEXT_SURFACES                                (0x0000018C)
#define NV0054_COLOR_KEY_VALUE                                     (0x00000300)
#define NV0054_TEXTURE_OFFSET                                      (0x00000304)
#define NV0054_TEXTURE_FORMAT                                      (0x00000308)
#define NV0054_TEXTURE_FORMAT_CONTEXT_DMA                                   1:0
#define NV0054_TEXTURE_FORMAT_CONTEXT_DMA_A                        (0x00000001)
#define NV0054_TEXTURE_FORMAT_CONTEXT_DMA_B                        (0x00000002)
#define NV0054_TEXTURE_FORMAT_COLOR_KEY_MATCH                               3:2
#define NV0054_TEXTURE_FORMAT_COLOR_KEY_MATCH_SRCCOPY              (0x00000000)
#define NV0054_TEXTURE_FORMAT_COLOR_KEY_MATCH_ZERO_ALPHA           (0x00000001)
#define NV0054_TEXTURE_FORMAT_ORIGIN_ZOH                                    5:4
#define NV0054_TEXTURE_FORMAT_ORIGIN_ZOH_CENTER                    (0x00000001)
#define NV0054_TEXTURE_FORMAT_ORIGIN_ZOH_CORNER                    (0x00000002)
#define NV0054_TEXTURE_FORMAT_ORIGIN_FOH                                    7:6
#define NV0054_TEXTURE_FORMAT_ORIGIN_FOH_CENTER                    (0x00000001)
#define NV0054_TEXTURE_FORMAT_ORIGIN_FOH_CORNER                    (0x00000002)
#define NV0054_TEXTURE_FORMAT_COLOR                                        11:8
#define NV0054_TEXTURE_FORMAT_COLOR_NE_Y8                          (0x00000001)
#define NV0054_TEXTURE_FORMAT_COLOR_LE_A1R5G5B5                    (0x00000002)
#define NV0054_TEXTURE_FORMAT_COLOR_LE_X1R5G5B5                    (0x00000003)
#define NV0054_TEXTURE_FORMAT_COLOR_LE_A4R4G4B4                    (0x00000004)
#define NV0054_TEXTURE_FORMAT_COLOR_LE_R5G6B5                      (0x00000005)
#define NV0054_TEXTURE_FORMAT_COLOR_LE_A8R8G8B8                    (0x00000006)
#define NV0054_TEXTURE_FORMAT_COLOR_LE_X8R8G8B8                    (0x00000007)
#define NV0054_TEXTURE_FORMAT_MIPMAP_LEVELS                               15:12
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U                                 19:16
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_1                        (0x00000000)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_2                        (0x00000001)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_4                        (0x00000002)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_8                        (0x00000003)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_16                       (0x00000004)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_32                       (0x00000005)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_64                       (0x00000006)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_128                      (0x00000007)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_256                      (0x00000008)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_512                      (0x00000009)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_1024                     (0x0000000A)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_U_2048                     (0x0000000B)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V                                 23:20
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_1                        (0x00000000)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_2                        (0x00000001)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_4                        (0x00000002)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_8                        (0x00000003)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_16                       (0x00000004)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_32                       (0x00000005)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_64                       (0x00000006)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_128                      (0x00000007)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_256                      (0x00000008)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_512                      (0x00000009)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_1024                     (0x0000000A)
#define NV0054_TEXTURE_FORMAT_BASE_SIZE_V_2048                     (0x0000000B)
#define NV0054_TEXTURE_FORMAT_TEXTUREADDRESSU                             26:24
#define NV0054_TEXTURE_FORMAT_TEXTUREADDRESSU_WRAP                 (0x00000001)
#define NV0054_TEXTURE_FORMAT_TEXTUREADDRESSU_MIRROR               (0x00000002)
#define NV0054_TEXTURE_FORMAT_TEXTUREADDRESSU_CLAMP                (0x00000003)
#define NV0054_TEXTURE_FORMAT_TEXTUREADDRESSU_CLAMP_4              (0x00000004)
#define NV0054_TEXTURE_FORMAT_WRAPU                                       27:27
#define NV0054_TEXTURE_FORMAT_WRAPU_FALSE                          (0x00000000)
#define NV0054_TEXTURE_FORMAT_WRAPU_TRUE                           (0x00000001)
#define NV0054_TEXTURE_FORMAT_TEXTUREADDRESSV                             30:28
#define NV0054_TEXTURE_FORMAT_TEXTUREADDRESSV_WRAP                 (0x00000001)
#define NV0054_TEXTURE_FORMAT_TEXTUREADDRESSV_MIRROR               (0x00000002)
#define NV0054_TEXTURE_FORMAT_TEXTUREADDRESSV_CLAMP                (0x00000003)
#define NV0054_TEXTURE_FORMAT_TEXTUREADDRESSV_CLAMP_4              (0x00000004)
#define NV0054_TEXTURE_FORMAT_WRAPV                                       31:31
#define NV0054_TEXTURE_FORMAT_WRAPV_FALSE                          (0x00000000)
#define NV0054_TEXTURE_FORMAT_WRAPV_TRUE                           (0x00000001)
#define NV0054_TEXTURE_FILTER                                      (0x0000030C)
#define NV0054_TEXTURE_FILTER_KERNEL_SIZE_X                                 7:0
#define NV0054_TEXTURE_FILTER_KERNEL_SIZE_Y                                14:8
#define NV0054_TEXTURE_FILTER_MIPMAP_DITHER_ENABLE                        15:15
#define NV0054_TEXTURE_FILTER_MIPMAP_DITHER_ENABLE_FALSE           (0x00000000)
#define NV0054_TEXTURE_FILTER_MIPMAP_DITHER_ENABLE_TRUE            (0x00000001)
#define NV0054_TEXTURE_FILTER_MIPMAPLODBIAS                               23:16
#define NV0054_TEXTURE_FILTER_TEXTUREMIN                                  26:24
#define NV0054_TEXTURE_FILTER_TEXTUREMIN_NEAREST                   (0x00000001)
#define NV0054_TEXTURE_FILTER_TEXTUREMIN_LINEAR                    (0x00000002)
#define NV0054_TEXTURE_FILTER_TEXTUREMIN_MIPNEAREST                (0x00000003)
#define NV0054_TEXTURE_FILTER_TEXTUREMIN_MIPLINEAR                 (0x00000004)
#define NV0054_TEXTURE_FILTER_TEXTUREMIN_LINEARMIPNEAREST          (0x00000005)
#define NV0054_TEXTURE_FILTER_TEXTUREMIN_LINEARMIPLINEAR           (0x00000006)
#define NV0054_TEXTURE_FILTER_ANISOTROPIC_MINIFY_ENABLE                   27:27
#define NV0054_TEXTURE_FILTER_ANISOTROPIC_MINIFY_ENABLE_FALSE      (0x00000000)
#define NV0054_TEXTURE_FILTER_ANISOTROPIC_MINIFY_ENABLE_TRUE       (0x00000001)
#define NV0054_TEXTURE_FILTER_TEXTUREMAG                                  30:28
#define NV0054_TEXTURE_FILTER_TEXTUREMAG_NEAREST                   (0x00000001)
#define NV0054_TEXTURE_FILTER_TEXTUREMAG_LINEAR                    (0x00000002)
#define NV0054_TEXTURE_FILTER_TEXTUREMAG_NEAREST_3                 (0x00000003)
#define NV0054_TEXTURE_FILTER_TEXTUREMAG_LINEAR_4                  (0x00000004)
#define NV0054_TEXTURE_FILTER_TEXTUREMAG_NEAREST_5                 (0x00000005)
#define NV0054_TEXTURE_FILTER_TEXTUREMAG_LINEAR_6                  (0x00000006)
#define NV0054_TEXTURE_FILTER_TEXTUREMAG_MIPNEAREST                (0x00000003)
#define NV0054_TEXTURE_FILTER_TEXTUREMAG_MIPLINEAR                 (0x00000004)
#define NV0054_TEXTURE_FILTER_TEXTUREMAG_LINEARMIPNEAREST          (0x00000005)
#define NV0054_TEXTURE_FILTER_TEXTUREMAG_LINEARMIPLINEAR           (0x00000006)
#define NV0054_TEXTURE_FILTER_ANISOTROPIC_MAGNIFY_ENABLE                  31:31
#define NV0054_TEXTURE_FILTER_ANISOTROPIC_MAGNIFY_ENABLE_FALSE     (0x00000000)
#define NV0054_TEXTURE_FILTER_ANISOTROPIC_MAGNIFY_ENABLE_TRUE      (0x00000001)
#define NV0054_BLEND                                               (0x00000310)
#define NV0054_BLEND_TEXTUREMAPBLEND                                        3:0
#define NV0054_BLEND_TEXTUREMAPBLEND_DECAL                         (0x00000001)
#define NV0054_BLEND_TEXTUREMAPBLEND_MODULATE                      (0x00000002)
#define NV0054_BLEND_TEXTUREMAPBLEND_DECALALPHA                    (0x00000003)
#define NV0054_BLEND_TEXTUREMAPBLEND_MODULATEALPHA                 (0x00000004)
#define NV0054_BLEND_TEXTUREMAPBLEND_DECALMASK                     (0x00000005)
#define NV0054_BLEND_TEXTUREMAPBLEND_MODULATEMASK                  (0x00000006)
#define NV0054_BLEND_TEXTUREMAPBLEND_COPY                          (0x00000007)
#define NV0054_BLEND_TEXTUREMAPBLEND_ADD                           (0x00000008)
#define NV0054_BLEND_MASK_BIT                                               5:4
#define NV0054_BLEND_MASK_BIT_LSB                                  (0x00000001)
#define NV0054_BLEND_MASK_BIT_MSB                                  (0x00000002)
#define NV0054_BLEND_SHADEMODE                                              7:6
#define NV0054_BLEND_SHADEMODE_FLAT                                (0x00000001)
#define NV0054_BLEND_SHADEMODE_GOURAUD                             (0x00000002)
#define NV0054_BLEND_SHADEMODE_GOURAUD_3                           (0x00000003)
#define NV0054_BLEND_TEXTUREPERSPECTIVE                                    11:8
#define NV0054_BLEND_TEXTUREPERSPECTIVE_FALSE                      (0x00000000)
#define NV0054_BLEND_TEXTUREPERSPECTIVE_TRUE                       (0x00000001)
#define NV0054_BLEND_SPECULARENABLE                                       15:12
#define NV0054_BLEND_SPECULARENABLE_FALSE                          (0x00000000)
#define NV0054_BLEND_SPECULARENABLE_TRUE                           (0x00000001)
#define NV0054_BLEND_FOGENABLE                                            19:16
#define NV0054_BLEND_FOGENABLE_FALSE                               (0x00000000)
#define NV0054_BLEND_FOGENABLE_TRUE                                (0x00000001)
#define NV0054_BLEND_ALPHABLENDENABLE                                     23:20
#define NV0054_BLEND_ALPHABLENDENABLE_FALSE                        (0x00000000)
#define NV0054_BLEND_ALPHABLENDENABLE_TRUE                         (0x00000001)
#define NV0054_BLEND_SRCBLEND                                             27:24
#define NV0054_BLEND_SRCBLEND_ZERO                                 (0x00000001)
#define NV0054_BLEND_SRCBLEND_ONE                                  (0x00000002)
#define NV0054_BLEND_SRCBLEND_SRCCOLOR                             (0x00000003)
#define NV0054_BLEND_SRCBLEND_INVSRCCOLOR                          (0x00000004)
#define NV0054_BLEND_SRCBLEND_SRCALPHA                             (0x00000005)
#define NV0054_BLEND_SRCBLEND_INVSRCALPHA                          (0x00000006)
#define NV0054_BLEND_SRCBLEND_DESTALPHA                            (0x00000007)
#define NV0054_BLEND_SRCBLEND_INVDESTALPHA                         (0x00000008)
#define NV0054_BLEND_SRCBLEND_DESTCOLOR                            (0x00000009)
#define NV0054_BLEND_SRCBLEND_INVDESTCOLOR                         (0x0000000A)
#define NV0054_BLEND_SRCBLEND_SRCALPHASAT                          (0x0000000B)
#define NV0054_BLEND_DESTBLEND                                            31:28
#define NV0054_BLEND_DESTBLEND_ZERO                                (0x00000001)
#define NV0054_BLEND_DESTBLEND_ONE                                 (0x00000002)
#define NV0054_BLEND_DESTBLEND_SRCCOLOR                            (0x00000003)
#define NV0054_BLEND_DESTBLEND_INVSRCCOLOR                         (0x00000004)
#define NV0054_BLEND_DESTBLEND_SRCALPHA                            (0x00000005)
#define NV0054_BLEND_DESTBLEND_INVSRCALPHA                         (0x00000006)
#define NV0054_BLEND_DESTBLEND_DESTALPHA                           (0x00000007)
#define NV0054_BLEND_DESTBLEND_INVDESTALPHA                        (0x00000008)
#define NV0054_BLEND_DESTBLEND_DESTCOLOR                           (0x00000009)
#define NV0054_BLEND_DESTBLEND_INVDESTCOLOR                        (0x0000000A)
#define NV0054_BLEND_DESTBLEND_SRCALPHASAT                         (0x0000000B)
#define NV0054_CONTROL                                             (0x00000314)
#define NV0054_CONTROL_ALPHAREF                                             7:0
#define NV0054_CONTROL_ALPHAFUNC                                           11:8
#define NV0054_CONTROL_ALPHAFUNC_NEVER                             (0x00000001)
#define NV0054_CONTROL_ALPHAFUNC_LESS                              (0x00000002)
#define NV0054_CONTROL_ALPHAFUNC_EQUAL                             (0x00000003)
#define NV0054_CONTROL_ALPHAFUNC_LESSEQUAL                         (0x00000004)
#define NV0054_CONTROL_ALPHAFUNC_GREATER                           (0x00000005)
#define NV0054_CONTROL_ALPHAFUNC_NOTEQUAL                          (0x00000006)
#define NV0054_CONTROL_ALPHAFUNC_GREATEREQUAL                      (0x00000007)
#define NV0054_CONTROL_ALPHAFUNC_ALWAYS                            (0x00000008)
#define NV0054_CONTROL_ALPHATESTENABLE                                    12:12
#define NV0054_CONTROL_ALPHATESTENABLE_FALSE                       (0x00000000)
#define NV0054_CONTROL_ALPHATESTENABLE_TRUE                        (0x00000001)
#define NV0054_CONTROL_ORIGIN                                             13:13
#define NV0054_CONTROL_ORIGIN_CENTER                               (0x00000000)
#define NV0054_CONTROL_ORIGIN_CORNER                               (0x00000001)
#define NV0054_CONTROL_ZENABLE                                            15:14
#define NV0054_CONTROL_ZENABLE_FALSE                               (0x00000000)
#define NV0054_CONTROL_ZENABLE_TRUE                                (0x00000001)
#define NV0054_CONTROL_ZFUNC                                              19:16
#define NV0054_CONTROL_ZFUNC_NEVER                                 (0x00000001)
#define NV0054_CONTROL_ZFUNC_LESS                                  (0x00000002)
#define NV0054_CONTROL_ZFUNC_EQUAL                                 (0x00000003)
#define NV0054_CONTROL_ZFUNC_LESSEQUAL                             (0x00000004)
#define NV0054_CONTROL_ZFUNC_GREATER                               (0x00000005)
#define NV0054_CONTROL_ZFUNC_NOTEQUAL                              (0x00000006)
#define NV0054_CONTROL_ZFUNC_GREATEREQUAL                          (0x00000007)
#define NV0054_CONTROL_ZFUNC_ALWAYS                                (0x00000008)
#define NV0054_CONTROL_CULLMODE                                           21:20
#define NV0054_CONTROL_CULLMODE_NONE                               (0x00000001)
#define NV0054_CONTROL_CULLMODE_CW                                 (0x00000002)
#define NV0054_CONTROL_CULLMODE_CCW                                (0x00000003)
#define NV0054_CONTROL_DITHERENABLE                                       22:22
#define NV0054_CONTROL_DITHERENABLE_FALSE                          (0x00000000)
#define NV0054_CONTROL_DITHERENABLE_TRUE                           (0x00000001)
#define NV0054_CONTROL_Z_PERSPECTIVE_ENABLE                               23:23
#define NV0054_CONTROL_Z_PERSPECTIVE_ENABLE_FALSE                  (0x00000000)
#define NV0054_CONTROL_Z_PERSPECTIVE_ENABLE_TRUE                   (0x00000001)
#define NV0054_CONTROL_ZWRITEENABLE                                       29:24
#define NV0054_CONTROL_ZWRITEENABLE_FALSE                          (0x00000000)
#define NV0054_CONTROL_ZWRITEENABLE_TRUE                           (0x00000001)
#define NV0054_CONTROL_Z_FORMAT                                           31:30
#define NV0054_CONTROL_Z_FORMAT_FIXED                              (0x00000001)
#define NV0054_CONTROL_Z_FORMAT_FLOAT                              (0x00000002)
#define NV0054_FOG_COLOR                                           (0x00000318)
#define NV0054_TLVERTEX(i)                                         (0x00000400\
                                                                   +(i)*0x0020)
#define NV0054_TLVERTEX_SX(i)                                      (0x00000400\
                                                                   +(i)*0x0020)
#define NV0054_TLVERTEX_SY(i)                                      (0x00000404\
                                                                   +(i)*0x0020)
#define NV0054_TLVERTEX_SZ(i)                                      (0x00000408\
                                                                   +(i)*0x0020)
#define NV0054_TLVERTEX_RHW(i)                                     (0x0000040C\
                                                                   +(i)*0x0020)
#define NV0054_TLVERTEX_COLOR(i)                                   (0x00000410\
                                                                   +(i)*0x0020)
#define NV0054_TLVERTEX_SPECULAR(i)                                (0x00000414\
                                                                   +(i)*0x0020)
#define NV0054_TLVERTEX_SPECULAR_BLUE                                       7:0
#define NV0054_TLVERTEX_SPECULAR_GREEN                                     15:8
#define NV0054_TLVERTEX_SPECULAR_RED                                      23:16
#define NV0054_TLVERTEX_SPECULAR_FOG                                      31:24
#define NV0054_TLVERTEX_TU(i)                                      (0x00000418\
                                                                   +(i)*0x0020)
#define NV0054_TLVERTEX_TV(i)                                      (0x0000041C\
                                                                   +(i)*0x0020)
#define NV0054_DRAW_PRIMITIVE(a)                                   (0x00000600\
                                                                   +(a)*0x0004)
#define NV0054_DRAW_PRIMITIVE_I0                                            3:0
#define NV0054_DRAW_PRIMITIVE_I1                                            7:4
#define NV0054_DRAW_PRIMITIVE_I2                                           11:8
#define NV0054_DRAW_PRIMITIVE_I3                                          15:12
#define NV0054_DRAW_PRIMITIVE_I4                                          19:16
#define NV0054_DRAW_PRIMITIVE_I5                                          31:20

	typedef NvV32       Nv0055Typedef;


	typedef NvV32       Nv0056Typedef;

	typedef NvV32       Nv0057Typedef;


/* class NV03_CONTEXT_SURFACES_2D */
#define  NV03_CONTEXT_SURFACES_2D                                  (0x00000058)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV0058_NOTIFICATION_STATUS_*     000f-000f */
	} Nv0058Notification;
#define NV0058_NOTIFIERS_SYNCHRONIZE                                        (0)
#define NV0058_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV0058_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV03_CONTEXT_SURFACES_2D         0000-0003 */
		NvV32               status;	/* returns NV0058_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv0058AllocParameters;
#define NV0058_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV0058_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV0058_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV0058_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_CONTEXT_SURFACES_2D         0000-0003 */
		NvV32               status;	/* returns NV0058_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0058FreeParameters;
#define NV0058_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV0058_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_CONTEXT_SURFACES_2D         0000-0003 */
		NvV32               status;	/* returns NV0058_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv0058ControlParameters;
#define NV0058_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Synchronize;	/* NV0058_SYNCHRONIZE_*             0100-0103 */
		NvV32               Reserved00[0x01f];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextDmaSource;	/* NV01_CONTEXT_DMA                 0184-0187 */
		NvV32               SetContextDmaDestin;	/* NV01_CONTEXT_DMA                 0188-018b */
		NvV32               Reserved01[0x05d];
		NvV32               SetFormat;	/* NV0058_SET_FORMAT_*              0300-0303 */
		NvU32               SetPitch;	/* destin_source U16_U16            0304-0307 */
		NvU32               SetOffsetSource;	/* byte offset of top-left pixel    0308-030b */
		NvU32               SetOffsetDestin;	/* byte offset of top-left pixel    030c-030f */
		NvV32               Reserved02[0x73c];
	} Nv0058Typedef    , Nv03ContextSurfaces2d;
#define NV0058_TYPEDEF                                    nv03ContextSurfaces2d
/* method offsets, fields, and values */
#define NV0058_SYNCHRONIZE                                         (0x00000100)
#define NV0058_SYNCHRONIZE_NO_OPERATION                            (0x00000000)
#define NV0058_SYNCHRONIZE_WAIT_FOR_IDLE                           (0x00000001)
#define NV0058_SYNCHRONIZE_WAIT_FOR_IDLE_WRITE_LE_NOTIFY           (0x00000002)
#define NV0058_SYNCHRONIZE_WAIT_FOR_IDLE_WRITE_LE_NOTIFY_AWAKEN    (0x00000003)
#define NV0058_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV0058_SET_CONTEXT_DMA_SOURCE                              (0x00000184)
#define NV0058_SET_CONTEXT_DMA_DESTIN                              (0x00000188)
#define NV0058_SET_FORMAT                                          (0x00000300)
#define NV0058_SET_FORMAT_COLOR                                            31:0
#define NV0058_SET_FORMAT_COLOR_Y8                                 (0x00000001)
#define NV0058_SET_FORMAT_COLOR_X1R5G5B5_Z1R5G5B5                  (0x00000002)
#define NV0058_SET_FORMAT_COLOR_Y16                                (0x00000005)
#define NV0058_SET_FORMAT_COLOR_X8R8G8B8_Z8R8G8B8                  (0x00000006)
#define NV0058_SET_PITCH                                           (0x00000304)
#define NV0058_SET_PITCH_SOURCE                                            15:0
#define NV0058_SET_PITCH_DESTIN                                           31:16
#define NV0058_SET_OFFSET_SOURCE                                   (0x00000308)
#define NV0058_SET_OFFSET_DESTIN                                   (0x0000030C)


/* class NV03_CONTEXT_SURFACES_3D */
#define  NV03_CONTEXT_SURFACES_3D                                  (0x0000005A)
/* notification fields and values */
	typedef volatile struct
	{
		NvU64               timeStamp;	/* nanoseconds since Jan. 1, 1970   0000-0007 */
		NvV8                zero[0x007];	/* zero                             0008-000e */
		NvV8                status;	/* NV005A_NOTIFICATION_STATUS_*     000f-000f */
	} Nv005aNotification;
#define NV005A_NOTIFIERS_SYNCHRONIZE                                        (0)
#define NV005A_NOTIFICATION_STATUS_DONE_SUCCESS                          (0x00)
#define NV005A_NOTIFICATION_STATUS_IN_PROGRESS                           (0xFF)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV03_CONTEXT_SURFACES_3D         0000-0003 */
		NvV32               status;	/* returns NV005A_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               ignored00[0x00c];
	} Nv005aAllocParameters;
#define NV005A_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV005A_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV005A_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV005A_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_CONTEXT_SURFACES_3D instanc 0000-0003 */
		NvV32               status;	/* returns NV005A_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv005aFreeParameters;
#define NV005A_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV005A_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_CONTEXT_SURFACES_3D instanc 0000-0003 */
		NvV32               status;	/* returns NV005A_CONTROL_STATUS_*  0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv005aControlParameters;
#define NV005A_CONTROL_STATUS_SUCCESS                              (0x00000000)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Synchronize;	/* NV005A_SYNCHRONIZE_*             0100-0103 */
		NvV32               Reserved00[0x01f];
		NvV32               SetContextDmaNotifies;	/* NV01_CONTEXT_DMA                 0180-0183 */
		NvV32               SetContextDmaSurfaces;	/* NV01_CONTEXT_DMA                 0184-0187 */
		NvV32               Reserved01[0x05e];
		NvU32               SetPitch;	/* in bytes                         0300-0303 */
		NvU32               SetOffsetColor;	/* byte offset of top-left pixel    0304-0307 */
		NvU32               SetOffsetZeta;	/* byte offset of top-left pixel    0308-030b */
		NvV32               Reserved02[0x73d];
	} Nv005aTypedef    , Nv03ContextSurfaces3d;
#define NV005A_TYPEDEF                                    nv03ContextSurfaces3d
/* method offsets, fields, and values */
#define NV005A_SYNCHRONIZE                                         (0x00000100)
#define NV005A_SYNCHRONIZE_NO_OPERATION                            (0x00000000)
#define NV005A_SYNCHRONIZE_WAIT_FOR_IDLE                           (0x00000001)
#define NV005A_SYNCHRONIZE_WAIT_FOR_IDLE_WRITE_LE_NOTIFY           (0x00000002)
#define NV005A_SYNCHRONIZE_WAIT_FOR_IDLE_WRITE_LE_NOTIFY_AWAKEN    (0x00000003)
#define NV005A_SET_CONTEXT_DMA_NOTIFIES                            (0x00000180)
#define NV005A_SET_CONTEXT_DMA_SURFACES                            (0x00000184)
#define NV005A_SET_PITCH                                           (0x00000300)
#define NV005A_SET_OFFSET_COLOR                                    (0x00000304)
#define NV005A_SET_OFFSET_ZETA                                     (0x00000308)

	typedef NvV32       Nv005cTypedef;

	typedef NvV32       Nv005dTypedef;

	typedef NvV32       Nv005eTypedef;

	typedef NvV32       Nv005fTypedef;

	typedef NvV32       Nv0060Typedef;

	typedef NvV32       Nv0061Typedef;

	typedef NvV32       Nv0062Typedef;

	typedef NvV32       Nv0063Typedef;

	typedef NvV32       Nv0064Typedef;

	typedef NvV32       Nv0065Typedef;

	typedef NvV32       Nv0066Typedef;

	typedef NvV32       Nv0067Typedef;



/* class NV03_CHANNEL_DMA */
#define  NV03_CHANNEL_DMA                                          (0x0000006B)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV03_CHANNEL_DMA                 0000-0003 */
		NvV32               status;	/* returns NV006B_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvV32               objectBuffer;	/* instance of NV01_CONTEXT_DMA     0010-0013 */
		NvU32               offset;	/* initial get and put offsets      0014-0017 */
		NvV32               ignored00[0x00a];
	} Nv006bAllocParameters;
#define NV006B_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV006B_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV006B_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV006B_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
#define NV006B_ALLOC_STATUS_ERROR_BAD_OBJECT_BUFFER                (0x00000005)
#define NV006B_ALLOC_STATUS_ERROR_BAD_OFFSET                       (0x00000006)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_CHANNEL_DMA instance        0000-0003 */
		NvV32               status;	/* returns NV006B_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv006bFreeParameters;
#define NV006B_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV006B_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_CHANNEL_DMA instance        0000-0003 */
		NvV32               status;	/* returns NV006B_CONTROL_STATUS_*  0004-0007 */
		NvV32               info;	/* returns NV006B_CONTROL_INFO_*    0008-000b */
		NvV32               flags;	/* NV006B_CONTROL_FLAGS_*           000c-000f */
		NvV32               get;	/* returns get offset               0010-0013 */
		NvV32               put;	/* put offset                       0014-0017 */
		NvV32               jump;	/* jump offset                      0018-001b */
		NvV32               ignored00[0x009];
	} Nv006bControlParameters;
#define NV006B_CONTROL_STATUS_SUCCESS                              (0x00000000)
#define NV006B_CONTROL_STATUS_ERROR_BAD_FLAGS_PUT                  (0x00000002)
#define NV006B_CONTROL_STATUS_ERROR_BAD_FLAGS_JUMP                 (0x00000003)
#define NV006B_CONTROL_STATUS_ERROR_BAD_PUT                        (0x00000004)
#define NV006B_CONTROL_STATUS_ERROR_BAD_JUMP                       (0x00000005)
#define NV006B_CONTROL_INFO_EMPTY_AND_IDLE                         (0x00000000)
#define NV006B_CONTROL_INFO_BUSY                                   (0x00000001)
#define NV006B_CONTROL_FLAGS_PUT                                            3:0
#define NV006B_CONTROL_FLAGS_PUT_IGNORE                            (0x00000000)
#define NV006B_CONTROL_FLAGS_PUT_UPDATE                            (0x00000001)
#define NV006B_CONTROL_FLAGS_JUMP                                          31:4
#define NV006B_CONTROL_FLAGS_JUMP_IGNORE                           (0x00000000)
#define NV006B_CONTROL_FLAGS_JUMP_REGISTER                         (0x00000001)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Reserved00[0x7c0];
	} Nv006bTypedef    , Nv03ChannelDma;
#define  NV006B_TYPEDEF                                          nv03ChannelDma
/* method offsets, fields, and values */
#define NV006B_NUMBER_OF_SUBCHANNELS                                        (8)
#define NV006B_SET_OBJECT                                          (0x00000000)
#define NV006B_U                                                   (0x00000100)



	typedef NvV32       Nv006cTypedef;

	typedef NvV32       Nv006dTypedef;

	typedef NvV32       Nv006eTypedef;

	typedef NvV32       Nv0072Typedef;

	typedef NvV32       Nv0076Typedef;

	typedef NvV32       Nv0077Typedef;

	typedef NvV32       Nv0079Typedef;

	typedef NvV32       Nv007aTypedef;

	typedef NvV32       Nv007bTypedef;

	typedef NvV32       Nv007cTypedef;

	typedef NvV32       Nv007dTypedef;

	typedef NvV32       Nv007eTypedef;

	typedef NvV32       Nv007fTypedef;

	typedef NvV32       Nv0082Typedef;

	typedef NvV32       Nv0084Typedef;

	typedef NvV32       Nv0085Typedef;


	typedef NvV32       Nv0087Typedef;

	typedef NvV32       Nv0088Typedef;

	typedef NvV32       Nv0093Typedef;

	typedef NvV32       Nv0094Typedef;

	typedef NvV32       Nv0095Typedef;



 /***************************************************************************\
|*                               PIO Channels                                *|
 \***************************************************************************/

	typedef NvV32       Nv0068Typedef;

	typedef NvV32       Nv0069Typedef;


/* class NV03_CHANNEL_PIO */
#define  NV03_CHANNEL_PIO                                          (0x0000006A)
/* NVSW001_ALLOC parameters and errors */
	typedef struct
	{
		NvV32               classNumber;	/* NV03_CHANNEL_PIO                 0000-0003 */
		NvV32               status;	/* returns NV006A_ALLOC_STATUS_*    0004-0007 */
		NvV32               objectNew;	/* new object handle                0008-000b */
		NvV32               objectParent;	/* see text                         000c-000f */
		NvP64               base;	/* returns Nv006aChannel pointer    0010-0017 */
		NvU64               limit;	/* size-1 of channel's FIFO         0018-001f */
		NvV32               ignored00[0x008];
	} Nv006aAllocParameters;
#define NV006A_ALLOC_STATUS_SUCCESS                                (0x00000000)
#define NV006A_ALLOC_STATUS_ERROR_INSUFFICIENT_RESOURCES           (0x00000002)
#define NV006A_ALLOC_STATUS_ERROR_BAD_OBJECT_NEW                   (0x00000003)
#define NV006A_ALLOC_STATUS_ERROR_BAD_OBJECT_PARENT                (0x00000004)
#define NV006A_ALLOC_STATUS_ERROR_BAD_LIMIT                        (0x00000005)
/* NVSW002_FREE parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_CHANNEL_PIO instance        0000-0003 */
		NvV32               status;	/* returns NV006A_FREE_STATUS_*     0004-0007 */
		NvV32               ignored00[0x00e];
	} Nv006aFreeParameters;
#define NV006A_FREE_STATUS_SUCCESS                                 (0x00000000)
#define NV006A_FREE_STATUS_ERROR_OBJECT_IN_USE                     (0x00000002)
/* NVSW003_CONTROL parameters and errors */
	typedef struct
	{
		NvV32               object;	/* NV03_CHANNEL_PIO instance        0000-0003 */
		NvV32               status;	/* returns NV006A_CONTROL_STATUS_*  0004-0007 */
		NvV32               info;	/* returns NV006A_CONTROL_INFO_*    0008-000b */
		NvV32               ignored00[0x00d];
	} Nv006aControlParameters;
#define NV006A_CONTROL_STATUS_SUCCESS                              (0x00000000)
#define NV006A_CONTROL_INFO_EMPTY_AND_IDLE                         (0x00000000)
#define NV006A_CONTROL_INFO_BUSY                                   (0x00000001)
/* Nv0001Error[].status values */
#define NV006A_ERROR_STATUS_FIFO_OVERRUN                           (0x00000001)
#define NV006A_ERROR_STATUS_ILLEGAL_WRITE                          (0x00000002)
#define NV006A_ERROR_STATUS_ILLEGAL_READ                           (0x00000004)
#define NV006A_ERROR_STATUS_BAD_SIZE                               (0x00000008)
#define NV006A_ERROR_STATUS_BAD_ALIGNMENT                          (0x00000010)
/* pio method data structure */
	typedef volatile struct
	{
		NvV32               Reserved00[0x7c0];
	} Nv006aTypedef    , Nv03ChannelPio;
#define NV006A_TYPEDEF                                           nv03ChannelPio
/* pio subchannel method data structure */
	typedef volatile struct
	{
		NvV32               SetObject;	/* current object, write only       0000-0003 */
		NvV32               Reserved00[0x003];
		NvU16               Free;	/* free count, read only            0010-0011 */
		NvU16               Zero[7];	/* zeroes, read only                0012-001f */
		NvV32               Reserved01[0x038];
		union
		{		/* start class methods, write only  0100-    */
/*Nv0000Typedef NV0000_TYPEDEF;*/
			Nv0001Typedef       NV0001_TYPEDEF;
			Nv0002Typedef       NV0002_TYPEDEF;
			Nv0003Typedef       NV0003_TYPEDEF;
			Nv0004Typedef       NV0004_TYPEDEF;
			Nv0005Typedef       NV0005_TYPEDEF;
			Nv0006Typedef       NV0006_TYPEDEF;
			Nv0007Typedef       NV0007_TYPEDEF;
			Nv0008Typedef       NV0008_TYPEDEF;
			Nv0009Typedef       NV0009_TYPEDEF;
			Nv000aTypedef       NV000A_TYPEDEF;
			Nv000bTypedef       NV000B_TYPEDEF;
			Nv000cTypedef       NV000C_TYPEDEF;
			Nv000dTypedef       NV000D_TYPEDEF;
			Nv000eTypedef       NV000E_TYPEDEF;
			Nv000fTypedef       NV000F_TYPEDEF;
			Nv0010Typedef       NV0010_TYPEDEF;
			Nv0011Typedef       NV0011_TYPEDEF;
			Nv0012Typedef       NV0012_TYPEDEF;
			Nv0013Typedef       NV0013_TYPEDEF;
			Nv0014Typedef       NV0014_TYPEDEF;
			Nv0015Typedef       NV0015_TYPEDEF;
			Nv0016Typedef       NV0016_TYPEDEF;
			Nv0017Typedef       NV0017_TYPEDEF;
			Nv0018Typedef       NV0018_TYPEDEF;
			Nv0019Typedef       NV0019_TYPEDEF;
			Nv001aTypedef       NV001A_TYPEDEF;
			Nv001bTypedef       NV001B_TYPEDEF;
			Nv001cTypedef       NV001C_TYPEDEF;
			Nv001dTypedef       NV001D_TYPEDEF;
			Nv001eTypedef       NV001E_TYPEDEF;
			Nv001fTypedef       NV001F_TYPEDEF;
			Nv0020Typedef       NV0020_TYPEDEF;
			Nv0021Typedef       NV0021_TYPEDEF;
			Nv0022Typedef       NV0022_TYPEDEF;
			Nv0023Typedef       NV0023_TYPEDEF;
			Nv0024Typedef       NV0024_TYPEDEF;
			Nv0025Typedef       NV0025_TYPEDEF;
			Nv0026Typedef       NV0026_TYPEDEF;
			Nv0027Typedef       NV0027_TYPEDEF;
			Nv0028Typedef       NV0028_TYPEDEF;
			Nv0029Typedef       NV0029_TYPEDEF;
			Nv002aTypedef       NV002A_TYPEDEF;
			Nv002bTypedef       NV002B_TYPEDEF;
			Nv002cTypedef       NV002C_TYPEDEF;
			Nv002dTypedef       NV002D_TYPEDEF;
			Nv002eTypedef       NV002E_TYPEDEF;
			Nv002fTypedef       NV002F_TYPEDEF;
			Nv0030Typedef       NV0030_TYPEDEF;
			Nv0031Typedef       NV0031_TYPEDEF;
			Nv0032Typedef       NV0032_TYPEDEF;
			Nv0033Typedef       NV0033_TYPEDEF;
			Nv0034Typedef       NV0034_TYPEDEF;
			Nv0035Typedef       NV0035_TYPEDEF;
			Nv0036Typedef       NV0036_TYPEDEF;
			Nv0037Typedef       NV0037_TYPEDEF;
			Nv0038Typedef       NV0038_TYPEDEF;
			Nv0039Typedef       NV0039_TYPEDEF;
			Nv003aTypedef       NV003A_TYPEDEF;
			Nv003bTypedef       NV003B_TYPEDEF;
			Nv003cTypedef       NV003C_TYPEDEF;
			Nv003dTypedef       NV003D_TYPEDEF;
			Nv003eTypedef       NV003E_TYPEDEF;
			Nv003fTypedef       NV003F_TYPEDEF;
			Nv0040Typedef       NV0040_TYPEDEF;
			Nv0042Typedef       NV0042_TYPEDEF;
			Nv0043Typedef       NV0043_TYPEDEF;
			Nv0044Typedef       NV0044_TYPEDEF;
			Nv0045Typedef       NV0045_TYPEDEF;
			Nv0046Typedef       NV0046_TYPEDEF;
			Nv0047Typedef       NV0047_TYPEDEF;
			Nv0048Typedef       NV0048_TYPEDEF;
			Nv0049Typedef       NV0049_TYPEDEF;
			Nv004aTypedef       NV004A_TYPEDEF;
			Nv004bTypedef       NV004B_TYPEDEF;
			Nv004cTypedef       NV004C_TYPEDEF;
			Nv004dTypedef       NV004D_TYPEDEF;
			Nv004eTypedef       NV004E_TYPEDEF;
			Nv004fTypedef       NV004F_TYPEDEF;
			Nv0050Typedef       NV0050_TYPEDEF;
			Nv0051Typedef       NV0051_TYPEDEF;
			Nv0052Typedef       NV0052_TYPEDEF;
			Nv0053Typedef       NV0053_TYPEDEF;
			Nv0054Typedef       NV0054_TYPEDEF;
			Nv0055Typedef       NV0055_TYPEDEF;
			Nv0056Typedef       NV0056_TYPEDEF;
			Nv0057Typedef       NV0057_TYPEDEF;
			Nv0058Typedef       NV0058_TYPEDEF;
			Nv005aTypedef       NV005A_TYPEDEF;
			Nv005cTypedef       NV005C_TYPEDEF;
			Nv005dTypedef       NV005D_TYPEDEF;
			Nv005eTypedef       NV005E_TYPEDEF;
			Nv005fTypedef       NV005F_TYPEDEF;
			Nv0060Typedef       NV0060_TYPEDEF;
			Nv0061Typedef       NV0061_TYPEDEF;
			Nv0062Typedef       NV0062_TYPEDEF;
			Nv0063Typedef       NV0063_TYPEDEF;
			Nv0064Typedef       NV0064_TYPEDEF;
			Nv0065Typedef       NV0065_TYPEDEF;
			Nv0066Typedef       NV0066_TYPEDEF;
			Nv0067Typedef       NV0067_TYPEDEF;
			Nv0068Typedef       NV0068_TYPEDEF;
			Nv0069Typedef       NV0069_TYPEDEF;
			Nv006aTypedef       NV006A_TYPEDEF;
			Nv006bTypedef       NV006B_TYPEDEF;
			Nv006cTypedef       NV006C_TYPEDEF;
			Nv006dTypedef       NV006D_TYPEDEF;
			Nv006eTypedef       NV006E_TYPEDEF;
			Nv0072Typedef       NV0072_TYPEDEF;
			Nv0076Typedef       NV0076_TYPEDEF;
			Nv0077Typedef       NV0077_TYPEDEF;
			Nv0079Typedef       NV0079_TYPEDEF;
			Nv007aTypedef       NV007A_TYPEDEF;
			Nv007bTypedef       NV007B_TYPEDEF;
			Nv007cTypedef       NV007C_TYPEDEF;
			Nv007dTypedef       NV007D_TYPEDEF;
			Nv007eTypedef       NV007E_TYPEDEF;
			Nv007fTypedef       NV007F_TYPEDEF;
			Nv0082Typedef       NV0082_TYPEDEF;
			Nv0084Typedef       NV0084_TYPEDEF;
			Nv0085Typedef       NV0085_TYPEDEF;
			Nv0087Typedef       NV0087_TYPEDEF;
			Nv0088Typedef       NV0088_TYPEDEF;
			Nv0093Typedef       NV0093_TYPEDEF;
			Nv0094Typedef       NV0094_TYPEDEF;
			Nv0095Typedef       NV0095_TYPEDEF;
		} u;		/* end of class methods                  -1fff */
	} Nv006aSubchannel;
/* pio channel */
#define NV006A_NUMBER_OF_SUBCHANNELS                                        (8)
	typedef volatile struct
	{			/* start of array of subchannels     0000-    */
		Nv006aSubchannel    subchannel[NV006A_NUMBER_OF_SUBCHANNELS];	/*0000-1fff */
	} Nv006aChannel;	/* end of array of subchannels          -ffff */
/* method offsets, fields, and values */
#define NV006A_SET_OBJECT                                          (0x00000000)
#define NV006A_FREE                                                (0x00000010)
#define NV006A_FREE_FIFO_FULL                                          (0x0000)
#define NV006A_ZERO(a)                                             (0x00000012\
                                                                   +(a)*0x0002)
/* obsolete stuff */
#if NVDEPRECATED
#define NV006A_FIFO_FULL                                               (0x0000)
#endif


 /***************************************************************************\
|*                            Well Known Objects                             *|
 \***************************************************************************/


/* object NV01_NULL_OBJECT */
#define   NV01_NULL_OBJECT                                         (0x00000000)


 /***************************************************************************\
|*                                   Ports                                   *|
 \***************************************************************************/


/* NV01_DEVICE (PCI) */
#define NV0003_ALLOC_PORT_ID_PCI_INSTANCE                                   2:0
#define NV0003_ALLOC_PORT_ID_PCI_SLOT                                       7:3
#define NV0003_ALLOC_PORT_ID_PCI_BUS                                       15:8
#define NV0003_ALLOC_PORT_ID_PCI_IGNORE                                   31:16


#ifdef __cplusplus
};
#endif
#endif /* NVHW32_INCLUDED */
