 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


EngineObjInfo       nv01NullEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 23) : (1 * 32 + 23)) & 31)), 0, {(0x00000030), 0xffffffff,
			0x0}, (void *) 0,
};
ClassInfo           nv01NullClassInfo = {
	(0x00000030), "null", sizeof (EngineObj), 0x1, 1, &nv01NullEngineObjInfo, (void *) 0,
		(void *) 0, (void *) 0, (void *) 0, (void *) 0, (void *) 0, (void *) 0, 0,
		(void *) 0, 0, (void *) 0
};
NvV32
nvAllocNv01Null (NvChannelObj *channel)
{
	EngineObj          *nullObj;
	NvP64               base;
	NvU64               limit;
	NvV32               memoryId,
	                    status;
	NvU32               errorTblSz;

	;
	if (channel == (void *) 0)
		return 2;
	(&limit)->high = 0, (&limit)->low = (NvU32) (sizeof (EngineObj) - 1);
	status = nvArchMemoryAllocKernel (&base, limit, &memoryId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return 2;
	}
	nullObj = (EngineObj *) (&base)->low;
	nullObj->base.memoryId = memoryId;
	nullObj->base.name = (NV_PMC_BOOT_0);
	nullObj->base.classInfo = &nv01NullClassInfo;
	nullObj->base.parent = (GenericObj *) channel;
	nullObj->base.mask = 0x1;
	nullObj->base.node.Value = 0;
	nullObj->base.node.Data = 0;
	nullObj->base.childList = (void *) 0;
	nullObj->base.refcnt = 1;
	errorTblSz = sizeof (Nv0001Error) * 1;
	(&limit)->high = 0, (&limit)->low = (NvU32) (errorTblSz - 1);
	status = nvArchMemoryAllocKernel (&base, limit, &memoryId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		nvArchMemoryFree (nullObj->base.memoryId);
		return 2;
	}
	nullObj->base.errorBase = (Nv0001Error *) (&base)->low;
	nullObj->base.errorBaseId = memoryId;
	while (errorTblSz--)
		*(((NvU8 *) nullObj->base.errorBase) + errorTblSz) = 0;
	nullObj->base.errorWrite = 0;
	nullObj->base.errorRead = 0;
	channel->nullObj = nullObj;
	return 0;
}

NvV32
nvAttachNv01Null (NvChannelObj *channel)
{
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *device;
	HwDeviceInfo       *hwdev;
	HwReg              *hwram;
	EngineObj          *nullObj;
	NvV32               status;
	NvU32               instMemLoc;
	NvV32               instMemSize;

	;
	if (channel == (void *) 0)
		return 2;
	deviceObj = (NvDeviceObj *) channel->base.parent;
	;
	device = deviceObj->device->deviceInfo;
	;
	hwdev = (HwDeviceInfo *) device;
	hwram = ((hwdev)->base.imAddr);
	if ((nullObj = channel->nullObj) == (void *) 0)
	{
		;
		return 2;
	}
	;
	instMemSize = 1;
	status = fbAllocInstMem (device, &instMemLoc, &instMemSize, 0);
	if (status != 0)
	{
		;
		return 2;
	}
	(hwram)->Reg32[((0 ? 0x01FFFFFF : 0x01C00000) + ((instMemLoc) << 4) + ((((0 ? (0 * 32 +
								31) : (0 * 32 + 0)) / 32) << 2)) -
			(0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
		(NvV32) ((nv01NullEngineObjInfo.instanceMem[0]));
	(hwram)->Reg32[((0 ? 0x01FFFFFF : 0x01C00000) + ((instMemLoc) << 4) + ((((0 ? (1 * 32 +
								31) : (1 * 32 + 0)) / 32) << 2)) -
			(0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
		(NvV32) ((nv01NullEngineObjInfo.instanceMem[1]));
	(hwram)->Reg32[((0 ? 0x01FFFFFF : 0x01C00000) + ((instMemLoc) << 4) + ((((0 ? (2 * 32 +
								31) : (2 * 32 + 0)) / 32) << 2)) -
			(0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
		(NvV32) ((nv01NullEngineObjInfo.instanceMem[2]));
	nullObj->instMemLoc = instMemLoc;
	;
	nullObj->context =
		nv01NullEngineObjInfo.hashContextMask | (((instMemLoc) & (0xFFFFFFFF >> (31 -
					(1 ? (1 * 32 + 15) : (1 * 32 + 0)) + (0 ? (1 * 32 +
							15) : (1 * 32 + 0))))) << ((0 ? (1 * 32 +
					15) : (1 * 32 +
					0)) & 31)) | (((channel->channel->id) & (0xFFFFFFFF >> (31 -
					(1 ? (1 * 32 + 30) : (1 * 32 + 24)) + (0 ? (1 * 32 +
							30) : (1 * 32 + 24))))) << ((0 ? (1 * 32 +
					30) : (1 * 32 + 24)) & 31));
	nullObj->notifyCtxDma = (void *) 0;
	fifoAddHashEntry (device, nullObj);
	return 0;
}

NvV32
nvDetachNv01Null (NvChannelObj *channel)
{
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *device;
	EngineObj          *nullObj;

	;
	if (channel == (void *) 0)
		return 1;
	deviceObj = (NvDeviceObj *) channel->base.parent;
	;
	device = deviceObj->device->deviceInfo;
	;
	nullObj = channel->nullObj;
	;
	fifoRemoveHashEntry (device, nullObj);
	fbFreeInstMem (device, nullObj->instMemLoc, 1);
	return 0;
}

NvV32
nvFreeNv01Null (NvChannelObj *channel)
{
	EngineObj          *nullObj;

	;
	if (channel == (void *) 0)
		return 1;
	nullObj = channel->nullObj;
	;
	if (nullObj->base.errorBase)
	{
		nvArchMemoryFree (nullObj->base.errorBaseId);
		nullObj->base.errorBase = (void *) 0;
	}
	nvArchMemoryFree (nullObj->base.memoryId);
	channel->nullObj = (EngineObj *) 0xdeadbeee;
	return 0;
}
