 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
mpInit (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU8                lock;
	NvU8                seq_index;
	NvU8                daddr,
	                    subaddr,
	                    data;

	;
	seq_index = ((hwreg)->Reg8[0x000C03c4]);
	(hwreg)->Reg8[0x000C03c4] = (NvV8) (0x00000006);
	lock = ((hwreg)->Reg8[0x000C03c5]);
	(hwreg)->Reg8[0x000C03c5] = (NvV8) (0x00000057);
	hwdev->info.MediaPort.MPCPresent = 0;
	hwdev->info.MediaPort.MPCDeviceAddr = 0;
	hwdev->info.MediaPort.CurrVideoVbiPort = (void *) 0;
	hwdev->info.MediaPort.CurrVideoInputPort = (void *) 0;
	hwdev->info.MediaPort.CurrDataOutputPort = (void *) 0;
	hwdev->info.MediaPort.CurrIntrPort = (void *) 0;
	hwdev->info.MediaPort.CurrIoPort = (void *) 0;
	for (daddr = 0x24; daddr <= 0x27; daddr++)
	{
		subaddr = 0x1;
		data = 0x8F;
		if (i2cWrite (device, daddr, 1, &subaddr, 1, &data) != 0)
			continue;
		subaddr = 0x0;
		data = 0x80;
		if (i2cWrite (device, daddr, 1, &subaddr, 1, &data) != 0)
			continue;
		if (i2cRead (device, daddr, 1, &subaddr, 1, &data) != 0)
			continue;
		if ((data & 0xc0) != 0xc0)
			continue;
		subaddr = 0x0;
		data = 0x40;
		if (i2cWrite (device, daddr, 1, &subaddr, 1, &data) != 0)
			continue;
		if (i2cRead (device, daddr, 1, &subaddr, 1, &data) != 0)
			continue;
		if ((data & 0xc0) == 0x0)
		{
			hwdev->info.MediaPort.MPCPresent = 1;
			hwdev->info.MediaPort.MPCDeviceAddr = daddr;
			;
			break;
		}
	}
	if (hwdev->info.MediaPort.MPCPresent)
	{
		;
		subaddr = 1;
		data = 0xFF;
		i2cWrite (device, (NvU8) hwdev->info.MediaPort.MPCDeviceAddr, 1, &subaddr, 1,
			&data);
		subaddr = 0;
		data = 0;
		i2cWrite (device, (NvU8) hwdev->info.MediaPort.MPCDeviceAddr, 1, &subaddr, 1,
			&data);
		subaddr = 0;
		data = 0x07;
		i2cWrite (device, (NvU8) hwdev->info.MediaPort.MPCDeviceAddr, 1, &subaddr, 1,
			&data);
		(hwreg)->Reg32[(0x00200200) / 4] = (NvV32) (((0x00000001) << ((0 ? 1 : 0) % 32)));
		(hwreg)->Reg32[(0x00200318) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x0020031c) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x00200320) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x00200358) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x0020035c) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x00200360) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x00200398) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x0020039c) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x002003a0) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x00200418) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x0020041c) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x00200420) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(0x00200080) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(0x00200084) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 1 : 0) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 6 : 4) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 9 : 8) % 32)));
	}
	else
	{
		;
	}
	(hwreg)->Reg8[0x000C03c4] = (NvV8) (0x00000006);
	if (lock == 0)
	{
		(hwreg)->Reg8[0x000C03c5] = (NvV8) (0x00000099);
	}
	(hwreg)->Reg8[0x000C03c4] = (NvV8) (seq_index);
	return 0;
}
