 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
mcInit (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               M,
	                    N,
	                    O,
	                    P;
	NvU32               crystal;

	;
	hwdev->info.Chip.SavePmc = ((hwreg)->Reg32[(NV_PMC_ENABLE) / 4]);
	if (hwdev->info.Chip.SavePmc == 0)
	{
		;
		hwdev->info.Chip.SavePmc = 0xFFFFFFFF;
		(hwreg)->Reg32[(NV_PMC_ENABLE) / 4] = (NvV32) (NV_PMC_BOOT_0);
	}
	hwdev->info.Chip.SaveIntrEn0 = ((hwreg)->Reg32[(NV_PMC_INTR_EN_0) / 4]);
	(hwreg)->Reg32[(NV_PMC_ENABLE) / 4] = (NvV32) (0xFFFFFFFF);
	if ((((((hwreg)->Reg32[(NV_PEXTDEV_BOOT_0) / 4])) >> ((0 ? 6 : 6) %
					32)) & (0xFFFFFFFF >> (31 - ((1 ? 6 : 6) % 32) +
					((0 ? 6 : 6) % 32)))) == NV_PMC_BOOT_0)
	{
		hwdev->info.Chip.CrystalFreq = 13500000;
	}
	else if ((((((hwreg)->Reg32[(NV_PEXTDEV_BOOT_0) / 4])) >> ((0 ? 6 : 6) %
					32)) & (0xFFFFFFFF >> (31 - ((1 ? 6 : 6) % 32) +
					((0 ? 6 : 6) % 32)))) == 0x00000001)
	{
		hwdev->info.Chip.CrystalFreq = 14318180;
	}
	crystal = hwdev->info.Chip.CrystalFreq;
	M = (((((hwreg)->Reg32[(NV_PRAMDAC_MPLL_COEFF) / 4])) >> ((0 ? 7 : 0) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 0) % 32) +
				((0 ? 7 : 0) % 32))));
	N = (((((hwreg)->Reg32[(NV_PRAMDAC_MPLL_COEFF) / 4])) >> ((0 ? 15 : 8) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 8) % 32) +
				((0 ? 15 : 8) % 32))));
	P = (((((hwreg)->Reg32[(NV_PRAMDAC_MPLL_COEFF) / 4])) >> ((0 ? 18 : 16) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 18 : 16) % 32) +
				((0 ? 18 : 16) % 32))));
	O = 1;
	hwdev->info.Dac.MPllM = M;
	hwdev->info.Dac.MPllN = N;
	hwdev->info.Dac.MPllO = O;
	hwdev->info.Dac.MPllP = P;
	if (!P)
	{
		P = 1;
	}
	hwdev->info.Dac.MClk = (N * crystal / (1 << P) / M);
	M = (((((hwreg)->Reg32[(NV_PRAMDAC_VPLL_COEFF) / 4])) >> ((0 ? 7 : 0) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 0) % 32) +
				((0 ? 7 : 0) % 32))));
	N = (((((hwreg)->Reg32[(NV_PRAMDAC_VPLL_COEFF) / 4])) >> ((0 ? 15 : 8) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 8) % 32) +
				((0 ? 15 : 8) % 32))));
	P = (((((hwreg)->Reg32[(NV_PRAMDAC_VPLL_COEFF) / 4])) >> ((0 ? 18 : 16) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 18 : 16) % 32) +
				((0 ? 18 : 16) % 32))));
	O = 1;
	hwdev->info.Dac.VPllM = M;
	hwdev->info.Dac.VPllN = N;
	hwdev->info.Dac.VPllO = O;
	hwdev->info.Dac.VPllP = P;
	hwdev->info.Dac.VClk = (N * crystal / (1 << P) / M);
	M = (((((hwreg)->Reg32[(NV_PRAMDAC_NVPLL_COEFF) / 4])) >> ((0 ? 7 : 0) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 0) % 32) +
				((0 ? 7 : 0) % 32))));
	N = (((((hwreg)->Reg32[(NV_PRAMDAC_NVPLL_COEFF) / 4])) >> ((0 ? 15 : 8) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 8) % 32) +
				((0 ? 15 : 8) % 32))));
	P = (((((hwreg)->Reg32[(NV_PRAMDAC_NVPLL_COEFF) / 4])) >> ((0 ? 18 : 16) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 18 : 16) % 32) +
				((0 ? 18 : 16) % 32))));
	O = 1;
	hwdev->info.Dac.NVPllM = M;
	hwdev->info.Dac.NVPllN = N;
	hwdev->info.Dac.NVPllO = O;
	hwdev->info.Dac.NVPllP = P;
	hwdev->info.Dac.NVClk = (N * crystal / (1 << P) / M);
	;
	hwdev->info.Chip.Revision =
		(((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4])) >> ((0 ? 7 : 4) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 4) % 32) +
				((0 ? 7 : 4) % 32))));
	hwdev->info.Chip.Subrevision =
		(((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4])) >> ((0 ? 3 : 0) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
				((0 ? 3 : 0) % 32))));
	hwdev->info.Chip.Implementation =
		(((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4])) >> ((0 ? 11 : 8) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 11 : 8) % 32) +
				((0 ? 11 : 8) % 32))));
	hwdev->info.Chip.Architecture =
		(((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4])) >> ((0 ? 15 : 12) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 12) % 32) +
				((0 ? 15 : 12) % 32))));
	hwdev->info.Chip.Manufacturer =
		(((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4])) >> ((0 ? 27 : 24) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 27 : 24) % 32) +
				((0 ? 27 : 24) % 32))));
	hwdev->info.Chip.MaskRevision =
		(((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4])) >> ((0 ? 23 : 20) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 23 : 20) % 32) +
				((0 ? 23 : 20) % 32))));
	if (hwdev->info.Chip.Architecture != 0x00000004)
	{
		;
		return (-2);
	}
	switch (hwdev->info.Chip.MaskRevision)
	{
		case (NV_PMC_BOOT_0):
			strcpy (hwdev->info.Chip.ID, " NV4 Rev. A ");
			break;
		case (0x00000001):
			strcpy (hwdev->info.Chip.ID, " NV5 Rev. A ");
			break;
		case (0x00000002):
			strcpy (hwdev->info.Chip.ID, " NV6 Rev. A ");
		default:;
			return (-2);
	}
	hwdev->info.Chip.IntrEn0 = ((0x00000001) << ((0 ? 1 : 0) % 32));
	if ((((((hwreg)->Reg32[(0x00001860) / 4])) >> ((0 ? 15 : 8) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 15 : 8) % 32) + ((0 ? 15 : 8) % 32)))) == 0x00000044)
	{
		;
		hwdev->info.Chip.Bus = 4;
	}
	else
	{
		;
		hwdev->info.Chip.Bus = 1;
	}
	if (((hwdev->info.Chip.Architecture > 0x00000004)
			|| (hwdev->info.Chip.Architecture == 0x00000004
				&& hwdev->info.Chip.MaskRevision >= 0x00000001)))
	{
		NvU32               savedPCI1,
		                    savedPCI19;

		savedPCI1 = ((hwreg)->Reg32[(0x00001804) / 4]);
		(hwreg)->Reg32[(0x00001804) / 4] =
			(NvV32) (savedPCI1 & ~((0x00000001) << ((0 ? 2 : 2) % 32)));
		savedPCI19 = ((hwreg)->Reg32[(0x0000184C) / 4]);
		(hwreg)->Reg32[(0x0000184C) / 4] =
			(NvV32) (savedPCI19 & ~((0x00000001) << ((0 ? 8 : 8) % 32)));
		(hwreg)->Reg32[(NV_PMC_ENABLE) / 4] =
			(NvV32) (0xffffffff & ~((0x00000001) << ((0 ? 16 : 16) % 32)));
		(hwreg)->Reg32[(NV_PMC_ENABLE) / 4] = (NvV32) (0xffffffff);
		(hwreg)->Reg32[(0x00001804) / 4] = (NvV32) (savedPCI1);
		(hwreg)->Reg32[(0x0000184C) / 4] = (NvV32) (savedPCI19);
	}
	return 0;
}
