 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
Nv01AllocMemoryLocalLinear (GenericObj *obj, NvClassAllocParameters *alloc)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *deviceInfo;
	HwDeviceInfo       *hwdev;
	NvU32               offset,
	                    size;
	NvV32               status,
	                    flags;
	Nv0040AllocParameters *memAlloc = (Nv0040AllocParameters *) alloc;

	flags = ((memAlloc->flags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
				((0 ? 3 : 0) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)) && (flags != (0x00000001))
		&& (flags != (0x00000002)))
	{
		;
		return (0x00000005);
	}
	flags = ((memAlloc->flags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 4) % 32) +
				((0 ? 7 : 4) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)) && (flags != (0x00000002))
		&& (flags != (0x00000003)) && (flags != (0x00000004)))
	{
		;
		return (0x00000006);
	}
	flags = ((memAlloc->flags >> ((0 ? 31 : 8) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 31 : 8) % 32) + ((0 ? 31 : 8) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)))
	{
		;
		return (0x00000007);
	}
	deviceObj = (NvDeviceObj *) memoryObj->base.parent;
	deviceInfo = (NvDeviceInfo *) deviceObj->device->deviceInfo;
	hwdev = (HwDeviceInfo *) deviceInfo;
	size = (unsigned long) (&memAlloc->limit)->low + 1;
	status = fbMemAlloc (deviceInfo, (0x00000040), 0xffffffff, &size, &offset, 0x00);
	if (status != 0)
	{
		;
		(&memAlloc->limit)->high = 0, (&memAlloc->limit)->low = (NvU32) (0);
		return (0x00000002);
	}
	(&memoryObj->limit)->high = 0, (&memoryObj->limit)->low = (NvU32) (size - 1);
	(&memoryObj->physAddr)->low =
		(unsigned long) ((void *) ((&deviceInfo->fbPhysAddr)->low + offset));
	(&memoryObj->kernAddr)->low = (unsigned long) (0);
	(&memoryObj->usrAddr)->low = (unsigned long) (0);
	return (NV_PMC_BOOT_0);
}

NvV32
Nv01RealizeMemoryLocalLinear (GenericObj *obj, NvClassAllocParameters *alloc)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *deviceInfo;
	HwDeviceInfo       *hwdev;
	Nv0040AllocParameters *memAlloc = (Nv0040AllocParameters *) alloc;
	NvP64               base;
	NvV32               status,
	                    mappingId;

	;
	deviceObj = (NvDeviceObj *) memoryObj->base.parent;
	deviceInfo = (NvDeviceInfo *) deviceObj->device->deviceInfo;
	hwdev = (HwDeviceInfo *) deviceInfo;
	base = memoryObj->physAddr;
	status = nvArchMappingAllocPhysToUser (&base, memoryObj->limit, (memAlloc->flags),
		&mappingId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return (0x00000002);
	}
	memoryObj->usrAddr = base;
	memoryObj->usrId = mappingId;
	base = memoryObj->physAddr;
	status = nvArchMappingAllocPhysToKern (&base, memoryObj->limit,
		(((NV_PMC_BOOT_0) << ((0 ? 3 : 0) % 32)) | ((NV_PMC_BOOT_0) << ((0 ? 7 : 4) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 31 : 8) % 32))),
		&mappingId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return (0x00000002);
	}
	zeroMemory ((NvU32 *) (&base)->low, ((unsigned long) (&memoryObj->limit)->low + 1) / 4);
	nvArchMappingFree (mappingId);
	memAlloc->base = memoryObj->usrAddr;
	memAlloc->limit = memoryObj->limit;
	return (NV_PMC_BOOT_0);
}

NvV32
Nv01UnrealizeMemoryLocalLinear (GenericObj *obj)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;

	;
	if (memoryObj->usrId)
		nvArchMappingFree (memoryObj->usrId);
	return (NV_PMC_BOOT_0);
}

NvV32
Nv01FreeMemoryLocalLinear (GenericObj *obj)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *deviceInfo;
	HwDeviceInfo       *hwdev;
	NvU32               offset;

	;
	;
	;
	deviceObj = (NvDeviceObj *) memoryObj->base.parent;
	deviceInfo = (NvDeviceInfo *) deviceObj->device->deviceInfo;
	hwdev = (HwDeviceInfo *) deviceInfo;
	offset = (&memoryObj->physAddr)->low - (&deviceInfo->fbPhysAddr)->low;
	fbMemFree (deviceInfo, offset);
	return 0;
}

ClassInfo           Nv01MemoryLocalLinearClassInfo = {
	(0x00000040), "nv03 memory local linear", sizeof (NvMemoryObj), 0x2, 1, (void *) 0,
		(void *) 0, Nv01AllocMemoryLocalLinear, (void *) 0, Nv01RealizeMemoryLocalLinear,
		Nv01FreeMemoryLocalLinear, (void *) 0, Nv01UnrealizeMemoryLocalLinear, 0,
		(void *) 0, 0, (void *) 0
};
NvV32
Nv03AttachMemoryLocalCursor (GenericObj *obj, NvClassAllocParameters *alloc)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *deviceInfo;
	HwDeviceInfo       *hwdev;
	NvU32               size;
	NvV32               status,
	                    flags,
	                    instance;
	Nv003fAllocParameters *memAlloc = (Nv003fAllocParameters *) alloc;

	flags = ((memAlloc->flags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
				((0 ? 3 : 0) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)) && (flags != (0x00000002))
		&& (flags != (0x00000003)))
	{
		;
		return (0x00000005);
	}
	flags = ((memAlloc->flags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 4) % 32) +
				((0 ? 7 : 4) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)) && (flags != (0x00000002))
		&& (flags != (0x00000003)) && (flags != (0x00000004)))
	{
		;
		return (0x00000006);
	}
	flags = ((memAlloc->flags >> ((0 ? 31 : 8) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 31 : 8) % 32) + ((0 ? 31 : 8) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)))
	{
		;
		return (0x00000007);
	}
	deviceObj = (NvDeviceObj *) memoryObj->base.parent;
	deviceInfo = (NvDeviceInfo *) deviceObj->device->deviceInfo;
	hwdev = (HwDeviceInfo *) deviceInfo;
	size = (unsigned long) (&memAlloc->limit)->low + 1;
	;
	if (size & 0xfff)
	{
		size = ((size + 0xfff) & ~0xfff);
		;
	}
	size = (((size + 15) & ~15) >> 4);
	status = fbAllocInstMemAlign (deviceInfo, &instance, &size, (((0xfff + 1 + 15) & ~15) >> 4),
		1);
	if (status != 0)
	{
		;
		return (0x00000002);
	}
	size <<= 4;
	(&memoryObj->limit)->high = 0, (&memoryObj->limit)->low = (NvU32) (size - 1);
	;
	(&memoryObj->physAddr)->low =
		(unsigned long) ((void *) ((&deviceInfo->imPhysAddr)->low + (instance << 4)));
	(&memoryObj->kernAddr)->low =
		(unsigned long) ((void *) ((unsigned long) deviceInfo->imAddr + (instance << 4)));
	;
	return (NV_PMC_BOOT_0);
}

NvV32
Nv03RealizeMemoryLocalCursor (GenericObj *obj, NvClassAllocParameters *alloc)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *deviceInfo;
	HwDeviceInfo       *hwdev;
	NvP64               base;
	Nv003fAllocParameters *memAlloc = (Nv003fAllocParameters *) alloc;
	NvV32               status,
	                    mappingId;

	;
	deviceObj = (NvDeviceObj *) memoryObj->base.parent;
	deviceInfo = (NvDeviceInfo *) deviceObj->device->deviceInfo;
	hwdev = (HwDeviceInfo *) deviceInfo;
	base = memoryObj->physAddr;
	status = nvArchMappingAllocPhysToUser (&base, memoryObj->limit, (memAlloc->flags),
		&mappingId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return (0x00000002);
	}
	memoryObj->usrAddr = base;
	memoryObj->usrId = mappingId;
	zeroMemory ((NvU32 *) (&memoryObj->kernAddr)->low,
		((unsigned long) (&memoryObj->limit)->low + 1) / 4);
	memAlloc->base = memoryObj->usrAddr;
	memAlloc->limit = memoryObj->limit;
	return (NV_PMC_BOOT_0);
}

NvV32
Nv03DetachMemoryLocalCursor (GenericObj *obj)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *deviceInfo;
	HwDeviceInfo       *hwdev;
	NvV32               instance;

	deviceObj = (NvDeviceObj *) memoryObj->base.parent;
	deviceInfo = (NvDeviceInfo *) deviceObj->device->deviceInfo;
	hwdev = (HwDeviceInfo *) deviceInfo;
	instance = ((&memoryObj->physAddr)->low - (&deviceInfo->imPhysAddr)->low) >> 4;
	fbFreeInstMem (deviceInfo, instance,
		((((unsigned long) (&memoryObj->limit)->low + 1 + 15) & ~15) >> 4));
	return (NV_PMC_BOOT_0);
}

NvV32
Nv03UnrealizeMemoryLocalCursor (GenericObj *obj)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;

	;
	if (memoryObj->usrId)
		nvArchMappingFree (memoryObj->usrId);
	return (NV_PMC_BOOT_0);
}

ClassInfo           Nv03MemoryLocalCursorClassInfo = {
	(0x0000003F), "nv03 memory local cursor", sizeof (NvMemoryObj), 0x2, 1, (void *) 0,
		(void *) 0, (void *) 0, Nv03AttachMemoryLocalCursor, Nv03RealizeMemoryLocalCursor,
		(void *) 0, Nv03DetachMemoryLocalCursor, Nv03UnrealizeMemoryLocalCursor, 0,
		(void *) 0, 0, (void *) 0
};
NvV32
Nv01AllocMemoryLocalBanked (GenericObj *obj, NvClassAllocParameters *alloc)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *deviceInfo;
	HwDeviceInfo       *hwdev;
	NvU32               offset,
	                    size;
	NvV32               status,
	                    flags;
	Nv003dAllocParameters *memAlloc = (Nv003dAllocParameters *) alloc;

	flags = ((memAlloc->flags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
				((0 ? 3 : 0) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)) && (flags != (0x00000002))
		&& (flags != (0x00000003)))
	{
		;
		return (0x00000005);
	}
	flags = ((memAlloc->flags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 4) % 32) +
				((0 ? 7 : 4) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)) && (flags != (0x00000002))
		&& (flags != (0x00000003)) && (flags != (0x00000004)))
	{
		;
		return (0x00000006);
	}
	flags = ((memAlloc->flags >> ((0 ? 31 : 8) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 31 : 8) % 32) + ((0 ? 31 : 8) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)))
	{
		;
		return (0x00000007);
	}
	deviceObj = (NvDeviceObj *) memoryObj->base.parent;
	deviceInfo = (NvDeviceInfo *) deviceObj->device->deviceInfo;
	hwdev = (HwDeviceInfo *) deviceInfo;
	size = (unsigned long) (&memAlloc->limit)->low + 1;
	status = fbMemAlloc (deviceInfo, (0x0000003D), memAlloc->portId, &size, &offset,
		(memAlloc->portId / 2) ? 0x01 : 0x00);
	if (status != 0)
	{
		;
		return (0x00000002);
	}
	(&memoryObj->limit)->high = 0, (&memoryObj->limit)->low = (NvU32) (size - 1);
	(&memoryObj->physAddr)->low =
		(unsigned long) ((void *) ((&deviceInfo->fbPhysAddr)->low + offset));
	(&memoryObj->kernAddr)->low = (unsigned long) (0);
	(&memoryObj->usrAddr)->low = (unsigned long) (0);
	return (NV_PMC_BOOT_0);
}

NvV32
Nv01RealizeMemoryLocalBanked (GenericObj *obj, NvClassAllocParameters *alloc)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *deviceInfo;
	HwDeviceInfo       *hwdev;
	Nv003dAllocParameters *memAlloc = (Nv003dAllocParameters *) alloc;
	NvP64               base;
	NvV32               status,
	                    mappingId;

	;
	deviceObj = (NvDeviceObj *) memoryObj->base.parent;
	deviceInfo = (NvDeviceInfo *) deviceObj->device->deviceInfo;
	hwdev = (HwDeviceInfo *) deviceInfo;
	base = memoryObj->physAddr;
	status = nvArchMappingAllocPhysToUser (&base, memoryObj->limit, (memAlloc->flags),
		&mappingId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return (0x00000002);
	}
	memoryObj->usrAddr = base;
	memoryObj->usrId = mappingId;
	base = memoryObj->physAddr;
	status = nvArchMappingAllocPhysToKern (&base, memoryObj->limit,
		(((NV_PMC_BOOT_0) << ((0 ? 3 : 0) % 32)) | ((NV_PMC_BOOT_0) << ((0 ? 7 : 4) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 31 : 8) % 32))),
		&mappingId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return (0x00000002);
	}
	zeroMemory ((NvU32 *) (&base)->low, ((unsigned long) (&memoryObj->limit)->low + 1) / 4);
	nvArchMappingFree (mappingId);
	memAlloc->base = memoryObj->usrAddr;
	memAlloc->limit = memoryObj->limit;
	return (NV_PMC_BOOT_0);
}

NvV32
Nv01UnrealizeMemoryLocalBanked (GenericObj *obj)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;

	;
	if (memoryObj->usrId)
		nvArchMappingFree (memoryObj->usrId);
	return (NV_PMC_BOOT_0);
}

NvV32
Nv01FreeMemoryLocalBanked (GenericObj *obj)
{
	NvMemoryObj        *memoryObj = (NvMemoryObj *) obj;
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *deviceInfo;
	HwDeviceInfo       *hwdev;
	NvU32               offset;

	;
	;
	;
	deviceObj = (NvDeviceObj *) memoryObj->base.parent;
	deviceInfo = (NvDeviceInfo *) deviceObj->device->deviceInfo;
	hwdev = (HwDeviceInfo *) deviceInfo;
	offset = (&memoryObj->physAddr)->low - (&deviceInfo->fbPhysAddr)->low;
	fbMemFree (deviceInfo, offset);
	return 0;
}

ClassInfo           Nv01MemoryLocalBankedClassInfo = {
	(0x0000003D), "nv03 memory local banked", sizeof (NvMemoryObj), 0x2, 1, (void *) 0,
		(void *) 0, Nv01AllocMemoryLocalBanked, (void *) 0, Nv01RealizeMemoryLocalBanked,
		Nv01FreeMemoryLocalBanked, (void *) 0, Nv01UnrealizeMemoryLocalBanked, 0,
		(void *) 0, 0, (void *) 0
};
