 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvU8                iniFlag = 0;
NvU32               wMaxWaitStates = 3000;
static NvU8
i2cHardwareInit (NvDeviceInfo *device, NvU32 portId)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	if (iniFlag == 1)
		return 1;
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x0000003F) & 0x3F);
		(hwreg)->Reg8[0x006013d5] = (NvV8) ((0x31));
	};
	iniFlag = 1;
	return 1;
}
static void
i2cWriteCtrl (NvDeviceInfo *device, NvU32 portId, NvU8 reg, NvU8 bit)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU8                data;

	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x0000003F) & 0x3F);
		(data) = ((hwreg)->Reg8[0x006013d5]);
	};
	data &= 0xf0;
	data |= 0x01;
	if (reg == 0x01)
	{
		if (bit)
			data |= 0x20;
		else
			data &= ~0x20;
	}
	else
	{
		if (bit)
			data |= 0x10;
		else
			data &= ~0x10;
	}
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x0000003F) & 0x3F);
		(hwreg)->Reg8[0x006013d5] = (NvV8) ((data));
	};
}
static NvU8
i2cReadCtrl (NvDeviceInfo *device, NvU32 portId, NvU8 reg)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU8                data;

	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x0000003E) & 0x3F);
		(data) = ((hwreg)->Reg8[0x006013d5]);
	};
	if (reg == 0x01)
		return ((data & 0x04) != 0);
	else
		return ((data & 0x08) != 0);
}
static void
readSDA (NvDeviceInfo *device, NvU8 *data)
{
	*data = i2cReadCtrl (device, 0x00, 0x02);
}
static void
readSCL (NvDeviceInfo *device, NvU8 *data)
{
	*data = i2cReadCtrl (device, 0x00, 0x01);
}
static void
setSCLLine (NvDeviceInfo *device)
{
	i2cWriteCtrl (device, 0x00, 0x01, 1);
}
static void
resetSCLLine (NvDeviceInfo *device)
{
	i2cWriteCtrl (device, 0x00, 0x01, 0);
}
static void
setSDALine (NvDeviceInfo *device)
{
	i2cWriteCtrl (device, 0x00, 0x02, 1);
}
static void
resetSDALine (NvDeviceInfo *device)
{
	i2cWriteCtrl (device, 0x00, 0x02, 0);
}
static NvU8
waitHighSDALine (NvDeviceInfo *device)
{
	NvU8                data_in;
	NvU32               retries = wMaxWaitStates;

	do
	{
		readSDA (device, &data_in);
		if (data_in)
			break;
		tmrDelay (device, 5000);
	}
	while (retries--);
	if (!retries)
		return (-1);
	return 0;
}
static NvU8
waitHighSCLLine (NvDeviceInfo *device)
{
	NvU8                data_in;
	NvU32               retries = wMaxWaitStates;

	do
	{
		readSCL (device, (NvU8 *) &data_in);
		if (data_in)
			break;
		tmrDelay (device, 2500);
	}
	while (retries--);
	if (!retries)
		return (-1);
	return (0);
}

void
i2cStart (NvDeviceInfo *device)
{
	setSDALine (device);
	tmrDelay (device, 5000);
	setSCLLine (device);
	waitHighSCLLine (device);
	resetSDALine (device);
	tmrDelay (device, 5000);
	resetSCLLine (device);
}

void
i2cStop (NvDeviceInfo *device)
{
	resetSCLLine (device);
	resetSDALine (device);
	tmrDelay (device, 5000);
	setSCLLine (device);
	waitHighSCLLine (device);
	setSDALine (device);
	waitHighSDALine (device);
	tmrDelay (device, 5000);
}
static NvU8
i2cAck (NvDeviceInfo *device)
{
	NvU8                ack;

	resetSCLLine (device);
	tmrDelay (device, 5000);
	setSDALine (device);
	tmrDelay (device, 5000);
	setSCLLine (device);
	waitHighSCLLine (device);
	readSDA (device, &ack);
	resetSCLLine (device);
	return (ack);
}

void
i2cInit (NvDeviceInfo *device)
{
	setSCLLine (device);
	waitHighSCLLine (device);
	setSDALine (device);
	waitHighSDALine (device);
}
static NvU8
i2cSendByte (NvDeviceInfo *device, NvU8 byte)
{
	NvU8                i;

	for (i = 0; i < 8; i++)
	{
		resetSCLLine (device);
		if (byte & 0x80)
			setSDALine (device);
		else
			resetSDALine (device);
		tmrDelay (device, 2500);
		setSCLLine (device);
		waitHighSCLLine (device);
		byte <<= 1;
	}
	return (i2cAck (device));
}
static void
i2cReceiveByte (NvDeviceInfo *device, NvU8 *byte, NvU8 ack)
{
	NvU8                data = 0;
	NvU8                i;

	resetSCLLine (device);
	setSDALine (device);
	waitHighSDALine (device);
	for (i = 0; i < 8; i++)
	{
		resetSCLLine (device);
		resetSCLLine (device);
		setSCLLine (device);
		waitHighSCLLine (device);
		readSDA (device, &data);
		*byte <<= 1;
		*byte |= (data == 1);
	}
	resetSCLLine (device);
	if (ack)
	{
		setSDALine (device);
		tmrDelay (device, 1000);
	}
	else
	{
		resetSDALine (device);
	}
	setSCLLine (device);
	waitHighSCLLine (device);
	resetSCLLine (device);
}

NvV32
i2cWrite (NvDeviceInfo *device, NvU8 chipAddr, NvU16 addrLen, NvU8 *addr, NvU16 dataLen, NvU8 *data)
{
	i2cHardwareInit (device, 0x00);
	i2cStart (device);
	if (i2cSendByte (device, (NvU8) (chipAddr << 1)))
	{
		i2cStop (device);
		return -2;
	}
	for (; addrLen; addrLen--)
	{
		if (i2cSendByte (device, *addr++))
		{
			i2cStop (device);
			return -2;
		}
	}
	for (; dataLen; dataLen--)
	{
		if (i2cSendByte (device, *data++))
		{
			i2cStop (device);
			return -2;
		}
	}
	i2cStop (device);
	return 0;
}

NvV32
i2cRead (NvDeviceInfo *device, NvU8 chipAddr, NvU16 addrLen, NvU8 *addr, NvU16 dataLen, NvU8 *data)
{
	NvU8                dat;

	i2cHardwareInit (device, 0x00);
	i2cStart (device);
	i2cSendByte (device, (NvU8) (chipAddr << 1));
	for (; addrLen; addrLen--)
	{
		if (i2cSendByte (device, *addr++))
		{
			i2cStop (device);
			return -2;
		}
	}
	i2cStart (device);
	if (i2cSendByte (device, (NvU8) ((chipAddr << 1) | 1)))
	{
		i2cStop (device);
		return -2;
	}
	for (; dataLen; dataLen--)
	{
		i2cReceiveByte (device, (NvU8 *) &dat, (NvU8) ((dataLen == 1) ? 0x01 : 0x00));
		*data++ = dat;
	}
	i2cStop (device);
	return 0;
}

NvV32
i2cWrite_ALT (NvDeviceInfo *device, NvU8 chipAddr, NvU16 dataLen, NvU8 *data)
{
	i2cHardwareInit (device, 0x00);
	i2cStart (device);
	if (i2cSendByte (device, (NvU8) (chipAddr << 1)))
	{
		i2cStop (device);
		return -2;
	}
	for (; dataLen; dataLen--)
	{
		if (i2cSendByte (device, *data++))
		{
			i2cStop (device);
			return -2;
		}
	}
	i2cStop (device);
	return 0;
}

NvV32
i2cRead_ALT (NvDeviceInfo *device, NvU8 chipAddr, NvU16 dataLen, NvU8 *data)
{
	NvU8                dat;

	;
	i2cHardwareInit (device, 0x00);
	i2cStart (device);
	i2cSendByte (device, (NvU8) ((chipAddr << 1) | 1));
	for (; dataLen; dataLen--)
	{
		i2cReceiveByte (device, (NvU8 *) &dat, (NvU8) ((dataLen == 1) ? 0x01 : 0x00));
		*data++ = dat;
	}
	i2cStop (device);
	return 0;
}

NvV32
i2cRead_ALT2 (NvDeviceInfo *device, NvU8 chipAddr, NvU16 addrLen, NvU8 *addr, NvU16 dataLen,
	NvU8 *data)
{
	NvU8                dat;

	i2cHardwareInit (device, 0x00);
	i2cStart (device);
	i2cSendByte (device, (NvU8) (chipAddr << 1));
	for (; addrLen; addrLen--)
	{
		if (i2cSendByte (device, *addr++))
		{
			i2cStop (device);
			return -2;
		}
	}
	i2cStop (device);
	i2cStart (device);
	if (i2cSendByte (device, (NvU8) ((chipAddr << 1) | 1)))
	{
		i2cStop (device);
		return -2;
	}
	for (; dataLen; dataLen--)
	{
		i2cReceiveByte (device, (NvU8 *) &dat, (NvU8) ((dataLen == 1) ? 0x01 : 0x00));
		*data++ = dat;
	}
	i2cStop (device);
	return 0;
}
