 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


extern int          grRenderObjectValidForRendering (EngineObj *engObj);
extern int          grRenderObjectValidForHardware (EngineObj *engObj);
extern int          grImageBlitValidForRendering (EngineObj *engObj);
extern int          grImageBlitValidForHardware (EngineObj *engObj);
extern int          grImageObjectValidForRendering (EngineObj *engObj);
extern int          grImageObjectValidForHardware (EngineObj *engObj);
extern int          grImageFromMemValidForRendering (EngineObj *engObj);
extern int          grImageFromMemValidForHardware (EngineObj *engObj);
extern int          grMemoryToMemoryFormatValidForHardware (EngineObj *engObj);
extern int          grContextObjectValidForHardware (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForRendering (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForHardware (EngineObj *engObj);
extern int          grGdiRectObjectValidForRendering (EngineObj *engObj);
extern int          grGdiRectObjectValidForHardware (EngineObj *engObj);
extern void         grValidateObject (EngineObj *obj);
static void
grUpdateFifoContext (EngineObj *engObj)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwReg              *hwram = ((hwdev)->base.imAddr);
	HashTableEntry     *hwHashTable = (HashTableEntry *) hwdev->info.Pram.HashTableAddr;
	NvV32               context;
	NvV32               pull0,
	                    push0,
	                    reassign;
	int                 i;

	context = engObj->context;
	if (engObj->base.mask & 0x1000)
	{
		;
		context &= ~((0x00000001) << ((0 ? (1 * 32 + 23) : (1 * 32 + 23)) & 31));
	}
	reassign = ((hwreg)->Reg32[(NV_PFIFO_CACHES) / 4]);
	pull0 = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4]);
	push0 = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4]);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
		(NvV32) ((((hwreg)->Reg32[(NV_PFIFO_CACHES) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 0 : 0) % 32) +
						((0 ? 0 : 0) % 32))) << ((0 ? 0 : 0) %
					32))) | ((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
		(NvV32) ((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 0 : 0) % 32) +
						((0 ? 0 : 0) % 32))) << ((0 ? 0 : 0) %
					32))) | ((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
		(NvV32) ((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 0 : 0) % 32) +
						((0 ? 0 : 0) % 32))) << ((0 ? 0 : 0) %
					32))) | ((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	for (i = 0; i < 8; i++)
	{
		NvV32               fifoContext = ((hwreg)->Reg32[((0x00003280 + (i) * 16)) / 4]);

		;
		if (engObj->instMemLoc ==
			(((fifoContext) >> ((0 ? 15 : 0) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 15 : 0) % 32) + ((0 ? 15 : 0) % 32)))))
		{
			;
			;
			;
			;
			(hwreg)->Reg32[((0x00003280 + (i) * 16)) / 4] =
				(NvV32) (context & 0xffffff);
		}
	}
	if (engObj->hashEntry != (~0))
	{
		;
		;
		(hwram)->Reg32[((NvU32) &hwHashTable[engObj->hashEntry].context -
				(0 ? 0x01FFFFFF : 0x01C00000)) / 4] = (NvV32) (context);
	}
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] = (NvV32) (push0);
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] = (NvV32) (pull0);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (reassign);
}

int
grRenderObjectValidForRendering (EngineObj *engObj)
{
	GrRenderObj        *obj = (GrRenderObj *) engObj;
	NvV32               patchConfig =
		(((obj->ctxSwitch) >> ((0 ? 28 : 24) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 28 : 24) % 32) + ((0 ? 28 : 24) % 32))));
	NvV32               colorFormat =
		(((obj->ctxSwitch) >> ((0 ? 2 : 0) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 2 : 0) % 32) + ((0 ? 2 : 0) % 32))));
	int                 check1 = patchConfig != 0x00000010 || obj->ctxPattern != (void *) 0;
	int                 check2 = patchConfig != 0x00000010 || obj->ctxRop != (void *) 0;
	int                 check3 = patchConfig != 0x00000019 || obj->ctxBeta1 != (void *) 0;
	int                 check4 = obj->ctxSurfaces2d != (void *) 0
		&& (((GrNv03Surfaces2dObj *) obj->ctxSurfaces2d)->ctxDmaDestin != (void *) 0)
		&& (((GrNv03Surfaces2dObj *) obj->ctxSurfaces2d)->ctxDmaSource != (void *) 0);
	int                 check5 = engObj->base.mask & 0x2000;
	int                 result = check1 && check2 && check3 && check4 && check5;

	if (result)
	{
		result = ((((GrNv03Surfaces2dObj *) obj->ctxSurfaces2d)->colorFormat != (0x00000001)
				|| colorFormat == 0x00000003)
			&& (((GrNv03Surfaces2dObj *) obj->ctxSurfaces2d)->colorFormat !=
				(0x00000005) || colorFormat == 0x00000004));
		result = result
			&& ((((GrNv03Surfaces2dObj *) obj->ctxSurfaces2d)->colorFormat !=
				(0x00000001) || patchConfig == 0x00000017
				|| patchConfig == 0x00000010)
			&& (((GrNv03Surfaces2dObj *) obj->ctxSurfaces2d)->colorFormat !=
				(0x00000005) || patchConfig == 0x00000017));
	}
	;
	return result;
}

int
grRenderObjectValidForHardware (EngineObj *engObj)
{
	GrRenderObj        *obj = (GrRenderObj *) engObj;
	int                 check1 = obj->base.notifyCtxDma != (void *) 0;
	int                 check2345 = grRenderObjectValidForRendering (engObj);
	int                 result = check1 && check2345;

	;
	return result;
}

int
grImageBlitValidForRendering (EngineObj *engObj)
{
	GrImageObj         *imageObj = (GrImageObj *) engObj;
	GrRenderObj        *rendObj = (GrRenderObj *) &imageObj->base;
	NvV32               patchConfig =
		(((rendObj->ctxSwitch) >> ((0 ? 28 : 24) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 28 : 24) % 32) + ((0 ? 28 : 24) % 32))));
	int                 check1 = (patchConfig == 0x00000017
		|| imageObj->ctxColorKey == (void *) 0);
	int                 check2 = patchConfig != 0x00000010 || rendObj->ctxPattern != (void *) 0;
	int                 check3 = patchConfig != 0x00000010 || rendObj->ctxRop != (void *) 0;
	int                 check4 = patchConfig != 0x00000019 || rendObj->ctxBeta1 != (void *) 0;
	int                 check5 = rendObj->ctxSurfaces2d != (void *) 0
		&& (((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->ctxDmaDestin != (void *) 0)
		&& (((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->ctxDmaSource != (void *) 0);
	int                 check6 = engObj->base.mask & 0x2000;
	int                 result = check1 && check2 && check3 && check4 && check5 && check6;

	if (result)
	{
		result = ((((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->colorFormat !=
				(0x00000001) || patchConfig == 0x00000017
				|| patchConfig == 0x00000010)
			&& (((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->colorFormat !=
				(0x00000005) || patchConfig == 0x00000017)
			&& (((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->colorFormat !=
				(0x00000005) || imageObj->ctxColorKey == (void *) 0));
	}
	;
	return result;
}

int
grImageBlitValidForHardware (EngineObj *engObj)
{
	int                 check1 = engObj->notifyCtxDma != (void *) 0;
	int                 check23456 = grImageBlitValidForRendering (engObj);
	int                 result = check1 && check23456;

	;
	return result;
}

int
grImageObjectValidForRendering (EngineObj *engObj)
{
	GrImageObj         *imageObj = (GrImageObj *) engObj;
	GrRenderObj        *rendObj = (GrRenderObj *) &imageObj->base;
	NvV32               patchConfig =
		(((rendObj->ctxSwitch) >> ((0 ? 28 : 24) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 28 : 24) % 32) + ((0 ? 28 : 24) % 32))));
	NvV32               colorFormat =
		(((rendObj->ctxSwitch) >> ((0 ? 2 : 0) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 2 : 0) % 32) + ((0 ? 2 : 0) % 32))));
	int                 check1 = (patchConfig == 0x00000017
		|| imageObj->ctxColorKey == (void *) 0);
	int                 check2 = patchConfig != 0x00000010 || rendObj->ctxPattern != (void *) 0;
	int                 check3 = patchConfig != 0x00000010 || rendObj->ctxRop != (void *) 0;
	int                 check4 = patchConfig != 0x00000019 || rendObj->ctxBeta1 != (void *) 0;
	int                 check5 = rendObj->ctxSurfaces2d != (void *) 0
		&& (((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->ctxDmaDestin != (void *) 0)
		&& (((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->ctxDmaSource != (void *) 0);
	int                 check6 = engObj->base.mask & 0x2000;
	int                 result = check1 && check2 && check3 && check4 && check5 && check6;

	if (result)
	{
		result = ((((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->colorFormat !=
				(0x00000001) || colorFormat == 0x00000003)
			&& (((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->colorFormat !=
				(0x00000005))
			&& ((((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->colorFormat !=
					(0x00000001) || patchConfig == 0x00000017
					|| patchConfig == 0x00000010)));
	}
	;
	return result;
}

int
grImageObjectValidForHardware (EngineObj *engObj)
{
	int                 result = grImageObjectValidForRendering (engObj);

	;
	return result;
}

int
grImageFromMemValidForRendering (EngineObj *engObj)
{
	GrImageFromMemObj  *imageObj = (GrImageFromMemObj *) engObj;
	GrRenderObj        *rendObj = (GrRenderObj *) &imageObj->base;
	NvV32               patchConfig =
		(((rendObj->ctxSwitch) >> ((0 ? 28 : 24) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 28 : 24) % 32) + ((0 ? 28 : 24) % 32))));
	int                 check1 = imageObj->ctxDmaImage != (void *) 0;
	int                 check2 = patchConfig != 0x00000010 || rendObj->ctxPattern != (void *) 0;
	int                 check3 = patchConfig != 0x00000010 || rendObj->ctxRop != (void *) 0;
	int                 check4 = patchConfig != 0x00000019 || rendObj->ctxBeta1 != (void *) 0;
	int                 check5 = rendObj->ctxSurfaces2d != (void *) 0
		&& (((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->ctxDmaDestin != (void *) 0)
		&& (((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->ctxDmaSource != (void *) 0);
	int                 check6 = engObj->base.mask & 0x2000;
	int                 result = check1 && check2 && check3 && check4 && check5 && check6;

	if (result)
	{
		result = ((((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->colorFormat !=
				(0x00000001))
			&& (((GrNv03Surfaces2dObj *) rendObj->ctxSurfaces2d)->colorFormat !=
				(0x00000005)));
	}
	;
	return result;
}

int
grImageFromMemValidForHardware (EngineObj *engObj)
{
	int                 result = grImageFromMemValidForRendering (engObj);

	;
	return result;
}

int
grDx3TexturedTriangleValidForRendering (EngineObj *engObj)
{
	GrDx3TexTriObj     *obj = (GrDx3TexTriObj *) engObj;
	int                 check1 = obj->base.ctxSurfaces3d
		&& ((GrNv03Surfaces3dObj *) obj->base.ctxSurfaces3d)->ctxDmaSurface;
	int                 check2 = (obj->ctxDmaTexture != (void *) 0);
	int                 check3 = engObj->base.mask & 0x2000;
	int                 result = check1 && check2 && check3;

	;
	return result;
}

int
grDx3TexturedTriangleValidForHardware (EngineObj *engObj)
{
	GrDx3TexTriObj     *obj = (GrDx3TexTriObj *) engObj;
	int                 check1 = obj->base.base.notifyCtxDma != (void *) 0;
	int                 check234 = grDx3TexturedTriangleValidForRendering (engObj);
	int                 result = check1 && check234;

	;
	return result;
}

int
grMemoryToMemoryFormatValidForHardware (EngineObj *engObj)
{
	GrMemToMemObj      *obj = (GrMemToMemObj *) engObj;
	int                 check1 = obj->base.notifyCtxDma != (void *) 0;
	int                 check2 = obj->ctxDmaBufferIn != (void *) 0;
	int                 check3 = obj->ctxDmaBufferOut != (void *) 0;
	int                 result = check1 && check2 && check3;

	;
	return result;
}

int
grGdiRectObjectValidForRendering (EngineObj *engObj)
{
	GrRenderObj        *obj = (GrRenderObj *) engObj;
	NvV32               patchConfig =
		(((obj->ctxSwitch) >> ((0 ? 28 : 24) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 28 : 24) % 32) + ((0 ? 28 : 24) % 32))));
	NvV32               colorFormat =
		(((obj->ctxSwitch) >> ((0 ? 2 : 0) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 2 : 0) % 32) + ((0 ? 2 : 0) % 32))));
	int                 check1 = patchConfig != 0x00000010 || obj->ctxPattern != (void *) 0;
	int                 check2 = patchConfig != 0x00000010 || obj->ctxRop != (void *) 0;
	int                 check3 = patchConfig != 0x00000019 || obj->ctxBeta1 != (void *) 0;
	int                 check4 = obj->ctxSurfaces2d != (void *) 0
		&& (((GrNv03Surfaces2dObj *) obj->ctxSurfaces2d)->ctxDmaDestin != (void *) 0)
		&& (((GrNv03Surfaces2dObj *) obj->ctxSurfaces2d)->ctxDmaSource != (void *) 0);
	int                 check5 = engObj->base.mask & 0x2000;
	int                 result = check1 && check2 && check3 && check4 && check5;

	if (result)
	{
		result = ((((GrNv03Surfaces2dObj *) obj->ctxSurfaces2d)->colorFormat != (0x00000001)
				|| colorFormat == 0x00000003)
			&& (((GrNv03Surfaces2dObj *) obj->ctxSurfaces2d)->colorFormat !=
				(0x00000005)));
		result = result
			&& ((((GrNv03Surfaces2dObj *) obj->ctxSurfaces2d)->colorFormat !=
				(0x00000001) || patchConfig == 0x00000017
				|| patchConfig == 0x00000010));
	}
	;
	return result;
}

int
grGdiRectObjectValidForHardware (EngineObj *engObj)
{
	GrRenderObj        *obj = (GrRenderObj *) engObj;
	int                 check1 = obj->base.notifyCtxDma != (void *) 0;
	int                 check2345 = grGdiRectObjectValidForRendering (engObj);
	int                 result = check1 && check2345;

	;
	return result;
}

int
grContextObjectValidForHardware (EngineObj *obj)
{
	int                 check1 = obj->notifyCtxDma != (void *) 0;
	int                 result = check1;

	;
	return result;
}

void
grValidateObject (EngineObj *engObj)
{
	EngineObjInfo      *engObjInfo = ((engObj)->base.classInfo->objectInfo);

	if (engObjInfo->validateForHardware (engObj))
	{
		;
		if (engObj->base.mask & 0x1000)
		{
			engObj->base.mask &= ~0x1000;
			grUpdateFifoContext (engObj);
		}
	}
	else
	{
		;
		if (!(engObj->base.mask & 0x1000))
		{
			engObj->base.mask |= 0x1000;
			grUpdateFifoContext (engObj);
		}
	}
}
