 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


extern NvV32        mthdUnimplemented (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSwSetContextDmaNotifies (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdUnimplemented (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrNoOperation (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrResend (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrRenderResend (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaNotifies (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaScaledImage (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaTexture (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaA (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaB (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc539 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc536 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc537 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextSurfaces2d (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextSurfaces3d (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextClipRectangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextColorKey (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextPattern (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextRop (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextBeta1 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetColorFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetMonochromeFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetOperation (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrNotify (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaBufferIn (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaBufferOut (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderLin (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderTriangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdDx3Control0 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderRectangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageBlt (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageTransfer (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdMemoryToMemoryFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderDx3TexturedTriangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderGdiRectangleText (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageFromMem (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern int          grRenderObjectValidForRendering (EngineObj *engObj);
extern int          grRenderObjectValidForHardware (EngineObj *engObj);
extern int          grImageBlitValidForRendering (EngineObj *engObj);
extern int          grImageBlitValidForHardware (EngineObj *engObj);
extern int          grImageObjectValidForRendering (EngineObj *engObj);
extern int          grImageObjectValidForHardware (EngineObj *engObj);
extern int          grImageFromMemValidForRendering (EngineObj *engObj);
extern int          grImageFromMemValidForHardware (EngineObj *engObj);
extern int          grMemoryToMemoryFormatValidForHardware (EngineObj *engObj);
extern int          grContextObjectValidForHardware (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForRendering (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForHardware (EngineObj *engObj);
extern int          grGdiRectObjectValidForRendering (EngineObj *engObj);
extern int          grGdiRectObjectValidForHardware (EngineObj *engObj);
extern void         grValidateObject (EngineObj *obj);
static void
grUpdateSurface (EngineObj *engObj)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvContextDmaObj    *ctxDmaObj;
	NvU32               blimit0,
	                    blimit1,
	                    height;
	NvU32               bbase0,
	                    bbase1;
	NvU32               bpixel,
	                    state;

	;
	if (chid == hwdev->info.Graphics.CurrentChID)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		bpixel = ((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4]);
		state = ((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]);
	}
	else
	{
		bpixel = hwchan->gr.bpixel;
		state = hwchan->gr.state;
	}
	if (((engObj)->base.classInfo->num) == (0x00000058))
	{
		GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
		NvU32               colorFmt;

		bpixel &=
			(~((0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
						((0 ? 3 : 0) % 32))) << ((0 ? 3 : 0) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 7 : 4) % 32) +
						((0 ? 7 : 4) % 32))) << ((0 ? 7 : 4) % 32)));
		state &= (~((0xFFFFFFFF >> (31 - ((1 ? 0 : 0) % 32) +
						((0 ? 0 : 0) % 32))) << ((0 ? 0 : 0) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 1 : 1) % 32) +
						((0 ? 1 : 1) % 32))) << ((0 ? 1 : 1) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 8 : 8) % 32) +
						((0 ? 8 : 8) % 32))) << ((0 ? 8 : 8) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 9 : 9) % 32) +
						((0 ? 9 : 9) % 32))) << ((0 ? 9 : 9) % 32)));
		colorFmt = surfacesObj->colorFormat;
		ctxDmaObj = surfacesObj->ctxDmaDestin;
		if (ctxDmaObj == (void *) 0)
		{
			bbase0 = 0;
			blimit0 = 0;
		}
		else
		{
			bbase0 = ((&ctxDmaObj->pteBase)->low);
			height = ((((((unsigned long) (&ctxDmaObj->limit)->low + 1) -
							surfacesObj->offsetDest) /
						surfacesObj->destPitch) <
					0x3ffe) ? ((((unsigned long) (&ctxDmaObj->limit)->low + 1) -
						surfacesObj->offsetDest) /
					surfacesObj->destPitch) : 0x3ffe);
			blimit0 = surfacesObj->offsetDest + (height * surfacesObj->destPitch) - 1;
			if (colorFmt == (0x00000001))
				bpixel |= ((0x00000001) << ((0 ? 3 : 0) % 32));
			else if (colorFmt == (0x00000005))
				bpixel |= ((0x00000006) << ((0 ? 3 : 0) % 32));
			else if (colorFmt == (0x00000002))
				bpixel |= ((0x00000002) << ((0 ? 3 : 0) % 32));
			else if (colorFmt == (0x00000006))
				bpixel |= ((0x00000007) << ((0 ? 3 : 0) % 32));
			state |= (((0x00000001) << ((0 ? 0 : 0) %
						32)) | ((0x00000001) << ((0 ? 8 : 8) % 32)));
		}
		ctxDmaObj = surfacesObj->ctxDmaSource;
		if (ctxDmaObj == (void *) 0)
		{
			bbase1 = 0;
			blimit1 = 0;
		}
		else
		{
			bbase1 = ((&ctxDmaObj->pteBase)->low);
			height = ((((((unsigned long) (&ctxDmaObj->limit)->low + 1) -
							surfacesObj->offsetSrc) /
						surfacesObj->srcPitch) <
					0x3ffe) ? ((((unsigned long) (&ctxDmaObj->limit)->low + 1) -
						surfacesObj->offsetSrc) /
					surfacesObj->srcPitch) : 0x3ffe);
			blimit1 = surfacesObj->offsetSrc + (height * surfacesObj->srcPitch) - 1;
			if (colorFmt == (0x00000001))
				bpixel |= ((0x00000001) << ((0 ? 7 : 4) % 32));
			else if (colorFmt == (0x00000005))
				bpixel |= ((0x00000006) << ((0 ? 7 : 4) % 32));
			else if (colorFmt == (0x00000002))
				bpixel |= ((0x00000002) << ((0 ? 7 : 4) % 32));
			else if (colorFmt == (0x00000006))
				bpixel |= ((0x00000007) << ((0 ? 7 : 4) % 32));
			state |= (((0x00000001) << ((0 ? 1 : 1) %
						32)) | ((0x00000001) << ((0 ? 9 : 9) % 32)));
		}
		;
		;
		;
		;
		if (chid == hwdev->info.Graphics.CurrentChID)
		{
			(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (0) * 4)) / 4] = (NvV32) (bbase0);
			(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (0) * 4)) / 4] = (NvV32) (blimit0);
			(hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (0) * 4)) / 4] =
				(NvV32) (surfacesObj->destPitch);
			(hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (0) * 4)) / 4] =
				(NvV32) (surfacesObj->offsetDest);
			(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (1) * 4)) / 4] = (NvV32) (bbase1);
			(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (1) * 4)) / 4] = (NvV32) (blimit1);
			(hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (1) * 4)) / 4] =
				(NvV32) (surfacesObj->srcPitch);
			(hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (1) * 4)) / 4] =
				(NvV32) (surfacesObj->offsetSrc);
			(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] = (NvV32) (bpixel);
			(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] = (NvV32) (state);
		}
		else
		{
			hwchan->gr.bbase[0] = bbase0;
			hwchan->gr.blimit[0] = blimit0;
			hwchan->gr.bpitch[0] = surfacesObj->destPitch;
			hwchan->gr.boffset[0] = surfacesObj->offsetDest;
			hwchan->gr.bbase[1] = bbase1;
			hwchan->gr.blimit[1] = blimit1;
			hwchan->gr.bpitch[1] = surfacesObj->destPitch;
			hwchan->gr.boffset[1] = surfacesObj->offsetDest;
			hwchan->gr.bpixel = bpixel;
			hwchan->gr.state = state;
		}
	}
	else if (((engObj)->base.classInfo->num) == (0x0000005A))
	{
		GrNv03Surfaces3dObj *surfacesObj = (GrNv03Surfaces3dObj *) engObj;

		bpixel &=
			(~((0xFFFFFFFF >> (31 - ((1 ? 11 : 8) % 32) +
						((0 ? 11 : 8) % 32))) << ((0 ? 11 : 8) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 15 : 12) % 32) +
						((0 ? 15 : 12) % 32))) << ((0 ? 15 : 12) % 32)));
		state &= (~((0xFFFFFFFF >> (31 - ((1 ? 2 : 2) % 32) +
						((0 ? 2 : 2) % 32))) << ((0 ? 2 : 2) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 3 : 3) % 32) +
						((0 ? 3 : 3) % 32))) << ((0 ? 3 : 3) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 10 : 10) % 32) +
						((0 ? 10 : 10) % 32))) << ((0 ? 10 : 10) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 11 : 11) % 32) +
						((0 ? 11 : 11) % 32))) << ((0 ? 11 : 11) % 32)));
		ctxDmaObj = surfacesObj->ctxDmaSurface;
		if (ctxDmaObj == (void *) 0)
		{
			bbase0 = 0;
			bbase1 = 0;
			blimit0 = 0;
			blimit1 = 0;
		}
		else
		{
			;
			bbase0 = bbase1 = ((&ctxDmaObj->pteBase)->low);
			height = ((((unsigned long) (&ctxDmaObj->limit)->low + 1) -
					((surfacesObj->offsetColor >
							surfacesObj->offsetZeta) ? surfacesObj->
						offsetColor : surfacesObj->offsetZeta))) /
				surfacesObj->pitch;
			blimit0 = surfacesObj->offsetColor + (height * surfacesObj->pitch) - 1;
			blimit1 = surfacesObj->offsetZeta + (height * surfacesObj->pitch) - 1;
			if (blimit0 == (NvU32) -1)
				blimit0 = 0;
			if (blimit1 == (NvU32) -1)
				blimit1 = 0;
			bpixel |=
				(((0x00000002) << ((0 ? 11 : 8) %
						32)) | ((0x00000002) << ((0 ? 15 : 12) % 32)));
			state |= (((0x00000001) << ((0 ? 2 : 2) %
						32)) | ((0x00000001) << ((0 ? 3 : 3) %
						32)) | ((0x00000001) << ((0 ? 10 : 10) %
						32)) | ((0x00000001) << ((0 ? 11 : 11) % 32)));
		}
		;
		;
		;
		;
		if (chid == hwdev->info.Graphics.CurrentChID)
		{
			(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (2) * 4)) / 4] = (NvV32) (bbase0);
			(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (2) * 4)) / 4] = (NvV32) (blimit0);
			(hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (2) * 4)) / 4] =
				(NvV32) (surfacesObj->pitch);
			(hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (2) * 4)) / 4] =
				(NvV32) (surfacesObj->offsetColor);
			(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (3) * 4)) / 4] = (NvV32) (bbase1);
			(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (3) * 4)) / 4] = (NvV32) (blimit1);
			(hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (3) * 4)) / 4] =
				(NvV32) (surfacesObj->pitch);
			(hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (3) * 4)) / 4] =
				(NvV32) (surfacesObj->offsetZeta);
			(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] = (NvV32) (bpixel);
			(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] = (NvV32) (state);
		}
		else
		{
			hwchan->gr.bbase[2] = bbase0;
			hwchan->gr.blimit[2] = blimit0;
			hwchan->gr.bpitch[2] = surfacesObj->pitch;
			hwchan->gr.boffset[2] = surfacesObj->offsetColor;
			hwchan->gr.bbase[3] = bbase1;
			hwchan->gr.blimit[3] = blimit1;
			hwchan->gr.bpitch[3] = surfacesObj->pitch;
			hwchan->gr.boffset[3] = surfacesObj->offsetZeta;
			hwchan->gr.bpixel = bpixel;
			hwchan->gr.state = state;
		}
	}
	else
	{
		;
	}
}
static NvV32
grAttachNv03Surfaces2dObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvV32               status;

	;
	if (hwchan->nv03Surfaces2d != (void *) 0)
	{
		;
		return (0x00000002);
	}
	if ((status = swAttachEngineObject (genObj, alloc)) != 0)
	{
		;
		return status;
	}
	surfacesObj->colorFormat = (0x00000001);
	surfacesObj->srcPitch = 0x40;
	surfacesObj->destPitch = 0x40;
	surfacesObj->offsetSrc = 0;
	surfacesObj->offsetDest = 0;
	surfacesObj->ctxDmaDestin = (void *) 0;
	surfacesObj->ctxDmaSource = (void *) 0;
	(*(&surfacesObj->notifyType) = -1);
	hwchan->nv03Surfaces2d = surfacesObj;
	if (chid == hwdev->info.Graphics.CurrentChID)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		(hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (0) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (0) * 4)) / 4] =
			(NvV32) (surfacesObj->destPitch);
		(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (0) * 4)) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (0) * 4)) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 3 : 0) % 32) +
							((0 ? 3 : 0) % 32))) << ((0 ? 3 : 0) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 3 : 0) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 8 : 8) % 32) +
							((0 ? 8 : 8) % 32))) << ((0 ? 8 : 8) %
						32))) | ((0x00000001) << ((0 ? 8 : 8) % 32)));
		(hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (1) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (1) * 4)) / 4] =
			(NvV32) (surfacesObj->srcPitch);
		(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (1) * 4)) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (1) * 4)) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 7 : 4) % 32) +
							((0 ? 7 : 4) % 32))) << ((0 ? 7 : 4) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 7 : 4) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 9 : 9) % 32) +
							((0 ? 9 : 9) % 32))) << ((0 ? 9 : 9) %
						32))) | ((0x00000001) << ((0 ? 9 : 9) % 32)));
	}
	else
	{
		hwchan->gr.boffset[0] = 0;
		hwchan->gr.bpitch[0] = surfacesObj->destPitch;
		hwchan->gr.bbase[0] = 0x0;
		hwchan->gr.blimit[0] = 0x0;
		hwchan->gr.bpixel &=
			~((0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
					((0 ? 3 : 0) % 32))) << ((0 ? 3 : 0) % 32));
		hwchan->gr.bpixel |= ((NV_PMC_BOOT_0) << ((0 ? 3 : 0) % 32));
		hwchan->gr.boffset[1] = 0;
		hwchan->gr.bpitch[1] = surfacesObj->srcPitch;
		hwchan->gr.bbase[1] = 0x0;
		hwchan->gr.blimit[1] = 0x0;
		hwchan->gr.bpixel &=
			~((0xFFFFFFFF >> (31 - ((1 ? 7 : 4) % 32) +
					((0 ? 7 : 4) % 32))) << ((0 ? 7 : 4) % 32));
		hwchan->gr.bpixel |= ((NV_PMC_BOOT_0) << ((0 ? 7 : 4) % 32));
		hwchan->gr.state |=
			(((0x00000001) << ((0 ? 8 : 8) % 32)) | ((0x00000001) << ((0 ? 9 : 9) %
					32)));
	}
	return status;
}
static NvV32
grDetachNv03Surfaces2dObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvV32               status;

	;
	if ((status = swDetachEngineObject (genObj)) != 0)
	{
		;
		return status;
	}
	if (surfacesObj->ctxDmaDestin)
	{
		surfacesObj->ctxDmaDestin->base.refcnt--;
		;
		surfacesObj->ctxDmaDestin = (void *) 0;
	}
	if (surfacesObj->ctxDmaSource)
	{
		surfacesObj->ctxDmaSource->base.refcnt--;
		;
		surfacesObj->ctxDmaSource = (void *) 0;
	}
	if (hwchan->nv03Surfaces2d == surfacesObj)
		hwchan->nv03Surfaces2d = (void *) 0;
	return status;
}
static void
gr2dSurfaceNotify (GrNv03Surfaces2dObj *surfaceObj, int awaken, int ndx, NvV32 status)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) ((((EngineObj *) surfaceObj))->base.parent->
					parent))->device->deviceInfo));
	NvContextDmaObj    *ctxDmaObj = ((EngineObj *) surfaceObj)->notifyCtxDma;
	NvU32               timeHi,
	                    timeLo;
	Nv0058Notification *notify;
	int                 i;

	;
	;
	notify = (Nv0058Notification *) ((&ctxDmaObj->memoryObj->kernAddr)->low +
		(unsigned long) (&ctxDmaObj->offset)->low);
	tmrGetCurrentTime (device, &timeHi, &timeLo);
	notify[ndx].timeStamp.high = timeHi;
	notify[ndx].timeStamp.low = timeLo;
	for (i = 0; i < 7; i++)
		notify[ndx].zero[i] = (NvV8) 0;
	notify[ndx].status = (NvV8) status;
}
static NvV32
mthd2dSynchronize (EngineObj *object, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvV32               status = 0;

	;
	if (!object->notifyCtxDma)
		status |= (0x01000000);
	switch (data)
	{
		case (NV_PMC_BOOT_0):
		case (0x00000001):
			return 0;
		case (0x00000002):
		case (0x00000003):
			break;
		default:;
			status |= (0x02000000);
			break;
	}
	if (status)
		return status;
	gr2dSurfaceNotify ((GrNv03Surfaces2dObj *) object, (data == (0x00000003)), 0, status);
	return 0;
}
static NvV32
mthdSetContextDmaDestin (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0)))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(0x00000001))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000002)))))
		{
			;
			;
			return (0x01000000);
		}
		if (surfacesObj->ctxDmaDestin != (void *) 0)
		{
			surfacesObj->ctxDmaDestin->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		surfacesObj->ctxDmaDestin = ctxDmaObj;
	}
	else
	{
		ctxDmaObj = surfacesObj->ctxDmaDestin;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			surfacesObj->ctxDmaDestin = (void *) 0;
		}
	}
	grUpdateSurface (engObj);
	return (0x00);
}
static NvV32
mthdSetContextDmaSource (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0)))))
			|| !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 3 : 0) % 32) +
								((0 ? 3 : 0) % 32)))) ==
					(NV_PMC_BOOT_0)))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000001)))))
		{
			;
			;
			return (0x01000000);
		}
		if (surfacesObj->ctxDmaSource != (void *) 0)
		{
			surfacesObj->ctxDmaSource->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		surfacesObj->ctxDmaSource = ctxDmaObj;
	}
	else
	{
		ctxDmaObj = surfacesObj->ctxDmaSource;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			surfacesObj->ctxDmaSource = (void *) 0;
		}
	}
	grUpdateSurface (engObj);
	return (0x00);
}
static NvV32
mthdSetFormat (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;

	;
	if ((data != (0x00000001)) && (data != (0x00000005))
		&& (data != (0x00000002)) & (data != (0x00000006)))
	{
		;
		return (0x02000000);
	}
	surfacesObj->colorFormat = data;
	grUpdateSurface (engObj);
	return (0x00);
}
static NvV32
mthdSet2dPitch (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	NvU32               srcPitch,
	                    destPitch;

	;
	srcPitch =
		(data >> ((0 ? 15 : 0) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
			((0 ? 15 : 0) % 32)));
	destPitch =
		(data >> ((0 ? 31 : 16) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
			((0 ? 31 : 16) % 32)));
	if (((srcPitch & 0x3f) || (srcPitch < 64) || (srcPitch > 8128)) || ((destPitch & 0x3f)
			|| (destPitch < 64) || (destPitch > 8128)))
	{
		;
		return (0x02000000);
	}
	surfacesObj->destPitch = destPitch;
	surfacesObj->srcPitch = srcPitch;
	grUpdateSurface (engObj);
	return (0x00);
}
static NvV32
mthdSetOffset2d (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	int                 buffer = (offset >= 0x308 && offset <= 0x30b);

	if (data & 0x3f)
	{
		;
		return (0x02000000);
	}
	if (buffer == 1)
		surfacesObj->offsetSrc = data;
	else
		surfacesObj->offsetDest = data;
	grUpdateSurface (engObj);
	return (0x00);
}
static MethodInfo   Nv03Surfaces2dMethods[] = {
	{mthd2dSynchronize, "Synchronize", 0x100, 0x103}, {mthdSwSetContextDmaNotifies,
			"SetContextDmaNotifies", 0x180, 0x183}, {mthdSetContextDmaSource,
			"SetContextDmaSource", 0x184, 0x187}, {mthdSetContextDmaDestin,
			"SetContextDmaDestin", 0x188, 0x18b}, {mthdSetFormat, "SetFormat", 0x300,
			0x303}, {mthdSet2dPitch, "SetPitch", 0x304, 0x307}, {mthdSetOffset2d,
			"SetOffsetSource", 0x308, 0x30b}, {mthdSetOffset2d, "SetOffsetDestin",
			0x30c, 0x30f},
};
EngineObjInfo       Nv03Surfaces2dEngineObjInfo = {
	((NV_PMC_BOOT_0) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0, {(0x00000058), 0x0,
			0x0}, (void *) 0
};
ClassInfo           Nv03Surfaces2dClassInfo = {
	(0x00000058), "surfaces 2d", sizeof (GrNv03Surfaces2dObj), 0x1, 1,
		&Nv03Surfaces2dEngineObjInfo, (void *) 0, (void *) 0, grAttachNv03Surfaces2dObj,
		(void *) 0, (void *) 0, grDetachNv03Surfaces2dObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv03Surfaces2dMethods) / sizeof (Nv03Surfaces2dMethods[0])),
		Nv03Surfaces2dMethods
};
static NvV32
grAttachNv03Surfaces3dObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrNv03Surfaces3dObj *surfacesObj = (GrNv03Surfaces3dObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvV32               status;

	;
	if (hwchan->nv03Surfaces3d != (void *) 0)
	{
		;
		return (0x00000002);
	}
	if ((status = swAttachEngineObject (genObj, alloc)) != 0)
	{
		;
		return status;
	}
	surfacesObj->pitch = 0x40;
	surfacesObj->offsetColor = 0;
	surfacesObj->offsetZeta = 0;
	surfacesObj->ctxDmaSurface = (void *) 0;
	(*(&surfacesObj->notifyType) = -1);
	hwchan->nv03Surfaces3d = surfacesObj;
	if (chid == hwdev->info.Graphics.CurrentChID)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		(hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (2) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (2) * 4)) / 4] = (NvV32) (0x40);
		(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (2) * 4)) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (2) * 4)) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 11 : 8) % 32) +
							((0 ? 11 : 8) % 32))) << ((0 ? 11 : 8) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 11 : 8) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 10 : 10) % 32) +
							((0 ? 10 : 10) % 32))) << ((0 ? 10 : 10) %
						32))) | ((0x00000001) << ((0 ? 10 : 10) % 32)));
		(hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (3) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (3) * 4)) / 4] = (NvV32) (0x40);
		(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (3) * 4)) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (3) * 4)) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 15 : 12) % 32) +
							((0 ? 15 : 12) % 32))) << ((0 ? 15 : 12) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 15 : 12) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 11 : 11) % 32) +
							((0 ? 11 : 11) % 32))) << ((0 ? 11 : 11) %
						32))) | ((0x00000001) << ((0 ? 11 : 11) % 32)));
	}
	else
	{
		hwchan->gr.boffset[2] = 0;
		hwchan->gr.bpitch[2] = 0x40;
		hwchan->gr.bbase[2] = 0x0;
		hwchan->gr.blimit[2] = 0x0;
		hwchan->gr.boffset[3] = 0;
		hwchan->gr.bpitch[3] = 0x40;
		hwchan->gr.bbase[3] = 0x0;
		hwchan->gr.blimit[3] = 0x0;
		hwchan->gr.bpixel &=
			(~((0xFFFFFFFF >> (31 - ((1 ? 11 : 8) % 32) +
						((0 ? 11 : 8) % 32))) << ((0 ? 11 : 8) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 15 : 12) % 32) +
						((0 ? 15 : 12) % 32))) << ((0 ? 15 : 12) % 32)));
		hwchan->gr.bpixel |=
			(((NV_PMC_BOOT_0) << ((0 ? 11 : 8) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 15 : 12) % 32)));
		hwchan->gr.state |=
			((0x00000001) << ((0 ? 10 : 10) % 32)) | ((0x00000001) << ((0 ? 11 : 11) %
				32));
	}
	return status;
}
static NvV32
grDetachNv03Surfaces3dObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrNv03Surfaces3dObj *surfacesObj = (GrNv03Surfaces3dObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvV32               status;

	;
	if ((status = swDetachEngineObject (genObj)) != 0)
	{
		;
		return status;
	}
	if (surfacesObj->ctxDmaSurface)
	{
		surfacesObj->ctxDmaSurface->base.refcnt--;
		;
		surfacesObj->ctxDmaSurface = (void *) 0;
	}
	if (hwchan->nv03Surfaces3d == surfacesObj)
		hwchan->nv03Surfaces3d = (void *) 0;
	return status;
}
static void
gr3dSurfaceNotify (GrNv03Surfaces3dObj *surfaceObj, int awaken, int ndx, NvV32 status)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) ((((EngineObj *) surfaceObj))->base.parent->
					parent))->device->deviceInfo));
	NvContextDmaObj    *ctxDmaObj = ((EngineObj *) surfaceObj)->notifyCtxDma;
	NvU32               timeHi,
	                    timeLo;
	Nv005aNotification *notify;
	int                 i;

	;
	;
	notify = (Nv005aNotification *) ((&ctxDmaObj->memoryObj->kernAddr)->low +
		(unsigned long) (&ctxDmaObj->offset)->low);
	tmrGetCurrentTime (device, &timeHi, &timeLo);
	notify[ndx].timeStamp.high = timeHi;
	notify[ndx].timeStamp.low = timeLo;
	for (i = 0; i < 7; i++)
		notify[ndx].zero[i] = (NvV8) 0;
	notify[ndx].status = (NvV8) status;
}
static NvV32
mthd3dSynchronize (EngineObj *object, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvV32               status = 0;

	;
	if (!object->notifyCtxDma)
		status |= (0x01000000);
	switch (data)
	{
		case (NV_PMC_BOOT_0):
		case (0x00000001):
			return 0;
		case (0x00000002):
		case (0x00000003):
			break;
		default:;
			status |= (0x02000000);
			break;
	}
	if (status)
		return status;
	gr3dSurfaceNotify ((GrNv03Surfaces3dObj *) object, (data == (0x00000003)), 0, status);
	return 0;
}
static NvV32
mthdSetContextDmaSurfaces3d (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	GrNv03Surfaces3dObj *surfacesObj = (GrNv03Surfaces3dObj *) engObj;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0)))))
			|| !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 3 : 0) % 32) +
								((0 ? 3 : 0) % 32)))) ==
					(NV_PMC_BOOT_0)))
			|| !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(NV_PMC_BOOT_0))))
		{
			;
			;
			return (0x01000000);
		}
		if (surfacesObj->ctxDmaSurface != (void *) 0)
		{
			surfacesObj->ctxDmaSurface->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		surfacesObj->ctxDmaSurface = ctxDmaObj;
	}
	else
	{
		ctxDmaObj = surfacesObj->ctxDmaSurface;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			surfacesObj->ctxDmaSurface = (void *) 0;
		}
	}
	grUpdateSurface (engObj);
	return (0x00);
}
static NvV32
mthdSet3dPitch (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	GrNv03Surfaces3dObj *surfacesObj = (GrNv03Surfaces3dObj *) engObj;

	if ((data & 0x3f) || (data < 64) || (data > 8128))
	{
		;
		return (0x02000000);
	}
	surfacesObj->pitch = data;
	grUpdateSurface (engObj);
	return (0x00);
}
static NvV32
mthdSetOffset3d (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	GrNv03Surfaces3dObj *surfacesObj = (GrNv03Surfaces3dObj *) engObj;
	int                 buffer = (offset >= 0x308 && offset <= 0x30c) + 2;

	if (data & 0x3f)
	{
		;
		return (0x02000000);
	}
	if (buffer == 2)
		surfacesObj->offsetColor = data;
	else
		surfacesObj->offsetZeta = data;
	grUpdateSurface (engObj);
	return (0x00);
}

MethodInfo          Nv03Surfaces3dMethods[] = {
	{mthd3dSynchronize, "Synchronize", 0x100, 0x103}, {mthdSwSetContextDmaNotifies,
			"SetContextDmaNotifies", 0x180, 0x183}, {mthdSetContextDmaSurfaces3d,
			"SetContextDmaSurfaces", 0x184, 0x187}, {mthdSet3dPitch, "SetPitch", 0x300,
			0x303}, {mthdSetOffset3d, "SetOffsetColor", 0x304, 0x307}, {mthdSetOffset3d,
			"SetOffsetZeta", 0x308, 0x30b},
};
EngineObjInfo       Nv03Surfaces3dEngineObjInfo = {
	((NV_PMC_BOOT_0) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0, {(0x0000005A), 0x0,
			0x0}, (void *) 0
};
ClassInfo           Nv03Surfaces3dClassInfo = {
	(0x0000005A), "nv03 surfaces 3d", sizeof (GrNv03Surfaces3dObj), 0x1, 1,
		&Nv03Surfaces3dEngineObjInfo, (void *) 0, (void *) 0, grAttachNv03Surfaces3dObj,
		(void *) 0, (void *) 0, grDetachNv03Surfaces3dObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv03Surfaces3dMethods) / sizeof (Nv03Surfaces3dMethods[0])),
		Nv03Surfaces3dMethods
};
static NvV32
grAttachNv04Surfaces3dObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrNv04Surfaces3dObj *surfacesObj = (GrNv04Surfaces3dObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvU32               data;
	NvV32               status;

	;
	if ((hwchan->nv03Surfaces3d != (void *) 0) || (hwchan->allocMask & 0x0008)
		|| (hwchan->allocMask & 0x0040))
	{
		;
		return (0x00000002);
	}
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	surfacesObj->ctxDmaColor = (void *) 0;
	surfacesObj->ctxDmaZeta = (void *) 0;
	hwchan->allocMask |= 0x0040;
	if (chid == hwdev->info.Graphics.CurrentChID)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_SURFACE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_SURFACE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 1 : 0) % 32) +
							((0 ? 1 : 0) % 32))) << ((0 ? 1 : 0) %
						32))) | ((0x00000001) << ((0 ? 1 : 0) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_BSWIZZLE2) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BSWIZZLE2) /
						4]) & ~((0xFFFFFFFF >> (31 - ((1 ? 19 : 16) % 32) +
							((0 ? 19 : 16) % 32))) << ((0 ? 19 : 16) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 19 : 16) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_BSWIZZLE2) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BSWIZZLE2) /
						4]) & ~((0xFFFFFFFF >> (31 - ((1 ? 27 : 24) % 32) +
							((0 ? 27 : 24) % 32))) << ((0 ? 27 : 24) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 27 : 24) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMIN) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMIN) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_VALID1) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_VALID1) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 28 : 28) % 32) +
							((0 ? 28 : 28) % 32))) << ((0 ? 28 : 28) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 28 : 28) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMAX) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMAX) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_VALID1) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_VALID1) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 30 : 30) % 32) +
							((0 ? 30 : 30) % 32))) << ((0 ? 30 : 30) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 30 : 30) % 32)));
		(hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (2) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (2) * 4)) / 4] = (NvV32) (0x20);
		(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (2) * 4)) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (2) * 4)) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (3) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (3) * 4)) / 4] = (NvV32) (0x20);
		(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (3) * 4)) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (3) * 4)) / 4] = (NvV32) (0x0);
		data = (((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4]) & (~((0xFFFFFFFF >> (31 -
							((1 ? 11 : 8) % 32) +
							((0 ? 11 : 8) % 32))) << ((0 ? 11 : 8) %
						32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 15 : 12) % 32) +
							((0 ? 15 : 12) % 32))) << ((0 ? 15 : 12) %
						32))));
		data |= (((0x00000002) << ((0 ? 11 : 8) % 32)) | ((0x00000002) << ((0 ? 15 : 12) %
					32)));
		(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] = (NvV32) (data);
		data = (((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & (~((0xFFFFFFFF >> (31 -
							((1 ? 2 : 2) % 32) +
							((0 ? 2 : 2) % 32))) << ((0 ? 2 : 2) %
						32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 3 : 3) % 32) +
							((0 ? 3 : 3) % 32))) << ((0 ? 3 : 3) %
						32))));
		data |= (((NV_PMC_BOOT_0) << ((0 ? 2 : 2) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 3 : 3) %
					32)) | ((0x00000001) << ((0 ? 10 : 10) %
					32)) | ((0x00000001) << ((0 ? 11 : 11) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] = (NvV32) (data);
	}
	else
	{
		hwchan->gr.surface = ((0x00000001) << ((0 ? 1 : 0) % 32));
		hwchan->gr.bswizzle2 =
			(((NV_PMC_BOOT_0) << ((0 ? 19 : 16) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 27 : 24) % 32)));
		hwchan->gr.abs_uclip_xmin = 0;
		hwchan->gr.abs_uclip_ymin = 0;
		hwchan->gr.abs_uclip_xmax = 0;
		hwchan->gr.abs_uclip_ymax = 0;
		hwchan->gr.valid1 &=
			(~((0xFFFFFFFF >> (31 - ((1 ? 28 : 28) % 32) +
						((0 ? 28 : 28) % 32))) << ((0 ? 28 : 28) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 30 : 30) % 32) +
						((0 ? 30 : 30) % 32))) << ((0 ? 30 : 30) % 32)));
		hwchan->gr.valid1 |=
			(((NV_PMC_BOOT_0) << ((0 ? 28 : 28) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 30 : 30) % 32)));
		hwchan->gr.boffset[2] = 0;
		hwchan->gr.bpitch[2] = 0x20;
		hwchan->gr.bbase[2] = 0x0;
		hwchan->gr.blimit[2] = 0x0;
		hwchan->gr.boffset[3] = 0;
		hwchan->gr.bpitch[3] = 0x20;
		hwchan->gr.bbase[3] = 0x0;
		hwchan->gr.blimit[3] = 0x0;
		hwchan->gr.bpixel &=
			(~((0xFFFFFFFF >> (31 - ((1 ? 11 : 8) % 32) +
						((0 ? 11 : 8) % 32))) << ((0 ? 11 : 8) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 15 : 12) % 32) +
						((0 ? 15 : 12) % 32))) << ((0 ? 15 : 12) % 32)));
		hwchan->gr.bpixel |=
			(((NV_PMC_BOOT_0) << ((0 ? 11 : 8) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 15 : 12) % 32)));
		hwchan->gr.state &=
			(~((0xFFFFFFFF >> (31 - ((1 ? 2 : 2) % 32) +
						((0 ? 2 : 2) % 32))) << ((0 ? 2 : 2) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 3 : 3) % 32) +
						((0 ? 3 : 3) % 32))) << ((0 ? 3 : 3) % 32)));
		hwchan->gr.state |=
			(((NV_PMC_BOOT_0) << ((0 ? 2 : 2) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 3 : 3) %
					32)) | ((0x00000001) << ((0 ? 10 : 10) %
					32)) | ((0x00000001) << ((0 ? 11 : 11) % 32)));
	}
	return status;
}
static NvV32
grDetachNv04Surfaces3dObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrNv04Surfaces3dObj *surfacesObj = (GrNv04Surfaces3dObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvV32               status;

	;
	if ((status = grDetachObject (genObj)) != 0)
	{
		;
		return status;
	}
	if (surfacesObj->ctxDmaColor)
	{
		surfacesObj->ctxDmaColor->base.refcnt--;
		;
		surfacesObj->ctxDmaColor = (void *) 0;
	}
	if (surfacesObj->ctxDmaZeta)
	{
		surfacesObj->ctxDmaZeta->base.refcnt--;
		;
		surfacesObj->ctxDmaZeta = (void *) 0;
	}
	hwchan->allocMask &= ~0x0040;
	return status;
}
static NvV32
mthdSetContextDmaColor (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	GrNv04Surfaces3dObj *surfacesObj = (GrNv04Surfaces3dObj *) engObj;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvU32               bbase,
	                    blimit;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0)))))
			|| !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 3 : 0) % 32) +
								((0 ? 3 : 0) % 32)))) ==
					(NV_PMC_BOOT_0)))
			|| !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(NV_PMC_BOOT_0))))
		{
			;
			;
			return (0x01000000);
		}
		if (surfacesObj->ctxDmaColor != (void *) 0)
		{
			surfacesObj->ctxDmaColor->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		surfacesObj->ctxDmaColor = ctxDmaObj;
		bbase = ((&ctxDmaObj->pteBase)->low);
		blimit = (unsigned long) (&ctxDmaObj->limit)->low + 1;
	}
	else
	{
		ctxDmaObj = surfacesObj->ctxDmaColor;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			surfacesObj->ctxDmaColor = (void *) 0;
		}
		bbase = 0x0;
		blimit = 0x0;
	}
	if (chid == hwdev->info.Graphics.CurrentChID)
	{
		(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (2) * 4)) / 4] = (NvV32) (bbase);
		(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (2) * 4)) / 4] = (NvV32) (blimit);
	}
	else
	{
		hwchan->gr.bbase[2] = bbase;
		hwchan->gr.blimit[2] = blimit;
	}
	return (0x00);
}
static NvV32
mthdSetContextDmaZeta (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	GrNv04Surfaces3dObj *surfacesObj = (GrNv04Surfaces3dObj *) engObj;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvU32               bbase,
	                    blimit;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0)))))
			|| !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 3 : 0) % 32) +
								((0 ? 3 : 0) % 32)))) ==
					(NV_PMC_BOOT_0)))
			|| !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(NV_PMC_BOOT_0))))
		{
			;
			;
			return (0x01000000);
		}
		if (surfacesObj->ctxDmaZeta != (void *) 0)
		{
			surfacesObj->ctxDmaZeta->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		surfacesObj->ctxDmaZeta = ctxDmaObj;
		bbase = ((&ctxDmaObj->pteBase)->low);
		blimit = (unsigned long) (&ctxDmaObj->limit)->low + 1;
	}
	else
	{
		ctxDmaObj = surfacesObj->ctxDmaZeta;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			surfacesObj->ctxDmaZeta = (void *) 0;
		}
		bbase = 0x0;
		blimit = 0x0;
	}
	if (chid == hwdev->info.Graphics.CurrentChID)
	{
		(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (3) * 4)) / 4] = (NvV32) (bbase);
		(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (3) * 4)) / 4] = (NvV32) (blimit);
	}
	else
	{
		hwchan->gr.bbase[3] = bbase;
		hwchan->gr.blimit[3] = blimit;
	}
	return (0x00);
}

MethodInfo          Nv04Surfaces3dMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextDmaColor, "SetContextDmaColor", 0x184, 0x187},
		{mthdSetContextDmaZeta, "SetContextDmaZeta", 0x188, 0x18b}, {mthdGrResend,
			"SetClipHorizontal", 0x2f8, 0x2fb}, {mthdGrResend, "SetClipVertical", 0x2fc,
			0x2ff}, {mthdGrResend, "SetFormat", 0x300, 0x303}, {mthdGrResend,
			"SetClipSize", 0x304, 0x307}, {mthdGrResend, "SetPitch", 0x308, 0x30b},
		{mthdGrResend, "SetOffsetColor", 0x30c, 0x30f}, {mthdGrResend, "SetOffsetZeta",
			0x310, 0x313},
};
EngineObjInfo       Nv04Surfaces3dEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0x0040, {(0x00000053), 0x0,
			0x0}, (void *) 0
};
ClassInfo           Nv04Surfaces3dClassInfo = {
	(0x00000053), "nv04 surfaces 3d", sizeof (GrNv04Surfaces3dObj), 0x1, 1,
		&Nv04Surfaces3dEngineObjInfo, (void *) 0, (void *) 0, grAttachNv04Surfaces3dObj,
		(void *) 0, (void *) 0, grDetachNv04Surfaces3dObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv04Surfaces3dMethods) / sizeof (Nv04Surfaces3dMethods[0])),
		Nv04Surfaces3dMethods
};
