 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


extern NvV32        mthdUnimplemented (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSwSetContextDmaNotifies (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdUnimplemented (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrNoOperation (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrResend (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrRenderResend (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaNotifies (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaScaledImage (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaTexture (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc539 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc536 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc537 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextSurfaces2d (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextSurfaces3d (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextClipRectangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextColorKey (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextPattern (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextRop (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextBeta1 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetColorFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetMonochromeFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetOperation (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrNotify (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaBufferIn (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaBufferOut (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderLin (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderTriangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdDx3Control0 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderRectangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageBlt (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageTransfer (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdMemoryToMemoryFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderDx3TexturedTriangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderGdiRectangleText (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageFromMem (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern int          grRenderObjectValidForRendering (EngineObj *engObj);
extern int          grRenderObjectValidForHardware (EngineObj *engObj);
extern int          grImageBlitValidForRendering (EngineObj *engObj);
extern int          grImageBlitValidForHardware (EngineObj *engObj);
extern int          grImageObjectValidForRendering (EngineObj *engObj);
extern int          grImageObjectValidForHardware (EngineObj *engObj);
extern int          grImageFromMemValidForRendering (EngineObj *engObj);
extern int          grImageFromMemValidForHardware (EngineObj *engObj);
extern int          grMemoryToMemoryFormatValidForHardware (EngineObj *engObj);
extern int          grContextObjectValidForHardware (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForRendering (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForHardware (EngineObj *engObj);
extern int          grGdiRectObjectValidForRendering (EngineObj *engObj);
extern int          grGdiRectObjectValidForHardware (EngineObj *engObj);
extern void         grValidateObject (EngineObj *obj);
static void
grCalcClipLogic (NvDeviceInfo *device, EngineObj *engObj, NvU32 canvasMin, NvU32 canvasMax)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               xyLogicMisc = 0;
	NvU32               usrClipMinX,
	                    usrClipMinY,
	                    usrClipMaxX,
	                    usrClipMaxY;
	NvU32               canvasMinX,
	                    canvasMinY,
	                    canvasMaxX,
	                    canvasMaxY;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];

	;
	canvasMinX =
		(((canvasMin) >> ((0 ? 10 : 0) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 10 : 0) % 32) +
				((0 ? 10 : 0) % 32))));
	canvasMinY =
		(((canvasMin) >> ((0 ? 30 : 16) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 30 : 16) % 32) +
				((0 ? 30 : 16) % 32))));
	canvasMaxX =
		(((canvasMax) >> ((0 ? 10 : 0) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 10 : 0) % 32) +
				((0 ? 10 : 0) % 32))));
	canvasMaxY =
		(((canvasMax) >> ((0 ? 30 : 16) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 30 : 16) % 32) +
				((0 ? 30 : 16) % 32))));
	;
	if (chid == hwdev->info.Graphics.CurrentChID)
	{
		usrClipMinX = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMIN) / 4]);
		usrClipMinY = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMIN) / 4]);
		usrClipMaxX = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMAX) / 4]);
		usrClipMaxY = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMAX) / 4]);
	}
	else
	{
		usrClipMinX = hwchan->gr.abs_uclip_xmin;
		usrClipMinY = hwchan->gr.abs_uclip_ymin;
		usrClipMaxX = hwchan->gr.abs_uclip_xmax;
		usrClipMaxY = hwchan->gr.abs_uclip_ymax;
	}
	;
	if ((usrClipMinX > canvasMaxX) || (usrClipMaxX < canvasMinX))
	{
		xyLogicMisc |= ((0x00000001) << ((0 ? 8 : 8) % 32));
	}
	else
	{
		xyLogicMisc |=
			(usrClipMinX > canvasMinX) ? ((0x00000001) << ((0 ? 12 : 12) % 32)) : 0;
		xyLogicMisc |=
			(usrClipMaxX < canvasMaxX) ? ((0x00000001) << ((0 ? 13 : 13) % 32)) : 0;
	}
	if ((usrClipMinY > canvasMaxY) || (usrClipMaxY < canvasMinY))
	{
		xyLogicMisc |= ((0x00000001) << ((0 ? 9 : 9) % 32));
	}
	else
	{
		xyLogicMisc |=
			(usrClipMinY > canvasMinY) ? ((0x00000001) << ((0 ? 16 : 16) % 32)) : 0;
		xyLogicMisc |=
			(usrClipMaxY < canvasMaxY) ? ((0x00000001) << ((0 ? 17 : 17) % 32)) : 0;
	}
	if (chid == hwdev->info.Graphics.CurrentChID)
	{
		(hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC1) / 4] = (NvV32) (xyLogicMisc);
	}
	else
	{
		hwchan->gr.xy_logic_misc1 = xyLogicMisc;
	}
	if (chid == hwdev->info.Graphics.CurrentChID)
	{
		usrClipMinX = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_XMIN) / 4]);
		usrClipMinY = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_YMIN) / 4]);
		usrClipMaxX = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_XMAX) / 4]);
		usrClipMaxY = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_YMAX) / 4]);
	}
	else
	{
		usrClipMinX = hwchan->gr.abs_uclipa_xmin;
		usrClipMinY = hwchan->gr.abs_uclipa_ymin;
		usrClipMaxX = hwchan->gr.abs_uclipa_xmax;
		usrClipMaxY = hwchan->gr.abs_uclipa_ymax;
	}
	;
	if ((usrClipMinX > canvasMaxX) || (usrClipMaxX < canvasMinX))
	{
		xyLogicMisc |= ((0x00000001) << ((0 ? 8 : 8) % 32));
	}
	else
	{
		xyLogicMisc |=
			(usrClipMinX > canvasMinX) ? ((0x00000001) << ((0 ? 12 : 12) % 32)) : 0;
		xyLogicMisc |=
			(usrClipMaxX < canvasMaxX) ? ((0x00000001) << ((0 ? 13 : 13) % 32)) : 0;
	}
	if ((usrClipMinY > canvasMaxY) || (usrClipMaxY < canvasMinY))
	{
		xyLogicMisc |= ((0x00000001) << ((0 ? 9 : 9) % 32));
	}
	else
	{
		xyLogicMisc |=
			(usrClipMinY > canvasMinY) ? ((0x00000001) << ((0 ? 16 : 16) % 32)) : 0;
		xyLogicMisc |=
			(usrClipMaxY < canvasMaxY) ? ((0x00000001) << ((0 ? 17 : 17) % 32)) : 0;
	}
	if (chid == hwdev->info.Graphics.CurrentChID)
	{
		(hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC2) / 4] = (NvV32) (xyLogicMisc);
	}
	else
	{
		hwchan->gr.xy_logic_misc2 = xyLogicMisc;
	}
}
void
grUpdateSurfaceDest (EngineObj *engObj)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvU32               bpixel,
	                    canvasMaxX,
	                    canvasMaxY;
	GrNv03Surfaces2dObj *surfaces2dObj;
	GrNv03Surfaces3dObj *surfaces3dObj;
	NvV32               surfaceBase;

	;
	;
	if (((engObj)->base.classInfo->num) == (0x0000005A))
	{
		surfaces3dObj = (GrNv03Surfaces3dObj *) engObj;
		if (surfaces3dObj->ctxDmaSurface == (void *) 0)
		{
			;
			return;
		}
		surfaceBase = (NvV32) ((&surfaces3dObj->ctxDmaSurface->pteBase)->low);
		;
		canvasMaxX = (surfaces3dObj->pitch / 2) + 1;
		canvasMaxY =
			(((((unsigned long) (&surfaces3dObj->ctxDmaSurface->limit)->low) + 1) -
				((surfaces3dObj->offsetColor >
						surfaces3dObj->offsetZeta) ? surfaces3dObj->
					offsetColor : surfaces3dObj->offsetZeta)) /
			surfaces3dObj->pitch) + 1;
		;
		if (chid == hwdev->info.Graphics.CurrentChID)
		{
			{
				NvV32               _status;

				_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
				while (_status)
				{
					NvV32               _pmc =
						((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
					if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
					{
						grService (device);
					}
					_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
				}
			};
			(hwreg)->Reg32[(NV_PGRAPH_DST_CANVAS_MIN) / 4] = (NvV32) (0x0);
			(hwreg)->Reg32[(NV_PGRAPH_DST_CANVAS_MAX) / 4] =
				(NvV32) ((((canvasMaxX) & (0xFFFFFFFF >> (31 - ((1 ? 10 : 0) % 32) +
								((0 ? 10 : 0) %
									32)))) << ((0 ? 10 : 0) %
						32)) | (((canvasMaxY) & (0xFFFFFFFF >> (31 -
								((1 ? 30 : 16) % 32) +
								((0 ? 30 : 16) %
									32)))) << ((0 ? 30 : 16) %
						32)));
			(hwreg)->Reg32[(NV_PGRAPH_BOFFSET2) / 4] =
				(NvV32) (surfaces3dObj->offsetColor + surfaceBase);
			(hwreg)->Reg32[(NV_PGRAPH_BOFFSET3) / 4] =
				(NvV32) (surfaces3dObj->offsetZeta + surfaceBase);
			(hwreg)->Reg32[(NV_PGRAPH_BPITCH2) / 4] = (NvV32) (surfaces3dObj->pitch);
			bpixel = ((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4]);
			bpixel &=
				(~((0xFFFFFFFF >> (31 - ((1 ? 9 : 8) % 32) +
							((0 ? 9 : 8) % 32))) << ((0 ? 9 : 8) %
						32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 10 : 10) % 32) +
							((0 ? 10 : 10) % 32))) << ((0 ? 10 : 10) %
						32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 13 : 12) % 32) +
							((0 ? 13 : 12) % 32))) << ((0 ? 13 : 12) %
						32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 14 : 14) % 32) +
							((0 ? 14 : 14) % 32))) << ((0 ? 14 : 14) %
						32)));
			bpixel |=
				(((0x00000002) << ((0 ? 9 : 8) %
						32)) | ((0x00000001) << ((0 ? 10 : 10) %
						32)) | ((NV_PMC_BOOT_0) << ((0 ? 13 : 12) %
						32)) | ((0x00000001) << ((0 ? 14 : 14) % 32)));
			(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] = (NvV32) (bpixel);
		}
		else
		{
			hwchan->gr.dst_canvas_min = 0x0;
			hwchan->gr.dst_canvas_max =
				(((canvasMaxX) & (0xFFFFFFFF >> (31 - ((1 ? 10 : 0) % 32) +
							((0 ? 10 : 0) % 32)))) << ((0 ? 10 : 0) %
					32)) | (((canvasMaxY) & (0xFFFFFFFF >> (31 -
							((1 ? 30 : 16) % 32) +
							((0 ? 30 : 16) % 32)))) << ((0 ? 30 : 16) %
					32));
			hwchan->gr.boffset2 = surfaces3dObj->offsetColor + surfaceBase;
			hwchan->gr.boffset3 = surfaces3dObj->offsetZeta + surfaceBase;
			hwchan->gr.bpitch2 = surfaces3dObj->pitch;
			hwchan->gr.bpixel &=
				(~((0xFFFFFFFF >> (31 - ((1 ? 9 : 8) % 32) +
							((0 ? 9 : 8) % 32))) << ((0 ? 9 : 8) %
						32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 10 : 10) % 32) +
							((0 ? 10 : 10) % 32))) << ((0 ? 10 : 10) %
						32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 13 : 12) % 32) +
							((0 ? 13 : 12) % 32))) << ((0 ? 13 : 12) %
						32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 14 : 14) % 32) +
							((0 ? 14 : 14) % 32))) << ((0 ? 14 : 14) %
						32)));
			hwchan->gr.bpixel |=
				((0x00000002) << ((0 ? 9 : 8) %
					32)) | ((0x00000001) << ((0 ? 10 : 10) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 13 : 12) %
					32)) | ((0x00000001) << ((0 ? 14 : 14) % 32));
		}
		hwchan->dstCanvasOwner = (0x0000005A);
	}
	else
	{
		surfaces2dObj = (GrNv03Surfaces2dObj *) engObj;
		;
		if (surfaces2dObj->ctxDmaDestin == (void *) 0)
		{
			;
			return;
		}
		surfaceBase = (NvV32) ((&surfaces2dObj->ctxDmaDestin->pteBase)->low);
		;
		canvasMaxX =
			(surfaces2dObj->destPitch / ((surfaces2dObj->colorFormat ==
					(0x00000001)) ? 1 : ((surfaces2dObj->colorFormat ==
						(0x00000006)) ? 4 : 2))) + 1;
		canvasMaxY =
			(((((((unsigned long) (&surfaces2dObj->ctxDmaDestin->limit)->low) + 1) -
						surfaces2dObj->offsetDest) /
					surfaces2dObj->destPitch) <
				0x3ffe) ? (((((unsigned long) (&surfaces2dObj->ctxDmaDestin->
								limit)->low) + 1) -
					surfaces2dObj->offsetDest) /
				surfaces2dObj->destPitch) : 0x3ffe) + 1;
		;
		if (chid == hwdev->info.Graphics.CurrentChID)
		{
			{
				NvV32               _status;

				_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
				while (_status)
				{
					NvV32               _pmc =
						((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
					if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
					{
						grService (device);
					}
					_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
				}
			};
			(hwreg)->Reg32[(NV_PGRAPH_DST_CANVAS_MAX) / 4] =
				(NvV32) ((((canvasMaxX) & (0xFFFFFFFF >> (31 - ((1 ? 10 : 0) % 32) +
								((0 ? 10 : 0) %
									32)))) << ((0 ? 10 : 0) %
						32)) | (((canvasMaxY) & (0xFFFFFFFF >> (31 -
								((1 ? 30 : 16) % 32) +
								((0 ? 30 : 16) %
									32)))) << ((0 ? 30 : 16) %
						32)));
			(hwreg)->Reg32[(NV_PGRAPH_BOFFSET0) / 4] =
				(NvV32) (surfaces2dObj->offsetDest + surfaceBase);
			(hwreg)->Reg32[(NV_PGRAPH_BPITCH0) / 4] =
				(NvV32) (surfaces2dObj->destPitch);
			if (surfaces2dObj->colorFormat == (0x00000001))
				(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
					(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) /
								4]) & ~((0xFFFFFFFF >> (31 -
									((1 ? 1 : 0) % 32) +
									((0 ? 1 : 0) %
										32))) << ((0 ? 1 :
									0) %
								32))) | ((0x00000001) << ((0 ? 1 :
								0) % 32)));
			else if (surfaces2dObj->colorFormat == (0x00000005))
				(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
					(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) /
								4]) & ~((0xFFFFFFFF >> (31 -
									((1 ? 1 : 0) % 32) +
									((0 ? 1 : 0) %
										32))) << ((0 ? 1 :
									0) %
								32))) | ((NV_PMC_BOOT_0) << ((0 ? 1
								: 0) % 32)));
			else if (surfaces2dObj->colorFormat == (0x00000002))
				(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
					(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) /
								4]) & ~((0xFFFFFFFF >> (31 -
									((1 ? 1 : 0) % 32) +
									((0 ? 1 : 0) %
										32))) << ((0 ? 1 :
									0) %
								32))) | ((0x00000002) << ((0 ? 1 :
								0) % 32)));
			else if (surfaces2dObj->colorFormat == (0x00000006))
				(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
					(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) /
								4]) & ~((0xFFFFFFFF >> (31 -
									((1 ? 1 : 0) % 32) +
									((0 ? 1 : 0) %
										32))) << ((0 ? 1 :
									0) %
								32))) | ((0x00000003) << ((0 ? 1 :
								0) % 32)));
			(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
				(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) /
							4]) & ~((0xFFFFFFFF >> (31 -
								((1 ? 2 : 2) % 32) +
								((0 ? 2 : 2) %
									32))) << ((0 ? 2 : 2) %
							32))) | ((0x00000001) << ((0 ? 2 : 2) %
						32)));
		}
		else
		{
			hwchan->gr.dst_canvas_max =
				(((canvasMaxX) & (0xFFFFFFFF >> (31 - ((1 ? 10 : 0) % 32) +
							((0 ? 10 : 0) % 32)))) << ((0 ? 10 : 0) %
					32)) | (((canvasMaxY) & (0xFFFFFFFF >> (31 -
							((1 ? 30 : 16) % 32) +
							((0 ? 30 : 16) % 32)))) << ((0 ? 30 : 16) %
					32));
			hwchan->gr.boffset0 = surfaces2dObj->offsetDest + surfaceBase;
			hwchan->gr.bpitch0 = surfaces2dObj->destPitch;
			hwchan->gr.bpixel &=
				(~((0xFFFFFFFF >> (31 - ((1 ? 1 : 0) % 32) +
							((0 ? 1 : 0) % 32))) << ((0 ? 1 : 0) %
						32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 2 : 2) % 32) +
							((0 ? 2 : 2) % 32))) << ((0 ? 2 : 2) %
						32)));
			if (surfaces2dObj->colorFormat == (0x00000001))
				hwchan->gr.bpixel |= ((0x00000001) << ((0 ? 1 : 0) % 32));
			else if (surfaces2dObj->colorFormat == (0x00000005))
				hwchan->gr.bpixel |= ((NV_PMC_BOOT_0) << ((0 ? 1 : 0) % 32));
			else if (surfaces2dObj->colorFormat == (0x00000002))
				hwchan->gr.bpixel |= ((0x00000002) << ((0 ? 1 : 0) % 32));
			else if (surfaces2dObj->colorFormat == (0x00000006))
				hwchan->gr.bpixel |= ((0x00000003) << ((0 ? 1 : 0) % 32));
			hwchan->gr.bpixel |= ((0x00000001) << ((0 ? 2 : 2) % 32));
		}
		hwchan->dstCanvasOwner = (0x00000058);
	}
	grCalcClipLogic (device, engObj, 0,
		(((canvasMaxX) & (0xFFFFFFFF >> (31 - ((1 ? 10 : 0) % 32) +
						((0 ? 10 : 0) % 32)))) << ((0 ? 10 : 0) %
				32)) | (((canvasMaxY) & (0xFFFFFFFF >> (31 - ((1 ? 30 : 16) % 32) +
						((0 ? 30 : 16) % 32)))) << ((0 ? 30 : 16) % 32)));
}

void
grUpdateSurfaceSrc (EngineObj *engObj)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvU32               canvasMaxX,
	                    canvasMaxY;
	GrNv03Surfaces2dObj *surfaces2dObj = (GrNv03Surfaces2dObj *) engObj;
	NvV32               surfaceBase;

	;
	;
	;
	if (surfaces2dObj->ctxDmaSource == (void *) 0)
	{
		;
		return;
	}
	surfaceBase = (NvV32) ((&surfaces2dObj->ctxDmaSource->pteBase)->low);
	;
	canvasMaxX =
		(surfaces2dObj->srcPitch / ((surfaces2dObj->colorFormat ==
				(0x00000001)) ? 1 : ((surfaces2dObj->colorFormat ==
					(0x00000006)) ? 4 : 2))) + 1;
	canvasMaxY =
		(((((((unsigned long) (&surfaces2dObj->ctxDmaSource->limit)->low) + 1) -
					surfaces2dObj->offsetSrc) / surfaces2dObj->srcPitch) <
			0x3ffe) ? (((((unsigned long) (&surfaces2dObj->ctxDmaSource->limit)->low) +
					1) -
				surfaces2dObj->offsetSrc) / surfaces2dObj->srcPitch) : 0x3ffe) + 1;
	;
	if (chid == hwdev->info.Graphics.CurrentChID)
	{
		{
			NvV32               _status;

			_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			while (_status)
			{
				NvV32               _pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);

				if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
				{
					grService (device);
				}
				_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_SRC_CANVAS_MIN) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_SRC_CANVAS_MAX) / 4] =
			(NvV32) ((((canvasMaxX) & (0xFFFFFFFF >> (31 - ((1 ? 10 : 0) % 32) +
							((0 ? 10 : 0) % 32)))) << ((0 ? 10 : 0) %
					32)) | (((canvasMaxY) & (0xFFFFFFFF >> (31 -
							((1 ? 30 : 16) % 32) +
							((0 ? 30 : 16) % 32)))) << ((0 ? 30 : 16) %
					32)));
		(hwreg)->Reg32[(NV_PGRAPH_BOFFSET1) / 4] =
			(NvV32) (surfaces2dObj->offsetSrc + surfaceBase);
		(hwreg)->Reg32[(NV_PGRAPH_BPITCH1) / 4] = (NvV32) (surfaces2dObj->srcPitch);
		if (surfaces2dObj->colorFormat == (0x00000001))
			(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
				(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) /
							4]) & ~((0xFFFFFFFF >> (31 -
								((1 ? 5 : 4) % 32) +
								((0 ? 5 : 4) %
									32))) << ((0 ? 5 : 4) %
							32))) | ((0x00000001) << ((0 ? 5 : 4) %
						32)));
		else if (surfaces2dObj->colorFormat == (0x00000005))
			(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
				(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) /
							4]) & ~((0xFFFFFFFF >> (31 -
								((1 ? 5 : 4) % 32) +
								((0 ? 5 : 4) %
									32))) << ((0 ? 5 : 4) %
							32))) | ((NV_PMC_BOOT_0) << ((0 ? 5 : 4) %
						32)));
		else if (surfaces2dObj->colorFormat == (0x00000002))
			(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
				(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) /
							4]) & ~((0xFFFFFFFF >> (31 -
								((1 ? 5 : 4) % 32) +
								((0 ? 5 : 4) %
									32))) << ((0 ? 5 : 4) %
							32))) | ((0x00000002) << ((0 ? 5 : 4) %
						32)));
		else if (surfaces2dObj->colorFormat == (0x00000006))
			(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
				(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) /
							4]) & ~((0xFFFFFFFF >> (31 -
								((1 ? 5 : 4) % 32) +
								((0 ? 5 : 4) %
									32))) << ((0 ? 5 : 4) %
							32))) | ((0x00000003) << ((0 ? 5 : 4) %
						32)));
		(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 6 : 6) % 32) +
							((0 ? 6 : 6) % 32))) << ((0 ? 6 : 6) %
						32))) | ((0x00000001) << ((0 ? 6 : 6) % 32)));
	}
	else
	{
		hwchan->gr.src_canvas_min = 0;
		hwchan->gr.src_canvas_max =
			(((canvasMaxX) & (0xFFFFFFFF >> (31 - ((1 ? 10 : 0) % 32) +
						((0 ? 10 : 0) % 32)))) << ((0 ? 10 : 0) %
				32)) | (((canvasMaxY) & (0xFFFFFFFF >> (31 - ((1 ? 30 : 16) % 32) +
						((0 ? 30 : 16) % 32)))) << ((0 ? 30 : 16) % 32));
		hwchan->gr.boffset1 = surfaces2dObj->offsetSrc + surfaceBase;
		hwchan->gr.bpitch1 = surfaces2dObj->srcPitch;
		hwchan->gr.bpixel &=
			(~((0xFFFFFFFF >> (31 - ((1 ? 5 : 4) % 32) +
						((0 ? 5 : 4) % 32))) << ((0 ? 5 : 4) %
					32)) & ~((0xFFFFFFFF >> (31 - ((1 ? 6 : 6) % 32) +
						((0 ? 6 : 6) % 32))) << ((0 ? 6 : 6) % 32)));
		if (surfaces2dObj->colorFormat == (0x00000001))
			hwchan->gr.bpixel |= ((0x00000001) << ((0 ? 5 : 4) % 32));
		else if (surfaces2dObj->colorFormat == (0x00000005))
			hwchan->gr.bpixel |= ((NV_PMC_BOOT_0) << ((0 ? 5 : 4) % 32));
		else if (surfaces2dObj->colorFormat == (0x00000002))
			hwchan->gr.bpixel |= ((0x00000002) << ((0 ? 5 : 4) % 32));
		else if (surfaces2dObj->colorFormat == (0x00000006))
			hwchan->gr.bpixel |= ((0x00000003) << ((0 ? 5 : 4) % 32));
		hwchan->gr.bpixel |= ((0x00000001) << ((0 ? 6 : 6) % 32));
	}
}
void
grCanvasCtxSwitch (EngineObj *engObj)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	NvU32               chid = objectToChID (engObj);
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvU32               classNum = ((engObj)->base.classInfo->num);
	GrRenderObj        *surface2dUser;
	GrDxTexTriObj      *surface3dUser;

	;
	if ((classNum == (0x0000001C)) || (classNum == (0x0000001D)) || (classNum == (0x0000001E))
		|| (classNum == (0x00000021)) || (classNum == (0x0000004B))
		|| (classNum == (0x00000036)) || (classNum == (0x00000037))
		|| (classNum == (0x0000001F)))
	{
		if (hwchan->dstCanvasOwner == (0x00000058))
		{
			;
			return;
		}
		if (hwchan->dstCanvasOwner == (0x0000005A))
		{
			;
			for (surface3dUser = hwchan->nv03Surfaces3d->surfaceUsers; surface3dUser;
				surface3dUser = surface3dUser->next)
			{
				;
				((EngineObj *) surface3dUser)->base.mask &= ~0x2000;
				grValidateObject ((EngineObj *) surface3dUser);
			}
		}
		for (surface2dUser = hwchan->nv03Surfaces2d->surfaceUsers; surface2dUser;
			surface2dUser = surface2dUser->next)
		{
			;
			((EngineObj *) surface2dUser)->base.mask |= 0x2000;
			grValidateObject ((EngineObj *) surface2dUser);
		}
		grUpdateSurfaceDest (((GrRenderObj *) engObj)->ctxSurfaces2d);
		return;
	}
	else if (classNum == (0x00000048))
	{
		if (hwchan->dstCanvasOwner == (0x0000005A))
		{
			;
			return;
		}
		if (hwchan->dstCanvasOwner == (0x00000058))
		{
			;
			for (surface2dUser = hwchan->nv03Surfaces2d->surfaceUsers; surface2dUser;
				surface2dUser = surface2dUser->next)
			{
				;
				((EngineObj *) surface2dUser)->base.mask &= ~0x2000;
				grValidateObject ((EngineObj *) surface2dUser);
			}
		}
		for (surface3dUser = hwchan->nv03Surfaces3d->surfaceUsers; surface3dUser;
			surface3dUser = surface3dUser->next)
		{
			;
			((EngineObj *) surface3dUser)->base.mask |= 0x2000;
			grValidateObject ((EngineObj *) surface3dUser);
		}
		grUpdateSurfaceDest (((GrDxTexTriObj *) engObj)->ctxSurfaces3d);
		return;
	}
	else
	{
		;
	}
	return;
}
static NvV32
grAttachNv03Surfaces2dObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvV32               status;

	;
	if (hwchan->nv03Surfaces2d != (void *) 0)
	{
		;
		return (0x00000002);
	}
	if ((status = swAttachEngineObject (genObj, alloc)) != 0)
	{
		;
		return status;
	}
	surfacesObj->colorFormat = (0x00000001);
	surfacesObj->srcPitch = 0x40;
	surfacesObj->destPitch = 0x40;
	surfacesObj->offsetSrc = 0;
	surfacesObj->offsetDest = 0;
	surfacesObj->ctxDmaDestin = (void *) 0;
	surfacesObj->ctxDmaSource = (void *) 0;
	surfacesObj->surfaceUsers = (void *) 0;
	(*(&surfacesObj->notifyType) = -1);
	hwchan->nv03Surfaces2d = surfacesObj;
	return status;
}
static NvV32
grDetachNv03Surfaces2dObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvV32               status;

	;
	if ((status = swDetachEngineObject (genObj)) != 0)
	{
		;
		return status;
	}
	if (surfacesObj->ctxDmaDestin)
	{
		surfacesObj->ctxDmaDestin->base.refcnt--;
		;
		surfacesObj->ctxDmaDestin = (void *) 0;
	}
	if (surfacesObj->ctxDmaSource)
	{
		surfacesObj->ctxDmaSource->base.refcnt--;
		;
		surfacesObj->ctxDmaSource = (void *) 0;
	}
	if (surfacesObj->surfaceUsers)
	{
		GrRenderObj        *renderObj;

		for (renderObj = surfacesObj->surfaceUsers; renderObj; renderObj = renderObj->next)
		{
			;
			renderObj->ctxSurfaces2d = (void *) 0;
			grValidateObject (&renderObj->base);
		}
	}
	if (((engObj)->base.classInfo->num) == hwchan->dstCanvasOwner)
		hwchan->dstCanvasOwner = 0;
	if (hwchan->nv03Surfaces2d == surfacesObj)
		hwchan->nv03Surfaces2d = (void *) 0;
	return status;
}
static void
gr2dSurfaceNotify (GrNv03Surfaces2dObj *surfaceObj, int awaken, int ndx, NvV32 status)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) ((((EngineObj *) surfaceObj))->base.parent->
					parent))->device->deviceInfo));
	NvContextDmaObj    *ctxDmaObj = ((EngineObj *) surfaceObj)->notifyCtxDma;
	NvU32               timeHi,
	                    timeLo;
	Nv0058Notification *notify;
	int                 i;

	;
	;
	notify = (Nv0058Notification *) ((&ctxDmaObj->memoryObj->kernAddr)->low +
		(unsigned long) (&ctxDmaObj->offset)->low);
	tmrGetCurrentTime (device, &timeHi, &timeLo);
	notify[ndx].timeStamp.high = timeHi;
	notify[ndx].timeStamp.low = timeLo;
	for (i = 0; i < 7; i++)
		notify[ndx].zero[i] = (NvV8) 0;
	notify[ndx].status = (NvV8) status;
}
static NvV32
mthd2dSynchronize (EngineObj *object, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvV32               status = 0;

	;
	if (!object->notifyCtxDma)
		status |= (0x01000000);
	switch (data)
	{
		case (NV_PMC_BOOT_0):
		case (0x00000001):
			return 0;
		case (0x00000002):
		case (0x00000003):
			break;
		default:;
			status |= (0x02000000);
			break;
	}
	if (status)
		return status;
	gr2dSurfaceNotify ((GrNv03Surfaces2dObj *) object, (data == (0x00000003)), 0, status);
	return 0;
}
static NvV32
mthdSetContextDmaDestin (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0)))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(0x00000001))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000002)))))
		{
			;
			;
			return (0x01000000);
		}
		if (surfacesObj->ctxDmaDestin != (void *) 0)
		{
			surfacesObj->ctxDmaDestin->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		surfacesObj->ctxDmaDestin = ctxDmaObj;
		if (((engObj)->base.classInfo->num) == hwchan->dstCanvasOwner)
			grUpdateSurfaceDest (engObj);
	}
	else
	{
		ctxDmaObj = surfacesObj->ctxDmaDestin;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			surfacesObj->ctxDmaDestin = (void *) 0;
		}
		if (surfacesObj->surfaceUsers)
		{
			GrRenderObj        *renderObj;

			for (renderObj = surfacesObj->surfaceUsers; renderObj;
				renderObj = renderObj->next)
			{
				;
				grValidateObject (&renderObj->base);
			}
		}
	}
	return (0x00);
}
static NvV32
mthdSetContextDmaSource (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0)))))
			|| !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 3 : 0) % 32) +
								((0 ? 3 : 0) % 32)))) ==
					(NV_PMC_BOOT_0)))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000001)))))
		{
			;
			;
			return (0x01000000);
		}
		if (surfacesObj->ctxDmaSource != (void *) 0)
		{
			surfacesObj->ctxDmaSource->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		surfacesObj->ctxDmaSource = ctxDmaObj;
		grUpdateSurfaceSrc (engObj);
	}
	else
	{
		ctxDmaObj = surfacesObj->ctxDmaSource;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			surfacesObj->ctxDmaSource = (void *) 0;
		}
		if (surfacesObj->surfaceUsers)
		{
			GrRenderObj        *renderObj;

			for (renderObj = surfacesObj->surfaceUsers; renderObj;
				renderObj = renderObj->next)
			{
				;
				grValidateObject (&renderObj->base);
			}
		}
	}
	return (0x00);
}
static NvV32
mthdSetFormat (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];

	;
	if ((data != (0x00000001)) && (data != (0x00000005))
		&& (data != (0x00000002)) & (data != (0x00000006)))
	{
		;
		return (0x02000000);
	}
	surfacesObj->colorFormat = data;
	if (((engObj)->base.classInfo->num) == hwchan->dstCanvasOwner)
		grUpdateSurfaceDest (engObj);
	grUpdateSurfaceSrc (engObj);
	return (0x00);
}
static NvV32
mthdSet2dPitch (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	NvU32               srcPitch,
	                    destPitch;

	;
	srcPitch =
		(data >> ((0 ? 15 : 0) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
			((0 ? 15 : 0) % 32)));
	destPitch =
		(data >> ((0 ? 31 : 16) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
			((0 ? 31 : 16) % 32)));
	if (((srcPitch & 0x3f) || (srcPitch < 64) || (srcPitch > 8128)) || ((destPitch & 0x3f)
			|| (destPitch < 64) || (destPitch > 8128)))
	{
		;
		return (0x02000000);
	}
	surfacesObj->destPitch = destPitch;
	surfacesObj->srcPitch = srcPitch;
	grUpdateSurfaceSrc (engObj);
	if (((engObj)->base.classInfo->num) == hwchan->dstCanvasOwner)
	{
		grUpdateSurfaceDest (engObj);
	}
	return (0x00);
}
static NvV32
mthdSetOffset2d (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	GrNv03Surfaces2dObj *surfacesObj = (GrNv03Surfaces2dObj *) engObj;
	int                 buffer = (offset >= 0x308 && offset <= 0x30b);

	if (data & 0x3f)
	{
		;
		return (0x02000000);
	}
	if (buffer == 1)
		surfacesObj->offsetSrc = data;
	else
		surfacesObj->offsetDest = data;
	if (buffer == 0)
	{
		if (((engObj)->base.classInfo->num) == hwchan->dstCanvasOwner)
			grUpdateSurfaceDest (engObj);
	}
	else
	{
		grUpdateSurfaceSrc (engObj);
	}
	return (0x00);
}
static MethodInfo   Nv03Surfaces2dMethods[] = {
	{mthd2dSynchronize, "Synchronize", 0x100, 0x103}, {mthdSwSetContextDmaNotifies,
			"SetContextDmaNotifies", 0x180, 0x183}, {mthdSetContextDmaSource,
			"SetContextDmaSource", 0x184, 0x187}, {mthdSetContextDmaDestin,
			"SetContextDmaDestin", 0x188, 0x18b}, {mthdSetFormat, "SetFormat", 0x300,
			0x303}, {mthdSet2dPitch, "SetPitch", 0x304, 0x307}, {mthdSetOffset2d,
			"SetOffsetSource", 0x308, 0x30b}, {mthdSetOffset2d, "SetOffsetDestin",
			0x30c, 0x30f},
};
EngineObjInfo       Nv03Surfaces2dEngineObjInfo = {
	((NV_PMC_BOOT_0) << ((0 ? (1 * 32 + 23) : (1 * 32 + 23)) & 31)), 0, {(0x00000058), 0x0,
			0x0}, (void *) 0
};
ClassInfo           Nv03Surfaces2dClassInfo = {
	(0x00000058), "surfaces 2d", sizeof (GrNv03Surfaces2dObj), 0x1, 1,
		&Nv03Surfaces2dEngineObjInfo, (void *) 0, (void *) 0, grAttachNv03Surfaces2dObj,
		(void *) 0, (void *) 0, grDetachNv03Surfaces2dObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv03Surfaces2dMethods) / sizeof (Nv03Surfaces2dMethods[0])),
		Nv03Surfaces2dMethods
};
static NvV32
grAttachNv03Surfaces3dObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrNv03Surfaces3dObj *surfacesObj = (GrNv03Surfaces3dObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvV32               status;

	;
	if (hwchan->nv03Surfaces3d != (void *) 0)
	{
		;
		return (0x00000002);
	}
	if ((status = swAttachEngineObject (genObj, alloc)) != 0)
	{
		;
		return status;
	}
	surfacesObj->pitch = 0x40;
	surfacesObj->offsetColor = 0;
	surfacesObj->offsetZeta = 0;
	surfacesObj->ctxDmaSurface = (void *) 0;
	surfacesObj->surfaceUsers = (void *) 0;
	(*(&surfacesObj->notifyType) = -1);
	hwchan->nv03Surfaces3d = surfacesObj;
	return status;
}
static NvV32
grDetachNv03Surfaces3dObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrNv03Surfaces3dObj *surfacesObj = (GrNv03Surfaces3dObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvV32               status;

	;
	if ((status = swDetachEngineObject (genObj)) != 0)
	{
		;
		return status;
	}
	if (surfacesObj->ctxDmaSurface)
	{
		surfacesObj->ctxDmaSurface->base.refcnt--;
		;
		surfacesObj->ctxDmaSurface = (void *) 0;
	}
	if (((GrNv03Surfaces3dObj *) surfacesObj)->surfaceUsers)
	{
		GrDxTexTriObj      *triObj;

		for (triObj = ((GrNv03Surfaces3dObj *) surfacesObj)->surfaceUsers; triObj;
			triObj = triObj->next)
		{
			;
			grValidateObject (&triObj->base);
		}
	}
	if (((engObj)->base.classInfo->num) == hwchan->dstCanvasOwner)
		hwchan->dstCanvasOwner = 0;
	if (hwchan->nv03Surfaces3d == surfacesObj)
		hwchan->nv03Surfaces3d = (void *) 0;
	return status;
}
static void
gr3dSurfaceNotify (GrNv03Surfaces3dObj *surfaceObj, int awaken, int ndx, NvV32 status)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) ((((EngineObj *) surfaceObj))->base.parent->
					parent))->device->deviceInfo));
	NvContextDmaObj    *ctxDmaObj = ((EngineObj *) surfaceObj)->notifyCtxDma;
	NvU32               timeHi,
	                    timeLo;
	Nv005aNotification *notify;
	int                 i;

	;
	;
	notify = (Nv005aNotification *) ((&ctxDmaObj->memoryObj->kernAddr)->low +
		(unsigned long) (&ctxDmaObj->offset)->low);
	tmrGetCurrentTime (device, &timeHi, &timeLo);
	notify[ndx].timeStamp.high = timeHi;
	notify[ndx].timeStamp.low = timeLo;
	for (i = 0; i < 7; i++)
		notify[ndx].zero[i] = (NvV8) 0;
	notify[ndx].status = (NvV8) status;
}
static NvV32
mthd3dSynchronize (EngineObj *object, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvV32               status = 0;

	;
	if (!object->notifyCtxDma)
		status |= (0x01000000);
	switch (data)
	{
		case (NV_PMC_BOOT_0):
		case (0x00000001):
			return 0;
		case (0x00000002):
		case (0x00000003):
			break;
		default:;
			status |= (0x02000000);
			break;
	}
	if (status)
		return status;
	gr3dSurfaceNotify ((GrNv03Surfaces3dObj *) object, (data == (0x00000003)), 0, status);
	return 0;
}
static NvV32
mthdSetContextDmaSurfaces3d (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	GrNv03Surfaces3dObj *surfacesObj = (GrNv03Surfaces3dObj *) engObj;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0)))))
			|| !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 3 : 0) % 32) +
								((0 ? 3 : 0) % 32)))) ==
					(NV_PMC_BOOT_0)))
			|| !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(NV_PMC_BOOT_0))))
		{
			;
			;
			return (0x01000000);
		}
		if (surfacesObj->ctxDmaSurface != (void *) 0)
		{
			surfacesObj->ctxDmaSurface->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		surfacesObj->ctxDmaSurface = ctxDmaObj;
		if (((engObj)->base.classInfo->num) == hwchan->dstCanvasOwner)
			grUpdateSurfaceDest (engObj);
	}
	else
	{
		ctxDmaObj = surfacesObj->ctxDmaSurface;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			surfacesObj->ctxDmaSurface = (void *) 0;
		}
		if (((GrNv03Surfaces3dObj *) surfacesObj)->surfaceUsers)
		{
			GrDxTexTriObj      *triObj;

			for (triObj = ((GrNv03Surfaces3dObj *) surfacesObj)->surfaceUsers; triObj;
				triObj = triObj->next)
			{
				;
				grValidateObject (&triObj->base);
			}
		}
	}
	return (0x00);
}
static NvV32
mthdSet3dPitch (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	GrNv03Surfaces3dObj *surfacesObj = (GrNv03Surfaces3dObj *) engObj;

	if ((data & 0x3f) || (data < 64) || (data > 8128))
	{
		;
		return (0x02000000);
	}
	surfacesObj->pitch = data;
	if (((engObj)->base.classInfo->num) == hwchan->dstCanvasOwner)
		grUpdateSurfaceDest (engObj);
	return (0x00);
}
static NvV32
mthdSetOffset3d (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	GrNv03Surfaces3dObj *surfacesObj = (GrNv03Surfaces3dObj *) engObj;
	int                 buffer = (offset >= 0x308 && offset <= 0x30c) + 2;

	if (data & 0x3f)
	{
		;
		return (0x02000000);
	}
	if (buffer == 2)
		surfacesObj->offsetColor = data;
	else
		surfacesObj->offsetZeta = data;
	if ((buffer == 2) && (((engObj)->base.classInfo->num) == hwchan->dstCanvasOwner))
	{
		grUpdateSurfaceDest (engObj);
	}
	return (0x00);
}

MethodInfo          Nv03Surfaces3dMethods[] = {
	{mthd3dSynchronize, "Synchronize", 0x100, 0x103}, {mthdSwSetContextDmaNotifies,
			"SetContextDmaNotifies", 0x180, 0x183}, {mthdSetContextDmaSurfaces3d,
			"SetContextDmaSurfaces", 0x184, 0x187}, {mthdSet3dPitch, "SetPitch", 0x300,
			0x303}, {mthdSetOffset3d, "SetOffsetColor", 0x304, 0x307}, {mthdSetOffset3d,
			"SetOffsetZeta", 0x308, 0x30b},
};
EngineObjInfo       Nv03Surfaces3dEngineObjInfo = {
	((NV_PMC_BOOT_0) << ((0 ? (1 * 32 + 23) : (1 * 32 + 23)) & 31)), 0, {(0x0000005A), 0x0,
			0x0}, (void *) 0
};
ClassInfo           Nv03Surfaces3dClassInfo = {
	(0x0000005A), "nv03 surfaces 3d", sizeof (GrNv03Surfaces3dObj), 0x1, 1,
		&Nv03Surfaces3dEngineObjInfo, (void *) 0, (void *) 0, grAttachNv03Surfaces3dObj,
		(void *) 0, (void *) 0, grDetachNv03Surfaces3dObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv03Surfaces3dMethods) / sizeof (Nv03Surfaces3dMethods[0])),
		Nv03Surfaces3dMethods
};
